/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOElement;
import com.webobjects.appserver._private.WODeclarationFormatException;
import com.webobjects.appserver._private.WODeclarationParser;
import com.webobjects.appserver._private.WOHTMLCommentString;
import com.webobjects.appserver._private.WOHTMLFormatException;
import com.webobjects.appserver._private.WOHTMLParser;
import com.webobjects.appserver._private.WOHTMLParserDelegate;
import com.webobjects.appserver._private.WOHTMLWebObjectTag;
import com.webobjects.appserver._private.WOParser;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation._NSUtilities;

public class WOHTMLTemplateParser
extends WOParser
implements WOHTMLParserDelegate {
    protected WOHTMLWebObjectTag _currentWebObjectTag = new WOHTMLWebObjectTag();
    protected NSDictionary _declarations = null;

    public WOHTMLTemplateParser(String string, String string2, NSArray nSArray) {
        super(string, string2, nSArray);
    }

    public void didParseOpeningWebObjectTag(String string, WOHTMLParser wOHTMLParser) throws WOHTMLFormatException {
        this._currentWebObjectTag = new WOHTMLWebObjectTag(string, this._currentWebObjectTag);
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x800000L)) {
            NSLog.debug.appendln((Object)("<WOHTMLTemplateParser> inserted WebObject with Name '" + this._currentWebObjectTag.name() + "'."));
        }
    }

    public void didParseClosingWebObjectTag(String string, WOHTMLParser wOHTMLParser) throws WODeclarationFormatException, WOHTMLFormatException, ClassNotFoundException {
        WOHTMLWebObjectTag wOHTMLWebObjectTag = this._currentWebObjectTag.parentTag();
        if (this._currentWebObjectTag == null || wOHTMLWebObjectTag == null) {
            throw new WOHTMLFormatException("<" + this.getClass().getName() + "> Unbalanced WebObject tags. Either there is an extra closing </WEBOBJECT> tag in the html template, or one of the opening <WEBOBJECT ...> tag has a typo (extra spaces between a < sign and a WEBOBJECT tag ?).");
        }
        WOElement wOElement = this._currentWebObjectTag.dynamicElement(this._declarations, this._languages);
        this._currentWebObjectTag = wOHTMLWebObjectTag;
        this._currentWebObjectTag.addChildElement(wOElement);
    }

    public void didParseComment(String string, WOHTMLParser wOHTMLParser) {
        WOHTMLCommentString wOHTMLCommentString = new WOHTMLCommentString(string);
        this._currentWebObjectTag.addChildElement(wOHTMLCommentString);
    }

    public void didParseText(String string, WOHTMLParser wOHTMLParser) {
        this._currentWebObjectTag.addChildElement(string);
    }

    private void parseDeclarations() throws WODeclarationFormatException {
        if (this._declarations == null && this._declarationString != null) {
            this._declarations = WODeclarationParser.declarationsWithString(this._declarationString);
        }
    }

    private WOElement parseHTML() throws WOHTMLFormatException, WODeclarationFormatException, ClassNotFoundException {
        if (this._HTMLString != null && this._declarations != null) {
            WOHTMLParser wOHTMLParser = new WOHTMLParser(this, this._HTMLString);
            Object var2_2 = null;
            String string = null;
            wOHTMLParser.parseHTML();
            string = this._currentWebObjectTag.name();
            if (string != null) {
                throw new WOHTMLFormatException("while parsing .html file. There is an unbalanced WebObjects tag named '" + string + "'.");
            }
            return this._currentWebObjectTag.template();
        }
        return null;
    }

    public WOElement parse() throws WODeclarationFormatException, WOHTMLFormatException, ClassNotFoundException {
        this.parseDeclarations();
        WOElement wOElement = this.parseHTML();
        return wOElement;
    }

    static {
        block2: {
            try {
                _NSUtilities.registerPackage((String)"com.webobjects.appserver._private");
            }
            catch (Exception exception) {
                NSLog.err.appendln((Object)("<WOHTMLTemplateParser> Exception during static initialization: " + exception.toString()));
                if (!NSLog.debugLoggingAllowedForLevel((int)1)) break block2;
                NSLog.debug.appendln((Throwable)exception);
            }
        }
    }
}

