/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDisposable;
import com.webobjects.foundation.NSProperties;

public abstract class WOObjectPool {
    private NSDisposable[] _objects;
    private int _index;
    private int highWaterMarkSize;

    public WOObjectPool(int n) {
        this._objects = new NSDisposable[n];
        this._initObjects(0, n);
        String string = this.highWaterMarkPropertyKey();
        int n2 = NSProperties.integerForKey((String)string);
        this.highWaterMarkSize = n2 < n ? n : n2;
    }

    public abstract NSDisposable newInstance();

    public abstract String highWaterMarkPropertyKey();

    public int highWaterMarkSize() {
        return this.highWaterMarkSize;
    }

    public void resize() {
        int n = this._objects.length;
        int n2 = 2 * n;
        int n3 = this.highWaterMarkSize();
        if (n2 > n3) {
            if (n >= n3) {
                throw new IllegalStateException("<" + this.getClass().getName() + "> Reached the high water mark for this pool. Please increase the " + this.highWaterMarkPropertyKey() + " property if this is normal.");
            }
            n2 = n3;
        }
        NSDisposable[] nSDisposableArray = new NSDisposable[n2];
        System.arraycopy(this._objects, 0, nSDisposableArray, 0, n);
        this._objects = nSDisposableArray;
        this._initObjects(n, n2 - n);
    }

    private void _initObjects(int n, int n2) {
        if (n + n2 > this._objects.length) {
            throw new IllegalArgumentException("<" + this.getClass().getName() + "> Tried to pre-fill pool outside of its boundary.");
        }
        for (int i = 0; i < n2; ++i) {
            this._objects[n + i] = this.newInstance();
        }
    }

    public void dispose() {
        for (int i = 0; i < this._index; ++i) {
            this._objects[i].dispose();
        }
        this._index = 0;
    }

    public NSDisposable nextInstance() {
        if (this._index == this._objects.length) {
            this.resize();
        }
        NSDisposable nSDisposable = this._objects[this._index];
        ++this._index;
        return nSDisposable;
    }

    private void _freeInstanceAtIndex(int n) {
        if (n >= this._index || this._index == 0) {
            throw new IllegalStateException("<" + this.getClass().getName() + "> Internal inconsistency while cleaning up object pool.");
        }
        NSDisposable nSDisposable = this._objects[n];
        --this._index;
        if (this._index > 0) {
            this._objects[n] = this._objects[this._index];
            this._objects[this._index] = nSDisposable;
            nSDisposable.dispose();
        }
    }

    public void freeInstance(Object object) {
        int n;
        for (n = 0; n < this._index && object != this._objects[n]; ++n) {
        }
        this._freeInstanceAtIndex(n);
    }

    public void freeLastInstance() {
        if (this._index > 0) {
            --this._index;
            this._objects[this._index].dispose();
        }
    }

    public void freeInstances(NSArray nSArray) {
        int n = nSArray.count();
        for (int i = 0; i < n; ++i) {
            this.freeInstance(nSArray.objectAtIndex(i));
        }
    }

    public int instancesCount() {
        return this._index;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("<" + this.getClass().getName() + " size=" + this._index + " \n");
        stringBuffer.append("Objects In Use:\n");
        for (n = 0; n < this._index; ++n) {
            stringBuffer.append(this._objects[n].toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append("Objects Free:\n");
        for (n = this._index; n < this._objects.length; ++n) {
            stringBuffer.append(this._objects[n].toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

