/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSRange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;

public class WOUrlConnection {
    public static final String CONNECTION = "connection";
    public static final String CLOSE = "close";
    public static final String KEEPALIVE = "keep-alive";
    private volatile URLConnection _urlConnection;
    private long _connectTimeout;
    private long _sendTimeout;
    private long _readTimeout;
    private long _receiveTimeout;
    private InputStream _httpIs;
    private UrlDataSender _urlDataSender;
    private UrlDataReceiver _urlDataReceiver;
    private NSMutableDictionary _responseHeaders;

    private void closeConnection() {
        String string;
        boolean bl = false;
        this._responseHeaders = new NSMutableDictionary();
        int n = 1;
        while ((string = this._urlConnection.getHeaderField(n)) != null) {
            String string2 = this._urlConnection.getHeaderFieldKey(n).toLowerCase();
            NSMutableArray nSMutableArray = (NSMutableArray)this._responseHeaders.objectForKey((Object)string2);
            if (nSMutableArray == null) {
                nSMutableArray = new NSMutableArray();
            }
            nSMutableArray.addObject((Object)string);
            this._responseHeaders.setObjectForKey((Object)nSMutableArray, (Object)string2);
            if (string2.equals(CONNECTION)) {
                bl = string.toLowerCase().equals(CLOSE);
            }
            ++n;
        }
        string = this._urlConnection.getRequestProperty(CONNECTION);
        if ((string != null && string.toLowerCase().equals(CLOSE) || bl) && this._urlConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)this._urlConnection).disconnect();
        }
    }

    public WOUrlConnection(URL uRL, int n, int n2, int n3, int n4) throws IOException {
        this._urlConnection = uRL.openConnection();
        this._connectTimeout = n;
        this._sendTimeout = n2;
        this._receiveTimeout = n3;
        this._readTimeout = n4;
        this._urlDataSender = new UrlDataSender(this._urlConnection);
        this._urlDataReceiver = new UrlDataReceiver(this._urlConnection);
    }

    public WOUrlConnection(URL uRL) throws IOException {
        this(uRL, 0, 0, 0, 0);
    }

    public void cleanup() {
        this._urlDataSender.stop();
        this._urlDataReceiver.stop();
        this._urlConnection = null;
    }

    public void reset() {
        this._urlDataSender.reset();
        this._urlDataReceiver.reset();
    }

    public long connectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(long l) {
        this._connectTimeout = l;
    }

    public long sendTimeout() {
        return this._sendTimeout;
    }

    public void setSendTimeout(long l) {
        this._sendTimeout = l;
    }

    public long receiveTimeout() {
        return this._receiveTimeout;
    }

    public void setReceiveTimeout(long l) {
        this._receiveTimeout = l;
    }

    public long readTimeout() {
        return this._readTimeout;
    }

    public void setReadTimeout(long l) {
        this._readTimeout = l;
    }

    public void connect() throws IOException {
        this.connect(this._connectTimeout);
    }

    public void connect(long l) throws IOException {
        this.send(l, null);
    }

    public void send(byte[] byArray) throws IOException {
        this.send(this._sendTimeout, byArray);
    }

    public void send(long l, byte[] byArray) throws IOException {
        if (this._urlDataSender.sent()) {
            return;
        }
        this._urlDataSender.setContent(byArray);
        Thread thread = new Thread(this._urlDataSender);
        thread.start();
        try {
            thread.join(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this._urlDataSender.sent()) {
            this._urlDataSender.stop();
            throw new IOException("Cannot send URL request to " + this._urlConnection.getURL().getHost() + ":" + this._urlConnection.getURL().getPort());
        }
    }

    public NSData receive() throws IOException {
        return this.receive(this._receiveTimeout, this._readTimeout);
    }

    public NSData receive(long l, long l2) throws IOException {
        this._urlDataReceiver.setReadTimeout(l2);
        Thread thread = new Thread(this._urlDataReceiver);
        thread.start();
        try {
            thread.join(l);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
        finally {
            this._urlDataReceiver.stop();
        }
        Exception exception = this._urlDataReceiver.exception();
        if (exception != null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception.getMessage());
        }
        NSData nSData = this._urlDataReceiver.response();
        if (nSData == null) {
            throw new IOException("Time out when receiving " + this._urlConnection.getURL().getHost() + ":" + this._urlConnection.getURL().getPort());
        }
        this.closeConnection();
        return nSData;
    }

    public URLConnection urlConnection() {
        return this._urlConnection;
    }

    public HttpURLConnection httpUrlConnection() {
        return (HttpURLConnection)this._urlConnection;
    }

    public NSDictionary responseHeaders() {
        return this._responseHeaders;
    }

    class UrlDataReader
    implements Runnable {
        private volatile Exception _exception;
        private volatile int _bytesRead;
        private boolean _keepReading;
        private volatile byte[] _bytes;
        private volatile int _offset;
        private volatile int _bytesToRead;
        private boolean _readManyBytes;
        private boolean[] _startReading = new boolean[]{false};
        private boolean[] _chunkRead = new boolean[]{false};

        public void reset() {
            this._exception = null;
            this._bytesRead = 0;
            this._keepReading = false;
            this._startReading[0] = false;
            this._chunkRead[0] = false;
        }

        public Exception exception() {
            return this._exception;
        }

        public int bytesRead() {
            return this._bytesRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prepare(boolean bl) {
            this._readManyBytes = bl;
            boolean[] blArray = this._startReading;
            synchronized (this._startReading) {
                this._startReading[0] = true;
                this._startReading.notify();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void prepare(byte[] byArray, int n, int n2) {
            this._bytes = byArray;
            this._offset = n;
            this._bytesToRead = n2;
            this.prepare(true);
        }

        public void prepare() {
            this.prepare(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForChunk(long l) throws InterruptedException {
            boolean[] blArray = this._chunkRead;
            synchronized (this._chunkRead) {
                if (!this._chunkRead[0]) {
                    this._chunkRead.wait(l);
                }
                this._chunkRead[0] = false;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            boolean[] blArray = this._startReading;
            synchronized (this._startReading) {
                this._keepReading = false;
                this._startReading.notify();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            this._exception = null;
            this._bytesRead = 0;
            if (!WOUrlConnection.this._urlDataSender.sent()) {
                this._exception = new IOException("Request has not been sent to server yet.");
                return;
            }
            this._keepReading = true;
            try {
                while (true) {
                    boolean[] blArray = this._startReading;
                    // MONITORENTER : this._startReading
                    if (!this._startReading[0]) {
                        this._startReading.wait();
                    }
                    if (!this._keepReading) {
                        // MONITOREXIT : blArray
                        return;
                    }
                    this._bytesRead = this._readManyBytes ? WOUrlConnection.this._httpIs.read(this._bytes, this._offset, this._bytesToRead) : WOUrlConnection.this._httpIs.read();
                    boolean[] blArray2 = this._chunkRead;
                    // MONITORENTER : this._chunkRead
                    this._chunkRead[0] = true;
                    this._chunkRead.notify();
                    // MONITOREXIT : blArray2
                    this._startReading[0] = false;
                    // MONITOREXIT : blArray
                }
            }
            catch (Exception exception) {
                this._exception = new IOException(exception.getMessage());
            }
        }
    }

    class UrlDataReceiver
    implements Runnable {
        private static final int CHUNK_SIZE = 1024;
        private volatile URLConnection _urlConnection;
        private volatile boolean _keepReceiving;
        private long _readTimeout;
        private UrlDataReader _urlDataReader;
        private final byte[] _dataLock = new byte[0];
        private NSData _data;
        private volatile Exception _exception;

        public UrlDataReceiver(URLConnection uRLConnection) {
            this._urlConnection = uRLConnection;
            this._urlDataReader = new UrlDataReader();
        }

        public void reset() {
            this._urlDataReader.reset();
            this._keepReceiving = false;
        }

        public void setReadTimeout(long l) {
            this._readTimeout = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NSData response() {
            byte[] byArray = this._dataLock;
            synchronized (this._dataLock) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this._data;
            }
        }

        public Exception exception() {
            return this._exception;
        }

        public void stop() {
            this._keepReceiving = false;
            this._urlDataReader.stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!WOUrlConnection.this._urlDataSender.sent()) {
                this._exception = new IOException("Request has not been sent to server yet.");
                return;
            }
            byte[] byArray = this._dataLock;
            synchronized (this._dataLock) {
                this._data = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                int n = this._urlConnection.getContentLength();
                if (n <= 0) {
                    n = 1024;
                }
                LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
                byte[] byArray2 = new byte[n];
                linkedList.add(byArray2);
                int n2 = 1;
                int n3 = 0;
                int n4 = n;
                int n5 = 0;
                Thread thread = new Thread(this._urlDataReader);
                thread.start();
                try {
                    Object object;
                    Object object2;
                    this._keepReceiving = true;
                    while (this._keepReceiving) {
                        this._urlDataReader.prepare(byArray2, n3, n4);
                        this._urlDataReader.waitForChunk(this._readTimeout);
                        n5 = this._urlDataReader.bytesRead();
                        if (n5 <= 0) break;
                        if ((n4 -= n5) == 0) {
                            n4 = n;
                        }
                        if ((n3 += n5) + n4 <= byArray2.length) continue;
                        this._urlDataReader.prepare();
                        this._urlDataReader.waitForChunk(this._readTimeout);
                        n5 = this._urlDataReader.bytesRead();
                        if (n5 <= 0) break;
                        byArray2 = new byte[(n2 *= 2) * n];
                        linkedList.add(byArray2);
                        byArray2[0] = (byte)n5;
                        n3 = 1;
                        --n4;
                    }
                    if (n5 == 0) {
                        this._exception = this._urlDataReader.exception();
                        if (this._exception == null) {
                            this._exception = new IOException("Read timeout");
                        }
                        return;
                    }
                    int n6 = (n2 - 1) * n + n3;
                    if (linkedList.size() == 1) {
                        byArray2 = (byte[])linkedList.removeFirst();
                    } else {
                        byArray2 = new byte[n6];
                        object2 = (byte[])linkedList.removeLast();
                        System.arraycopy(object2, 0, byArray2, (n2 - 1) * n, n3);
                        object = linkedList.listIterator(0);
                        n3 = 0;
                        while (object.hasNext()) {
                            object2 = (byte[])object.next();
                            System.arraycopy(object2, 0, byArray2, n3, ((byte[])object2).length);
                            n3 += ((byte[])object2).length;
                            object2 = null;
                        }
                    }
                    linkedList = null;
                    object2 = new NSRange(0, n6);
                    object = this._dataLock;
                    synchronized (this._dataLock) {
                        this._data = new NSData(byArray2, (NSRange)object2, false);
                        // ** MonitorExit[var11_14] (shouldn't be in output)
                    }
                }
                catch (InterruptedException interruptedException) {
                    this._exception = interruptedException;
                }
                {
                    return;
                }
            }
        }
    }

    class UrlDataSender
    implements Runnable {
        private volatile URLConnection _urlConnection;
        private volatile boolean _dataSent;
        private volatile byte[] _content;

        public UrlDataSender(URLConnection uRLConnection) {
            this._urlConnection = uRLConnection;
        }

        public final void setContent(byte[] byArray) {
            this._content = byArray;
        }

        public final void reset() {
            this._dataSent = false;
        }

        public final void stop() {
            if (this._urlConnection instanceof HttpURLConnection) {
                try {
                    this._urlConnection.getInputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ((HttpURLConnection)this._urlConnection).disconnect();
            }
        }

        public void run() {
            try {
                this._dataSent = false;
                if (this._content != null) {
                    this._urlConnection.setDoInput(true);
                    this._urlConnection.setDoOutput(true);
                    OutputStream outputStream = this._urlConnection.getOutputStream();
                    outputStream.write(this._content);
                    outputStream.flush();
                }
                WOUrlConnection.this._httpIs = this._urlConnection.getInputStream();
                this._dataSent = true;
            }
            catch (IOException iOException) {
                this._dataSent = false;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public final boolean sent() {
            return this._dataSent;
        }
    }
}

