/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOWebServiceRegistrar;
import com.webobjects.appserver._private.WOActionRequestHandler;
import com.webobjects.appserver._private.WODynamicURL;
import com.webobjects.appserver._private.WOServerSessionHandler;
import com.webobjects.appserver._private.WOWebService;
import com.webobjects.foundation.NSArray;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;

public class WOWebServiceRequestHandler
extends WOActionRequestHandler {
    protected String defaultActionClassName() {
        return "WOWebService";
    }

    public static WORequestHandler handler() {
        return new WOWebServiceRequestHandler();
    }

    public WOWebServiceRequestHandler() {
        this(null, "default", true);
    }

    public WOWebServiceRequestHandler(String string, String string2, boolean bl) {
        super(null, string2, bl);
    }

    public WOResponse nullResponse() {
        WOResponse wOResponse = WOApplication.application().createResponseInContext(null);
        return wOResponse;
    }

    public void registerWillHandleActionRequest() {
        WOApplication.application().statisticsStore().applicationWillHandleWebServiceRequest();
    }

    public void registerDidHandleActionRequestWithActionNamed(String string) {
        WOApplication.application().statisticsStore().applicationDidHandleWebServiceRequestWithActionNamed(string);
    }

    public NSArray getRequestHandlerPathForRequest(WORequest wORequest) {
        return wORequest.requestHandlerPathArray();
    }

    protected boolean isSessionIDInRequest(WORequest wORequest) {
        if (wORequest.isSessionIDInRequest()) {
            return true;
        }
        String string = wORequest.contentString();
        return string.indexOf(WOServerSessionHandler.sessionHeaderQName.getNamespaceURI()) != -1 && string.indexOf(WOServerSessionHandler.sessionHeaderQName.getLocalPart()) != -1;
    }

    public WOResponse generateRequestRefusal(WORequest wORequest) {
        WODynamicURL wODynamicURL = wORequest._uriDecomposed();
        String string = "Sorry, your request could not immediately be processed. Please try this URL: <a href=\"" + wODynamicURL + "\">" + wODynamicURL + "</a>";
        wODynamicURL.setApplicationNumber("-1");
        WOResponse wOResponse = WOApplication.application().createResponseInContext(null);
        WOResponse._redirectResponse(wOResponse, wODynamicURL.toString(), string);
        return wOResponse;
    }

    public WOResponse generateErrorResponse(Exception exception, WOContext wOContext) {
        WOResponse wOResponse = WOApplication.application().createResponseInContext(wOContext);
        try {
            AxisFault axisFault = AxisFault.makeFault((Exception)exception);
            Message message = new Message((Object)axisFault);
            String string = message.getContentType(new MessageContext((AxisEngine)WOWebService.engine).getSOAPConstants());
            wOResponse.setHeader(string, "content-type");
            wOResponse.setContent(message.getSOAPPartAsString());
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
        wOResponse.setStatus(500);
        return wOResponse;
    }

    public WOResponse handleRequest(WORequest wORequest) {
        String string;
        if (this.actionClassClass == null) {
            Class clazz = this.actionClassClass = WOWebService.class;
        }
        if (!WOWebServiceRegistrar._registeredServiceNames.contains(string = wORequest.requestHandlerPath())) {
            WOResponse wOResponse = this.nullResponse();
            wOResponse.appendContentString("Your requested web service, namely \"" + string + "\", cannot be found in WOWebServiceRegistrar.");
            return wOResponse;
        }
        return super.handleRequest(wORequest);
    }
}

