/*
 * Decompiled with CFR 0.152.
 */
package jode.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import jode.bytecode.ClassFormatException;
import jode.bytecode.Reference;
import jode.bytecode.TypeSignature;

public class ConstantPool {
    public static final int CLASS = 7;
    public static final int FIELDREF = 9;
    public static final int METHODREF = 10;
    public static final int INTERFACEMETHODREF = 11;
    public static final int STRING = 8;
    public static final int INTEGER = 3;
    public static final int FLOAT = 4;
    public static final int LONG = 5;
    public static final int DOUBLE = 6;
    public static final int NAMEANDTYPE = 12;
    public static final int UTF8 = 1;
    int count;
    int[] tags;
    int[] indices1;
    int[] indices2;
    Object[] constants;

    public void read(DataInputStream dataInputStream) throws IOException {
        this.count = dataInputStream.readUnsignedShort();
        this.tags = new int[this.count];
        this.indices1 = new int[this.count];
        this.indices2 = new int[this.count];
        this.constants = new Object[this.count];
        int n = 1;
        while (n < this.count) {
            int n2;
            this.tags[n] = n2 = dataInputStream.readUnsignedByte();
            switch (n2) {
                case 7: {
                    this.indices1[n] = dataInputStream.readUnsignedShort();
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.indices1[n] = dataInputStream.readUnsignedShort();
                    this.indices2[n] = dataInputStream.readUnsignedShort();
                    break;
                }
                case 8: {
                    this.indices1[n] = dataInputStream.readUnsignedShort();
                    break;
                }
                case 3: {
                    this.constants[n] = new Integer(dataInputStream.readInt());
                    break;
                }
                case 4: {
                    this.constants[n] = new Float(dataInputStream.readFloat());
                    break;
                }
                case 5: {
                    this.constants[n] = new Long(dataInputStream.readLong());
                    this.tags[++n] = -5;
                    break;
                }
                case 6: {
                    this.constants[n] = new Double(dataInputStream.readDouble());
                    this.tags[++n] = -6;
                    break;
                }
                case 12: {
                    this.indices1[n] = dataInputStream.readUnsignedShort();
                    this.indices2[n] = dataInputStream.readUnsignedShort();
                    break;
                }
                case 1: {
                    this.constants[n] = dataInputStream.readUTF().intern();
                    break;
                }
                default: {
                    throw new ClassFormatException("unknown constant tag");
                }
            }
            ++n;
        }
    }

    public int getTag(int n) throws ClassFormatException {
        if (n == 0) {
            throw new ClassFormatException("null tag");
        }
        return this.tags[n];
    }

    public String getUTF8(int n) throws ClassFormatException {
        if (n == 0) {
            return null;
        }
        if (this.tags[n] != 1) {
            throw new ClassFormatException("Tag mismatch");
        }
        return (String)this.constants[n];
    }

    public Reference getRef(int n) throws ClassFormatException {
        if (n == 0) {
            return null;
        }
        if (this.tags[n] != 9 && this.tags[n] != 10 && this.tags[n] != 11) {
            throw new ClassFormatException("Tag mismatch");
        }
        if (this.constants[n] == null) {
            int n2 = this.indices1[n];
            int n3 = this.indices2[n];
            if (this.tags[n3] != 12) {
                throw new ClassFormatException("Tag mismatch");
            }
            String string = this.getUTF8(this.indices2[n3]);
            try {
                if (this.tags[n] == 9) {
                    TypeSignature.checkTypeSig(string);
                } else {
                    TypeSignature.checkMethodTypeSig(string);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ClassFormatException(illegalArgumentException.getMessage());
            }
            String string2 = this.getClassType(n2);
            this.constants[n] = Reference.getReference(string2, this.getUTF8(this.indices1[n3]), string);
        }
        return (Reference)this.constants[n];
    }

    public Object getConstant(int n) throws ClassFormatException {
        if (n == 0) {
            throw new ClassFormatException("null constant");
        }
        switch (this.tags[n]) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this.constants[n];
            }
            case 8: {
                return this.getUTF8(this.indices1[n]);
            }
        }
        throw new ClassFormatException("Tag mismatch: " + this.tags[n]);
    }

    public String getClassType(int n) throws ClassFormatException {
        if (n == 0) {
            return null;
        }
        if (this.tags[n] != 7) {
            throw new ClassFormatException("Tag mismatch");
        }
        String string = this.getUTF8(this.indices1[n]);
        if (string.charAt(0) != '[') {
            string = ("L" + string + ';').intern();
        }
        try {
            TypeSignature.checkTypeSig(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassFormatException(illegalArgumentException.getMessage());
        }
        return string;
    }

    public String getClassName(int n) throws ClassFormatException {
        if (n == 0) {
            return null;
        }
        if (this.tags[n] != 7) {
            throw new ClassFormatException("Tag mismatch");
        }
        String string = this.getUTF8(this.indices1[n]);
        try {
            TypeSignature.checkTypeSig("L" + string + ";");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassFormatException(illegalArgumentException.getMessage());
        }
        return string.replace('/', '.').intern();
    }

    public String toString(int n) {
        switch (this.tags[n]) {
            case 7: {
                return "Class " + this.toString(this.indices1[n]);
            }
            case 8: {
                return "String \"" + this.toString(this.indices1[n]) + "\"";
            }
            case 3: {
                return "Int " + this.constants[n].toString();
            }
            case 4: {
                return "Float " + this.constants[n].toString();
            }
            case 5: {
                return "Long " + this.constants[n].toString();
            }
            case 6: {
                return "Double " + this.constants[n].toString();
            }
            case 1: {
                return this.constants[n].toString();
            }
            case 9: {
                return "Fieldref: " + this.toString(this.indices1[n]) + "; " + this.toString(this.indices2[n]);
            }
            case 10: {
                return "Methodref: " + this.toString(this.indices1[n]) + "; " + this.toString(this.indices2[n]);
            }
            case 11: {
                return "Interfaceref: " + this.toString(this.indices1[n]) + "; " + this.toString(this.indices2[n]);
            }
            case 12: {
                return "Name " + this.toString(this.indices1[n]) + "; Type " + this.toString(this.indices2[n]);
            }
        }
        return "unknown tag: " + this.tags[n];
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ null");
        int n = 1;
        while (n < this.count) {
            stringBuffer.append(", ").append(n).append(" = ").append(this.toString(n));
            ++n;
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

