/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import jode.decompiler.Declarable;
import jode.decompiler.LocalInfo;
import jode.decompiler.TabbedPrintWriter;
import jode.expr.Expression;
import jode.expr.LocalLoadOperator;
import jode.expr.LocalStoreOperator;
import jode.expr.StoreInstruction;
import jode.flow.InstructionBlock;
import jode.flow.SequentialBlock;
import jode.flow.SpecialBlock;
import jode.flow.StructuredBlock;
import jode.flow.VariableStack;
import jode.type.Type;

public class CatchBlock
extends StructuredBlock {
    StructuredBlock catchBlock;
    Type exceptionType;
    LocalInfo exceptionLocal;
    LocalInfo pushedLocal;

    public Type getExceptionType() {
        return this.exceptionType;
    }

    public LocalInfo getLocal() {
        return this.exceptionLocal;
    }

    public void setCatchBlock(StructuredBlock structuredBlock) {
        this.catchBlock = structuredBlock;
        structuredBlock.outer = this;
        structuredBlock.setFlowBlock(this.flowBlock);
        if (this.exceptionLocal == null) {
            this.combineLocal();
        }
    }

    public boolean replaceSubBlock(StructuredBlock structuredBlock, StructuredBlock structuredBlock2) {
        if (this.catchBlock != structuredBlock) {
            return false;
        }
        this.catchBlock = structuredBlock2;
        return true;
    }

    public StructuredBlock[] getSubBlocks() {
        return new StructuredBlock[]{this.catchBlock};
    }

    public VariableStack mapStackToLocal(VariableStack variableStack) {
        VariableStack variableStack2;
        if (this.exceptionLocal == null) {
            this.pushedLocal = new LocalInfo();
            this.pushedLocal.setType(this.exceptionType);
            variableStack2 = variableStack.push(this.pushedLocal);
        } else {
            variableStack2 = variableStack;
        }
        return super.mapStackToLocal(variableStack2);
    }

    public void removePush() {
        if (this.pushedLocal != null) {
            this.exceptionLocal = this.pushedLocal;
        }
        super.removePush();
    }

    public Set getDeclarables() {
        if (this.exceptionLocal != null) {
            return Collections.singleton(this.exceptionLocal);
        }
        return Collections.EMPTY_SET;
    }

    public void makeDeclaration(Set set) {
        super.makeDeclaration(set);
        if (this.exceptionLocal != null) {
            if (this.declare.contains(this.exceptionLocal)) {
                this.declare.remove(this.exceptionLocal);
            } else {
                LocalInfo localInfo = new LocalInfo();
                Expression expression = new StoreInstruction(new LocalStoreOperator(this.exceptionLocal.getType(), this.exceptionLocal)).addOperand(new LocalLoadOperator(localInfo.getType(), null, localInfo));
                InstructionBlock instructionBlock = new InstructionBlock(expression);
                instructionBlock.setFlowBlock(this.flowBlock);
                instructionBlock.appendBlock(this.catchBlock);
                this.catchBlock = instructionBlock;
                this.exceptionLocal = localInfo;
                String string = localInfo.guessName();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Declarable declarable = (Declarable)iterator.next();
                    if (!string.equals(declarable.getName())) continue;
                    localInfo.makeNameUnique();
                    break;
                }
            }
        }
    }

    public void dumpInstruction(TabbedPrintWriter tabbedPrintWriter) throws IOException {
        tabbedPrintWriter.closeBraceContinue();
        tabbedPrintWriter.print("catch (");
        tabbedPrintWriter.printType(this.exceptionType);
        tabbedPrintWriter.print(" " + (this.exceptionLocal != null ? this.exceptionLocal.getName() : "PUSH") + ")");
        tabbedPrintWriter.openBrace();
        tabbedPrintWriter.tab();
        this.catchBlock.dumpSource(tabbedPrintWriter);
        tabbedPrintWriter.untab();
    }

    public boolean jumpMayBeChanged() {
        return this.catchBlock.jump != null || this.catchBlock.jumpMayBeChanged();
    }

    public boolean combineLocal() {
        Expression expression;
        StructuredBlock structuredBlock;
        StructuredBlock structuredBlock2 = structuredBlock = this.catchBlock instanceof SequentialBlock ? this.catchBlock.getSubBlocks()[0] : this.catchBlock;
        if (structuredBlock instanceof SpecialBlock && ((SpecialBlock)structuredBlock).type == SpecialBlock.POP && ((SpecialBlock)structuredBlock).count == 1) {
            this.exceptionLocal = new LocalInfo();
            this.exceptionLocal.setType(this.exceptionType);
            structuredBlock.removeBlock();
            return true;
        }
        if (structuredBlock instanceof InstructionBlock && (expression = ((InstructionBlock)structuredBlock).getInstruction()) instanceof StoreInstruction && ((StoreInstruction)expression).getLValue() instanceof LocalStoreOperator) {
            this.exceptionLocal = ((LocalStoreOperator)((StoreInstruction)expression).getLValue()).getLocalInfo();
            this.exceptionLocal.setType(this.exceptionType);
            structuredBlock.removeBlock();
            return true;
        }
        return false;
    }

    public CatchBlock(Type type) {
        this.exceptionType = type;
    }
}

