/*
 * Decompiled with CFR 0.152.
 */
package jode.flow;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import jode.AssertError;
import jode.GlobalOptions;
import jode.decompiler.LocalInfo;
import jode.expr.Expression;
import jode.expr.LocalLoadOperator;
import jode.expr.LocalStoreOperator;
import jode.expr.MonitorExitOperator;
import jode.expr.NopOperator;
import jode.expr.Operator;
import jode.expr.StoreInstruction;
import jode.flow.BreakBlock;
import jode.flow.CatchBlock;
import jode.flow.DescriptionBlock;
import jode.flow.EmptyBlock;
import jode.flow.FinallyBlock;
import jode.flow.FlowBlock;
import jode.flow.InstructionBlock;
import jode.flow.JsrBlock;
import jode.flow.Jump;
import jode.flow.LoopBlock;
import jode.flow.RetBlock;
import jode.flow.ReturnBlock;
import jode.flow.SequentialBlock;
import jode.flow.SpecialBlock;
import jode.flow.StructuredBlock;
import jode.flow.SynchronizedBlock;
import jode.flow.ThrowBlock;
import jode.flow.TryBlock;
import jode.type.Type;

public class TransformExceptionHandlers {
    SortedSet handlers = new TreeSet();

    public void addHandler(FlowBlock flowBlock, int n, FlowBlock flowBlock2, Type type) {
        this.handlers.add(new Handler(flowBlock, n, flowBlock2, type));
    }

    static void analyzeCatchBlock(Type type, FlowBlock flowBlock, StructuredBlock structuredBlock) {
        CatchBlock catchBlock = new CatchBlock(type);
        ((TryBlock)flowBlock.block).addCatchBlock(catchBlock);
        catchBlock.setCatchBlock(structuredBlock);
    }

    boolean transformSubRoutine(StructuredBlock structuredBlock) {
        Object object;
        if (!(structuredBlock instanceof SequentialBlock)) {
            return false;
        }
        SequentialBlock sequentialBlock = (SequentialBlock)structuredBlock;
        StructuredBlock structuredBlock2 = sequentialBlock.getSubBlocks()[0];
        LocalInfo localInfo = null;
        if (structuredBlock2 instanceof SpecialBlock) {
            object = (SpecialBlock)structuredBlock2;
            if (((SpecialBlock)object).type != SpecialBlock.POP || ((SpecialBlock)object).count != 1) {
                return false;
            }
        } else if (structuredBlock2 instanceof InstructionBlock) {
            object = ((InstructionBlock)structuredBlock2).getInstruction();
            if (object instanceof StoreInstruction && ((StoreInstruction)object).getLValue() instanceof LocalStoreOperator) {
                LocalStoreOperator localStoreOperator = (LocalStoreOperator)((StoreInstruction)object).getLValue();
                localInfo = localStoreOperator.getLocalInfo();
                object = ((StoreInstruction)object).getSubExpressions()[1];
            }
            if (!(object instanceof NopOperator)) {
                return false;
            }
        } else {
            return false;
        }
        structuredBlock2.removeBlock();
        while (sequentialBlock.subBlocks[1] instanceof SequentialBlock) {
            sequentialBlock = (SequentialBlock)sequentialBlock.subBlocks[1];
        }
        if (sequentialBlock.subBlocks[1] instanceof RetBlock && ((RetBlock)sequentialBlock.subBlocks[1]).local.equals(localInfo)) {
            sequentialBlock.subBlocks[1].removeBlock();
        }
        return true;
    }

    private void removeReturnLocal(ReturnBlock returnBlock) {
        StructuredBlock structuredBlock = TransformExceptionHandlers.getPredecessor(returnBlock);
        if (!(structuredBlock instanceof InstructionBlock)) {
            return;
        }
        Expression expression = ((InstructionBlock)structuredBlock).getInstruction();
        if (!(expression instanceof StoreInstruction)) {
            return;
        }
        Expression expression2 = returnBlock.getInstruction();
        if (!(expression2 instanceof LocalLoadOperator) || !((StoreInstruction)expression).lvalueMatches((LocalLoadOperator)expression2)) {
            return;
        }
        Expression expression3 = ((StoreInstruction)expression).getSubExpressions()[1];
        returnBlock.setInstruction(expression3);
        returnBlock.replace(returnBlock.outer);
    }

    private void removeJSR(FlowBlock flowBlock, StructuredBlock structuredBlock, FlowBlock flowBlock2) {
        Jump jump = flowBlock.getJumps(flowBlock2);
        while (jump != null) {
            StructuredBlock structuredBlock2;
            StructuredBlock structuredBlock3 = jump.prev;
            Jump jump2 = jump.next;
            if (structuredBlock3 instanceof EmptyBlock && structuredBlock3.outer instanceof JsrBlock) {
                structuredBlock2 = (JsrBlock)structuredBlock3.outer;
                if (structuredBlock3.outer != structuredBlock) {
                    StructuredBlock structuredBlock4;
                    flowBlock.removeSuccessor(jump);
                    structuredBlock3.removeJump();
                    if (((JsrBlock)structuredBlock2).isGood()) {
                        structuredBlock4 = structuredBlock2.getNextBlock();
                        structuredBlock2.removeBlock();
                        if (structuredBlock4 instanceof ReturnBlock) {
                            this.removeReturnLocal((ReturnBlock)structuredBlock4);
                        }
                    } else {
                        structuredBlock4 = new DescriptionBlock("ERROR: JSR FINALLY BLOCK!");
                        structuredBlock4.replace(structuredBlock3.outer);
                    }
                }
            } else {
                structuredBlock2 = new DescriptionBlock("ERROR: GOTO FINALLY BLOCK!");
                flowBlock.removeSuccessor(jump);
                structuredBlock3.removeJump();
                structuredBlock3.appendBlock(structuredBlock2);
            }
            jump = jump2;
        }
    }

    private static StructuredBlock getPredecessor(StructuredBlock structuredBlock) {
        if (structuredBlock.outer instanceof SequentialBlock) {
            SequentialBlock sequentialBlock = (SequentialBlock)structuredBlock.outer;
            if (sequentialBlock.subBlocks[1] == structuredBlock) {
                return sequentialBlock.subBlocks[0];
            }
            if (sequentialBlock.outer instanceof SequentialBlock) {
                return sequentialBlock.outer.getSubBlocks()[0];
            }
        }
        return null;
    }

    private static int getMonitorExitSlot(StructuredBlock structuredBlock) {
        MonitorExitOperator monitorExitOperator;
        Expression expression;
        if (structuredBlock instanceof InstructionBlock && (expression = ((InstructionBlock)structuredBlock).getInstruction()) instanceof MonitorExitOperator && (monitorExitOperator = (MonitorExitOperator)expression).getFreeOperandCount() == 0 && monitorExitOperator.getSubExpressions()[0] instanceof LocalLoadOperator) {
            return ((LocalLoadOperator)monitorExitOperator.getSubExpressions()[0]).getLocalInfo().getSlot();
        }
        return -1;
    }

    private boolean isMonitorExitSubRoutine(FlowBlock flowBlock, LocalInfo localInfo) {
        return this.transformSubRoutine(flowBlock.block) && TransformExceptionHandlers.getMonitorExitSlot(flowBlock.block) == localInfo.getSlot();
    }

    private static StructuredBlock skipFinExitChain(StructuredBlock structuredBlock) {
        StructuredBlock structuredBlock2 = structuredBlock instanceof ReturnBlock ? TransformExceptionHandlers.getPredecessor(structuredBlock) : structuredBlock;
        StructuredBlock structuredBlock3 = null;
        while (structuredBlock2 instanceof JsrBlock || TransformExceptionHandlers.getMonitorExitSlot(structuredBlock2) >= 0) {
            structuredBlock3 = structuredBlock2;
            structuredBlock2 = TransformExceptionHandlers.getPredecessor(structuredBlock2);
        }
        return structuredBlock3;
    }

    /*
     * Unable to fully structure code
     */
    private void checkAndRemoveJSR(FlowBlock var1_1, StructuredBlock var2_2, FlowBlock var3_3, int var4_4, int var5_5) {
        var6_6 = var1_1.getSuccessors().iterator();
        block0: while (var6_6.hasNext()) {
            var7_7 = (FlowBlock)var6_6.next();
            if (var7_7 == var3_3) continue;
            var8_8 = true;
            var9_9 = var1_1.getJumps(var7_7);
            while (var9_9 != null) {
                block10: {
                    var10_10 = var9_9.prev;
                    if (var10_10 instanceof ThrowBlock || var10_10 instanceof EmptyBlock && var10_10.outer instanceof JsrBlock) break block10;
                    var11_11 = TransformExceptionHandlers.skipFinExitChain(var10_10);
                    if (!(var11_11 instanceof JsrBlock)) ** GOTO lbl-1000
                    var12_12 = (JsrBlock)var11_11;
                    var13_13 = var12_12.innerBlock;
                    if (var13_13 instanceof EmptyBlock && var13_13.jump != null && var13_13.jump.destination == var3_3) {
                        var12_12.setGood(true);
                    } else lbl-1000:
                    // 2 sources

                    {
                        if (var11_11 == null && var8_8 && var9_9.destination.predecessors.size() == 1 && var9_9.destination.getAddr() >= var4_4 && var9_9.destination.getNextAddr() <= var5_5) {
                            var9_9.destination.analyze(var4_4, var5_5);
                            var12_12 = var9_9.destination.block;
                            if (var12_12 instanceof SequentialBlock) {
                                var12_12 = var12_12.getSubBlocks()[0];
                            }
                            if (var12_12 instanceof JsrBlock && var12_12.getSubBlocks()[0] instanceof EmptyBlock && var12_12.getSubBlocks()[0].jump.destination == var3_3) {
                                var13_13 = var12_12.getSubBlocks()[0];
                                var9_9.destination.removeSuccessor(var13_13.jump);
                                var13_13.removeJump();
                                var12_12.removeBlock();
                                continue block0;
                            }
                        }
                        var12_12 = new DescriptionBlock("ERROR: NO JSR TO FINALLY");
                        if (var11_11 != null) {
                            var11_11.prependBlock(var12_12);
                        } else {
                            var10_10.appendBlock(var12_12);
                            var12_12.moveJump(var10_10.jump);
                        }
                    }
                }
                var9_9 = var9_9.next;
                var8_8 = false;
            }
        }
        if (var1_1.getSuccessors().contains(var3_3)) {
            this.removeJSR(var1_1, var2_2, var3_3);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkAndRemoveMonitorExit(FlowBlock var1_1, StructuredBlock var2_2, LocalInfo var3_3, int var4_4, int var5_5) {
        var6_6 = null;
        var7_7 = var1_1.getSuccessors().iterator();
        block0: while (var7_7.hasNext()) {
            var8_8 = true;
            var9_9 = (FlowBlock)var7_7.next();
            var10_10 = var1_1.getJumps(var9_9);
            while (var10_10 != null) {
                block15: {
                    block17: {
                        block16: {
                            var11_11 = var10_10.prev;
                            if (var11_11 instanceof ThrowBlock || var11_11 instanceof EmptyBlock && var11_11.outer instanceof JsrBlock) break block15;
                            var12_12 = TransformExceptionHandlers.skipFinExitChain(var11_11);
                            if (!(var12_12 instanceof JsrBlock)) break block16;
                            var13_13 = (JsrBlock)var12_12;
                            var14_14 = var13_13.innerBlock;
                            if (!(var14_14 instanceof EmptyBlock) || var14_14.jump == null) break block17;
                            var15_15 = var14_14.jump.destination;
                            if (var6_6 == null && var15_15.getAddr() >= var4_4 && var15_15.getNextAddr() <= var5_5) {
                                var15_15.analyze(var4_4, var5_5);
                                if (this.isMonitorExitSubRoutine(var15_15, var3_3)) {
                                    var6_6 = var15_15;
                                }
                            }
                            if (var15_15 != var6_6) break block17;
                            var13_13.setGood(true);
                            break block15;
                        }
                        if (TransformExceptionHandlers.getMonitorExitSlot(var12_12) == var3_3.getSlot()) {
                            var12_12.removeBlock();
                            if (var11_11 instanceof ReturnBlock) {
                                this.removeReturnLocal((ReturnBlock)var11_11);
                                ** GOTO lbl59
                            } else {
                                ** GOTO lbl31
                            }
                        }
                        break block17;
lbl31:
                        // 2 sources

                        break block15;
                    }
                    if (var12_12 == null && var8_8 && var9_9.predecessors.size() == 1 && var9_9.getAddr() >= var4_4 && var9_9.getNextAddr() <= var5_5) {
                        var9_9.analyze(var4_4, var5_5);
                        var13_13 = var9_9.block;
                        if (var13_13 instanceof SequentialBlock) {
                            var13_13 = var13_13.getSubBlocks()[0];
                        }
                        if (var13_13 instanceof JsrBlock && var13_13.getSubBlocks()[0] instanceof EmptyBlock) {
                            var14_14 = var13_13.getSubBlocks()[0];
                            var15_15 = var14_14.jump.destination;
                            if (var6_6 == null && var15_15.getAddr() >= var4_4 && var15_15.getNextAddr() <= var5_5) {
                                var15_15.analyze(var4_4, var5_5);
                                if (this.isMonitorExitSubRoutine(var15_15, var3_3)) {
                                    var6_6 = var15_15;
                                }
                            }
                            if (var6_6 == var15_15) {
                                var9_9.removeSuccessor(var14_14.jump);
                                var14_14.removeJump();
                                var13_13.removeBlock();
                                continue block0;
                            }
                        }
                        if (TransformExceptionHandlers.getMonitorExitSlot(var13_13) == var3_3.getSlot()) {
                            var13_13.removeBlock();
                            continue block0;
                        }
                    }
                    var13_13 = new DescriptionBlock("ERROR: NO MONITOREXIT");
                    var11_11.appendBlock(var13_13);
                    var13_13.moveJump(var10_10);
                }
                var10_10 = var10_10.next;
                var8_8 = false;
            }
        }
        if (var6_6 != null) {
            if (var1_1.getSuccessors().contains(var6_6)) {
                this.removeJSR(var1_1, var2_2, var6_6);
            }
            var1_1.mergeAddr(var6_6);
        }
    }

    private StoreInstruction getExceptionStore(StructuredBlock structuredBlock) {
        if (!(structuredBlock instanceof SequentialBlock) || !(structuredBlock.getSubBlocks()[0] instanceof InstructionBlock)) {
            return null;
        }
        Expression expression = ((InstructionBlock)structuredBlock.getSubBlocks()[0]).getInstruction();
        if (!(expression instanceof StoreInstruction)) {
            return null;
        }
        StoreInstruction storeInstruction = (StoreInstruction)expression;
        if (!(storeInstruction.getLValue() instanceof LocalStoreOperator) || !(storeInstruction.getSubExpressions()[1] instanceof NopOperator)) {
            return null;
        }
        return storeInstruction;
    }

    private boolean analyzeSynchronized(FlowBlock flowBlock, StructuredBlock structuredBlock, int n) {
        StoreInstruction storeInstruction = this.getExceptionStore(structuredBlock);
        if (storeInstruction != null) {
            structuredBlock = structuredBlock.getSubBlocks()[1];
        }
        if (!(structuredBlock instanceof SequentialBlock) || !(structuredBlock.getSubBlocks()[0] instanceof InstructionBlock)) {
            return false;
        }
        Expression expression = ((InstructionBlock)structuredBlock.getSubBlocks()[0]).getInstruction();
        if (!(expression instanceof MonitorExitOperator && expression.getFreeOperandCount() == 0 && ((MonitorExitOperator)expression).getSubExpressions()[0] instanceof LocalLoadOperator && structuredBlock.getSubBlocks()[1] instanceof ThrowBlock)) {
            return false;
        }
        Expression expression2 = ((ThrowBlock)structuredBlock.getSubBlocks()[1]).getInstruction();
        if (storeInstruction != null ? !(expression2 instanceof Operator) || !storeInstruction.lvalueMatches((Operator)expression2) : !(expression2 instanceof NopOperator)) {
            return false;
        }
        MonitorExitOperator monitorExitOperator = (MonitorExitOperator)((InstructionBlock)structuredBlock.getSubBlocks()[0]).instr;
        LocalInfo localInfo = ((LocalLoadOperator)monitorExitOperator.getSubExpressions()[0]).getLocalInfo();
        if ((GlobalOptions.debuggingFlags & 0x20) != 0) {
            GlobalOptions.err.println("analyzeSynchronized(" + flowBlock.getAddr() + "," + flowBlock.getNextAddr() + "," + n + ")");
        }
        this.checkAndRemoveMonitorExit(flowBlock, structuredBlock, localInfo, flowBlock.getNextAddr(), n);
        SynchronizedBlock synchronizedBlock = new SynchronizedBlock(localInfo);
        TryBlock tryBlock = (TryBlock)flowBlock.block;
        synchronizedBlock.replace(tryBlock);
        synchronizedBlock.moveJump(tryBlock.jump);
        synchronizedBlock.setBodyBlock(tryBlock.subBlocks.length == 1 ? tryBlock.subBlocks[0] : tryBlock);
        flowBlock.lastModified = synchronizedBlock;
        return true;
    }

    private boolean analyzeFinally(FlowBlock flowBlock, StructuredBlock structuredBlock, int n) {
        StructuredBlock structuredBlock2;
        FlowBlock flowBlock2;
        StructuredBlock structuredBlock3;
        StoreInstruction storeInstruction = this.getExceptionStore(structuredBlock);
        if (storeInstruction == null) {
            return false;
        }
        if (!((structuredBlock = structuredBlock.getSubBlocks()[1]) instanceof SequentialBlock)) {
            return false;
        }
        StructuredBlock structuredBlock4 = null;
        if (structuredBlock.getSubBlocks()[0] instanceof LoopBlock) {
            structuredBlock3 = (LoopBlock)structuredBlock.getSubBlocks()[0];
            if (structuredBlock3.type == 1 && structuredBlock3.cond == LoopBlock.FALSE && structuredBlock3.bodyBlock instanceof SequentialBlock && this.transformSubRoutine(structuredBlock.getSubBlocks()[1])) {
                structuredBlock4 = structuredBlock.getSubBlocks()[1];
                structuredBlock = (SequentialBlock)structuredBlock3.bodyBlock;
            }
        }
        if (!(structuredBlock instanceof SequentialBlock && structuredBlock.getSubBlocks()[0] instanceof JsrBlock && structuredBlock.getSubBlocks()[1] instanceof ThrowBlock)) {
            return false;
        }
        structuredBlock3 = (JsrBlock)structuredBlock.getSubBlocks()[0];
        ThrowBlock throwBlock = (ThrowBlock)structuredBlock.getSubBlocks()[1];
        if (!(throwBlock.getInstruction() instanceof Operator) || !storeInstruction.lvalueMatches((Operator)throwBlock.getInstruction())) {
            return false;
        }
        if (structuredBlock4 != null) {
            if (!(((JsrBlock)structuredBlock3).innerBlock instanceof BreakBlock)) {
                return false;
            }
            structuredBlock = structuredBlock4;
            flowBlock2 = null;
        } else {
            if (!(((JsrBlock)structuredBlock3).innerBlock instanceof EmptyBlock)) {
                return false;
            }
            structuredBlock = structuredBlock3;
            flowBlock2 = ((JsrBlock)structuredBlock3).innerBlock.jump.destination;
            this.checkAndRemoveJSR(flowBlock, structuredBlock, flowBlock2, flowBlock.getNextAddr(), flowBlock2.getAddr());
        }
        StructuredBlock structuredBlock5 = (TryBlock)flowBlock.block;
        if (structuredBlock5.getSubBlocks()[0] instanceof TryBlock) {
            structuredBlock2 = (TryBlock)structuredBlock5.getSubBlocks()[0];
            ((TryBlock)structuredBlock2).gen = structuredBlock5.gen;
            structuredBlock2.replace(structuredBlock5);
            structuredBlock5 = structuredBlock2;
            flowBlock.lastModified = structuredBlock5;
            flowBlock.block = structuredBlock5;
        }
        structuredBlock2 = new FinallyBlock();
        ((FinallyBlock)structuredBlock2).setCatchBlock(structuredBlock);
        structuredBlock5.addCatchBlock(structuredBlock2);
        if (flowBlock2 != null) {
            while (flowBlock2.analyze(flowBlock.getNextAddr(), n)) {
            }
            if (flowBlock2.predecessors.size() == 1 && this.transformSubRoutine(flowBlock2.block)) {
                flowBlock.removeSuccessor(((JsrBlock)structuredBlock3).innerBlock.jump);
                flowBlock.mergeAddr(flowBlock2);
                flowBlock.mergeSuccessors(flowBlock2);
                flowBlock2.block.replace(structuredBlock);
                flowBlock.updateInOutCatch(flowBlock2);
            }
        }
        return true;
    }

    private boolean analyzeSpecialFinally(FlowBlock flowBlock, StructuredBlock structuredBlock, int n) {
        StructuredBlock structuredBlock2;
        Object object;
        StructuredBlock structuredBlock3;
        StructuredBlock structuredBlock4 = structuredBlock3 = structuredBlock instanceof SequentialBlock ? structuredBlock.getSubBlocks()[0] : structuredBlock;
        if (!(structuredBlock3 instanceof SpecialBlock) || ((SpecialBlock)structuredBlock3).type != SpecialBlock.POP || ((SpecialBlock)structuredBlock3).count != 1) {
            return false;
        }
        FlowBlock flowBlock2 = null;
        if (structuredBlock instanceof SequentialBlock) {
            structuredBlock = structuredBlock.getSubBlocks()[1];
        } else {
            structuredBlock = new EmptyBlock();
            structuredBlock.moveJump(structuredBlock3.jump);
            flowBlock2 = structuredBlock3.jump.destination;
        }
        if (flowBlock2 != null) {
            object = flowBlock.removeJumps(flowBlock2);
            object = flowBlock.resolveSomeJumps((Jump)object, flowBlock2);
            flowBlock.resolveRemaining((Jump)object);
        }
        if (((TryBlock)(object = (TryBlock)flowBlock.block)).getSubBlocks()[0] instanceof TryBlock) {
            structuredBlock2 = (TryBlock)((TryBlock)object).getSubBlocks()[0];
            ((TryBlock)structuredBlock2).gen = ((TryBlock)object).gen;
            structuredBlock2.replace((StructuredBlock)object);
            object = structuredBlock2;
            flowBlock.lastModified = structuredBlock2;
        }
        structuredBlock2 = new FinallyBlock();
        ((TryBlock)object).addCatchBlock(structuredBlock2);
        ((FinallyBlock)structuredBlock2).setCatchBlock(structuredBlock);
        return true;
    }

    public void analyze() {
        int n;
        Handler handler;
        Object object = null;
        Object object2 = this.handlers.iterator();
        while (object2.hasNext()) {
            handler = (Handler)object2.next();
            int n2 = handler.start.getAddr();
            n = handler.endAddr;
            int n3 = handler.handler.getAddr();
            if (n2 >= n || n3 < n) {
                throw new AssertError("ExceptionHandler order failed: not " + n2 + " < " + n + " <= " + n3);
            }
            if (object != null && (((Handler)object).start.getAddr() != n2 || ((Handler)object).endAddr != n) && n > ((Handler)object).start.getAddr() && n < ((Handler)object).endAddr) {
                throw new AssertError("Exception handlers ranges are intersecting: [" + ((Handler)object).start.getAddr() + ", " + ((Handler)object).endAddr + "] and [" + n2 + ", " + n + "].");
            }
            object = handler;
        }
        object = this.handlers.iterator();
        object2 = null;
        handler = object.hasNext() ? (Handler)object.next() : null;
        while (handler != null) {
            Object object3;
            Object object4;
            boolean bl;
            Object object5;
            Iterator iterator = object2;
            object2 = handler;
            handler = object.hasNext() ? (Handler)object.next() : null;
            n = Integer.MAX_VALUE;
            if (handler != null && handler.endAddr > ((Handler)object2).endAddr) {
                n = handler.endAddr;
            }
            FlowBlock flowBlock = ((Handler)object2).start;
            flowBlock.checkConsistent();
            if (iterator == null || ((Handler)object2).type == null || ((Handler)((Object)iterator)).start.getAddr() != ((Handler)object2).start.getAddr() || ((Handler)((Object)iterator)).endAddr != ((Handler)object2).endAddr) {
                if ((GlobalOptions.debuggingFlags & 0x20) != 0) {
                    GlobalOptions.err.println("analyzeTry(" + ((Handler)object2).start.getAddr() + ", " + ((Handler)object2).endAddr + ")");
                }
                while (flowBlock.analyze(flowBlock.getAddr(), ((Handler)object2).endAddr)) {
                }
                object5 = new TryBlock(flowBlock);
            } else if (!(flowBlock.block instanceof TryBlock)) {
                throw new AssertError("no TryBlock");
            }
            object5 = ((Handler)object2).handler;
            boolean bl2 = bl = ((FlowBlock)object5).predecessors.size() != 0;
            if (!bl && handler != null) {
                object4 = this.handlers.tailSet(handler).iterator();
                while (object4.hasNext()) {
                    object3 = (Handler)object4.next();
                    if (((Handler)object3).handler != object5) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                object4 = new EmptyBlock(new Jump((FlowBlock)object5));
                object3 = new FlowBlock(((FlowBlock)object5).method, ((FlowBlock)object5).getAddr());
                ((FlowBlock)object3).appendBlock((StructuredBlock)object4, 0);
                ((FlowBlock)object5).prevByAddr.nextByAddr = object3;
                ((FlowBlock)object3).prevByAddr = ((FlowBlock)object5).prevByAddr;
                ((FlowBlock)object3).nextByAddr = object5;
                ((FlowBlock)object5).prevByAddr = object3;
                object5 = object3;
            } else {
                if ((GlobalOptions.debuggingFlags & 0x20) != 0) {
                    GlobalOptions.err.println("analyzeCatch(" + ((FlowBlock)object5).getAddr() + ", " + n + ")");
                }
                while (((FlowBlock)object5).analyze(((FlowBlock)object5).getAddr(), n)) {
                }
            }
            flowBlock.updateInOutCatch((FlowBlock)object5);
            flowBlock.mergeSuccessors((FlowBlock)object5);
            flowBlock.mergeAddr((FlowBlock)object5);
            if (((Handler)object2).type != null) {
                TransformExceptionHandlers.analyzeCatchBlock(((Handler)object2).type, flowBlock, ((FlowBlock)object5).block);
            } else if (!(this.analyzeSynchronized(flowBlock, ((FlowBlock)object5).block, n) || this.analyzeFinally(flowBlock, ((FlowBlock)object5).block, n) || this.analyzeSpecialFinally(flowBlock, ((FlowBlock)object5).block, n))) {
                TransformExceptionHandlers.analyzeCatchBlock(Type.tObject, flowBlock, ((FlowBlock)object5).block);
            }
            flowBlock.checkConsistent();
            if ((GlobalOptions.debuggingFlags & 0x20) == 0) continue;
            GlobalOptions.err.println("analyzeTryCatch(" + flowBlock.getAddr() + ", " + flowBlock.getNextAddr() + ") done.");
        }
    }

    static class Handler
    implements Comparable {
        FlowBlock start;
        int endAddr;
        FlowBlock handler;
        Type type;

        public int compareTo(Object object) {
            Handler handler = (Handler)object;
            if (this.start.getAddr() != handler.start.getAddr()) {
                return handler.start.getAddr() - this.start.getAddr();
            }
            if (this.endAddr != handler.endAddr) {
                return this.endAddr - handler.endAddr;
            }
            if (this.handler.getAddr() != handler.handler.getAddr()) {
                return this.handler.getAddr() - handler.handler.getAddr();
            }
            if (this.type == handler.type) {
                return 0;
            }
            if (this.type == null) {
                return -1;
            }
            if (handler.type == null) {
                return 1;
            }
            return this.type.getTypeSignature().compareTo(handler.type.getTypeSignature());
        }

        public Handler(FlowBlock flowBlock, int n, FlowBlock flowBlock2, Type type) {
            this.start = flowBlock;
            this.endAddr = n;
            this.handler = flowBlock2;
            this.type = type;
        }
    }
}

