/*
 * Decompiled with CFR 0.152.
 */
package jode.obfuscator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import jode.GlobalOptions;
import jode.bytecode.ClassInfo;
import jode.bytecode.FieldInfo;
import jode.bytecode.InnerClassInfo;
import jode.bytecode.MethodInfo;
import jode.bytecode.Reference;
import jode.obfuscator.FieldIdentifier;
import jode.obfuscator.Identifier;
import jode.obfuscator.IdentifierMatcher;
import jode.obfuscator.Main;
import jode.obfuscator.MethodIdentifier;
import jode.obfuscator.PackageIdentifier;
import jode.obfuscator.modules.ModifierMatcher;

public class ClassIdentifier
extends Identifier {
    PackageIdentifier pack;
    String name;
    String fullName;
    ClassInfo info;
    String superName;
    String[] ifaceNames;
    List fieldIdents;
    List methodIdents;
    List knownSubClasses = new LinkedList();
    List virtualReachables = new LinkedList();

    public void addSubClass(ClassIdentifier classIdentifier) {
        this.knownSubClasses.add(classIdentifier);
        Iterator iterator = this.virtualReachables.iterator();
        while (iterator.hasNext()) {
            classIdentifier.reachableReference((Reference)iterator.next(), true);
        }
    }

    private FieldIdentifier findField(String string, String string2) {
        Iterator iterator = this.fieldIdents.iterator();
        while (iterator.hasNext()) {
            FieldIdentifier fieldIdentifier = (FieldIdentifier)iterator.next();
            if (!fieldIdentifier.getName().equals(string) || !fieldIdentifier.getType().equals(string2)) continue;
            return fieldIdentifier;
        }
        return null;
    }

    private MethodIdentifier findMethod(String string, String string2) {
        Iterator iterator = this.methodIdents.iterator();
        while (iterator.hasNext()) {
            MethodIdentifier methodIdentifier = (MethodIdentifier)iterator.next();
            if (!methodIdentifier.getName().equals(string) || !methodIdentifier.getType().equals(string2)) continue;
            return methodIdentifier;
        }
        return null;
    }

    public void reachableReference(Reference reference, boolean bl) {
        Object object;
        boolean bl2 = false;
        Iterator iterator = this.getChilds();
        while (iterator.hasNext()) {
            object = (Identifier)iterator.next();
            if (!reference.getName().equals(((Identifier)object).getName()) || !reference.getType().equals(((Identifier)object).getType())) continue;
            ((Identifier)object).setReachable();
            bl2 = true;
        }
        if (!bl2 && (iterator = Main.getClassBundle().getClassIdentifier(this.info.getSuperclass().getName())) != null) {
            ((ClassIdentifier)((Object)iterator)).reachableReference(reference, false);
        }
        if (bl) {
            iterator = this.virtualReachables.iterator();
            while (iterator.hasNext()) {
                object = (Reference)iterator.next();
                if (!((Reference)object).getName().equals(reference.getName()) || !((Reference)object).getType().equals(reference.getType())) continue;
                return;
            }
            iterator = this.knownSubClasses.iterator();
            while (iterator.hasNext()) {
                ((ClassIdentifier)iterator.next()).reachableReference(reference, false);
            }
            this.virtualReachables.add(reference);
        }
    }

    public void chainMethodIdentifier(Identifier identifier) {
        String string = identifier.getName();
        String string2 = identifier.getType();
        Iterator iterator = this.methodIdents.iterator();
        while (iterator.hasNext()) {
            Identifier identifier2 = (Identifier)iterator.next();
            if (!identifier2.getName().equals(string) || !identifier2.getType().equals(string2)) continue;
            identifier.addShadow(identifier2);
        }
    }

    public long calcSerialVersionUID() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            GlobalOptions.err.println("Can't calculate serialVersionUID");
            return 0L;
        }
        ClassIdentifier classIdentifier = this;
        if (classIdentifier == null) {
            throw null;
        }
        OutputStream outputStream = new OutputStream(classIdentifier, messageDigest){
            private final /* synthetic */ ClassIdentifier this$0;
            private final /* synthetic */ MessageDigest val$md;

            public void write(int n) {
                this.val$md.update((byte)n);
            }

            public void write(byte[] byArray, int n, int n2) {
                this.val$md.update(byArray, n, n2);
            }
            {
                this.val$md = messageDigest;
                this.this$0 = classIdentifier;
                this.constructor$0(classIdentifier);
            }

            private final void constructor$0(ClassIdentifier classIdentifier) {
            }
        };
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            Identifier identifier;
            dataOutputStream.writeUTF(this.info.getName());
            int n = this.info.getModifiers();
            dataOutputStream.writeInt(n &= 0x611);
            ClassInfo[] classInfoArray = (ClassInfo[])this.info.getInterfaces().clone();
            ClassIdentifier classIdentifier2 = this;
            if (classIdentifier2 == null) {
                throw null;
            }
            Arrays.sort(classInfoArray, new Comparator(classIdentifier2){
                private final /* synthetic */ ClassIdentifier this$0;

                public int compare(Object object, Object object2) {
                    return ((ClassInfo)object).getName().compareTo(((ClassInfo)object2).getName());
                }
                {
                    this.this$0 = classIdentifier;
                    this.constructor$0(classIdentifier);
                }

                private final void constructor$0(ClassIdentifier classIdentifier) {
                }
            });
            int n2 = 0;
            while (n2 < classInfoArray.length) {
                dataOutputStream.writeUTF(classInfoArray[n2].getName());
                ++n2;
            }
            ClassIdentifier classIdentifier3 = this;
            if (classIdentifier3 == null) {
                throw null;
            }
            Comparator comparator = new Comparator(classIdentifier3){
                private final /* synthetic */ ClassIdentifier this$0;

                public int compare(Object object, Object object2) {
                    boolean bl;
                    Identifier identifier = (Identifier)object;
                    Identifier identifier2 = (Identifier)object2;
                    String string = identifier.getName();
                    String string2 = identifier2.getName();
                    boolean bl2 = string.equals("<init>") || string.equals("<clinit>");
                    boolean bl3 = bl = string2.equals("<init>") || string2.equals("<clinit>");
                    if (bl2 != bl) {
                        return bl2 ? -1 : 1;
                    }
                    int n = identifier.getName().compareTo(identifier2.getName());
                    if (n != 0) {
                        return n;
                    }
                    return identifier.getType().compareTo(identifier2.getType());
                }
                {
                    this.this$0 = classIdentifier;
                    this.constructor$0(classIdentifier);
                }

                private final void constructor$0(ClassIdentifier classIdentifier) {
                }
            };
            List<Object> list = Arrays.asList(this.fieldIdents.toArray());
            List<Object> list2 = Arrays.asList(this.methodIdents.toArray());
            Collections.sort(list, comparator);
            Collections.sort(list2, comparator);
            Object object = list.iterator();
            while (object.hasNext()) {
                identifier = (FieldIdentifier)object.next();
                n = ((FieldIdentifier)identifier).info.getModifiers();
                if ((n & 2) != 0 && (n & 0x88) != 0) continue;
                dataOutputStream.writeUTF(((FieldIdentifier)identifier).getName());
                dataOutputStream.writeInt(n);
                dataOutputStream.writeUTF(((FieldIdentifier)identifier).getType());
            }
            object = list2.iterator();
            while (object.hasNext()) {
                identifier = (MethodIdentifier)object.next();
                n = ((MethodIdentifier)identifier).info.getModifiers();
                if (Modifier.isPrivate(n)) continue;
                dataOutputStream.writeUTF(((MethodIdentifier)identifier).getName());
                dataOutputStream.writeInt(n);
                dataOutputStream.writeUTF(((MethodIdentifier)identifier).getType().replace('/', '.'));
            }
            dataOutputStream.close();
            object = messageDigest.digest();
            long l = 0L;
            int n3 = 0;
            while (n3 < 8) {
                l += (long)(object[n3] & 0xFF) << 8 * n3;
                ++n3;
            }
            return l;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            GlobalOptions.err.println("Can't calculate serialVersionUID");
            return 0L;
        }
    }

    public void addSUID() {
        long l = this.calcSerialVersionUID();
        FieldInfo fieldInfo = new FieldInfo(this.info, "serialVersionUID", "J", 25);
        fieldInfo.setConstant(new Long(l));
        FieldIdentifier fieldIdentifier = new FieldIdentifier(this, fieldInfo);
        this.fieldIdents.add(fieldIdentifier);
        fieldIdentifier.setPreserved();
    }

    public boolean isSerializable() {
        return ClassInfo.forName("java.lang.Serializable").implementedBy(this.info);
    }

    public boolean hasSUID() {
        return this.findField("serialVersionUID", "J") != null;
    }

    protected void setSinglePreserved() {
        this.pack.setPreserved();
    }

    public void setSingleReachable() {
        super.setSingleReachable();
        Main.getClassBundle().analyzeIdentifier(this);
    }

    public void analyzeSuperClasses(ClassInfo classInfo) {
        while (classInfo != null) {
            Object object;
            ClassIdentifier classIdentifier = Main.getClassBundle().getClassIdentifier(classInfo.getName());
            if (classIdentifier != null) {
                classIdentifier.addSubClass(this);
            } else {
                object = ("L" + classInfo.getName().replace('.', '/') + ";").intern();
                MethodInfo[] methodInfoArray = classInfo.getMethods();
                int n = 0;
                while (n < methodInfoArray.length) {
                    int n2 = methodInfoArray[n].getModifiers();
                    if ((0x1A & n2) == 0 && !methodInfoArray[n].getName().equals("<init>")) {
                        this.reachableReference(Reference.getReference((String)object, methodInfoArray[n].getName(), methodInfoArray[n].getType()), true);
                    }
                    ++n;
                }
            }
            object = classInfo.getInterfaces();
            int n = 0;
            while (n < ((ClassInfo[])object).length) {
                this.analyzeSuperClasses(object[n]);
                ++n;
            }
            classInfo = classInfo.getSuperclass();
        }
    }

    public void analyze() {
        if (GlobalOptions.verboseLevel > 0) {
            GlobalOptions.err.println("Reachable: " + this);
        }
        ClassInfo[] classInfoArray = this.info.getInterfaces();
        int n = 0;
        while (n < classInfoArray.length) {
            this.analyzeSuperClasses(classInfoArray[n]);
            ++n;
        }
        this.analyzeSuperClasses(this.info.getSuperclass());
    }

    public void initSuperClasses(ClassInfo classInfo) {
        while (classInfo != null) {
            int n;
            int n2;
            Object object;
            ClassIdentifier classIdentifier = Main.getClassBundle().getClassIdentifier(classInfo.getName());
            if (classIdentifier != null) {
                object = classIdentifier.getMethodIdents().iterator();
                while (object.hasNext()) {
                    MethodIdentifier methodIdentifier = (MethodIdentifier)object.next();
                    n2 = methodIdentifier.info.getModifiers();
                    if ((0x1A & n2) != 0 || methodIdentifier.getName().equals("<init>")) continue;
                    this.chainMethodIdentifier(methodIdentifier);
                }
            } else {
                object = classInfo.getMethods();
                n = 0;
                while (n < ((Object)object).length) {
                    MethodIdentifier methodIdentifier;
                    n2 = ((MethodInfo)object[n]).getModifiers();
                    if ((0x1A & n2) == 0 && !((MethodInfo)object[n]).getName().equals("<init>") && (methodIdentifier = this.findMethod(((MethodInfo)object[n]).getName(), ((MethodInfo)object[n]).getType())) != null) {
                        methodIdentifier.setPreserved();
                    }
                    ++n;
                }
            }
            object = classInfo.getInterfaces();
            n = 0;
            while (n < ((Object)object).length) {
                this.initSuperClasses((ClassInfo)object[n]);
                ++n;
            }
            classInfo = classInfo.getSuperclass();
        }
    }

    public void initClass() {
        int n;
        this.info.loadInfo(255);
        FieldInfo[] fieldInfoArray = this.info.getFields();
        MethodInfo[] methodInfoArray = this.info.getMethods();
        if (Main.swapOrder) {
            Random random = new Random();
            Collections.shuffle(Arrays.asList(fieldInfoArray), random);
            Collections.shuffle(Arrays.asList(methodInfoArray), random);
        }
        this.fieldIdents = new ArrayList(fieldInfoArray.length);
        this.methodIdents = new ArrayList(methodInfoArray.length);
        int n2 = 0;
        while (n2 < fieldInfoArray.length) {
            this.fieldIdents.add(new FieldIdentifier(this, fieldInfoArray[n2]));
            ++n2;
        }
        n2 = 0;
        while (n2 < methodInfoArray.length) {
            MethodIdentifier methodIdentifier = new MethodIdentifier(this, methodInfoArray[n2]);
            this.methodIdents.add(methodIdentifier);
            if (methodIdentifier.getName().equals("<clinit>")) {
                methodIdentifier.setPreserved();
                methodIdentifier.setReachable();
            } else if (methodIdentifier.getName().equals("<init>")) {
                methodIdentifier.setPreserved();
            }
            ++n2;
        }
        ClassInfo[] classInfoArray = this.info.getInterfaces();
        this.ifaceNames = new String[classInfoArray.length];
        int n3 = 0;
        while (n3 < classInfoArray.length) {
            this.ifaceNames[n3] = classInfoArray[n3].getName();
            this.initSuperClasses(classInfoArray[n3]);
            ++n3;
        }
        if (this.info.getSuperclass() != null) {
            this.superName = this.info.getSuperclass().getName();
            this.initSuperClasses(this.info.getSuperclass());
        }
        if ((Main.stripping & 0x10) != 0) {
            this.info.setSourceFile(null);
        }
        if ((Main.stripping & 2) != 0) {
            this.info.setInnerClasses(new InnerClassInfo[0]);
            this.info.setOuterClasses(new InnerClassInfo[0]);
            this.info.setExtraClasses(new InnerClassInfo[0]);
        }
        InnerClassInfo[] innerClassInfoArray = this.info.getInnerClasses();
        InnerClassInfo[] innerClassInfoArray2 = this.info.getOuterClasses();
        InnerClassInfo[] innerClassInfoArray3 = this.info.getExtraClasses();
        if (innerClassInfoArray2 != null) {
            n = 0;
            while (n < innerClassInfoArray2.length) {
                if (innerClassInfoArray2[n].outer != null) {
                    Main.getClassBundle().getClassIdentifier(innerClassInfoArray2[n].outer);
                }
                ++n;
            }
        }
        if (innerClassInfoArray != null) {
            n = 0;
            while (n < innerClassInfoArray.length) {
                Main.getClassBundle().getClassIdentifier(innerClassInfoArray[n].inner);
                ++n;
            }
        }
        if (innerClassInfoArray3 != null) {
            n = 0;
            while (n < innerClassInfoArray3.length) {
                Main.getClassBundle().getClassIdentifier(innerClassInfoArray3[n].inner);
                if (innerClassInfoArray3[n].outer != null) {
                    Main.getClassBundle().getClassIdentifier(innerClassInfoArray3[n].outer);
                }
                ++n;
            }
        }
    }

    public void addIfaces(Collection collection, ClassIdentifier classIdentifier) {
        ClassInfo[] classInfoArray = classIdentifier.info.getInterfaces();
        int n = 0;
        while (n < classInfoArray.length) {
            ClassIdentifier classIdentifier2 = Main.getClassBundle().getClassIdentifier(classInfoArray[n].getName());
            if (classIdentifier2 != null && !classIdentifier2.isReachable()) {
                this.addIfaces(collection, classIdentifier2);
            } else {
                collection.add(classInfoArray[n]);
            }
            ++n;
        }
    }

    public void transformSuperIfaces() {
        Object object;
        if ((Main.stripping & 1) == 0) {
            return;
        }
        LinkedList linkedList = new LinkedList();
        ClassIdentifier classIdentifier = this;
        while (true) {
            this.addIfaces(linkedList, classIdentifier);
            object = Main.getClassBundle().getClassIdentifier(classIdentifier.superName);
            if (object == null || ((Identifier)object).isReachable()) break;
            classIdentifier = object;
        }
        object = classIdentifier.info.getSuperclass();
        ClassInfo[] classInfoArray = linkedList.toArray(new ClassInfo[linkedList.size()]);
        this.info.setSuperclass((ClassInfo)object);
        this.info.setInterfaces(classInfoArray);
    }

    public void transformInnerClasses() {
        InnerClassInfo[] innerClassInfoArray;
        InnerClassInfo[] innerClassInfoArray2;
        String string;
        Object object;
        Object object2;
        ClassIdentifier classIdentifier;
        int n;
        Object object3;
        Object object4;
        InnerClassInfo[] innerClassInfoArray3 = this.info.getOuterClasses();
        if (innerClassInfoArray3 != null) {
            int n2 = innerClassInfoArray3.length;
            if ((Main.stripping & 1) != 0) {
                int n3 = 0;
                while (n3 < innerClassInfoArray3.length) {
                    if (innerClassInfoArray3[n3].outer != null && (object4 = Main.getClassBundle().getClassIdentifier(innerClassInfoArray3[n3].outer)) != null && !((Identifier)object4).isReachable()) {
                        --n2;
                    }
                    ++n3;
                }
            }
            if (n2 == 0) {
                this.info.setOuterClasses(null);
            } else {
                InnerClassInfo[] innerClassInfoArray4 = new InnerClassInfo[n2];
                int n4 = 0;
                object3 = this.getFullAlias();
                n = 0;
                while (n < innerClassInfoArray3.length) {
                    ClassIdentifier classIdentifier2 = classIdentifier = innerClassInfoArray3[n].outer != null ? Main.getClassBundle().getClassIdentifier(innerClassInfoArray3[n].outer) : null;
                    if (classIdentifier == null || classIdentifier.isReachable()) {
                        object2 = object3;
                        Object object5 = object = classIdentifier == null ? innerClassInfoArray3[n].outer : classIdentifier.getFullAlias();
                        string = innerClassInfoArray3[n].name == null ? null : (object != null && ((String)object2).startsWith((String)object + "$") ? ((String)object2).substring(((String)object).length() + 1) : ((String)object2).substring(((String)object2).lastIndexOf(46) + 1));
                        innerClassInfoArray4[n4++] = new InnerClassInfo((String)object2, (String)object, string, innerClassInfoArray3[n].modifiers);
                        object3 = object;
                    }
                    ++n;
                }
                this.info.setOuterClasses(innerClassInfoArray4);
            }
        }
        if ((innerClassInfoArray2 = this.info.getInnerClasses()) != null) {
            int n5 = innerClassInfoArray2.length;
            if ((Main.stripping & 1) != 0) {
                int n6 = 0;
                while (n6 < innerClassInfoArray2.length) {
                    object3 = Main.getClassBundle().getClassIdentifier(innerClassInfoArray2[n6].inner);
                    if (object3 != null && !((Identifier)object3).isReachable()) {
                        --n5;
                    }
                    ++n6;
                }
            }
            if (n5 == 0) {
                this.info.setInnerClasses(null);
            } else {
                object4 = new InnerClassInfo[n5];
                int n7 = 0;
                n = 0;
                while (n < innerClassInfoArray2.length) {
                    classIdentifier = Main.getClassBundle().getClassIdentifier(innerClassInfoArray2[n].inner);
                    if (classIdentifier == null || (Main.stripping & 1) == 0 || classIdentifier.isReachable()) {
                        object2 = classIdentifier == null ? innerClassInfoArray2[n].inner : classIdentifier.getFullAlias();
                        object = this.getFullAlias();
                        string = innerClassInfoArray2[n].name == null ? null : (object != null && ((String)object2).startsWith((String)object + "$") ? ((String)object2).substring(((String)object).length() + 1) : ((String)object2).substring(((String)object2).lastIndexOf(46) + 1));
                        object4[n7++] = new InnerClassInfo((String)object2, (String)object, string, innerClassInfoArray2[n].modifiers);
                    }
                    ++n;
                }
                this.info.setInnerClasses((InnerClassInfo[])object4);
            }
        }
        if ((innerClassInfoArray = this.info.getExtraClasses()) != null) {
            int n8 = innerClassInfoArray.length;
            if ((Main.stripping & 1) != 0) {
                int n9 = 0;
                while (n9 < innerClassInfoArray.length) {
                    ClassIdentifier classIdentifier3 = innerClassInfoArray[n9].outer != null ? Main.getClassBundle().getClassIdentifier(innerClassInfoArray[n9].outer) : null;
                    classIdentifier = Main.getClassBundle().getClassIdentifier(innerClassInfoArray[n9].inner);
                    if (classIdentifier3 != null && !classIdentifier3.isReachable() || classIdentifier != null && !classIdentifier.isReachable()) {
                        --n8;
                    }
                    ++n9;
                }
            }
            if (n8 == 0) {
                this.info.setExtraClasses(null);
            } else {
                InnerClassInfo[] innerClassInfoArray5 = n8 > 0 ? new InnerClassInfo[n8] : null;
                int n10 = 0;
                int n11 = 0;
                while (n11 < innerClassInfoArray.length) {
                    object2 = innerClassInfoArray[n11].outer != null ? Main.getClassBundle().getClassIdentifier(innerClassInfoArray[n11].outer) : null;
                    object = Main.getClassBundle().getClassIdentifier(innerClassInfoArray[n11].inner);
                    if ((object == null || ((Identifier)object).isReachable()) && (object2 == null || ((Identifier)object2).isReachable())) {
                        String string2;
                        string = object == null ? innerClassInfoArray[n11].inner : ((ClassIdentifier)object).getFullAlias();
                        String string3 = string2 = object2 == null ? innerClassInfoArray[n11].outer : ((ClassIdentifier)object2).getFullAlias();
                        String string4 = innerClassInfoArray[n11].name == null ? null : (string2 != null && string.startsWith(string2 + "$") ? string.substring(string2.length() + 1) : string.substring(string.lastIndexOf(46) + 1));
                        innerClassInfoArray5[n10++] = new InnerClassInfo(string, string2, string4, innerClassInfoArray[n11].modifiers);
                    }
                    ++n11;
                }
                this.info.setExtraClasses(innerClassInfoArray5);
            }
        }
    }

    public void doTransformations() {
        Identifier identifier;
        if (GlobalOptions.verboseLevel > 0) {
            GlobalOptions.err.println("Transforming " + this);
        }
        this.info.setName(this.getFullAlias());
        this.transformSuperIfaces();
        this.transformInnerClasses();
        ArrayList<FieldInfo> arrayList = new ArrayList<FieldInfo>(this.fieldIdents.size());
        ArrayList<MethodInfo> arrayList2 = new ArrayList<MethodInfo>(this.methodIdents.size());
        Iterator iterator = this.fieldIdents.iterator();
        while (iterator.hasNext()) {
            identifier = (FieldIdentifier)iterator.next();
            if ((Main.stripping & 1) != 0 && !identifier.isReachable()) continue;
            ((FieldIdentifier)identifier).doTransformations();
            arrayList.add(((FieldIdentifier)identifier).info);
        }
        iterator = this.methodIdents.iterator();
        while (iterator.hasNext()) {
            identifier = (MethodIdentifier)iterator.next();
            if ((Main.stripping & 1) != 0 && !identifier.isReachable()) continue;
            ((MethodIdentifier)identifier).doTransformations();
            arrayList2.add(((MethodIdentifier)identifier).info);
        }
        this.info.setFields(arrayList.toArray(new FieldInfo[arrayList.size()]));
        this.info.setMethods(arrayList2.toArray(new MethodInfo[arrayList2.size()]));
    }

    public void storeClass(DataOutputStream dataOutputStream) throws IOException {
        if (GlobalOptions.verboseLevel > 0) {
            GlobalOptions.err.println("Writing " + this);
        }
        this.info.write(dataOutputStream);
        this.info = null;
        this.methodIdents = null;
        this.fieldIdents = null;
    }

    public Identifier getParent() {
        return this.pack;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getFullAlias() {
        if (this.pack.parent == null) {
            return this.getAlias();
        }
        return this.pack.getFullAlias() + "." + this.getAlias();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return "Ljava/lang/Class;";
    }

    public int getModifiers() {
        return this.info.getModifiers();
    }

    public List getFieldIdents() {
        return this.fieldIdents;
    }

    public List getMethodIdents() {
        return this.methodIdents;
    }

    public Iterator getChilds() {
        Iterator iterator = this.fieldIdents.iterator();
        Iterator iterator2 = this.methodIdents.iterator();
        ClassIdentifier classIdentifier = this;
        if (classIdentifier == null) {
            throw null;
        }
        return new Iterator(classIdentifier, iterator, iterator2){
            boolean fieldsNext;
            private final /* synthetic */ ClassIdentifier this$0;
            private final /* synthetic */ Iterator val$fieldIter;
            private final /* synthetic */ Iterator val$methodIter;

            public boolean hasNext() {
                return this.fieldsNext ? true : this.val$methodIter.hasNext();
            }

            public Object next() {
                if (this.fieldsNext) {
                    E e = this.val$fieldIter.next();
                    this.fieldsNext = this.val$fieldIter.hasNext();
                    return e;
                }
                return this.val$methodIter.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
            {
                this.val$fieldIter = iterator;
                this.val$methodIter = iterator2;
                this.this$0 = classIdentifier;
                this.fieldsNext = this.val$fieldIter.hasNext();
                this.constructor$0(classIdentifier);
            }

            private final void constructor$0(ClassIdentifier classIdentifier) {
            }
        };
    }

    public String toString() {
        return "ClassIdentifier " + this.getFullName();
    }

    public Identifier getIdentifier(String string, String string2) {
        Identifier identifier;
        Object object = this.getChilds();
        while (object.hasNext()) {
            identifier = (Identifier)object.next();
            if (!identifier.getName().equals(string) || !identifier.getType().startsWith(string2)) continue;
            return identifier;
        }
        if (this.superName != null && (object = Main.getClassBundle().getClassIdentifier(this.superName)) != null && (identifier = ((ClassIdentifier)object).getIdentifier(string, string2)) != null) {
            return identifier;
        }
        return null;
    }

    public boolean containsFieldAliasDirectly(String string, String string2, IdentifierMatcher identifierMatcher) {
        Iterator iterator = this.fieldIdents.iterator();
        while (iterator.hasNext()) {
            Identifier identifier = (Identifier)iterator.next();
            if ((Main.stripping & 1) != 0 && !identifier.isReachable() || !identifier.wasAliased() || !identifier.getAlias().equals(string) || !identifier.getType().startsWith(string2) || !identifierMatcher.matches(identifier)) continue;
            return true;
        }
        return false;
    }

    public boolean containsMethodAliasDirectly(String string, String string2, IdentifierMatcher identifierMatcher) {
        Iterator iterator = this.methodIdents.iterator();
        while (iterator.hasNext()) {
            Identifier identifier = (Identifier)iterator.next();
            if ((Main.stripping & 1) != 0 && !identifier.isReachable() || !identifier.wasAliased() || !identifier.getAlias().equals(string) || !identifier.getType().startsWith(string2) || !identifierMatcher.matches(identifier)) continue;
            return true;
        }
        return false;
    }

    public boolean fieldConflicts(FieldIdentifier fieldIdentifier, String string) {
        ModifierMatcher modifierMatcher;
        String string2 = (Main.options & 1) != 0 ? fieldIdentifier.getType() : "";
        return this.containsFieldAliasDirectly(string, string2, modifierMatcher = ModifierMatcher.allowAll);
    }

    public boolean methodConflicts(MethodIdentifier methodIdentifier, String string) {
        Object object;
        Object object2;
        ModifierMatcher modifierMatcher;
        String string2 = methodIdentifier.getType();
        if ((Main.options & 1) == 0) {
            string2 = string2.substring(0, string2.indexOf(41) + 1);
        }
        if (this.containsMethodAliasDirectly(string, string2, modifierMatcher = ModifierMatcher.allowAll)) {
            return true;
        }
        ModifierMatcher modifierMatcher2 = modifierMatcher.forceAccess(0, true);
        if (methodIdentifier.info.isStatic()) {
            modifierMatcher2.forbidModifier(8);
        }
        ClassInfo classInfo = this.info.getSuperclass();
        ClassIdentifier classIdentifier = this;
        while (classInfo != null) {
            object2 = Main.getClassBundle().getClassIdentifier(classInfo.getName());
            if (object2 != null) {
                if (((ClassIdentifier)object2).containsMethodAliasDirectly(string, string2, modifierMatcher2)) {
                    return true;
                }
            } else {
                object = classInfo.getMethods();
                int n = 0;
                while (n < ((MethodInfo[])object).length) {
                    if (object[n].getName().equals(string) && ((MethodInfo)object[n]).getType().startsWith(string2) && modifierMatcher2.matches(((MethodInfo)object[n]).getModifiers())) {
                        return true;
                    }
                    ++n;
                }
            }
            classInfo = classInfo.getSuperclass();
        }
        if (modifierMatcher2.matches(methodIdentifier)) {
            object2 = this.knownSubClasses.iterator();
            while (object2.hasNext()) {
                object = (ClassIdentifier)object2.next();
                if (!((ClassIdentifier)object).containsMethodAliasDirectly(string, string2, modifierMatcher2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean conflicting(String string) {
        return this.pack.contains(string, this);
    }

    public ClassIdentifier(PackageIdentifier packageIdentifier, String string, String string2, ClassInfo classInfo) {
        super(string2);
        this.pack = packageIdentifier;
        this.fullName = string;
        this.name = string2;
        this.info = classInfo;
    }
}

