/*
 * Decompiled with CFR 0.152.
 */
package jode.obfuscator;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jode.GlobalOptions;
import jode.bytecode.ClassInfo;
import jode.obfuscator.ClassBundle;
import jode.obfuscator.ClassIdentifier;
import jode.obfuscator.Identifier;
import jode.obfuscator.IdentifierMatcher;
import jode.obfuscator.Main;
import jode.obfuscator.Renamer;

public class PackageIdentifier
extends Identifier {
    ClassBundle bundle;
    PackageIdentifier parent;
    String name;
    String fullName;
    boolean loadOnDemand;
    Map loadedClasses;
    List swappedClasses;
    Random rand = new Random();

    protected void setSinglePreserved() {
        if (this.parent != null) {
            this.parent.setPreserved();
        }
    }

    public void setLoadOnDemand() {
        if (this.loadOnDemand) {
            return;
        }
        this.loadOnDemand = true;
        if ((Main.stripping & 1) == 0) {
            String string = this.fullName.length() > 0 ? this.fullName + "." : "";
            Enumeration enumeration = ClassInfo.getClassesAndPackages(this.getFullName());
            while (enumeration.hasMoreElements()) {
                Identifier identifier;
                String string2 = ((String)enumeration.nextElement()).intern();
                if (this.loadedClasses.containsKey(string2)) continue;
                String string3 = (string + string2).intern();
                if (ClassInfo.isPackage(string3)) {
                    identifier = new PackageIdentifier(this.bundle, this, string3, string2);
                    this.loadedClasses.put(string2, identifier);
                    this.swappedClasses = null;
                    ((PackageIdentifier)identifier).setLoadOnDemand();
                    continue;
                }
                identifier = new ClassIdentifier(this, string3, string2, ClassInfo.forName(string3));
                if (GlobalOptions.verboseLevel > 1) {
                    GlobalOptions.err.println("preloading Class " + string3);
                }
                this.loadedClasses.put(string2, identifier);
                this.swappedClasses = null;
                this.bundle.addClassIdentifier(identifier);
                ((ClassIdentifier)identifier).initClass();
            }
            this.loadOnDemand = false;
        }
    }

    public Identifier getIdentifier(String string) {
        if (this.loadOnDemand) {
            Identifier identifier = this.loadClass(string);
            return identifier;
        }
        int n = string.indexOf(46);
        if (n == -1) {
            return (Identifier)this.loadedClasses.get(string);
        }
        PackageIdentifier packageIdentifier = (PackageIdentifier)this.loadedClasses.get(string.substring(0, n));
        if (packageIdentifier != null) {
            return packageIdentifier.getIdentifier(string.substring(n + 1));
        }
        return null;
    }

    public Identifier loadClass(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            Identifier identifier = (Identifier)this.loadedClasses.get(string);
            if (identifier == null) {
                String string2 = this.fullName.length() > 0 ? this.fullName + "." + string : string;
                if (ClassInfo.isPackage(string2 = string2.intern())) {
                    PackageIdentifier packageIdentifier = new PackageIdentifier(this.bundle, this, string2, string);
                    this.loadedClasses.put(string, packageIdentifier);
                    this.swappedClasses = null;
                    packageIdentifier.setLoadOnDemand();
                    identifier = packageIdentifier;
                } else if (!ClassInfo.exists(string2)) {
                    GlobalOptions.err.println("Warning: Can't find class " + string2);
                    Thread.dumpStack();
                } else {
                    identifier = new ClassIdentifier(this, string2, string, ClassInfo.forName(string2));
                    this.loadedClasses.put(string, identifier);
                    this.swappedClasses = null;
                    this.bundle.addClassIdentifier(identifier);
                    ((ClassIdentifier)identifier).initClass();
                }
            }
            return identifier;
        }
        String string3 = string.substring(0, n);
        PackageIdentifier packageIdentifier = (PackageIdentifier)this.loadedClasses.get(string3);
        if (packageIdentifier == null) {
            String string4 = this.fullName.length() > 0 ? this.fullName + "." + string3 : string3;
            if (ClassInfo.isPackage(string4 = string4.intern())) {
                packageIdentifier = new PackageIdentifier(this.bundle, this, string4, string3);
                this.loadedClasses.put(string3, packageIdentifier);
                this.swappedClasses = null;
                if (this.loadOnDemand) {
                    packageIdentifier.setLoadOnDemand();
                }
            }
        }
        if (packageIdentifier != null) {
            return packageIdentifier.loadClass(string.substring(n + 1));
        }
        return null;
    }

    public void loadMatchingClasses(IdentifierMatcher identifierMatcher) {
        block17: {
            Identifier identifier;
            Object object;
            Object object2;
            block16: {
                String string = identifierMatcher.getNextComponent(this);
                if (string == null) break block16;
                Identifier identifier2 = (Identifier)this.loadedClasses.get(string);
                if (identifier2 == null) {
                    string = string.intern();
                    String string2 = this.fullName.length() > 0 ? this.fullName + "." + string : string;
                    if (ClassInfo.isPackage(string2 = string2.intern())) {
                        identifier2 = new PackageIdentifier(this.bundle, this, string2, string);
                        this.loadedClasses.put(string, identifier2);
                        this.swappedClasses = null;
                        if (this.loadOnDemand) {
                            ((PackageIdentifier)identifier2).setLoadOnDemand();
                        }
                    } else if (ClassInfo.exists(string2)) {
                        if (GlobalOptions.verboseLevel > 1) {
                            GlobalOptions.err.println("loading Class " + string2);
                        }
                        identifier2 = new ClassIdentifier(this, string2, string, ClassInfo.forName(string2));
                        if (this.loadOnDemand || identifierMatcher.matches(identifier2)) {
                            this.loadedClasses.put(string, identifier2);
                            this.swappedClasses = null;
                            this.bundle.addClassIdentifier(identifier2);
                            ((ClassIdentifier)identifier2).initClass();
                        }
                    } else {
                        GlobalOptions.err.println("Warning: Can't find class/package " + string2);
                    }
                }
                if (!(identifier2 instanceof PackageIdentifier)) break block17;
                if (identifierMatcher.matches(identifier2)) {
                    if (GlobalOptions.verboseLevel > 0) {
                        GlobalOptions.err.println("loading Package " + identifier2.getFullName());
                    }
                    ((PackageIdentifier)identifier2).setLoadOnDemand();
                }
                if (!identifierMatcher.matchesSub(identifier2, null)) break block17;
                ((PackageIdentifier)identifier2).loadMatchingClasses(identifierMatcher);
                break block17;
            }
            String string = this.fullName.length() > 0 ? this.fullName + "." : "";
            Enumeration enumeration = ClassInfo.getClassesAndPackages(this.getFullName());
            while (enumeration.hasMoreElements()) {
                object2 = ((String)enumeration.nextElement()).intern();
                if (this.loadedClasses.containsKey(object2)) continue;
                object = (string + (String)object2).intern();
                if (!identifierMatcher.matchesSub(this, (String)object2)) continue;
                if (ClassInfo.isPackage((String)object)) {
                    if (GlobalOptions.verboseLevel > 0) {
                        GlobalOptions.err.println("loading Package " + (String)object);
                    }
                    identifier = new PackageIdentifier(this.bundle, this, (String)object, (String)object2);
                    this.loadedClasses.put(object2, identifier);
                    this.swappedClasses = null;
                    if (!this.loadOnDemand && !identifierMatcher.matches(identifier)) continue;
                    ((PackageIdentifier)identifier).setLoadOnDemand();
                    continue;
                }
                identifier = new ClassIdentifier(this, (String)object, (String)object2, ClassInfo.forName((String)object));
                if (!this.loadOnDemand && !identifierMatcher.matches(identifier)) continue;
                if (GlobalOptions.verboseLevel > 1) {
                    GlobalOptions.err.println("loading Class " + (String)object);
                }
                this.loadedClasses.put(object2, identifier);
                this.swappedClasses = null;
                this.bundle.addClassIdentifier(identifier);
                ((ClassIdentifier)identifier).initClass();
            }
            object2 = new ArrayList();
            object2.addAll(this.loadedClasses.values());
            object = object2.iterator();
            while (object.hasNext()) {
                identifier = (Identifier)object.next();
                if (!(identifier instanceof PackageIdentifier)) continue;
                if (identifierMatcher.matches(identifier)) {
                    ((PackageIdentifier)identifier).setLoadOnDemand();
                }
                if (!identifierMatcher.matchesSub(identifier, null)) continue;
                ((PackageIdentifier)identifier).loadMatchingClasses(identifierMatcher);
            }
        }
    }

    public void applyPreserveRule(IdentifierMatcher identifierMatcher) {
        if (this.loadOnDemand) {
            this.loadMatchingClasses(identifierMatcher);
        }
        super.applyPreserveRule(identifierMatcher);
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getFullAlias() {
        if (this.parent != null) {
            String string = this.parent.getFullAlias();
            String string2 = this.getAlias();
            if (string2.length() == 0) {
                return string;
            }
            if (string.length() == 0) {
                return string2;
            }
            return string + "." + string2;
        }
        return "";
    }

    public void buildTable(Renamer renamer) {
        this.loadOnDemand = false;
        super.buildTable(renamer);
    }

    public void doTransformations() {
        Iterator iterator = this.getChilds();
        while (iterator.hasNext()) {
            Identifier identifier = (Identifier)iterator.next();
            if (identifier instanceof ClassIdentifier) {
                ((ClassIdentifier)identifier).doTransformations();
                continue;
            }
            ((PackageIdentifier)identifier).doTransformations();
        }
    }

    public void readTable(Map map) {
        if (this.parent != null) {
            this.setAlias((String)map.get(this.getFullName()));
        }
        Iterator iterator = this.loadedClasses.values().iterator();
        while (iterator.hasNext()) {
            Identifier identifier = (Identifier)iterator.next();
            if ((Main.stripping & 1) != 0 && !identifier.isReachable()) continue;
            identifier.readTable(map);
        }
    }

    public Identifier getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return "package";
    }

    public Iterator getChilds() {
        if (this.swappedClasses == null) {
            this.swappedClasses = Arrays.asList(this.loadedClasses.values().toArray());
            Collections.shuffle(this.swappedClasses, this.rand);
        }
        return this.swappedClasses.iterator();
    }

    public void storeClasses(ZipOutputStream zipOutputStream) {
        Iterator iterator = this.getChilds();
        while (iterator.hasNext()) {
            Identifier identifier = (Identifier)iterator.next();
            if ((Main.stripping & 1) != 0 && !identifier.isReachable()) {
                if (GlobalOptions.verboseLevel <= 4) continue;
                GlobalOptions.err.println("Class/Package " + identifier.getFullName() + " is not reachable");
                continue;
            }
            if (identifier instanceof PackageIdentifier) {
                ((PackageIdentifier)identifier).storeClasses(zipOutputStream);
                continue;
            }
            try {
                String string = identifier.getFullAlias().replace('.', '/') + ".class";
                zipOutputStream.putNextEntry(new ZipEntry(string));
                DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(zipOutputStream));
                ((ClassIdentifier)identifier).storeClass(dataOutputStream);
                dataOutputStream.flush();
                zipOutputStream.closeEntry();
            }
            catch (IOException iOException) {
                GlobalOptions.err.println("Can't write Class " + identifier.getName());
                iOException.printStackTrace(GlobalOptions.err);
            }
        }
    }

    public void storeClasses(File file) {
        File file2;
        File file3 = file2 = this.parent == null ? file : new File(file, this.getAlias());
        if (!file2.exists() && !file2.mkdir()) {
            GlobalOptions.err.println("Could not create directory " + file2.getPath() + ", check permissions.");
        }
        Iterator iterator = this.getChilds();
        while (iterator.hasNext()) {
            Identifier identifier = (Identifier)iterator.next();
            if ((Main.stripping & 1) != 0 && !identifier.isReachable()) {
                if (GlobalOptions.verboseLevel <= 4) continue;
                GlobalOptions.err.println("Class/Package " + identifier.getFullName() + " is not reachable");
                continue;
            }
            if (identifier instanceof PackageIdentifier) {
                ((PackageIdentifier)identifier).storeClasses(file2);
                continue;
            }
            try {
                File file4 = new File(file2, identifier.getAlias() + ".class");
                DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file4)));
                ((ClassIdentifier)identifier).storeClass(dataOutputStream);
                dataOutputStream.close();
            }
            catch (IOException iOException) {
                GlobalOptions.err.println("Can't write Class " + identifier.getName());
                iOException.printStackTrace(GlobalOptions.err);
            }
        }
    }

    public String toString() {
        return this.parent == null ? "base package" : this.getFullName();
    }

    public boolean contains(String string, Identifier identifier) {
        Iterator iterator = this.loadedClasses.values().iterator();
        while (iterator.hasNext()) {
            Identifier identifier2 = (Identifier)iterator.next();
            if (identifier2 == identifier) continue;
            if (((Main.stripping & 1) == 0 || identifier2.isReachable()) && identifier2.getAlias().equalsIgnoreCase(string)) {
                return true;
            }
            if (!(identifier2 instanceof PackageIdentifier) || identifier2.getAlias().length() != 0 || !((PackageIdentifier)identifier2).contains(string, this)) continue;
            return true;
        }
        return this.getAlias().length() == 0 && this.parent != null && this.parent != identifier && this.parent.contains(string, this);
    }

    public boolean conflicting(String string) {
        return this.parent.contains(string, this);
    }

    public PackageIdentifier(ClassBundle classBundle, PackageIdentifier packageIdentifier, String string, String string2) {
        super(string2);
        this.bundle = classBundle;
        this.parent = packageIdentifier;
        this.fullName = string;
        this.name = string2;
        this.loadedClasses = new HashMap();
    }
}

