/*
 * Decompiled with CFR 0.152.
 */
package jode.swingui;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jode.bytecode.ClassInfo;
import jode.decompiler.Options;
import jode.swingui.Main;

public class PackagesTreeModel
implements TreeModel {
    Map cachedChildrens = new HashMap();
    Main main;
    TreeElement root;
    Set listeners;

    public void rebuild() {
        TreeModelListener[] treeModelListenerArray;
        this.cachedChildrens.clear();
        Object object = this.listeners;
        synchronized (object) {
            treeModelListenerArray = this.listeners.toArray(new TreeModelListener[this.listeners.size()]);
        }
        object = new TreeModelEvent((Object)this, new Object[]{this.root});
        int n = 0;
        while (n < treeModelListenerArray.length) {
            treeModelListenerArray[n].treeStructureChanged((TreeModelEvent)object);
            ++n;
        }
        this.main.reselect();
    }

    public TreeElement[] getChildrens(TreeElement treeElement) {
        TreeElement[] treeElementArray = (TreeElement[])this.cachedChildrens.get(treeElement);
        if (treeElementArray == null) {
            TreeSet<TreeElement> treeSet = new TreeSet<TreeElement>();
            String string = treeElement == this.root ? "" : treeElement.getFullName() + ".";
            Enumeration enumeration = ClassInfo.getClassesAndPackages(treeElement.getFullName());
            while (enumeration.hasMoreElements()) {
                boolean bl;
                String string2 = (String)enumeration.nextElement();
                String string3 = string + string2;
                boolean bl2 = bl = !ClassInfo.isPackage(string3);
                if (bl && Options.skipClass(ClassInfo.forName(string3))) continue;
                PackagesTreeModel packagesTreeModel = this;
                if (packagesTreeModel == null) {
                    throw null;
                }
                TreeElement treeElement2 = packagesTreeModel.new TreeElement(string, string2, bl);
                treeSet.add(treeElement2);
            }
            treeElementArray = treeSet.toArray(new TreeElement[treeSet.size()]);
            this.cachedChildrens.put(treeElement, treeElementArray);
        }
        return treeElementArray;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public Object getChild(Object object, int n) {
        return this.getChildrens((TreeElement)object)[n];
    }

    public int getChildCount(Object object) {
        return this.getChildrens((TreeElement)object).length;
    }

    public int getIndexOfChild(Object object, Object object2) {
        Object[] objectArray = this.getChildrens((TreeElement)object);
        int n = Arrays.binarySearch(objectArray, object2);
        if (n >= 0) {
            return n;
        }
        throw new NoSuchElementException(((TreeElement)object).getFullName() + "." + object2);
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object object) {
        return ((TreeElement)object).isLeaf();
    }

    public boolean isValidClass(Object object) {
        return ((TreeElement)object).isLeaf();
    }

    public TreePath getPath(String string) {
        if (string == null || string.length() == 0) {
            return new TreePath(this.root);
        }
        int n = -1;
        int n2 = 2;
        while ((n = string.indexOf(46, n + 1)) != -1) {
            ++n2;
        }
        Object[] objectArray = new TreeElement[n2];
        objectArray[0] = this.root;
        int n3 = 0;
        n = -1;
        block1: while (n < string.length()) {
            int n4 = n + 1;
            if ((n = string.indexOf(46, n4)) == -1) {
                n = string.length();
            }
            String string2 = string.substring(n4, n);
            TreeElement[] treeElementArray = this.getChildrens((TreeElement)objectArray[n3]);
            int n5 = 0;
            while (n5 < treeElementArray.length) {
                if (treeElementArray[n5].getName().equals(string2)) {
                    objectArray[++n3] = treeElementArray[n5];
                    continue block1;
                }
                ++n5;
            }
            return null;
        }
        return new TreePath(objectArray);
    }

    public String getFullName(Object object) {
        return ((TreeElement)object).getFullName();
    }

    public PackagesTreeModel(Main main) {
        PackagesTreeModel packagesTreeModel = this;
        if (packagesTreeModel == null) {
            throw null;
        }
        this.root = packagesTreeModel.new TreeElement("", "", false);
        this.listeners = new HashSet();
        this.main = main;
    }

    class TreeElement
    implements Comparable {
        String fullName;
        String name;
        boolean leaf;

        public String getFullName() {
            return this.fullName;
        }

        public String getName() {
            return this.name;
        }

        public boolean isLeaf() {
            return this.leaf;
        }

        public String toString() {
            return this.name;
        }

        public int compareTo(Object object) {
            TreeElement treeElement = (TreeElement)object;
            if (this.leaf != treeElement.leaf) {
                return this.leaf ? 1 : -1;
            }
            return this.fullName.compareTo(treeElement.fullName);
        }

        public boolean equals(Object object) {
            return object instanceof TreeElement && this.fullName.equals(((TreeElement)object).fullName);
        }

        public int hashCode() {
            return this.fullName.hashCode();
        }

        public TreeElement(String string, String string2, boolean bl) {
            this.fullName = string + string2;
            this.name = string2;
            this.leaf = bl;
        }
    }
}

