/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.appserver._private;

import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.foundation.ERXProperties;
import java.net.InetAddress;
import org.apache.log4j.Logger;

public class WOHostUtilities {
    private static final String LOCALHOST_IPS_PROPERTY_KEY = "er.extensions.WOHostUtilities.localhostips";
    static volatile NSArray _localHosts = null;
    private static final Logger log = Logger.getLogger(WOHostUtilities.class);

    static NSArray initLocalHosts() {
        NSMutableArray localNSMutableArray = new NSMutableArray();
        try {
            InetAddress localInetAddress1 = InetAddress.getLocalHost();
            WOHostUtilities._addInetAddress(localInetAddress1, localNSMutableArray);
        }
        catch (Exception localException1) {
            NSLog.err.appendln((Object)("<WOHostUtilities>: Couldn't invoke getLocalHost(): " + localException1));
        }
        try {
            InetAddress[] arrayOfInetAddress1 = InetAddress.getAllByName("localhost");
            WOHostUtilities._addInetAddressArray(arrayOfInetAddress1, localNSMutableArray);
        }
        catch (Exception localException2) {
            NSLog.err.appendln((Object)("<WOHostUtilities>: Couldn't get InetAddress for 'localhost': " + localException2));
        }
        try {
            InetAddress[] arrayOfInetAddress2 = InetAddress.getAllByName("127.0.0.1");
            WOHostUtilities._addInetAddressArray(arrayOfInetAddress2, localNSMutableArray);
        }
        catch (Exception localException3) {
            NSLog.err.appendln((Object)("<WOHostUtilities>: Couldn't get InetAddress for '127.0.0.1': " + localException3));
        }
        NSArray ips = ERXProperties.arrayForKey(LOCALHOST_IPS_PROPERTY_KEY);
        if (ips != null) {
            for (String ip : ips) {
                try {
                    InetAddress address = InetAddress.getByName(ip);
                    WOHostUtilities._addInetAddress(address, localNSMutableArray);
                    log.debug((Object)("Added the address " + address + " as a local host."));
                }
                catch (Exception e) {
                    log.error((Object)("Could not add localhost IP " + ip));
                }
            }
        }
        int i = localNSMutableArray.count();
        for (int j = 0; j < i; ++j) {
            InetAddress localInetAddress2 = (InetAddress)localNSMutableArray.objectAtIndex(j);
            try {
                InetAddress[] arrayOfInetAddress3 = InetAddress.getAllByName(localInetAddress2.getHostName());
                WOHostUtilities._addInetAddressArray(arrayOfInetAddress3, localNSMutableArray);
                continue;
            }
            catch (Exception localException4) {
                NSLog.err.appendln((Object)("<WOHostUtilities>: Couldn't get InetAddresses for '" + localInetAddress2.getHostName() + "': " + localException4));
            }
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)4L)) {
            NSLog.out.appendln((Object)("<WOHostUtilities>: Initialized Local Host List: " + localNSMutableArray));
        }
        return localNSMutableArray;
    }

    static void _addInetAddressArray(InetAddress[] paramArrayOfInetAddress, NSMutableArray paramNSMutableArray) {
        if (paramArrayOfInetAddress != null) {
            for (int i = 0; i < paramArrayOfInetAddress.length; ++i) {
                WOHostUtilities._addInetAddress(paramArrayOfInetAddress[i], paramNSMutableArray);
            }
        }
    }

    static void _addInetAddress(InetAddress paramInetAddress, NSMutableArray paramNSMutableArray) {
        if (paramInetAddress != null && !paramNSMutableArray.containsObject(paramInetAddress)) {
            paramNSMutableArray.addObject(paramInetAddress);
        }
    }

    public static NSArray getLocalHosts() {
        return _localHosts;
    }

    public static boolean isLocalInetAddress(InetAddress paramInetAddress, boolean paramBoolean) {
        if (paramInetAddress != null) {
            if (WOApplication.application()._unsetHost) {
                return WOHostUtilities._isLocalInetAddress(paramInetAddress, paramBoolean);
            }
            return paramInetAddress.equals(WOApplication.application().hostAddress());
        }
        return false;
    }

    public static boolean isAnyLocalInetAddress(InetAddress paramInetAddress, boolean paramBoolean) {
        return WOHostUtilities._isLocalInetAddress(paramInetAddress, paramBoolean) || WOApplication.application().hostAddress().equals(paramInetAddress);
    }

    public static boolean _isLocalInetAddress(InetAddress paramInetAddress, boolean paramBoolean) {
        boolean bool = false;
        if (paramInetAddress != null && !(bool = _localHosts.containsObject(paramInetAddress)) && paramBoolean) {
            _localHosts = WOHostUtilities.initLocalHosts();
            bool = _localHosts.containsObject(paramInetAddress);
        }
        return bool;
    }

    static {
        _localHosts = WOHostUtilities.initLocalHosts();
    }
}

