/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSMutableDictionary<K, V>
extends NSDictionary<K, V> {
    public static final Class _CLASS = _NSUtilitiesExtra._classWithFullySpecifiedNamePrime((String)"com.webobjects.foundation.NSMutableDictionary");
    static final long serialVersionUID = 6690723083816355576L;

    public NSMutableDictionary() {
    }

    public NSMutableDictionary(int capacity) {
        this();
        if (capacity < 0) {
            throw new IllegalArgumentException(this.getClass().getName() + ": Capacity cannot be less than 0");
        }
        this._ensureCapacity(capacity);
    }

    public NSMutableDictionary(V object, K key) {
        super(object, key);
    }

    public NSMutableDictionary(V[] objects, K[] keys) {
        super(objects, keys);
    }

    public NSMutableDictionary(NSArray<? extends V> objects, NSArray<? extends K> keys) {
        super(objects, keys);
    }

    public NSMutableDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
        this._copyMutableDictionary(otherDictionary);
    }

    public NSMutableDictionary(Dictionary<? extends K, ? extends V> dictionary, boolean ignoreNull) {
        super(dictionary, ignoreNull);
    }

    public NSMutableDictionary(Map<? extends K, ? extends V> map) {
        super(map);
    }

    public NSMutableDictionary(Map<? extends K, ? extends V> map, boolean ignoreNull) {
        super(map, ignoreNull);
    }

    public void setObjectForKey(V object, K key) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null object into an " + this.getClass().getName() + ".");
        }
        if (key == null) {
            throw new IllegalArgumentException("Attempt to insert null key into an " + this.getClass().getName() + ".");
        }
        int capacity = this._capacity;
        int count = this._count;
        if (++count > capacity) {
            this._ensureCapacity(count);
        }
        if (_NSCollectionPrimitives.addValueInHashTable(key, object, (Object[])this._keys, (Object[])this._objects, (byte[])this._flags)) {
            this._count = count;
            this._keysCache = null;
            this._keySetCache = null;
        }
        this._entrySetCache = null;
        this._objectsCache = null;
    }

    public V removeObjectForKey(Object key) {
        Object result = null;
        if (key == null) {
            throw new IllegalArgumentException("Attempt to remove null key from an " + this.getClass().getName() + ".");
        }
        if (this._count != 0 && (result = _NSCollectionPrimitives.removeValueInHashTable((Object)key, (Object[])this._keys, (Object[])this._objects, (byte[])this._flags)) != null) {
            --this._count;
            --this._deletionLimit;
            if (this._count == 0 || this._deletionLimit == 0) {
                this._clearDeletionsAndCollisions();
            }
            this._objectsCache = null;
            this._entrySetCache = null;
            this._keysCache = null;
            this._keySetCache = null;
        }
        return (V)result;
    }

    public void removeAllObjects() {
        if (this._count != 0) {
            this._objects = new Object[this._hashtableBuckets];
            this._keys = new Object[this._hashtableBuckets];
            this._flags = new byte[this._hashtableBuckets];
            this._count = 0;
            this._objectsCache = null;
            this._entrySetCache = null;
            this._keysCache = null;
            this._keySetCache = null;
            this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets((int)this._hashtableBuckets);
        }
    }

    public void setDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
        if (otherDictionary != this) {
            this.removeAllObjects();
            if (otherDictionary != null) {
                this.addEntriesFromDictionary(otherDictionary);
            }
        }
    }

    public void addEntriesFromDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
        if (otherDictionary != null) {
            Object[] keys = otherDictionary.keysNoCopy();
            for (int i = 0; i < keys.length; ++i) {
                this.setObjectForKey(otherDictionary.objectForKey(keys[i]), keys[i]);
            }
        }
    }

    public void removeObjectsForKeys(NSArray<?> keys) {
        if (keys != null) {
            Object[] keysArray = keys.objectsNoCopy();
            for (int i = 0; i < keysArray.length; ++i) {
                this.removeObjectForKey(keysArray[i]);
            }
        }
    }

    @Override
    public void takeValueForKey(Object value, String key) {
        if (value != null) {
            this.setObjectForKey(value, key);
        } else {
            this.removeObjectForKey(key);
        }
    }

    @Override
    public Object clone() {
        return new NSMutableDictionary<K, V>(this);
    }

    @Override
    public NSDictionary<K, V> immutableClone() {
        return new NSDictionary(this);
    }

    @Override
    public NSMutableDictionary<K, V> mutableClone() {
        return (NSMutableDictionary)this.clone();
    }

    @Override
    public V put(K key, V value) {
        Object temp = this.objectForKey(key);
        this.setObjectForKey(value, key);
        return temp;
    }

    @Override
    public V remove(Object key) {
        Object temp = this.objectForKey(key);
        this.removeObjectForKey(key);
        return temp;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.addEntriesFromDictionary(new NSDictionary<K, V>(m, true));
    }

    @Override
    public void clear() {
        this.removeAllObjects();
    }

    @Override
    public Collection<V> values() {
        return this.allValues();
    }
}

