/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WORequest;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.appserver.ERXBasicBrowser;
import er.extensions.appserver.ERXBrowser;
import er.extensions.foundation.ERXMutableDictionary;
import er.extensions.foundation.ERXMutableInteger;
import er.extensions.foundation.ERXStringUtilities;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ERXBrowserFactory {
    public static final Logger log = Logger.getLogger(ERXBrowserFactory.class);
    private static final String _DEFAULT_BROWSER_CLASS_NAME = ERXBasicBrowser.class.getName();
    private static ERXBrowserFactory _factory;
    private static final NSMutableArray<Pattern> robotExpressions;
    private static final NSMutableDictionary _cache;
    protected String _browserClassName;
    private NSMutableDictionary _browserPool;
    private NSMutableDictionary _referenceCounters;

    public static ERXBrowserFactory factory() {
        if (_factory == null) {
            String browserFactoryClass = System.getProperty("er.extensions.ERXBrowserFactory.FactoryClassName");
            if (browserFactoryClass != null && !browserFactoryClass.equals(ERXBrowserFactory.class.getName())) {
                log.debug((Object)("Creating browser factory for class name: " + browserFactoryClass));
                try {
                    Class<?> browserClass = Class.forName(browserFactoryClass);
                    _factory = (ERXBrowserFactory)browserClass.newInstance();
                }
                catch (Exception e) {
                    log.error((Object)("Unable to create browser factory for class name \"" + browserFactoryClass + "\""), (Throwable)e);
                }
            }
            if (_factory == null) {
                log.debug((Object)("Factory null creating default browser factory. " + browserFactoryClass));
                _factory = new ERXBrowserFactory();
            }
        }
        return _factory;
    }

    public static void setFactory(ERXBrowserFactory newFactory) {
        _factory = newFactory;
    }

    public String browserClassName() {
        return this._browserClassName;
    }

    public void setBrowserClassName(String name) {
        if (name != null && name.length() > 0) {
            this._browserClassName = name;
        }
    }

    public ERXBrowserFactory() {
        this.setBrowserClassName(System.getProperty("er.extensions.ERXBrowserFactory.BrowserClassName", _DEFAULT_BROWSER_CLASS_NAME));
    }

    public ERXBrowser browserMatchingRequest(WORequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Request can't be null.");
        }
        String ua = request.headerForKey((Object)"user-agent");
        if (ua == null) {
            return this.getBrowserInstance("Unknown Browser", "Unknown Version", "Unknown Version", "Unknown Platform", null);
        }
        ERXBrowser result = (ERXBrowser)_cache.objectForKey(ua);
        if (result == null) {
            String browserName = this.parseBrowserName(ua);
            String version = this.parseVersion(ua);
            String mozillaVersion = this.parseMozillaVersion(ua);
            String platform = this.parsePlatform(ua);
            NSDictionary<Object, Object> userInfo = new NSDictionary<Object, Object>(new Object[]{this.parseCPU(ua), this.parseGeckoVersion(ua)}, new Object[]{"cpu", "geckoRevision"});
            result = this.getBrowserInstance(browserName, version, mozillaVersion, platform, userInfo);
            _cache.setObjectForKey(result, ua);
        }
        return result;
    }

    public synchronized ERXBrowser getBrowserInstance(String browserName, String version, String mozillaVersion, String platform, NSDictionary userInfo) {
        String key = this._computeKey(browserName, version, mozillaVersion, platform, userInfo);
        ERXBrowser browser = (ERXBrowser)this._browserPool().objectForKey(key);
        if (browser == null) {
            browser = this.createBrowser(browserName, version, mozillaVersion, platform, userInfo);
        }
        return browser;
    }

    public synchronized ERXBrowser createBrowser(String browserName, String version, String mozillaVersion, String platform, NSDictionary userInfo) {
        ERXBrowser browser = null;
        try {
            browser = this._createBrowserWithClassName(this.browserClassNameForBrowserNamed(browserName), browserName, version, mozillaVersion, platform, userInfo);
        }
        catch (Exception ex) {
            log.error((Object)("Unable to create a browser for class name: " + this.browserClassNameForBrowserNamed(browserName) + " with exception: " + ex.getMessage() + ".  Will use default classes." + " Please ensure that the fully-qualified name for the class is specified" + " if it is in a different package."));
        }
        if (browser == null) {
            try {
                browser = this._createBrowserWithClassName(_DEFAULT_BROWSER_CLASS_NAME, browserName, version, mozillaVersion, platform, userInfo);
            }
            catch (Exception ex) {
                log.error((Object)("Unable to create even a default browser for class name: " + _DEFAULT_BROWSER_CLASS_NAME + " with exception: " + ex.getMessage() + "  Will instanciate a browser with regular" + " new " + _DEFAULT_BROWSER_CLASS_NAME + "(...) statement."));
                browser = new ERXBasicBrowser(browserName, version, mozillaVersion, platform, userInfo);
            }
        }
        return browser;
    }

    private ERXBrowser _createBrowserWithClassName(String className, String browserName, String version, String mozillaVersion, String platform, NSDictionary userInfo) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> browserClass = Class.forName(className);
        Class[] paramArray = new Class[]{String.class, String.class, String.class, String.class, NSDictionary.class};
        Constructor<?> constructor = browserClass.getConstructor(paramArray);
        return (ERXBrowser)constructor.newInstance(browserName, version, mozillaVersion, platform, userInfo);
    }

    public synchronized void retainBrowser(ERXBrowser browser) {
        String key = this._computeKey(browser);
        this._browserPool().setObjectForKey(browser, key);
        this._incrementReferenceCounterForKey(key);
    }

    public synchronized void releaseBrowser(ERXBrowser browser) {
        String key = this._computeKey(browser);
        ERXMutableInteger count = this._decrementReferenceCounterForKey(key);
        if (count == null) {
            this._browserPool().removeObjectForKey(key);
        } else if (count.intValue() <= 0) {
            this._browserPool().removeObjectForKey(key);
            this._referenceCounters().removeObjectForKey(key);
        }
    }

    public String browserClassNameForBrowserNamed(String browserName) {
        return this.browserClassName();
    }

    public String parseBrowserName(String userAgent) {
        String browserString = this._browserString(userAgent);
        String browser = "Unknown Browser";
        if (this.isRobot(browserString)) {
            browser = "robot";
        } else if (browserString.indexOf("Chrome") > -1) {
            browser = "Chrome";
        } else if (browserString.indexOf("MSIE") > -1) {
            browser = "IE";
        } else if (browserString.indexOf("Safari") > -1) {
            browser = "Safari";
        } else if (browserString.indexOf("Firefox") > -1) {
            browser = "Firefox";
        } else if (browserString.indexOf("OmniWeb") > -1) {
            browser = "OmniWeb";
        } else if (browserString.indexOf("iCab") > -1) {
            browser = "iCab";
        } else if (browserString.indexOf("Opera") > -1) {
            browser = "Opera";
        } else if (browserString.indexOf("Netscape") > -1) {
            browser = "Netscape";
        } else if (browserString.startsWith("Mozilla") && browserString.indexOf("compatible") == -1) {
            browser = "Mozilla";
        } else if (browserString.indexOf("Mozilla") > -1) {
            browser = "Netscape";
        }
        return browser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRobot(String userAgent) {
        NSMutableArray<Pattern> nSMutableArray = robotExpressions;
        synchronized (nSMutableArray) {
            if (robotExpressions.count() == 0) {
                String strings = ERXStringUtilities.stringFromResource("robots", "txt", NSBundle.bundleForName((String)"ERExtensions"));
                for (String item : NSArray.componentsSeparatedByString(strings, "\n")) {
                    if (item.trim().length() <= 0 || item.charAt(0) == '#') continue;
                    robotExpressions.addObject(Pattern.compile(item));
                }
            }
            userAgent = userAgent.toLowerCase();
            for (Pattern pattern : robotExpressions) {
                if (!pattern.matcher(userAgent).find()) continue;
                log.debug((Object)(pattern + " matches  " + userAgent));
                return true;
            }
        }
        return false;
    }

    public String parseGeckoVersion(String userAgent) {
        if (userAgent.indexOf("Gecko") >= 0) {
            int endPos;
            String revString = "; rv:";
            int startPos = userAgent.indexOf("; rv:") + "; rv:".length();
            if (startPos > "; rv:".length() && (endPos = userAgent.indexOf(")", startPos)) > startPos) {
                return userAgent.substring(startPos, endPos);
            }
        }
        return "No Gecko";
    }

    public String parseVersion(String userAgent) {
        StringTokenizer st;
        String versionString = this._versionString(userAgent);
        String version = "Unknown Version";
        String netscape6 = "Netscape6";
        int startpos = versionString.indexOf("Netscape6");
        if (startpos > -1) {
            versionString = versionString.substring(startpos + "Netscape6".length());
        }
        if ((startpos = ERXStringUtilities.indexOfNumericInString(versionString)) > -1 && (st = new StringTokenizer(versionString.substring(startpos), " ;")).hasMoreTokens()) {
            version = st.nextToken();
        }
        return version;
    }

    public String parseMozillaVersion(String userAgent) {
        StringTokenizer st;
        String mozilla = "Mozilla/";
        String mozillaVersion = "Unknown Version";
        int startpos = userAgent.indexOf("Mozilla/");
        if (startpos > -1 && (st = new StringTokenizer(userAgent.substring(startpos + "Mozilla/".length()), " ;")).hasMoreTokens()) {
            mozillaVersion = st.nextToken();
        }
        return mozillaVersion;
    }

    public String parsePlatform(String userAgent) {
        String platform = "Unknown Platform";
        if (userAgent.indexOf("Win") > -1) {
            platform = "Windows";
        } else if (userAgent.indexOf("iPhone") > -1 || userAgent.indexOf("iPod") > -1) {
            platform = "iPhone";
        } else if (userAgent.indexOf("Mac") > -1) {
            platform = "MacOS";
        } else if (userAgent.indexOf("Linux") > -1) {
            platform = "Linux";
        }
        return platform;
    }

    public String parseCPU(String userAgent) {
        String cpu = "Unknown CPU";
        if (userAgent.indexOf("PowerPC") > -1) {
            cpu = "PowerPC";
        } else if (userAgent.indexOf("PPC") > -1) {
            cpu = "PowerPC";
        }
        return cpu;
    }

    private String _browserString(String userAgent) {
        String browserString = userAgent;
        String safari = "Safari";
        int startpos = browserString.indexOf("Safari");
        if (startpos > -1) {
            browserString = browserString.substring(startpos);
        }
        String opera = "Opera";
        startpos = browserString.indexOf("Opera");
        if (startpos > -1) {
            browserString = browserString.substring(startpos);
        }
        String compatible = "compatible;";
        startpos = browserString.indexOf("compatible;");
        if (startpos > -1) {
            browserString = browserString.substring(startpos + "compatible;".length());
        }
        String netscape = "Netscape";
        startpos = browserString.indexOf("Netscape");
        if (startpos > -1) {
            browserString = browserString.substring(startpos);
        }
        return browserString;
    }

    private NSMutableDictionary _browserPool() {
        if (this._browserPool == null) {
            this._browserPool = new NSMutableDictionary();
        }
        return this._browserPool;
    }

    private NSMutableDictionary _referenceCounters() {
        if (this._referenceCounters == null) {
            this._referenceCounters = new NSMutableDictionary();
        }
        return this._referenceCounters;
    }

    private ERXMutableInteger _incrementReferenceCounterForKey(String key) {
        ERXMutableInteger count = (ERXMutableInteger)this._referenceCounters().objectForKey(key);
        if (count != null) {
            count.increment();
        } else {
            count = new ERXMutableInteger(1);
            this._referenceCounters().setObjectForKey(count, key);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("_incrementReferenceCounterForKey() - count = " + count + ", key = " + key));
        }
        return count;
    }

    private ERXMutableInteger _decrementReferenceCounterForKey(String key) {
        ERXMutableInteger count = (ERXMutableInteger)this._referenceCounters().objectForKey(key);
        if (count != null) {
            count.decrement();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("_decrementReferenceCounterForKey() - count = " + count + ", key = " + key));
        }
        return count;
    }

    private String _computeKey(ERXBrowser browser) {
        return browser.browserName() + "." + browser.version() + "." + browser.mozillaVersion() + "." + browser.platform() + "." + browser.userInfo();
    }

    private String _computeKey(String browserName, String version, String mozillaVersion, String platform, NSDictionary userInfo) {
        return browserName + "." + version + "." + mozillaVersion + "." + platform + "." + userInfo;
    }

    private String _versionString(String userAgent) {
        int startpos = userAgent.indexOf("Version/");
        String versionString = startpos > -1 ? userAgent.substring(startpos) : this._browserString(userAgent);
        return versionString;
    }

    static {
        robotExpressions = new NSMutableArray();
        _cache = ERXMutableDictionary.synchronizedDictionary();
    }
}

