/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.foundation.NSForwardException;
import er.extensions.appserver.ERXResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;

public class ERXKeepAliveResponse
extends ERXResponse {
    protected static final Logger log = Logger.getLogger(ERXKeepAliveResponse.class);
    protected Queue<byte[]> _queue = new ConcurrentLinkedQueue<byte[]>();
    protected byte[] _current = null;
    protected int _currentIndex = 0;

    public ERXKeepAliveResponse() {
        this.setContentStream(new InputStream(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read() throws IOException {
                Queue<byte[]> queue = ERXKeepAliveResponse.this._queue;
                synchronized (queue) {
                    if (ERXKeepAliveResponse.this._current != null && ERXKeepAliveResponse.this._currentIndex >= ERXKeepAliveResponse.this._current.length) {
                        ERXKeepAliveResponse.this._current = null;
                        ERXKeepAliveResponse.this._currentIndex = 0;
                    }
                    if (ERXKeepAliveResponse.this._current == null) {
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("waiting: " + ERXKeepAliveResponse.this._queue.hashCode()));
                            }
                            ERXKeepAliveResponse.this._queue.wait();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("got data: " + ERXKeepAliveResponse.this._queue.hashCode()));
                            }
                        }
                        catch (InterruptedException e) {
                            return -1;
                        }
                        ERXKeepAliveResponse.this._current = ERXKeepAliveResponse.this._queue.poll();
                    }
                    if (ERXKeepAliveResponse.this._current == null) {
                        return -1;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("writing: " + ERXKeepAliveResponse.this._currentIndex));
                    }
                    return ERXKeepAliveResponse.this._current[ERXKeepAliveResponse.this._currentIndex++];
                }
            }
        }, 1, Integer.MAX_VALUE);
    }

    public void push(String str) {
        try {
            this.push(str.getBytes(this.contentEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(byte[] data) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("pushing: " + this._queue.hashCode()));
        }
        Queue<byte[]> queue = this._queue;
        synchronized (queue) {
            this._queue.offer(data);
            this._queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Queue<byte[]> queue = this._queue;
        synchronized (queue) {
            this._current = null;
            this._currentIndex = 0;
            this._queue.notify();
        }
    }
}

