/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WORequest;
import com.webobjects.appserver._private.WOURLEncoder;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.appserver.ERXDirectActionRequestHandler;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXPathDirectActionRequestHandler
extends ERXDirectActionRequestHandler {
    private boolean useClassName = true;
    private boolean useActionName = true;

    public ERXPathDirectActionRequestHandler() {
    }

    public ERXPathDirectActionRequestHandler(String actionClassName, String defaultActionName, boolean shouldAddToStatistics) {
        super(actionClassName, defaultActionName, shouldAddToStatistics);
    }

    public ERXPathDirectActionRequestHandler(String actionClassName, String defaultActionName, boolean shouldAddToStatistics, boolean doUseClassName, boolean doUseActionName) {
        this(actionClassName, defaultActionName, shouldAddToStatistics);
        this.useClassName = doUseClassName;
        this.useActionName = doUseActionName;
    }

    public NSArray getRequestHandlerPathForRequest(WORequest aRequest) {
        NSArray paths = super.getRequestHandlerPathForRequest(aRequest);
        NSMutableArray<String> temp = new NSMutableArray<String>();
        if (paths != null) {
            int pathCount = paths.count();
            String firstPathComponent = pathCount > 0 ? (String)paths.objectAtIndex(0) : null;
            String lastPathComponent = (String)paths.lastObject();
            if (pathCount > 2) {
                if (this.useClassName && this.useActionName) {
                    temp.addObject(firstPathComponent);
                    temp.addObject(lastPathComponent);
                } else if (!this.useClassName) {
                    temp.addObject(lastPathComponent);
                } else {
                    temp.addObject(firstPathComponent);
                }
            } else if (pathCount == 2) {
                if (this.useClassName) {
                    temp.addObject(firstPathComponent);
                }
                if (this.useActionName) {
                    temp.addObject(lastPathComponent);
                }
            } else if (pathCount == 1 && (this.useActionName && !lastPathComponent.equals(this.defaultActionName) || this.useClassName && !lastPathComponent.equals(this.actionClassName))) {
                temp.addObject(lastPathComponent);
            }
        }
        if (this.actionClassName != null && temp.count() == 0) {
            temp.addObject(this.actionClassName);
        }
        return temp.immutableClone();
    }

    public static NSDictionary<String, String> formValuesFromRequest(WORequest request, boolean useActionClass, boolean useActionName) {
        NSMutableDictionary<String, String> params = new NSMutableDictionary<String, String>();
        boolean foundRequestHandler = false;
        Enumeration<String> e = NSArray.componentsSeparatedByString(request.uri(), "/").objectEnumerator();
        while (e.hasMoreElements()) {
            String part = e.nextElement();
            try {
                part = URLDecoder.decode(part, WOURLEncoder.WO_URL_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                log.error((Object)("Encoding not found: " + WOURLEncoder.WO_URL_ENCODING), (Throwable)ex);
            }
            if (foundRequestHandler && (!useActionName || useActionName && e.hasMoreElements())) {
                String value;
                String[] pair = part.split("=", 2);
                String key = pair[0];
                String string = value = pair.length == 2 ? pair[1] : pair[0];
                if (pair.length == 2) {
                    params.setObjectForKey(pair[1], pair[0]);
                } else {
                    params.setObjectForKey(pair[0], pair[0]);
                }
            }
            if (!part.equals(request.requestHandlerKey())) continue;
            foundRequestHandler = true;
            if (!useActionClass || !e.hasMoreElements()) continue;
            part = e.nextElement();
        }
        return params;
    }
}

