/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver._private.WOProperties;
import com.webobjects.appserver._private.WOShared;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.appserver.ERXApplication;
import er.extensions.appserver.ERXBrowser;
import er.extensions.appserver.ERXBrowserFactory;
import er.extensions.foundation.ERXProperties;
import er.extensions.localization.ERXLocalizer;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXRequest
extends WORequest {
    public static final Logger log = Logger.getLogger(ERXRequest.class);
    public static final String UNKNOWN_HOST = "UNKNOWN";
    public static final String X_FORWARDED_PROTO_FOR_SSL = ERXProperties.stringForKeyWithDefault("er.extensions.appserver.ERXRequest.xForwardedProtoForSsl", "https");
    protected static Boolean isBrowserFormValueEncodingOverrideEnabled;
    protected static final NSArray<String> HOST_ADDRESS_KEYS;
    protected static final NSArray<String> HOST_NAME_KEYS;
    protected NSArray<String> _browserLanguages;
    protected ERXBrowser _browser;
    protected boolean _secureDisabled;
    private static final NSComparator COMPARE_Qs;

    public ERXRequest(String string, String string0, String string1, NSDictionary nsdictionary, NSData nsdata, NSDictionary nsdictionary2) {
        super(string, string0, string1, nsdictionary, nsdata, nsdictionary2);
        if (this.isBrowserFormValueEncodingOverrideEnabled() && this.browser().formValueEncoding() != null) {
            this.setDefaultFormValueEncoding(this.browser().formValueEncoding());
        }
        this._secureDisabled = ERXRequest._isSecureDisabled();
    }

    public static boolean _isSecureDisabled() {
        return ERXProperties.booleanForKeyWithDefault("er.extensions.ERXRequest.secureDisabled", false);
    }

    public boolean isSecureDisabled() {
        return this._secureDisabled;
    }

    public boolean isBrowserFormValueEncodingOverrideEnabled() {
        if (isBrowserFormValueEncodingOverrideEnabled == null) {
            isBrowserFormValueEncodingOverrideEnabled = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXRequest.BrowserFormValueEncodingOverrideEnabled", false) ? Boolean.TRUE : Boolean.FALSE;
        }
        return isBrowserFormValueEncodingOverrideEnabled;
    }

    public WOContext context() {
        return this._context();
    }

    public NSArray<String> browserLanguages() {
        if (this._browserLanguages == null) {
            NSMutableArray<String> languageKeys = new NSMutableArray<String>();
            NSArray<String> fixedLanguages = null;
            String string = this.headerForKey("accept-language");
            if (string != null) {
                NSArray<String> rawLanguages = NSArray.componentsSeparatedByString(string, ",");
                fixedLanguages = this.fixAbbreviationArray(rawLanguages);
                Enumeration<String> e = fixedLanguages.objectEnumerator();
                while (e.hasMoreElements()) {
                    int index;
                    String languageKey = e.nextElement();
                    String language = (String)WOProperties.TheLanguageDictionary.objectForKey(languageKey);
                    if (language == null && (index = languageKey.indexOf(95)) > 0) {
                        String mainLanguageKey = languageKey.substring(0, index);
                        String region = languageKey.substring(index);
                        language = (String)WOProperties.TheLanguageDictionary.objectForKey(mainLanguageKey);
                        if (language != null) {
                            language = language + region.toUpperCase();
                        }
                    }
                    if (language == null) continue;
                    languageKeys.addObject(language);
                }
            }
            languageKeys.addObject("Nonlocalized");
            if (!languageKeys.containsObject(ERXLocalizer.defaultLanguage())) {
                languageKeys.addObject(ERXLocalizer.defaultLanguage());
            }
            this._browserLanguages = languageKeys.immutableClone();
        }
        return this._browserLanguages;
    }

    public String stringFormValueForKey(String key) {
        String result = super.stringFormValueForKey(key);
        if (result == null && "wodata".equals(key)) {
            String requestHandlerPath;
            String requestHandlerKey = (String)this.valueForKeyPath("_uriDecomposed.requestHandlerKey");
            if (WOApplication.application().resourceRequestHandlerKey().equals(requestHandlerKey) && (requestHandlerPath = (String)this.valueForKeyPath("_uriDecomposed.requestHandlerPath")) != null) {
                requestHandlerPath = "file:/" + requestHandlerPath.substring("wodata=/".length());
                result = requestHandlerPath.replace('+', ' ');
            }
        }
        return result;
    }

    public ERXBrowser browser() {
        if (this._browser == null) {
            ERXBrowserFactory browserFactory = ERXBrowserFactory.factory();
            this._browser = browserFactory.browserMatchingRequest(this);
            browserFactory.retainBrowser(this._browser);
        }
        return this._browser;
    }

    public void finalize() throws Throwable {
        if (this._browser != null) {
            ERXBrowserFactory.factory().releaseBrowser(this._browser);
        }
        super.finalize();
    }

    public boolean isSecure() {
        return ERXRequest.isRequestSecure(this);
    }

    public void _completeURLPrefix(StringBuffer stringbuffer, boolean secure, int port) {
        String portStr;
        if (this._secureDisabled) {
            secure = false;
        }
        String serverName = this._serverName();
        if (port == 0) {
            String sslPort = String.valueOf(ERXApplication.erxApplication().sslPort());
            portStr = secure ? sslPort : this._serverPort();
        } else {
            portStr = WOShared.unsignedIntString((int)port);
        }
        if (secure) {
            stringbuffer.append("https://");
        } else {
            stringbuffer.append("http://");
        }
        stringbuffer.append(serverName);
        if (portStr != null && (secure && !"443".equals(portStr) || !secure && !"80".equals(portStr))) {
            stringbuffer.append(':');
            stringbuffer.append(portStr);
        }
    }

    public static boolean isRequestSecure(WORequest request) {
        boolean isRequestSecure = false;
        if (request != null) {
            String httpsMode;
            String serverPort = request.headerForKey((Object)"SERVER_PORT");
            if (serverPort == null) {
                serverPort = request.headerForKey((Object)"x-webobjects-server-port");
            }
            if ((httpsMode = request.headerForKey((Object)"https")) != null && httpsMode.equalsIgnoreCase("on")) {
                isRequestSecure = true;
            } else if (serverPort != null && WOApplication.application() instanceof ERXApplication && String.valueOf(ERXApplication.erxApplication().sslPort()).equals(serverPort)) {
                isRequestSecure = true;
            } else if (!request.isUsingWebServer()) {
                String hostHeader = request.headerForKey((Object)"host");
                if (hostHeader != null && WOApplication.application() instanceof ERXApplication && hostHeader.endsWith(":" + ERXApplication.erxApplication().sslPort())) {
                    isRequestSecure = true;
                }
            } else if (X_FORWARDED_PROTO_FOR_SSL.equals(request.headerForKey((Object)"x-forwarded-proto"))) {
                isRequestSecure = true;
            }
        }
        return isRequestSecure;
    }

    protected NSArray<String> fixAbbreviationArray(NSArray<String> languages) {
        try {
            languages = languages.sortedArrayUsingComparator(COMPARE_Qs);
        }
        catch (NSComparator.ComparisonException e) {
            log.warn((Object)("Couldn't sort language array " + languages + ": " + (Object)((Object)e)));
        }
        catch (NumberFormatException e2) {
            log.warn((Object)("Couldn't sort language array " + languages + ": " + e2));
        }
        NSMutableArray<int> languagePrefix = new NSMutableArray<int>(languages.count());
        for (int languageNum = languages.count() - 1; languageNum >= 0; --languageNum) {
            String language = languages.objectAtIndex(languageNum);
            int offset = (language = language.trim()).indexOf(59);
            if (offset > 0) {
                language = language.substring(0, offset);
            }
            if ((offset = language.indexOf(45)) > 0) {
                String cooked;
                String langPrefix = language.substring(0, offset);
                if (!languagePrefix.containsObject(langPrefix)) {
                    languagePrefix.insertObjectAtIndex((int)langPrefix, 0);
                }
                language = cooked = language.replace('-', '_');
            }
            languagePrefix.insertObjectAtIndex((int)language, 0);
        }
        return languagePrefix;
    }

    public NSDictionary cookieValues() {
        try {
            return super.cookieValues();
        }
        catch (Throwable t) {
            log.warn((Object)(t + ":" + (Object)((Object)this)));
            log.warn((Object)t);
            return NSDictionary.EmptyDictionary;
        }
    }

    public boolean isSessionIDInRequest() {
        ERXApplication app = (ERXApplication)WOApplication.application();
        if (app.isStreamingRequestHandlerKey(this.requestHandlerKey())) {
            return false;
        }
        return super.isSessionIDInRequest();
    }

    protected String _getSessionIDFromValuesOrCookie(boolean inCookiesFirst) {
        ERXApplication app = (ERXApplication)WOApplication.application();
        boolean wis = WOApplication.application().streamActionRequestHandlerKey().equals(this.requestHandlerKey());
        boolean alternateStreaming = app.isStreamingRequestHandlerKey(this.requestHandlerKey());
        boolean streaming = wis || alternateStreaming;
        String sessionID = null;
        if (inCookiesFirst) {
            sessionID = this.cookieValueForKey("wosid");
            if (sessionID == null && !streaming) {
                sessionID = this.stringFormValueForKey("wosid");
            }
        } else {
            if (!streaming) {
                sessionID = this.stringFormValueForKey("wosid");
            }
            if (sessionID == null) {
                sessionID = this.cookieValueForKey("wosid");
            }
        }
        return sessionID;
    }

    public void setCredentials(String userName, String password) {
        String up = userName + ":" + password;
        BASE64Encoder coder = new BASE64Encoder();
        byte[] bytes = up.getBytes();
        String encodedString = coder.encode(bytes);
        this.setHeader("Basic " + encodedString, "authorization");
    }

    @Deprecated
    public String remoteHost() {
        return this.remoteHostAddress();
    }

    public String remoteHostAddress() {
        if (WOApplication.application().isDirectConnectEnabled() && this._originatingAddress() != null) {
            return this._originatingAddress().getHostAddress();
        }
        for (String key : HOST_ADDRESS_KEYS) {
            String remoteAddressHeaderValue = this.headerForKey(key);
            if (remoteAddressHeaderValue == null) continue;
            return remoteAddressHeaderValue;
        }
        return UNKNOWN_HOST;
    }

    public String remoteHostName() {
        for (String key : HOST_NAME_KEYS) {
            if (this.headerForKey(key) == null) continue;
            return this.headerForKey(key);
        }
        return UNKNOWN_HOST;
    }

    public NSMutableDictionary<String, Object> mutableUserInfo() {
        NSMutableDictionary<String, Object> mutableUserInfo;
        NSDictionary userInfo = this.userInfo();
        if (userInfo == null) {
            this._userInfo = mutableUserInfo = new NSMutableDictionary<String, Object>();
        } else if (userInfo instanceof NSMutableDictionary) {
            mutableUserInfo = (NSMutableDictionary<String, Object>)userInfo;
        } else {
            this._userInfo = mutableUserInfo = userInfo.mutableClone();
        }
        return mutableUserInfo;
    }

    static {
        HOST_ADDRESS_KEYS = new NSArray<String>(new String[]{"pc-remote-addr", "remote_host", "remote_addr", "remote_user", "x-webobjects-remote-addr"});
        HOST_NAME_KEYS = new NSArray<String>(new String[]{"x-forwarded-host", "Host", "x-webobjects-server-name", "server_name", "http_host"});
        COMPARE_Qs = new _LanguageComparator();
    }

    private static class _LanguageComparator
    extends NSComparator {
        private _LanguageComparator() {
        }

        private static float quality(String languageString) {
            float result = 0.0f;
            if (languageString != null) {
                int semicolon = (languageString = languageString.trim()).indexOf(59);
                result = semicolon != -1 && languageString.length() > semicolon + 2 ? Float.parseFloat(languageString.substring(semicolon + 1).trim().substring(2)) : 1.0f;
            }
            return result;
        }

        public int compare(Object o1, Object o2) {
            float f2;
            float f1 = _LanguageComparator.quality((String)o1);
            return f1 < (f2 = _LanguageComparator.quality((String)o2)) ? 1 : (f1 == f2 ? 0 : -1);
        }
    }
}

