/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResourceManager;
import com.webobjects.appserver._private.WODeployedBundle;
import com.webobjects.appserver._private.WOProjectBundle;
import com.webobjects.appserver._private.WOURLEncoder;
import com.webobjects.appserver._private.WOURLValuedElementData;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import er.extensions.appserver.ERXApplication;
import er.extensions.appserver.ERXRequest;
import er.extensions.appserver.ERXWOContext;
import er.extensions.foundation.ERXMutableURL;
import er.extensions.foundation.ERXProperties;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public class ERXResourceManager
extends WOResourceManager {
    private static Logger log = Logger.getLogger(ERXResourceManager.class);
    private WODeployedBundle TheAppProjectBundle = ERXResourceManager._initAppBundle();
    private _NSThreadsafeMutableDictionary _urlValuedElementsData;
    private IVersionManager _versionManager;

    protected ERXResourceManager() {
        try {
            Field field = WOResourceManager.class.getDeclaredField("_urlValuedElementsData");
            field.setAccessible(true);
            this._urlValuedElementsData = (_NSThreadsafeMutableDictionary)field.get((Object)this);
        }
        catch (Exception e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        String versionManagerClassName = ERXProperties.stringForKeyWithDefault("er.extensions.ERXResourceManager.versionManager", "default");
        if ("default".equals(versionManagerClassName)) {
            this._versionManager = new DefaultVersionManager();
        } else if ("properties".equals(versionManagerClassName)) {
            this._versionManager = new PropertiesVersionManager();
        } else {
            try {
                this._versionManager = Class.forName(versionManagerClassName).asSubclass(IVersionManager.class).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create the specified version manager '" + versionManagerClassName + ".", e);
            }
        }
    }

    public void setVersionManager(IVersionManager versionManager) {
        this._versionManager = versionManager;
    }

    public IVersionManager versionManager() {
        return this._versionManager;
    }

    private static WODeployedBundle _initAppBundle() {
        WOProjectBundle obj = null;
        try {
            WODeployedBundle wodeployedbundle = WODeployedBundle.deployedBundle();
            obj = wodeployedbundle.projectBundle();
            if (obj != null) {
                NSLog.err.appendln((Object)("Application project found: Will locate resources in '" + obj.projectPath() + "' rather than '" + wodeployedbundle.bundlePath() + "' ."));
            } else {
                obj = wodeployedbundle;
            }
        }
        catch (Exception exception) {
            NSLog.err.appendln((Object)("<WOResourceManager> Unable to initialize AppProjectBundle for reason:" + exception.toString()));
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)0L)) {
                NSLog.debug.appendln((Throwable)exception);
            }
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)exception);
        }
        return (WODeployedBundle)obj;
    }

    private String _cachedURLForResource(String name, String bundleName, NSArray languages, WORequest request) {
        String result = null;
        if (bundleName != null) {
            WODeployedBundle wodeployedbundle = this._cachedBundleForFrameworkNamed(bundleName);
            if (wodeployedbundle != null) {
                result = wodeployedbundle.urlForResource(name, languages);
            }
            if (result == null) {
                result = "/ERROR/NOT_FOUND/framework=" + bundleName + "/filename=" + (name == null ? "*null*" : name);
            }
        } else {
            result = this.TheAppProjectBundle.urlForResource(name, languages);
            if (result == null) {
                String appName = WOApplication.application().name();
                result = "/ERROR/NOT_FOUND/app=" + appName + "/filename=" + (name == null ? "*null*" : name);
            }
        }
        String resourceUrlPrefix = null;
        resourceUrlPrefix = ERXRequest.isRequestSecure(request) ? ERXProperties.stringForKey("er.extensions.ERXResourceManager.secureResourceUrlPrefix") : ERXProperties.stringForKey("er.extensions.ERXResourceManager.resourceUrlPrefix");
        if (resourceUrlPrefix != null && resourceUrlPrefix.length() > 0) {
            result = resourceUrlPrefix + result;
        }
        return result;
    }

    public String urlForResourceNamed(String name, String bundleName, NSArray languages, WORequest request) {
        String completeURL = null;
        if (request == null || request.isUsingWebServer() && !WOApplication.application()._rapidTurnaroundActiveForAnyProject()) {
            completeURL = this._cachedURLForResource(name, bundleName, languages, request);
        } else {
            URL url = this.pathURLForResourceNamed(name, bundleName, languages);
            String fileURL = null;
            if (url == null) {
                fileURL = "ERROR_NOT_FOUND_framework_" + (bundleName == null ? "*null*" : bundleName) + "_filename_" + (name == null ? "*null*" : name);
            } else {
                fileURL = url.toString();
                this.cacheDataIfNotInCache(fileURL);
            }
            String encoded = WOURLEncoder.encode((String)fileURL);
            WOContext context = null;
            String key = WOApplication.application().resourceRequestHandlerKey();
            if (WOApplication.application()._rapidTurnaroundActiveForAnyProject() && WOApplication.application().isDirectConnectEnabled() && ERXApplication.isWO54()) {
                key = "_wr_";
            }
            if (request != null) {
                context = (WOContext)request.valueForKey("context");
            }
            String wodata = _NSStringUtilities.concat((String)"wodata", (String)"=", (String)encoded);
            if (context != null) {
                completeURL = context.urlWithRequestHandlerKey(key, null, wodata);
            } else {
                StringBuffer stringbuffer = new StringBuffer(request.applicationURLPrefix());
                stringbuffer.append('/');
                stringbuffer.append(key);
                stringbuffer.append('?');
                stringbuffer.append(wodata);
                completeURL = stringbuffer.toString();
            }
            int offset = completeURL.indexOf("?wodata=file%3A");
            if (offset >= 0 && (completeURL = completeURL.replaceFirst("\\?wodata=file%3A", "/wodata=")).indexOf("/wodata=") > 0) {
                completeURL = completeURL.replaceAll("%2F", "/");
            }
        }
        completeURL = this._versionManager.versionedUrlForResourceNamed(completeURL, name, bundleName, languages, request);
        return completeURL;
    }

    private WOURLValuedElementData cachedDataForKey(String key) {
        WOURLValuedElementData data = (WOURLValuedElementData)this._urlValuedElementsData.objectForKey((Object)key);
        if (data == null && key != null && key.startsWith("file:") && ERXApplication.isDevelopmentModeSafe()) {
            data = this.cacheDataIfNotInCache(key);
        }
        return data;
    }

    protected WOURLValuedElementData cacheDataIfNotInCache(String key) {
        String contentType;
        WOURLValuedElementData data = (WOURLValuedElementData)this._urlValuedElementsData.objectForKey((Object)key);
        if (data == null && (data = new WOURLValuedElementData(null, contentType = this.contentTypeForResourceNamed(key), key)) != null) {
            this._urlValuedElementsData.setObjectForKey((Object)data, (Object)key);
        }
        return data;
    }

    public WOURLValuedElementData _cachedDataForKey(String key) {
        WOURLValuedElementData wourlvaluedelementdata = null;
        if (key != null) {
            wourlvaluedelementdata = this.cachedDataForKey(key);
        }
        return wourlvaluedelementdata;
    }

    public static boolean _shouldGenerateCompleteResourceURL(WOContext context) {
        return context instanceof ERXWOContext && ((ERXWOContext)context)._generatingCompleteResourceURLs() && !ERXApplication.erxApplication().rewriteDirectConnectURL();
    }

    public static String _completeURLForResource(String url, Boolean secure, WOContext context) {
        String completeUrl;
        boolean resourceIsSecure;
        boolean requestIsSecure = ERXRequest.isRequestSecure(context.request());
        boolean bl = resourceIsSecure = secure == null ? requestIsSecure : secure;
        if (resourceIsSecure && ERXProperties.stringForKey("er.extensions.ERXResourceManager.secureResourceUrlPrefix") == null || !resourceIsSecure && ERXProperties.stringForKey("er.extensions.ERXResourceManager.resourceUrlPrefix") == null) {
            StringBuffer sb = new StringBuffer();
            String serverPortStr = context.request()._serverPort();
            int serverPort = serverPortStr == null ? 0 : Integer.parseInt(serverPortStr);
            context.request()._completeURLPrefix(sb, resourceIsSecure, serverPort);
            sb.append(url);
            completeUrl = sb.toString();
        } else {
            completeUrl = url;
        }
        return completeUrl;
    }

    public static class PropertiesVersionManager
    implements IVersionManager {
        private String _defaultVersion;

        public PropertiesVersionManager() {
            String key = "er.extensions.ERXResourceManager.versionManager.default";
            this._defaultVersion = ERXProperties.stringForKey(key);
            if (this._defaultVersion == null) {
                this._defaultVersion = String.valueOf(System.currentTimeMillis());
            }
        }

        public String versionedUrlForResourceNamed(String resourceUrl, String name, String bundleName, NSArray languages, WORequest request) {
            String key;
            String version;
            if (bundleName == null) {
                bundleName = "app";
            }
            if ((version = ERXProperties.stringForKey(key = "er.extensions.ERXResourceManager.versionManager." + bundleName + "." + name)) == null) {
                version = this._defaultVersion;
            } else if ("none".equals(version) || version.length() == 0) {
                version = null;
            }
            if (version != null) {
                try {
                    ERXMutableURL url = new ERXMutableURL(resourceUrl);
                    url.addQueryParameter("", version);
                    resourceUrl = url.toExternalForm();
                }
                catch (MalformedURLException e) {
                    log.error((Object)("Failed to construct URL from '" + resourceUrl + "'."), (Throwable)e);
                }
            }
            return resourceUrl;
        }
    }

    public static class DefaultVersionManager
    implements IVersionManager {
        public String versionedUrlForResourceNamed(String resourceUrl, String name, String bundleName, NSArray languages, WORequest request) {
            return resourceUrl;
        }
    }

    public static interface IVersionManager {
        public String versionedUrlForResourceNamed(String var1, String var2, String var3, NSArray var4, WORequest var5);
    }
}

