/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResourceManager;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import er.extensions.appserver.ERXRequest;
import er.extensions.appserver.ERXResourceManager;
import er.extensions.appserver.ajax.ERXAjaxApplication;
import er.extensions.components.ERXStyleSheet;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXSelectorUtilities;
import er.extensions.foundation.ERXStringUtilities;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXResponseRewriter {
    public static final Logger log = Logger.getLogger(ERXResponseRewriter.class);
    private static final String ADDED_RESOURCES_KEY = "ERXResponseRewriter.addedResources";
    private static final String PENDING_INSERTS_KEY = "ERXResponseRewriter.pendingInserts";
    private static final String SECURE_RESOURCES_KEY = "er.ajax.secureResources";
    private static final String ORIGINAL_CONTEXT_ID_KEY = "_originalContextID";
    private static final String TOP_INDEX_KEY = "ERXResponseRewriter.topIndex";
    private static final String CONTEXT_OBSERVER_KEY = "ERXResponseRewriter.contextObserver";
    private static Map<WOComponent, NSMutableDictionary<String, Object>> _ajaxPageUserInfos;
    private static Map<WOComponent, NSMutableDictionary<String, Object>> _pageUserInfos;
    private static Delegate _delagate;

    public static void setDelegate(Delegate delegate) {
        _delagate = delegate;
    }

    public static NSMutableDictionary<String, Object> ajaxPageUserInfo(WOContext context) {
        WOComponent page = context.page();
        NSMutableDictionary<String, Object> pageInfo = _ajaxPageUserInfos.get(page);
        String contextID = context.contextID();
        if (contextID == null) {
            contextID = "none";
        }
        if (pageInfo != null && !ERXAjaxApplication.isAjaxRequest(context.request()) && !contextID.equals(pageInfo.objectForKey(ORIGINAL_CONTEXT_ID_KEY))) {
            pageInfo = null;
        }
        if (pageInfo == null) {
            pageInfo = new NSMutableDictionary();
            pageInfo.setObjectForKey(contextID, ORIGINAL_CONTEXT_ID_KEY);
            _ajaxPageUserInfos.put(page, pageInfo);
        }
        return pageInfo;
    }

    public static NSMutableDictionary<String, Object> pageUserInfo(WOContext context) {
        return ERXResponseRewriter.pageUserInfo(context.page());
    }

    public static NSMutableDictionary<String, Object> pageUserInfo(WOComponent page) {
        NSMutableDictionary<String, Object> pageInfo = _pageUserInfos.get(page);
        if (pageInfo == null) {
            pageInfo = new NSMutableDictionary();
            _pageUserInfos.put(page, pageInfo);
        }
        return pageInfo;
    }

    public static String _htmlCloseHeadTag() {
        String closeHeadTag = ERXProperties.stringForKeyWithDefault("er.ajax.AJComponent.htmlCloseHead", "</head>");
        return closeHeadTag;
    }

    public static boolean insertInResponseBeforeHead(WOResponse response, WOContext context, String content, TagMissingBehavior tagMissingBehavior) {
        return ERXResponseRewriter.insertInResponseBeforeTag(response, context, content, ERXResponseRewriter._htmlCloseHeadTag(), tagMissingBehavior);
    }

    public static void replaceAllInResponse(WOResponse response, WOContext context, Pattern pattern, String replacement) {
        String responseContent = response.contentString();
        if (responseContent != null) {
            String responseReplaced = pattern.matcher(responseContent).replaceAll(replacement);
            response.setContent(responseReplaced);
        }
    }

    public static void replaceFirstInResponse(WOResponse response, WOContext context, Pattern pattern, String replacement) {
        String responseContent = response.contentString();
        if (responseContent != null) {
            String responseReplaced = pattern.matcher(responseContent).replaceFirst(replacement);
            response.setContent(responseReplaced);
        }
    }

    public static boolean insertInResponseBeforeTag(WOResponse response, WOContext context, String content, String tag, TagMissingBehavior tagMissingBehavior) {
        int tagIndex;
        boolean inserted = false;
        String responseContent = response.contentString();
        if (tag != null) {
            tagIndex = responseContent.indexOf(tag);
            if (tagIndex < 0) {
                tagIndex = responseContent.toLowerCase().indexOf(tag.toLowerCase());
            }
        } else {
            tagIndex = -1;
        }
        if (tagIndex >= 0) {
            response.setContent(ERXStringUtilities.insertString(responseContent, content, tagIndex));
            inserted = true;
        } else if (tagMissingBehavior == TagMissingBehavior.Inline) {
            response.appendContentString(content);
            inserted = true;
        } else if (tagMissingBehavior == TagMissingBehavior.Top) {
            NSMutableDictionary<String, Object> pageInfo = ERXResponseRewriter.ajaxPageUserInfo(context);
            Integer topIndex = (Integer)pageInfo.objectForKey(TOP_INDEX_KEY);
            if (topIndex == null) {
                topIndex = 0;
                ContextObserver contextObserver = new ContextObserver();
                NSNotificationCenter.defaultCenter().addObserver((Object)contextObserver, ERXSelectorUtilities.notificationSelector("didHandleRequest"), WORequestHandler.DidHandleRequestNotification, (Object)context);
                pageInfo.setObjectForKey(contextObserver, CONTEXT_OBSERVER_KEY);
            }
            response.setContent(ERXStringUtilities.insertString(responseContent, content, topIndex));
            pageInfo.setObjectForKey(topIndex + content.length(), TOP_INDEX_KEY);
            inserted = true;
        } else if (tagMissingBehavior != TagMissingBehavior.Skip) {
            if (tagMissingBehavior == TagMissingBehavior.SkipAndWarn) {
                log.warn((Object)("There was no " + tag + ", so your content did not get added: " + content));
            } else {
                throw new IllegalArgumentException("Unknown tag missing missing: " + (Object)((Object)tagMissingBehavior) + ".");
            }
        }
        return inserted;
    }

    public static void addScriptResourceInHead(WOResponse response, WOContext context, String framework, String fileName) {
        String fallbackEndTag;
        String fallbackStartTag;
        boolean appendTypeAttribute = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXResponseRewriter.javascriptTypeAttribute", false);
        String scriptStartTag = appendTypeAttribute ? "<script type=\"text/javascript\" src=\"" : "<script src=\"";
        String scriptEndTag = "\"></script>";
        if (ERXAjaxApplication.isAjaxRequest(context.request()) && ERXProperties.booleanForKeyWithDefault("er.extensions.loadOnDemand", true)) {
            if (!ERXAjaxApplication.isAjaxReplacement(context.request()) || ERXProperties.booleanForKeyWithDefault("er.extensions.loadOnDemandDuringReplace", false)) {
                fallbackStartTag = appendTypeAttribute ? "<script type=\"text/javascript\">AOD.loadScript('" : "<script>AOD.loadScript('";
                fallbackEndTag = "')</script>";
            } else {
                fallbackStartTag = null;
                fallbackEndTag = null;
            }
        } else {
            fallbackStartTag = null;
            fallbackEndTag = null;
        }
        ERXResponseRewriter.addResourceInHead(response, context, framework, fileName, scriptStartTag, scriptEndTag, fallbackStartTag, fallbackEndTag, TagMissingBehavior.Inline);
    }

    public static void addStylesheetResourceInHead(WOResponse response, WOContext context, String framework, String fileName) {
        ERXResponseRewriter.addStylesheetResourceInHead(response, context, framework, fileName, null);
    }

    public static void addStylesheetResourceInHead(WOResponse response, WOContext context, String framework, String fileName, String media) {
        String cssStartTag = media == null ? "<link rel=\"stylesheet\" type=\"text/css\" href=\"" : "<link rel=\"stylesheet\" type=\"text/css\" media=\"" + media + "\" href=\"";
        String cssEndTag = ERXStyleSheet.shouldCloseLinkTags() ? "\"/>" : "\">";
        ERXResponseRewriter.addResourceInHead(response, context, framework, fileName, cssStartTag, cssEndTag, null, null, TagMissingBehavior.Inline);
    }

    public static void addScriptCodeInHead(WOResponse response, WOContext context, String script) {
        ERXResponseRewriter.addScriptCodeInHead(response, context, script, null);
    }

    public static void addScriptCodeInHead(WOResponse response, WOContext context, String script, String scriptName) {
        String js;
        boolean inserted;
        if ((scriptName == null || !ERXResponseRewriter.isResourceAddedToHead(context, null, scriptName)) && (inserted = ERXResponseRewriter.insertInResponseBeforeHead(response, context, js = "<script type=\"text/javascript\">\n" + script + "\n</script>", TagMissingBehavior.Top)) && scriptName != null) {
            ERXResponseRewriter.resourceAddedToHead(context, null, scriptName);
        }
    }

    public static void addResourceInHead(WOResponse response, WOContext context, String framework, String fileName, String startTag, String endTag) {
        ERXResponseRewriter.addResourceInHead(response, context, framework, fileName, startTag, endTag, TagMissingBehavior.Skip);
    }

    public static NSMutableSet<String> resourcesAddedToHead(WOContext context) {
        NSMutableDictionary<String, Object> userInfo = ERXResponseRewriter.ajaxPageUserInfo(context);
        NSMutableSet addedResources = (NSMutableSet)userInfo.objectForKey(ADDED_RESOURCES_KEY);
        if (addedResources == null) {
            addedResources = new NSMutableSet();
            userInfo.setObjectForKey(addedResources, ADDED_RESOURCES_KEY);
        }
        return addedResources;
    }

    public static boolean isResourceAddedToHead(WOContext context, String frameworkName, String resourceName) {
        NSMutableSet<String> addedResources = ERXResponseRewriter.resourcesAddedToHead(context);
        return addedResources.containsObject(frameworkName + "." + resourceName);
    }

    public static void resourceAddedToHead(WOContext context, String frameworkName, String resourceName) {
        NSMutableSet<String> addedResources = ERXResponseRewriter.resourcesAddedToHead(context);
        addedResources.addObject(frameworkName + "." + resourceName);
    }

    public static boolean addResourceInHead(WOResponse response, WOContext context, String framework, String fileName, String startTag, String endTag, TagMissingBehavior tagMissingBehavior) {
        return ERXResponseRewriter.addResourceInHead(response, context, framework, fileName, startTag, endTag, null, null, tagMissingBehavior);
    }

    public static boolean addResourceInHead(WOResponse response, WOContext context, String framework, String fileName, String startTag, String endTag, String fallbackStartTag, String fallbackEndTag, TagMissingBehavior tagMissingBehavior) {
        boolean inserted = true;
        String replacementResourceStr = ERXProperties.stringForKey("er.extensions.ERXResponseRewriter.resource." + framework + "." + fileName);
        if (replacementResourceStr != null) {
            int dotIndex = replacementResourceStr.indexOf(46);
            framework = replacementResourceStr.substring(0, dotIndex);
            fileName = replacementResourceStr.substring(dotIndex + 1);
        }
        if (!ERXResponseRewriter.isResourceAddedToHead(context, framework, fileName) && (_delagate == null || _delagate.responseRewriterShouldAddResource(framework, fileName))) {
            Resource replacementResource;
            boolean insert = true;
            if (_delagate != null && (replacementResource = _delagate.responseRewriterWillAddResource(framework, fileName)) != null && ERXResponseRewriter.isResourceAddedToHead(context, framework = replacementResource.framework(), fileName = replacementResource.fileName())) {
                insert = false;
            }
            if (insert) {
                String url;
                if (fileName.indexOf("://") != -1 || fileName.startsWith("/")) {
                    url = fileName;
                } else {
                    boolean secureAllResources;
                    WOResourceManager rm = WOApplication.application().resourceManager();
                    NSArray languages = null;
                    if (context.hasSession()) {
                        languages = context.session().languages();
                    }
                    url = rm.urlForResourceNamed(fileName, framework, languages, context.request());
                    boolean generateCompleteResourceURLs = ERXResourceManager._shouldGenerateCompleteResourceURL(context);
                    boolean bl = secureAllResources = ERXProperties.booleanForKey(SECURE_RESOURCES_KEY) && !ERXRequest.isRequestSecure(context.request());
                    if (generateCompleteResourceURLs || secureAllResources) {
                        url = ERXResourceManager._completeURLForResource(url, secureAllResources ? Boolean.TRUE : null, context);
                    }
                }
                String html = startTag + url + endTag + "\n";
                if (fallbackStartTag == null && fallbackEndTag == null) {
                    inserted = ERXResponseRewriter.insertInResponseBeforeHead(response, context, html, tagMissingBehavior);
                } else {
                    inserted = ERXResponseRewriter.insertInResponseBeforeHead(response, context, html, TagMissingBehavior.Skip);
                    if (!inserted) {
                        String fallbackHtml = fallbackStartTag + url + fallbackEndTag + "\n";
                        inserted = ERXResponseRewriter.insertInResponseBeforeTag(response, context, fallbackHtml, null, TagMissingBehavior.Top);
                    }
                }
                if (inserted) {
                    ERXResponseRewriter.resourceAddedToHead(context, framework, fileName);
                }
            }
        }
        return inserted;
    }

    static {
        _pageUserInfos = Collections.synchronizedMap(new WeakHashMap());
        _ajaxPageUserInfos = Collections.synchronizedMap(new WeakHashMap());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TagMissingBehavior {
        Top,
        Inline,
        Skip,
        SkipAndWarn;

    }

    public static interface Delegate {
        public boolean responseRewriterShouldAddResource(String var1, String var2);

        public Resource responseRewriterWillAddResource(String var1, String var2);
    }

    public static class ContextObserver {
        public void didHandleRequest(NSNotification n) {
            WOContext context = (WOContext)n.object();
            NSMutableDictionary<String, Object> pageInfo = ERXResponseRewriter.ajaxPageUserInfo(context);
            pageInfo.removeObjectForKey(ERXResponseRewriter.TOP_INDEX_KEY);
            pageInfo.removeObjectForKey(ERXResponseRewriter.CONTEXT_OBSERVER_KEY);
            NSNotificationCenter.defaultCenter().removeObserver((Object)this, WORequestHandler.DidHandleRequestNotification, (Object)context);
        }
    }

    public static class Resource {
        private String _framework;
        private String _fileName;

        public Resource(String url) {
            this._framework = null;
            this._fileName = url;
        }

        public Resource(String framework, String fileName) {
            this._framework = framework;
            this._fileName = fileName;
        }

        public String framework() {
            return this._framework;
        }

        public String fileName() {
            return this._fileName;
        }

        public String toString() {
            return "[Resource: framework = " + this._framework + "; name = " + this._fileName + "]";
        }
    }
}

