/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import er.extensions.appserver.ERXApplication;
import er.extensions.appserver.ERXRequest;
import er.extensions.appserver.ERXResponseRewriter;
import er.extensions.appserver.ajax.ERXAjaxContext;
import er.extensions.foundation.ERXMutableURL;
import er.extensions.foundation.ERXMutableUserInfoHolderInterface;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXRuntimeUtilities;
import er.extensions.foundation.ERXSelectorUtilities;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXThreadStorage;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXWOContext
extends ERXAjaxContext
implements ERXMutableUserInfoHolderInterface {
    private static Observer observer;
    private boolean _generateCompleteURLs;
    private boolean _generateCompleteResourceURLs;
    public static final String CONTEXT_KEY = "wocontext";
    public static final String CONTEXT_DICTIONARY_KEY = "ERXWOContext.dict";
    private static final String SAFE_IDENTIFIER_NAME_KEY = "ERXWOContext.safeIdentifierName";

    public WOSession existingSession() {
        String sessionID = this._requestSessionID();
        if (!super.hasSession() && sessionID != null) {
            WOApplication.application().restoreSessionWithID(sessionID, (WOContext)this);
        }
        return this._session();
    }

    public boolean hasSession() {
        if (super.hasSession()) {
            return true;
        }
        return this.existingSession() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static NSMutableDictionary contextDictionary() {
        NSMutableDictionary contextDictionary;
        if (observer == null) {
            Class<ERXWOContext> clazz = ERXWOContext.class;
            // MONITORENTER : er.extensions.appserver.ERXWOContext.class
            if (observer == null) {
                observer = new Observer();
                NSNotificationCenter.defaultCenter().addObserver((Object)observer, ERXSelectorUtilities.notificationSelector("applicationDidHandleRequest"), "ApplicationDidDispatchRequestNotification", null);
            }
            // MONITOREXIT : clazz
        }
        if ((contextDictionary = ERXWOContext._contextDictionary()) != null) return contextDictionary;
        contextDictionary = new NSMutableDictionary();
        ERXThreadStorage.takeValueForKey(contextDictionary, CONTEXT_DICTIONARY_KEY);
        return contextDictionary;
    }

    public static WOContext currentContext() {
        return (WOContext)ERXThreadStorage.valueForKey(CONTEXT_KEY);
    }

    public static void setCurrentContext(Object object) {
        ERXThreadStorage.takeValueForKey(object, CONTEXT_KEY);
    }

    protected static NSMutableDictionary _contextDictionary() {
        NSMutableDictionary contextDictionary = (NSMutableDictionary)ERXThreadStorage.valueForKey(CONTEXT_DICTIONARY_KEY);
        return contextDictionary;
    }

    public ERXWOContext(WORequest worequest) {
        super(worequest);
    }

    public void _setCurrentComponent(WOComponent wocomponent) {
        ERXRuntimeUtilities.checkThreadInterrupt();
        super._setCurrentComponent(wocomponent);
    }

    public Object clone() {
        ERXWOContext context = (ERXWOContext)super.clone();
        context._setGenerateCompleteResourceURLs(this._generateCompleteResourceURLs);
        return context;
    }

    public void _setGenerateCompleteResourceURLs(boolean generateCompleteResourceURLs) {
        this._generateCompleteResourceURLs = generateCompleteResourceURLs;
    }

    public boolean _generatingCompleteResourceURLs() {
        return this._generateCompleteResourceURLs;
    }

    public void _generateCompleteURLs() {
        super._generateCompleteURLs();
        this._generateCompleteURLs = true;
    }

    public void _generateRelativeURLs() {
        super._generateRelativeURLs();
        this._generateCompleteURLs = false;
    }

    public boolean _generatingCompleteURLs() {
        return this._generateCompleteURLs;
    }

    public static WOContext newContext() {
        WOApplication app = WOApplication.application();
        String requestUrl = app.cgiAdaptorURL() + "/" + app.name() + ".woa";
        try {
            URL url = new URL(requestUrl);
            requestUrl = url.getPath();
        }
        catch (MalformedURLException mue) {
            requestUrl = "";
        }
        return app.createContextForRequest(app.createRequest("GET", requestUrl, "HTTP/1.1", null, null, null));
    }

    @Override
    public NSMutableDictionary mutableUserInfo() {
        return ERXWOContext.contextDictionary();
    }

    @Override
    public void setMutableUserInfo(NSMutableDictionary userInfo) {
        ERXThreadStorage.takeValueForKey(userInfo, CONTEXT_DICTIONARY_KEY);
    }

    public NSDictionary userInfo() {
        return this.mutableUserInfo();
    }

    protected void _preprocessURL() {
        if (ERXProperties.booleanForKey("er.extensions.ERXWOContext.forceRemoveApplicationNumber")) {
            this._url().setApplicationNumber(null);
        }
    }

    protected String _postprocessURL(String url) {
        if (WOApplication.application() instanceof ERXApplication) {
            return ERXApplication.erxApplication()._rewriteURL(url);
        }
        return url;
    }

    public String _urlWithRequestHandlerKey(String requestHandlerKey, String requestHandlerPath, String queryString, boolean secure) {
        this._preprocessURL();
        String url = super._urlWithRequestHandlerKey(requestHandlerKey, requestHandlerPath, queryString, secure);
        if (!ERXApplication.isWO54()) {
            url = this._postprocessURL(url);
        }
        return url;
    }

    public String directActionURLForActionNamed(String actionName, NSDictionary queryDict, boolean includeSessionID) {
        String url = super.directActionURLForActionNamed(actionName, queryDict);
        if (!includeSessionID) {
            url = ERXWOContext.stripSessionIDFromURL(url);
        }
        return url;
    }

    public static String stripSessionIDFromURL(String url) {
        if (url == null) {
            return null;
        }
        int len = 1;
        int startpos = url.indexOf("?wosid");
        if (startpos < 0) {
            startpos = url.indexOf("&wosid");
        }
        if (startpos < 0) {
            startpos = url.indexOf("&amp;wosid");
            len = 5;
        }
        if (startpos >= 0) {
            int endpos = url.indexOf(38, startpos + len);
            if (endpos < 0) {
                url = url.substring(0, startpos);
            } else {
                int endLen = len;
                if (len == 1 && url.indexOf("&amp;") >= 0) {
                    endLen = 5;
                }
                url = url.substring(0, startpos + len) + url.substring(endpos + endLen);
            }
        }
        return url;
    }

    public static NSArray<String> componentPath(WOContext context) {
        NSMutableArray<String> result = new NSMutableArray<String>();
        if (context != null) {
            for (WOComponent component = context.component(); component != null; component = component.parent()) {
                if (component.name() == null) continue;
                result.insertObjectAtIndex(component.name(), 0);
            }
        }
        return result;
    }

    public static NSArray<WOComponent> _componentPath(WOContext context) {
        NSMutableArray<WOComponent> result = new NSMutableArray<WOComponent>();
        if (context != null) {
            for (WOComponent component = context.component(); component != null; component = component.parent()) {
                if (component.name() == null) continue;
                result.insertObjectAtIndex(component, 0);
            }
        }
        return result;
    }

    public static String _htmlCloseHeadTag() {
        return ERXResponseRewriter._htmlCloseHeadTag();
    }

    public static void insertInResponseBeforeTag(WOContext context, WOResponse response, String content, String tag, ERXResponseRewriter.TagMissingBehavior tagMissingBehavior) {
        ERXResponseRewriter.insertInResponseBeforeTag(response, context, content, tag, tagMissingBehavior);
    }

    public static void addScriptResourceInHead(WOContext context, WOResponse response, String framework, String fileName) {
        ERXResponseRewriter.addScriptResourceInHead(response, context, framework, fileName);
    }

    public static void addStylesheetResourceInHead(WOContext context, WOResponse response, String framework, String fileName) {
        ERXResponseRewriter.addStylesheetResourceInHead(response, context, framework, fileName);
    }

    public static void addScriptCodeInHead(WOContext context, WOResponse response, String script) {
        ERXResponseRewriter.addScriptCodeInHead(response, context, script);
    }

    public static void addScriptCodeInHead(WOContext context, WOResponse response, String script, String scriptName) {
        ERXResponseRewriter.addScriptCodeInHead(response, context, script, scriptName);
    }

    public static void addResourceInHead(WOContext context, WOResponse response, String framework, String fileName, String startTag, String endTag) {
        ERXResponseRewriter.addResourceInHead(response, context, framework, fileName, startTag, endTag);
    }

    public static void addResourceInHead(WOContext context, WOResponse response, String framework, String fileName, String startTag, String endTag, ERXResponseRewriter.TagMissingBehavior tagMissingBehavior) {
        ERXResponseRewriter.addResourceInHead(response, context, framework, fileName, startTag, endTag, tagMissingBehavior);
    }

    public static String safeIdentifierName(WOContext context, boolean willCache) {
        String safeIdentifierName;
        if (willCache) {
            NSMutableDictionary<String, Object> pageUserInfo = ERXResponseRewriter.pageUserInfo(context);
            Integer counter = (Integer)pageUserInfo.objectForKey(SAFE_IDENTIFIER_NAME_KEY);
            counter = counter == null ? Integer.valueOf(0) : Integer.valueOf(counter + 1);
            pageUserInfo.setObjectForKey(counter, SAFE_IDENTIFIER_NAME_KEY);
            safeIdentifierName = ERXStringUtilities.safeIdentifierName(counter.toString());
        } else {
            safeIdentifierName = ERXStringUtilities.safeIdentifierName("e_" + context.elementID());
        }
        return safeIdentifierName;
    }

    public static String toSafeElementID(String elementID) {
        return ERXStringUtilities.safeIdentifierName(elementID);
    }

    public static String _directActionURL(WOContext context, String actionName, NSDictionary queryParams, boolean secure) {
        try {
            String directActionURL;
            if (ERXApplication.isWO54()) {
                Method _directActionURLMethod = context.getClass().getMethod("_directActionURL", String.class, NSDictionary.class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE);
                directActionURL = (String)_directActionURLMethod.invoke((Object)context, actionName, queryParams, secure, new Integer(0), Boolean.FALSE);
            } else {
                Method _directActionURLMethod = context.getClass().getMethod("_directActionURL", String.class, NSDictionary.class, Boolean.TYPE);
                directActionURL = (String)_directActionURLMethod.invoke((Object)context, actionName, queryParams, secure);
            }
            return directActionURL;
        }
        catch (Exception e) {
            throw new NSForwardException((Throwable)e);
        }
    }

    public static String directActionUrl(WOContext context, String directActionName, Boolean secure, boolean includeSessionID) {
        return ERXWOContext.directActionUrl(context, null, null, null, directActionName, null, secure, includeSessionID);
    }

    public static String directActionUrl(WOContext context, String directActionName, String key, String value, Boolean secure, boolean includeSessionID) {
        return ERXWOContext.directActionUrl(context, null, null, null, directActionName, key, value, secure, includeSessionID);
    }

    public static String directActionUrl(WOContext context, String directActionName, NSDictionary<String, ? extends Object> queryParameters, Boolean secure, boolean includeSessionID) {
        return ERXWOContext.directActionUrl(context, null, null, null, directActionName, queryParameters, secure, includeSessionID);
    }

    public static String directActionUrl(WOContext context, String host, Integer port, String path, String directActionName, String key, Object value, Boolean secure, boolean includeSessionID) {
        NSDictionary<String, Object> queryParameters = null;
        if (key != null && value != null) {
            queryParameters = new NSDictionary<String, Object>(value, key);
        }
        return ERXWOContext.directActionUrl(context, host, port, path, directActionName, queryParameters, secure, includeSessionID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String directActionUrl(WOContext context, String host, Integer port, String path, String directActionName, NSDictionary<String, ? extends Object> queryParameters, Boolean secure, boolean includeSessionID) {
        String url;
        boolean secureBool;
        boolean currentlySecure = ERXRequest.isRequestSecure(context.request());
        boolean bl = secureBool = secure == null ? currentlySecure : secure;
        boolean completeUrls = host == null && currentlySecure == secureBool && port == null ? true : (context instanceof ERXWOContext ? ((ERXWOContext)context)._generatingCompleteURLs() : false);
        if (!completeUrls) {
            context._generateCompleteURLs();
        }
        try {
            try {
                boolean customPath;
                ERXMutableURL mu = new ERXMutableURL();
                boolean bl2 = customPath = path != null && path.length() > 0;
                if (!customPath) {
                    mu.setURL(ERXWOContext._directActionURL(context, directActionName, queryParameters, secureBool));
                    if (!includeSessionID) {
                        mu.removeQueryParameter("wosid");
                    }
                } else {
                    if (secureBool) {
                        mu.setProtocol("https");
                    } else {
                        mu.setProtocol("http");
                    }
                    mu.setHost(context.request()._serverName());
                    mu.setPath(path + directActionName);
                    mu.setQueryParameters(queryParameters);
                    if (includeSessionID && context.session().storesIDsInURLs()) {
                        mu.setQueryParameter("wosid", context.session().sessionID());
                    }
                }
                if (port != null) {
                    mu.setPort(port);
                }
                if (host != null && host.length() > 0) {
                    mu.setHost(host);
                    if (mu.protocol() == null) {
                        if (secureBool) {
                            mu.setProtocol("https");
                        } else {
                            mu.setProtocol("http");
                        }
                    }
                }
                url = mu.toExternalForm();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to create url for direct action '" + directActionName + "'.", e);
            }
            Object var15_15 = null;
            if (completeUrls) return url;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (completeUrls) throw throwable;
            context._generateRelativeURLs();
            throw throwable;
        }
        context._generateRelativeURLs();
        return url;
    }

    public String safeElementID() {
        return ERXStringUtilities.safeIdentifierName(this.elementID());
    }

    public static String ajaxActionUrl(WOContext context) {
        String url = context.componentActionURL().replaceFirst("/" + WOApplication.application().componentRequestHandlerKey() + "/", "/" + ERXApplication.erAjaxRequestHandlerKey() + "/");
        return url;
    }

    public static class Observer {
        public void applicationDidHandleRequest(NSNotification n) {
            ERXWOContext.setCurrentContext(null);
            ERXThreadStorage.removeValueForKey(ERXWOContext.CONTEXT_DICTIONARY_KEY);
        }
    }
}

