/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver.navigation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSRange;
import er.extensions.appserver.navigation.ERXNavigationItem;
import er.extensions.appserver.navigation.ERXNavigationManager;
import er.extensions.foundation.ERXValueUtilities;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXNavigationState {
    public static final Logger log = Logger.getLogger(ERXNavigationState.class);
    protected NSArray _additionalState;
    protected NSArray _state;
    protected boolean isDisabled;

    public NSArray state() {
        NSMutableArray state;
        NSArray nSArray = state = this._state == null ? NSArray.EmptyArray : this._state;
        if (this._additionalState != null) {
            NSMutableArray combinedState = new NSMutableArray(state);
            combinedState.addObjectsFromArray(this._additionalState);
            state = combinedState;
        }
        return state;
    }

    public void setAdditionalState(NSArray value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting additional navigation state: " + value));
        }
        this._additionalState = value;
    }

    public NSArray navigationItemsToBeShownForLevel(int currentNavigationLevel) {
        int navCount;
        NSArray itmesToBeShown = null;
        int n = navCount = this.state() != null ? this.state().count() : 0;
        if (currentNavigationLevel == 0) {
            itmesToBeShown = this.state();
        } else if (navCount != 0 && navCount <= currentNavigationLevel) {
            itmesToBeShown = new NSArray(this.state().lastObject());
        } else if (navCount != 0 && currentNavigationLevel < navCount) {
            int index = currentNavigationLevel - 1;
            int length = navCount - currentNavigationLevel + 1;
            NSRange range = new NSRange(index, length);
            log.debug((Object)("Range: " + range + " current: " + currentNavigationLevel + " navCount: " + navCount));
            itmesToBeShown = this.state().subarrayWithRange(range);
        }
        log.debug((Object)("Nav state: " + this.state() + " current nav level: " + currentNavigationLevel + " items: " + itmesToBeShown));
        return itmesToBeShown != null ? itmesToBeShown : NSArray.EmptyArray;
    }

    public void setState(NSArray navigationState) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting Navigation State: " + navigationState));
        }
        this._state = navigationState;
        this._additionalState = null;
    }

    public void setStateWithString(String navigationStateString) {
        if (navigationStateString != null) {
            this.setState(NSArray.componentsSeparatedByString(navigationStateString, "."));
        }
    }

    public String stateAsString() {
        if (this.state() != null) {
            return this.state().componentsJoinedByString(".");
        }
        return null;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setIsDisabled(boolean newIsDisabled) {
        this.isDisabled = newIsDisabled;
    }

    public void setStateForLevel(String state, int level) {
        if (level > 0) {
            NSMutableArray<String> navState = new NSMutableArray<String>(this.state());
            if (navState.count() >= level) {
                navState.replaceObjectAtIndex(state, level - 1);
            } else {
                navState.addObject(state);
            }
            this.setState(navState);
        } else {
            log.error((Object)("Attempting to set the state: " + state + " for a negative level: " + level));
        }
    }

    public String level(int i) {
        return this.state() != null && i < this.state().count() ? (String)this.state().objectAtIndex(i) : "";
    }

    public NSArray navigationItemsForLevel(int level, NSKeyValueCodingAdditions context) {
        ERXNavigationItem levelRoot = null;
        if (level == 1) {
            levelRoot = ERXNavigationManager.manager().rootNavigationItem();
        } else if (this.state().count() > level - 2) {
            levelRoot = ERXNavigationManager.manager().navigationItemForName(this.level(level - 2));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Root name for level: " + (level - 2) + " state: " + this.state() + "root: " + (levelRoot != null ? levelRoot.name() : "<NULL>")));
            }
        }
        NSArray children = null;
        if (levelRoot != null) {
            boolean hasChildrenConditions = levelRoot.childrenConditions().count() != 0;
            boolean meetsChildrenConditions = true;
            if (hasChildrenConditions) {
                String aCondition;
                Enumeration e = levelRoot.childrenConditions().objectEnumerator();
                while (e.hasMoreElements() && (meetsChildrenConditions = ERXValueUtilities.booleanValue(context.valueForKeyPath(aCondition = (String)e.nextElement())))) {
                }
            }
            if (meetsChildrenConditions) {
                if (levelRoot.children() != null) {
                    children = levelRoot.children();
                } else if (levelRoot.childrenBinding() != null) {
                    Object o = context.valueForKeyPath(levelRoot.childrenBinding());
                    if (o != null && o instanceof NSArray) {
                        children = (NSArray)o;
                    } else if (o != null && o instanceof String) {
                        children = (NSArray)levelRoot.childrenChoices().objectForKey((String)o);
                        if (children == null) {
                            log.warn((Object)("For nav core object: " + levelRoot + " and child binding: " + levelRoot.childrenBinding() + " couldn't find children for choice key: " + (String)o));
                        }
                    } else {
                        log.warn((Object)("For nav core object: " + levelRoot + " and child binding: " + levelRoot.childrenBinding() + " recieved binding object: " + o));
                    }
                }
            }
        }
        if (children == null) {
            children = NSArray.EmptyArray;
        }
        if (((NSArray)children).count() > 0) {
            NSMutableArray<ERXNavigationItem> childNavItems = new NSMutableArray<ERXNavigationItem>();
            Enumeration e = children.objectEnumerator();
            while (e.hasMoreElements()) {
                String childName = (String)e.nextElement();
                ERXNavigationItem item = ERXNavigationManager.manager().navigationItemForName(childName);
                if (item != null) {
                    childNavItems.addObject(item);
                    continue;
                }
                log.warn((Object)("Unable to find navigation item for name: " + childName));
            }
            children = childNavItems;
        }
        return children;
    }

    public String toString() {
        return "\"" + this.stateAsString() + "\"";
    }
}

