/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.batching;

import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.eoaccess.EODatabaseDataSource;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EODataSource;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOKeyValueUnarchiver;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation._NSDelegate;
import er.extensions.appserver.ERXDisplayGroup;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.foundation.ERXArrayUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXBatchingDisplayGroup<T>
extends ERXDisplayGroup<T> {
    private static final Logger log = Logger.getLogger(ERXBatchingDisplayGroup.class);
    protected int _batchCount;
    protected NSArray<T> _displayedObjects;
    protected Boolean _isBatching;
    protected NSArray<String> _prefetchingRelationshipKeyPaths;
    protected int _rowCount = -1;
    private boolean _rawRowsForCustomQueries = true;
    protected boolean _shouldRememberRowCount = true;

    public ERXBatchingDisplayGroup() {
    }

    public void setRawRowsForCustomQueries(boolean rawRowsForCustomQueries) {
        this._rawRowsForCustomQueries = rawRowsForCustomQueries;
    }

    public boolean isRawRowsForCustomQueries() {
        return this._rawRowsForCustomQueries;
    }

    public static Object decodeWithKeyValueUnarchiver(EOKeyValueUnarchiver unarchiver) {
        return new ERXBatchingDisplayGroup(unarchiver);
    }

    private ERXBatchingDisplayGroup(EOKeyValueUnarchiver unarchiver) {
        this();
        this.setCurrentBatchIndex(1);
        this.setNumberOfObjectsPerBatch(unarchiver.decodeIntForKey("numberOfObjectsPerBatch"));
        this.setFetchesOnLoad(unarchiver.decodeBoolForKey("fetchesOnLoad"));
        this.setValidatesChangesImmediately(unarchiver.decodeBoolForKey("validatesChangesImmediately"));
        this.setSelectsFirstObjectAfterFetch(unarchiver.decodeBoolForKey("selectsFirstObjectAfterFetch"));
        this.setLocalKeys((NSArray)unarchiver.decodeObjectForKey("localKeys"));
        this.setDataSource((EODataSource)unarchiver.decodeObjectForKey("dataSource"));
        this.setSortOrderings((NSArray)unarchiver.decodeObjectForKey("sortOrdering"));
        this.setQualifier((EOQualifier)unarchiver.decodeObjectForKey("qualifier"));
        this.setDefaultStringMatchFormat((String)unarchiver.decodeObjectForKey("formatForLikeQualifier"));
        NSDictionary insertedObjectDefaultValues = (NSDictionary)unarchiver.decodeObjectForKey("insertedObjectDefaultValues");
        if (insertedObjectDefaultValues == null) {
            insertedObjectDefaultValues = NSDictionary.EmptyDictionary;
        }
        this.setInsertedObjectDefaultValues(insertedObjectDefaultValues);
        this.finishInitialization();
    }

    protected void refetchIfNecessary() {
        if (this.isBatching() && this._displayedObjects == null) {
            this.refetch();
        }
    }

    protected boolean isBatching() {
        return this._isBatching == null ? false : this._isBatching;
    }

    @Override
    public void setDataSource(EODataSource eodatasource) {
        this._isBatching = eodatasource instanceof EODatabaseDataSource ? Boolean.TRUE : Boolean.FALSE;
        this.setRowCount(-1);
        super.setDataSource(eodatasource);
    }

    public int batchCount() {
        if (this.isBatching()) {
            if (this._displayedObjects == null) {
                this.updateBatchCount();
            }
            return this._batchCount;
        }
        return super.batchCount();
    }

    public void setCurrentBatchIndex(int index) {
        int previousBatchIndex = this.currentBatchIndex();
        super.setCurrentBatchIndex(index);
        if (this.isBatching() && previousBatchIndex != index) {
            this._displayedObjects = null;
        }
    }

    @Override
    public void setNumberOfObjectsPerBatch(int count) {
        boolean didFetch;
        boolean bl = didFetch = this._displayedObjects != null;
        if (this.isBatching() && this.numberOfObjectsPerBatch() != count) {
            this._displayedObjects = null;
        }
        NSArray selectedObjects = this.selectedObjects();
        super.setNumberOfObjectsPerBatch(count);
        this.setSelectedObjects(selectedObjects);
        if (didFetch) {
            this.updateBatchCount();
        }
    }

    @Override
    public NSArray<T> displayedObjects() {
        if (this.isBatching()) {
            this.refetchIfNecessary();
            return this._displayedObjects;
        }
        return super.displayedObjects();
    }

    public boolean hasMultipleBatches() {
        this.refetchIfNecessary();
        return super.hasMultipleBatches();
    }

    @Override
    public NSArray<T> filteredObjects() {
        if (this.isBatching()) {
            return this.allObjects();
        }
        return super.filteredObjects();
    }

    public void setQualifier(EOQualifier aEoqualifier) {
        super.setQualifier(aEoqualifier);
        this._displayedObjects = null;
        this.setRowCount(-1);
    }

    @Override
    public void setSortOrderings(NSArray nsarray) {
        NSArray selectedObjects = this.selectedObjects();
        super.setSortOrderings(nsarray);
        this.setSelectedObjects(selectedObjects);
        if (this.isBatching()) {
            this._displayedObjects = null;
        }
    }

    public void setPrefetchingRelationshipKeyPaths(NSArray<String> prefetchingRelationshipKeyPaths) {
        this._prefetchingRelationshipKeyPaths = prefetchingRelationshipKeyPaths;
    }

    public NSArray<String> prefetchingRelationshipKeyPaths() {
        return this._prefetchingRelationshipKeyPaths;
    }

    protected EOFetchSpecification fetchSpecification() {
        EODatabaseDataSource ds = (EODatabaseDataSource)this.dataSource();
        EOFetchSpecification spec = (EOFetchSpecification)ds.fetchSpecificationForFetch().clone();
        spec.setSortOrderings(ERXArrayUtilities.arrayByAddingObjectsFromArrayWithoutDuplicates(this.sortOrderings(), spec.sortOrderings()));
        EOQualifier dgQualifier = this.qualifier();
        Object qualifier = spec.qualifier();
        if (dgQualifier != null) {
            qualifier = qualifier != null ? new EOAndQualifier(new NSArray<EOQualifier>(new EOQualifier[]{dgQualifier, qualifier})) : dgQualifier;
            spec.setQualifier(qualifier);
        }
        return spec;
    }

    public int rowCount() {
        int rowCount = this._rowCount;
        if (rowCount == -1) {
            rowCount = this.isBatching() ? ERXEOAccessUtilities.rowCountForFetchSpecification(this.dataSource().editingContext(), this.fetchSpecification()) : this.dataSource().fetchObjects().count();
            if (this.shouldRememberRowCount()) {
                this._rowCount = rowCount;
            }
        }
        return rowCount;
    }

    public void setRowCount(int rowCount) {
        this._rowCount = rowCount;
    }

    public boolean shouldRememberRowCount() {
        return this._shouldRememberRowCount;
    }

    public void setShouldRememberRowCount(boolean shouldRememberRowCount) {
        this._shouldRememberRowCount = shouldRememberRowCount;
    }

    protected NSArray<T> objectsInRange(int start, int end) {
        EOEditingContext ec = this.dataSource().editingContext();
        EOFetchSpecification spec = (EOFetchSpecification)this.fetchSpecification().clone();
        if (this._prefetchingRelationshipKeyPaths != null && this._prefetchingRelationshipKeyPaths.count() > 0) {
            spec.setPrefetchingRelationshipKeyPaths(this._prefetchingRelationshipKeyPaths);
        }
        NSArray result = ERXEOControlUtilities.objectsInRange(ec, spec, start, end, this._rawRowsForCustomQueries);
        return result;
    }

    protected void refetch() {
        int displayedObjectsCount;
        int rowCount = this.rowCount();
        int start = (this.currentBatchIndex() - 1) * this.numberOfObjectsPerBatch();
        int end = start + this.numberOfObjectsPerBatch();
        if (this.numberOfObjectsPerBatch() == 0) {
            start = 0;
            end = rowCount;
        }
        if (start > rowCount) {
            start = rowCount;
        }
        if (end > rowCount) {
            end = rowCount;
        }
        if (this.filteredObjects().count() != rowCount) {
            NSArray selectedObjects = this.selectedObjects();
            this.setObjectArray(new FakeArray(rowCount));
            this.setSelectedObjects(selectedObjects);
        }
        this._displayedObjects = this.objectsInRange(start, end);
        if (this._rowCount != -1 && (displayedObjectsCount = this._displayedObjects.count()) < this.numberOfObjectsPerBatch()) {
            this._rowCount = start + this._displayedObjects.count();
        }
    }

    protected void updateBatchCount() {
        this._batchCount = this.numberOfObjectsPerBatch() == 0 ? 0 : (this.allObjects().count() == 0 ? 1 : (this.rowCount() - 1) / this.numberOfObjectsPerBatch() + 1);
    }

    public void setObjectArray(NSArray objects) {
        super.setObjectArray(objects);
        this.updateBatchCount();
    }

    @Override
    public Object fetch() {
        if (this.isBatching()) {
            _NSDelegate delegate = null;
            if (this.delegate() != null && (delegate = new _NSDelegate(WODisplayGroup.Delegate.class, this.delegate())).respondsTo("displayGroupShouldFetch") && !delegate.booleanPerform("displayGroupShouldFetch", (Object)this)) {
                return null;
            }
            if (this.undoManager() != null) {
                this.undoManager().removeAllActionsWithTarget((Object)this);
            }
            NSNotificationCenter.defaultCenter().postNotification("WODisplayGroupWillFetch", (Object)this);
            this.refetch();
            if (delegate != null && delegate.respondsTo("displayGroupDidFetchObjects")) {
                delegate.perform("displayGroupDidFetchObjects", (Object)this, this._displayedObjects);
            }
            return null;
        }
        return super.fetch();
    }

    public void updateDisplayedObjects() {
        if (this.isBatching()) {
            _NSDelegate delegate;
            NSMutableArray selectedObjects = (NSMutableArray)this.selectedObjects();
            NSArray obj = this.allObjects();
            if (this.delegate() != null && (delegate = new _NSDelegate(WODisplayGroup.Delegate.class, this.delegate())) != null && delegate.respondsTo("displayGroupDisplayArrayForObjects")) {
                delegate.perform("displayGroupDisplayArrayForObjects", (Object)this, obj);
            }
            this.setSelectedObjects(selectedObjects);
            this.redisplay();
        } else {
            super.updateDisplayedObjects();
        }
    }

    @Override
    public Object selectFilteredObjects() {
        if (this.isBatching()) {
            this.setSelectedObjects(this.objectsInRange(0, this.rowCount()));
            return null;
        }
        return super.selectFilteredObjects();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FakeArray
    extends NSMutableArray<Object> {
        public FakeArray(int count) {
            super(count);
            NSKeyValueCoding.ErrorHandling fakeObject = new NSKeyValueCoding.ErrorHandling(){

                public Object handleQueryWithUnboundKey(String anS) {
                    return null;
                }

                public void handleTakeValueForUnboundKey(Object anObj, String anS) {
                }

                public void unableToSetNullForKey(String anS) {
                }
            };
            for (int i = 0; i < count; ++i) {
                this.insertObjectAtIndex(fakeObject, i);
            }
        }
    }
}

