/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSPathUtilities;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXRuntimeUtilities;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXSystem;
import java.io.File;
import java.io.IOException;

public class ERXRemoteShell
extends WOComponent {
    private static String alternativeQuote = "!#ALT_QUOTE#!";
    public String dir = "/";
    public String selectedPath;
    public NSMutableArray pathHistory = new NSMutableArray();
    public String currentPath;
    public int timeout = 180000;
    public String envp;
    public String uploadPath = ERXSystem.getProperty("java.io.tmpdir");
    public String consoleText = null;
    public String consoleTextHistory = null;
    public String command = null;
    public String filePath;
    public String finalFilePath;
    public String mimeType;

    public String streamToFilePath() {
        return new File(this.uploadPath, NSPathUtilities.lastPathComponent((String)this.filePath)).getAbsolutePath();
    }

    public ERXRemoteShell(WOContext context) {
        super(context);
    }

    public void appendToResponse(WOResponse r, WOContext c) {
        if (this.session().objectForKey("ERXRemoteShell.enabled") != null) {
            this.dir = "";
            super.appendToResponse(r, c);
        } else {
            r.appendContentString("please use the ERXDirectAction remoteShellAction to login first!");
        }
    }

    public WOComponent execute() {
        if (ERXStringUtilities.stringIsNullOrEmpty(this.dir)) {
            this.dir = this.selectedPath;
        } else if (!this.pathHistory.containsObject(this.dir)) {
            this.pathHistory.addObject(this.dir);
        }
        String[] commandArray = ERXRemoteShell.buildCommandArray(this.command);
        String[] envpArray = ERXRemoteShell.buildEnvpArray(this.envp);
        if (envpArray == null || envpArray.length == 0) {
            envpArray = new String[]{"TEST=t"};
        }
        if (ERXStringUtilities.stringIsNullOrEmpty(this.dir)) {
            this.dir = "/";
        }
        try {
            ERXRuntimeUtilities.Result result = ERXRuntimeUtilities.execute(commandArray, envpArray, new File(this.dir), this.timeout);
            String response = result.getResponseAsString();
            this.consoleText = "\n" + response;
            this.consoleTextHistory = this.consoleTextHistory + "\n";
            this.consoleTextHistory = this.consoleTextHistory + "\n";
            this.consoleTextHistory = this.consoleTextHistory + "<b>" + this.command + "</b>";
            this.consoleTextHistory = this.consoleTextHistory + "\n";
            this.consoleTextHistory = this.consoleTextHistory + this.consoleText;
            return this.context().page();
        }
        catch (IOException e) {
            this.consoleText = this.consoleText + "\n";
            this.consoleText = this.consoleText + "an exception occured";
            this.consoleText = this.consoleText + "\n";
            this.consoleText = this.consoleText + e.getMessage();
            return this.context().page();
        }
        catch (ERXRuntimeUtilities.TimeoutException e) {
            this.consoleText = this.consoleText + "\n";
            this.consoleText = this.consoleText + "process did not timeout after " + this.timeout + " seconds";
            return this.context().page();
        }
    }

    public WOComponent clearConsole() {
        this.consoleText = "";
        this.consoleTextHistory = "";
        return this.context().page();
    }

    public WOComponent uploadFile() {
        return this.context().page();
    }

    private static String[] buildEnvpArray(String envp) {
        NSArray<String> a = NSArray.componentsSeparatedByString(envp, "13");
        return ERXArrayUtilities.toStringArray(a);
    }

    private static String[] buildCommandArray(String command) {
        String newCommand = ERXStringUtilities.replaceStringByStringInString("\\\"", alternativeQuote, command);
        NSMutableArray<String> a = new NSMutableArray<String>();
        StringBuffer buf = new StringBuffer();
        int length = newCommand.length();
        boolean insideQuote = false;
        for (int i = 0; i < length; ++i) {
            String s;
            char c = newCommand.charAt(i);
            if ('\"' == c) {
                if (insideQuote) {
                    s = buf.toString().replaceAll(alternativeQuote, "\"");
                    if (s.length() > 0) {
                        a.addObject(s);
                    }
                    buf = new StringBuffer();
                    continue;
                }
                insideQuote = true;
                buf = new StringBuffer();
                continue;
            }
            if (' ' == c) {
                if (insideQuote) {
                    buf.append(c);
                    continue;
                }
                s = buf.toString().replaceAll(alternativeQuote, "\"");
                if (s.length() > 0) {
                    a.addObject(s);
                }
                buf = new StringBuffer();
                continue;
            }
            buf.append(c);
        }
        if (buf.toString().length() > 0) {
            a.addObject(buf.toString().replaceAll(alternativeQuote, "\""));
        }
        return ERXArrayUtilities.toStringArray(a);
    }
}

