/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components.javascript;

import er.extensions.foundation.ERXStringUtilities;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ERXGoogleSpell {
    public static void main(String[] args) throws CorrectionException {
        String str = "gogle spel";
        System.out.println("ERXGoogleSpell.correct: " + ERXGoogleSpell.correct(str));
    }

    public static String correct(String text) throws CorrectionException {
        return ERXGoogleSpell.correct(text, "en");
    }

    public static String correct(String text, String lang) throws CorrectionException {
        return ERXGoogleSpell.correct(text, lang, lang);
    }

    public static String correct(String text, String lang, String hl) throws CorrectionException {
        return ERXGoogleSpell.correct(text, lang, hl, true);
    }

    public static String correct(String text, String lang, String hl, boolean escapeXml) throws CorrectionException {
        Correction[] corrections = ERXGoogleSpell.suggestions(text, lang, hl, escapeXml);
        int lastOffset = 0;
        StringBuffer buffer = new StringBuffer();
        for (int correctionNum = 0; correctionNum < corrections.length; ++correctionNum) {
            Correction correction = corrections[correctionNum];
            String[] suggestions = correction.suggestions();
            if (suggestions.length <= 0) continue;
            String suggestion = suggestions[0];
            int offset = correction.offset();
            buffer.append(text.substring(lastOffset, offset));
            buffer.append(suggestion);
            lastOffset = offset + correction.length();
        }
        buffer.append(text.substring(lastOffset));
        return buffer.toString();
    }

    public static Correction[] suggestions(String text) throws CorrectionException {
        return ERXGoogleSpell.suggestions(text, "en");
    }

    public static Correction[] suggestions(String text, String lang) throws CorrectionException {
        return ERXGoogleSpell.suggestions(text, lang, lang);
    }

    public static Correction[] suggestions(String text, String lang, String hl) throws CorrectionException {
        return ERXGoogleSpell.suggestions(text, lang, hl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Correction[] suggestions(String text, String lang, String hl, boolean escapeXml) throws CorrectionException {
        try {
            Correction[] corrections;
            StringBuffer request = new StringBuffer();
            request.append("<spellrequest textalreadyclipped=\"0\" ignoredups=\"1\" ignoredigits=\"1\" ignoreallcaps=\"0\"><text>");
            if (escapeXml) {
                request.append(ERXStringUtilities.escapeNonXMLChars(text));
            } else {
                request.append(text);
            }
            request.append("</text></spellrequest>");
            URL url = new URL("https://www.google.com/tbproxy/spell?lang=" + lang + "&hl=" + hl);
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
            out.write(request.toString());
            out.close();
            InputStream in = connection.getInputStream();
            try {
                Document responseDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
                responseDocument.normalize();
                NodeList correctionNodes = responseDocument.getElementsByTagName("c");
                int correctionCount = correctionNodes.getLength();
                corrections = new Correction[correctionCount];
                for (int correctionNum = 0; correctionNum < correctionCount; ++correctionNum) {
                    Node correctionNode = correctionNodes.item(correctionNum);
                    if (!(correctionNode instanceof Element)) continue;
                    Element correctionElement = (Element)correctionNode;
                    String correctionsStr = "";
                    Node correctionsNodeItem = correctionElement.getChildNodes().item(0);
                    if (correctionsNodeItem != null) {
                        correctionsStr = correctionsNodeItem.getNodeValue();
                    }
                    int offset = Integer.parseInt(correctionElement.getAttribute("o"));
                    int length = Integer.parseInt(correctionElement.getAttribute("l"));
                    int confidence = Integer.parseInt(correctionElement.getAttribute("s"));
                    String[] correctionStrs = correctionsStr.split("\t");
                    corrections[correctionNum] = new Correction(offset, length, confidence, correctionStrs);
                }
                Object var23_23 = null;
            }
            catch (Throwable throwable) {
                Object var23_24 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return corrections;
        }
        catch (Exception e) {
            throw new CorrectionException("Failed to correct spelling of '" + text + "'.", e);
        }
    }

    public static class CorrectionException
    extends Exception {
        public CorrectionException(String message, Throwable cause) {
            super(message, cause);
        }

        public CorrectionException(String message) {
            super(message);
        }
    }

    public static class Correction {
        private int _offset;
        private int _length;
        private int _confidence;
        private String[] _suggestions;

        public Correction(int offset, int length, int confidence, String[] suggestions) {
            this._offset = offset;
            this._length = length;
            this._confidence = confidence;
            this._suggestions = suggestions;
        }

        public int offset() {
            return this._offset;
        }

        public int length() {
            return this._length;
        }

        public int confidence() {
            return this._confidence;
        }

        public String[] suggestions() {
            return this._suggestions;
        }
    }
}

