/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.concurrency;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.concurrency.ERXLongResponse;
import er.extensions.eof.ERXEC;
import er.extensions.foundation.ERXUtilities;
import org.apache.log4j.Logger;

public interface ERXLongResponseTask
extends Runnable {
    public void setLongResponse(ERXLongResponse var1);

    public boolean isDone();

    public void start();

    public void stop();

    public WOComponent nextPage();

    public static abstract class DefaultImplementation
    implements Runnable,
    ERXLongResponseTask {
        public Logger log = Logger.getLogger(ERXUtilities.class);
        protected ERXLongResponse _longResponse;
        protected Object _status;
        protected Object _result;
        protected Exception _exception;
        protected boolean _cancelled;
        protected boolean _done;
        protected Thread _thread;

        public DefaultImplementation() {
            this._finishInitialization();
            this.log = Logger.getLogger((String)this.getClass().getName());
            this._thread = null;
        }

        protected void _finishInitialization() {
            if (!WOApplication.application().adaptorsDispatchRequestsConcurrently()) {
                throw new RuntimeException("<" + this.getClass().getName() + "> Cannot initialize because:\nThe application must be set to run with multiple threads to use this component. You must first increase the application's worker thread count to at least 1. You then have several options:\n1. If you set the count to 1, your code does not need to be thread safe.\n2. If you set the count above 1, and your code is not thread safe, disable concurrent request handling.\n3. you set the count above 1, and your code is thread safe, you can enable concurrent request handling.");
            }
            this._status = null;
            this._result = null;
            this._done = false;
            this._exception = null;
            this._cancelled = false;
        }

        public void setLongResponse(ERXLongResponse sender) {
            this._longResponse = sender;
        }

        public ERXLongResponse longResponse() {
            return this._longResponse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block4: {
                WOApplication app = WOApplication.application();
                this.setResult(null);
                this._done = false;
                this.log.debug((Object)"creating computation thread");
                try {
                    try {
                        this.setResult(this.performAction());
                    }
                    catch (Exception localException) {
                        this.setException(localException);
                        this.log.error((Object)("long response thread raised : " + localException.getMessage()), (Throwable)localException);
                        Object var4_3 = null;
                        ERXEC.unlockAllContextsForCurrentThread();
                        this._thread = null;
                        break block4;
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    ERXEC.unlockAllContextsForCurrentThread();
                    this._thread = null;
                    throw throwable;
                }
                ERXEC.unlockAllContextsForCurrentThread();
                this._thread = null;
            }
            this.log.debug((Object)"exiting computation thread");
            this._done = true;
        }

        public Object status() {
            return this._status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setStatus(Object anObject) {
            if (anObject != this._status) {
                DefaultImplementation defaultImplementation = this;
                synchronized (defaultImplementation) {
                    this._status = anObject;
                }
            }
        }

        protected Exception exception() {
            return this._exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setException(Exception anObject) {
            if (anObject != this._exception) {
                DefaultImplementation defaultImplementation = this;
                synchronized (defaultImplementation) {
                    this._exception = anObject;
                }
            }
        }

        protected Object result() {
            return this._result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setResult(Object anObject) {
            if (anObject != this._result) {
                DefaultImplementation defaultImplementation = this;
                synchronized (defaultImplementation) {
                    this._result = anObject;
                }
            }
        }

        protected boolean isCancelled() {
            return this._cancelled;
        }

        public boolean isDone() {
            return this._done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            DefaultImplementation defaultImplementation = this;
            synchronized (defaultImplementation) {
                this._cancelled = true;
                this._thread = null;
            }
        }

        public void start() {
            try {
                if (this._thread == null) {
                    this._thread = new WorkerThread(this);
                    this._thread.setName(this.toString());
                }
                if (!this._thread.isAlive()) {
                    this._thread.start();
                }
            }
            catch (Exception localException) {
                throw new NSForwardException((Throwable)localException, "<ERXLongResponse> Exception occurred while creating long response thread: " + localException.toString());
            }
        }

        protected WOComponent pageForException(Exception exception) {
            throw new NSForwardException((Throwable)exception, "<WOLongResponsePage> Exception occurred in long response thread: " + exception.toString());
        }

        protected WOComponent refreshPageForStatus(Object aStatus) {
            return this.longResponse().context().page();
        }

        protected WOComponent pageForResult(Object aResult) {
            return this.longResponse().context().page();
        }

        protected WOComponent cancelPageForStatus(Object aStatus) {
            return this.refreshPageForStatus(aStatus);
        }

        public WOComponent nextPage() {
            Exception e = this.exception();
            if (e != null) {
                return this.pageForException(e);
            }
            if (this.isDone()) {
                if (this.isCancelled()) {
                    return this.cancelPageForStatus(this.status());
                }
                return this.pageForResult(this.result());
            }
            return this.refreshPageForStatus(this.status());
        }

        public abstract Object performAction();
    }

    public static class WorkerThread
    extends Thread {
        protected ERXLongResponseTask _task;

        public WorkerThread(ERXLongResponseTask task) {
            super(task);
            this._task = task;
        }

        public ERXLongResponseTask task() {
            return this._task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                super.run();
                Object var2_1 = null;
                this._task = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this._task = null;
                throw throwable;
            }
        }

        public static NSArray tasks() {
            NSMutableArray<ERXLongResponseTask> tasks = new NSMutableArray<ERXLongResponseTask>();
            Thread[] threads = new Thread[Thread.activeCount()];
            Thread.enumerate(threads);
            for (int i = 0; i < threads.length; ++i) {
                ERXLongResponseTask task;
                Thread thread = threads[i];
                if (!(thread instanceof WorkerThread) || (task = ((WorkerThread)thread).task()) == null) continue;
                tasks.addObject(task);
            }
            return tasks.immutableClone();
        }
    }
}

