/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.crypting;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.crypting.ERXAESCrypter;
import er.extensions.crypting.ERXBlowfishCrypter;
import er.extensions.crypting.ERXCrypterInterface;
import er.extensions.crypting.ERXDESCrypter;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import java.io.IOException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXCrypto {
    public static final Logger log = Logger.getLogger(ERXCrypto.class);
    public static final String DES = "DES";
    public static final String BLOWFISH = "Blowfish";
    public static final String AES = "AES";
    private static NSMutableDictionary<String, ERXCrypterInterface> _crypters;

    private static synchronized NSMutableDictionary<String, ERXCrypterInterface> crypters() {
        if (_crypters == null) {
            _crypters = new NSMutableDictionary();
            _crypters.setObjectForKey(new ERXDESCrypter(), DES);
            _crypters.setObjectForKey(new ERXBlowfishCrypter(), BLOWFISH);
            _crypters.setObjectForKey(new ERXAESCrypter(), AES);
            NSArray<String> crypterAlgorithms = ERXProperties.componentsSeparatedByString("er.extensions.ERXCrypto.crypters", ",");
            if (crypterAlgorithms != null) {
                for (String crypterAlgorithm : crypterAlgorithms) {
                    String crypterClassName = ERXProperties.stringForKey("er.extensions.ERXCrypto.crypter." + crypterAlgorithm);
                    if (crypterClassName == null) {
                        throw new IllegalArgumentException("You did not provide a crypter class definition for 'er.extensions.ERXCrypto.crypter." + crypterAlgorithm + "'.");
                    }
                    try {
                        ERXCrypterInterface crypter = Class.forName(crypterClassName).asSubclass(ERXCrypterInterface.class).newInstance();
                        _crypters.setObjectForKey(crypter, crypterAlgorithm);
                    }
                    catch (Exception e) {
                        throw new NSForwardException((Throwable)e, "Failed to create " + crypterAlgorithm + " crypter '" + crypterClassName + "'.");
                    }
                }
            }
        }
        return _crypters;
    }

    public static ERXCrypterInterface defaultCrypter() {
        String defaultCrypterAlgorithm = ERXProperties.stringForKeyWithDefault("er.extensions.ERXCrypto.default", BLOWFISH);
        return ERXCrypto.crypterForAlgorithm(defaultCrypterAlgorithm);
    }

    public static void setCrypterForAlgorithm(ERXCrypterInterface crypter, String algorithm) {
        NSMutableDictionary<String, ERXCrypterInterface> crypters = ERXCrypto.crypters();
        crypters.setObjectForKey(crypter, algorithm);
    }

    public static ERXCrypterInterface crypterForAlgorithm(String algorithm) {
        NSMutableDictionary<String, ERXCrypterInterface> crypters = ERXCrypto.crypters();
        ERXCrypterInterface crypter = (ERXCrypterInterface)crypters.objectForKey(algorithm);
        if (crypter == null) {
            throw new IllegalArgumentException("Unknown encryption algorithm '" + algorithm + "'.");
        }
        return crypter;
    }

    public static NSMutableDictionary<String, String> decodedFormValuesDictionary(NSDictionary<String, NSArray<String>> dict) {
        NSMutableDictionary<String, String> result = new NSMutableDictionary<String, String>();
        Enumeration<String> e = dict.allKeys().objectEnumerator();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            NSArray<String> objects = dict.objectForKey(key);
            String value = ERXCrypto.defaultCrypter().decrypt(objects.lastObject()).trim();
            result.setObjectForKey(value, key);
        }
        return result;
    }

    public static String base64HashedString(String v) {
        String base64HashedPassword = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(v.getBytes());
            String hashedPassword = new String(md.digest());
            BASE64Encoder enc = new BASE64Encoder();
            base64HashedPassword = enc.encode(hashedPassword.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new NSForwardException((Throwable)e, "Couldn't find the SHA hash algorithm; perhaps you do not have the SunJCE security provider installed properly?");
        }
        return base64HashedPassword;
    }

    public static String shaEncode(String text) {
        if (text == null) {
            return text;
        }
        byte[] buf = text.getBytes();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(buf);
            return ERXStringUtilities.byteArrayToHexString(md.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new NSForwardException((Throwable)ex, "Couldn't find the SHA algorithm; perhaps you do not have the SunJCE security provider installed properly?");
        }
    }

    public static String base64Encode(byte[] byteArray) {
        BASE64Encoder enc = new BASE64Encoder();
        String base64String = enc.encode(byteArray);
        return base64String;
    }

    public static String base64urlEncode(byte[] byteArray) {
        String base64String = ERXCrypto.base64Encode(byteArray);
        StringBuffer sb = new StringBuffer(base64String.length());
        for (int i = 0; i < base64String.length(); ++i) {
            char ch = base64String.charAt(i);
            if (ch == '+') {
                sb.append('-');
                continue;
            }
            if (ch == '/') {
                sb.append('_');
                continue;
            }
            if (ch == '\r' || ch == '\n' || ch == '=') continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static byte[] base64Decode(String s) throws IOException {
        BASE64Decoder enc = new BASE64Decoder();
        byte[] raw = enc.decodeBuffer(s);
        return raw;
    }

    public static byte[] base64urlDecode(String s) throws IOException {
        int length = s.length();
        StringBuffer sb = new StringBuffer(length);
        for (int i = 0; i < length || (i & 2) != 0; ++i) {
            if (i >= length) {
                sb.append('=');
                continue;
            }
            char ch = s.charAt(i);
            if (ch == '-') {
                sb.append('+');
                continue;
            }
            if (ch == '_') {
                sb.append('/');
                continue;
            }
            sb.append(ch);
        }
        return ERXCrypto.base64Decode(sb.toString());
    }

    @Deprecated
    public static String bytesToString(byte[] bytes) {
        return ERXStringUtilities.byteArrayToHexString(bytes);
    }

    @Deprecated
    public static String base64EncryptedString(String clearText) {
        return ERXCrypto.crypterForAlgorithm(DES).encrypt(clearText);
    }

    @Deprecated
    public static String base64EncryptedString(String clearText, Key secretKey) {
        return ((ERXDESCrypter)ERXCrypto.crypterForAlgorithm(DES)).encrypt(clearText, secretKey);
    }

    @Deprecated
    public static String decryptedBase64String(String encryptedText) {
        return ERXCrypto.crypterForAlgorithm(DES).decrypt(encryptedText);
    }

    @Deprecated
    public static String decryptedBase64String(String encryptedText, Key secretKey) {
        return ((ERXDESCrypter)ERXCrypto.crypterForAlgorithm(DES)).decrypt(encryptedText, secretKey);
    }

    @Deprecated
    public static String blowfishEncode(String clearText) {
        return ERXCrypto.crypterForAlgorithm(BLOWFISH).encrypt(clearText);
    }

    @Deprecated
    public static String blowfishDecode(String encryptedText) {
        return ERXCrypto.crypterForAlgorithm(BLOWFISH).decrypt(encryptedText);
    }

    @Deprecated
    public static void setSecretKeyPathFramework(String secretKeyPathFramework) {
        ((ERXDESCrypter)ERXCrypto.crypterForAlgorithm(DES)).setSecretKeyPathFramework(secretKeyPathFramework);
    }

    @Deprecated
    public static void setSecretKeyPath(String secretKeyPath) {
        ((ERXDESCrypter)ERXCrypto.crypterForAlgorithm(DES)).setSecretKeyPath(secretKeyPath);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: ERXCrypto [plaintext]");
            System.out.println("       returns the encrypted form of the given plaintext using the default crypter");
            System.exit(0);
        }
        String plaintext = args[0];
        String encrypted = ERXCrypto.defaultCrypter().encrypt(plaintext);
        System.out.println("ERXCrypto.main: Encrypted form of '" + plaintext + "' is '" + encrypted + "'");
    }
}

