/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSPropertyListSerialization;
import er.extensions.foundation.ERXArrayUtilities;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ERXConstant {
    private static final Logger log = Logger.getLogger(ERXConstant.class);
    private static final Map _store = new HashMap();
    private static int globalSortOrder = 0;
    public static final int MAX_INT = 2500;
    protected static Integer[] INTEGERS = new Integer[2500];
    public static final Object EmptyObject;
    public static final String EmptyString = "";
    public static final NSArray EmptyArray;
    public static final NSArray SingleNullValueArray;
    public static final NSDictionary EmptyDictionary;
    public static final Integer MinusOneInteger;
    public static final Integer OneInteger;
    public static final Integer ZeroInteger;
    public static final Integer TwoInteger;
    public static final Integer ThreeInteger;
    public static final BigDecimal ZeroBigDecimal;
    public static final BigDecimal OneBigDecimal;
    public static final Class[] EmptyClassArray;
    public static final Class[] NotificationClassArray;
    public static final Class[] ObjectClassArray;
    public static final Class[] StringClassArray;
    public static final Object[] EmptyObjectArray;
    public static final NSData EmptyImage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSArray constantsForClassName(String clazzName) {
        Map map = _store;
        synchronized (map) {
            Map map2 = ERXConstant.keyMap(clazzName, false);
            NSMutableArray<Object> array = new NSMutableArray<Object>(map2.values().toArray());
            ERXArrayUtilities.sortArrayWithKey(array, "sortOrder");
            return array;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Constant constantForClassNamed(Object value, String clazzName) {
        Map map = _store;
        synchronized (map) {
            Map classMap = ERXConstant.keyMap(clazzName, false);
            Constant result = (Constant)classMap.get(value);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting " + result + " for " + clazzName + " and " + value));
            }
            return result;
        }
    }

    private static Map keyMap(String name, boolean create) {
        HashMap map = (HashMap)_store.get(name);
        if (map == null) {
            if (create) {
                map = new HashMap();
                _store.put(name, map);
                name = name.replace('$', '.');
                _store.put(name, map);
            } else {
                map = Collections.EMPTY_MAP;
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerConstant(Object key, Constant value, Class clazz) {
        Map map = _store;
        synchronized (map) {
            String className = clazz.getName();
            Map classMap = ERXConstant.keyMap(className, true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Putting " + key + " for " + className));
            }
            classMap.put(key, value);
        }
    }

    public static Integer integerForInt(int i) {
        return i >= 0 && i < 2500 ? INTEGERS[i] : new Integer(i);
    }

    public static Integer integerForString(String s) throws NumberFormatException {
        return ERXConstant.integerForInt(Integer.parseInt(s));
    }

    static {
        for (int i = 0; i < 2500; ++i) {
            ERXConstant.INTEGERS[i] = new Integer(i);
        }
        EmptyObject = new Object();
        EmptyArray = NSArray.EmptyArray;
        SingleNullValueArray = new NSArray<NSKeyValueCoding.Null>(NSKeyValueCoding.NullValue);
        EmptyDictionary = NSDictionary.EmptyDictionary;
        MinusOneInteger = new Integer(-1);
        OneInteger = ERXConstant.integerForInt(1);
        ZeroInteger = ERXConstant.integerForInt(0);
        TwoInteger = ERXConstant.integerForInt(2);
        ThreeInteger = ERXConstant.integerForInt(3);
        ZeroBigDecimal = new BigDecimal(0.0);
        OneBigDecimal = new BigDecimal(1.0);
        EmptyClassArray = new Class[0];
        NotificationClassArray = new Class[]{NSNotification.class};
        ObjectClassArray = new Class[]{Object.class};
        StringClassArray = new Class[]{String.class};
        EmptyObjectArray = new Object[0];
        EmptyImage = (NSData)NSPropertyListSerialization.propertyListFromString((String)"<47494638396101000100800000ffffff00000021f90401000000002c00000000010001000002024401003b00>");
    }

    public static abstract class ByteConstant
    implements Constant {
        private NSData _value;
        private String _name;
        private int _sortOrder;

        public ByteConstant(String value, String name) {
            this((NSData)NSPropertyListSerialization.propertyListFromString((String)value.toString()), name);
        }

        public ByteConstant(NSData value, String name) {
            this._value = value;
            this._name = name;
            this._sortOrder = globalSortOrder++;
            ERXConstant.registerConstant(value, this, this.getClass());
        }

        public String name() {
            return this._name;
        }

        public int sortOrder() {
            return this._sortOrder;
        }

        public Object value() {
            return this._value;
        }

        public String userPresentableDescription() {
            return this.name();
        }

        public String toString() {
            return this.getClass().getName() + ": " + this.userPresentableDescription();
        }

        public static ByteConstant constantForClassNamed(NSData value, String clazzName) {
            return (ByteConstant)ERXConstant.constantForClassNamed(value, clazzName);
        }

        public static ByteConstant constantForClassNamed(byte[] value, String clazzName) {
            return (ByteConstant)ERXConstant.constantForClassNamed(new NSData(value), clazzName);
        }
    }

    public static abstract class StringConstant
    implements Constant {
        private String _value;
        private String _name;
        private int _sortOrder;

        public StringConstant(String value, String name) {
            this._value = value;
            this._name = name;
            this._sortOrder = globalSortOrder++;
            ERXConstant.registerConstant(value, this, this.getClass());
        }

        public String name() {
            return this._name;
        }

        public int sortOrder() {
            return this._sortOrder;
        }

        public Object value() {
            return this._value;
        }

        public String userPresentableDescription() {
            return this.name() + " (" + this.value() + ")";
        }

        public String toString() {
            return this.getClass().getName() + ": " + this.userPresentableDescription();
        }

        public static StringConstant constantForClassNamed(String value, String clazzName) {
            return (StringConstant)ERXConstant.constantForClassNamed(value, clazzName);
        }
    }

    public static class NumberConstant
    extends Number
    implements Constant {
        private int _value;
        private String _name;
        private int _sortOrder;

        protected NumberConstant(int value, String name) {
            this._value = value;
            this._name = name;
            this._sortOrder = globalSortOrder++;
            ERXConstant.registerConstant(ERXConstant.integerForInt(value), this, this.getClass());
        }

        public int sortOrder() {
            return this._sortOrder;
        }

        public final double doubleValue() {
            return this.intValue();
        }

        public final float floatValue() {
            return this.intValue();
        }

        public final int intValue() {
            return this._value;
        }

        public final long longValue() {
            return this.intValue();
        }

        public final int hashCode() {
            return this._value;
        }

        public String name() {
            return this._name;
        }

        public String userPresentableDescription() {
            return this.name() + " (" + this.intValue() + ")";
        }

        public String toString() {
            return this.getClass().getName() + ": " + this.userPresentableDescription();
        }

        public Object value() {
            return ERXConstant.integerForInt(this.intValue());
        }

        public final boolean equals(Object otherObject) {
            if (otherObject == null) {
                return false;
            }
            if (otherObject.getClass() != this.getClass()) {
                return false;
            }
            return ((NumberConstant)otherObject).intValue() == this.intValue();
        }

        public static NumberConstant constantForClassNamed(int value, String clazzName) {
            return NumberConstant.constantForClassNamed(ERXConstant.integerForInt(value), clazzName);
        }

        public static NumberConstant constantForClassNamed(Number value, String clazzName) {
            return (NumberConstant)ERXConstant.constantForClassNamed(value, clazzName);
        }
    }

    public static interface Constant {
        public int sortOrder();

        public String name();

        public Object value();
    }
}

