/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXEnterpriseObjectCache;
import er.extensions.foundation.ERXSelectorUtilities;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXEnterpriseObjectArrayCache<T extends EOEnterpriseObject> {
    private String _entityName;
    private Map<Object, NSArray<EOGlobalID>> _cache;
    private long _timeout;
    private long _fetchTime;
    protected static final NSArray NOT_FOUND_MARKER = new NotFoundArray();

    public ERXEnterpriseObjectArrayCache(String entityName) {
        this(entityName, 0L);
    }

    public ERXEnterpriseObjectArrayCache(Class c) {
        this(ERXEnterpriseObjectArrayCache.entityNameForClass(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String entityNameForClass(Class c) {
        EOEditingContext ec;
        block3: {
            String string;
            ec = ERXEC.newEditingContext();
            ec.lock();
            try {
                EOEntity entity = EOUtilities.entityForClass((EOEditingContext)ec, (Class)c);
                if (entity == null) break block3;
                string = entity.name();
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                ec.unlock();
                throw throwable;
            }
            ec.unlock();
            return string;
        }
        String string = null;
        Object var5_6 = null;
        ec.unlock();
        return string;
    }

    public ERXEnterpriseObjectArrayCache(String entityName, long timeout) {
        this._entityName = entityName;
        this._timeout = timeout;
        this.registerForNotifications();
    }

    protected void registerForNotifications() {
        NSSelector selector = ERXSelectorUtilities.notificationSelector("editingContextDidSaveChanges");
        NSNotificationCenter.defaultCenter().addObserver((Object)this, selector, "EOEditingContextDidSaveChangesNotification", null);
        selector = ERXSelectorUtilities.notificationSelector("clearCaches");
        NSNotificationCenter.defaultCenter().addObserver((Object)this, selector, ERXEnterpriseObjectCache.ClearCachesNotification, null);
    }

    private boolean hadRelevantChanges(NSDictionary dict, String key) {
        NSArray eos = (NSArray)dict.objectForKey(key);
        Enumeration enumeration = eos.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            EOEnterpriseObject eo = (EOEnterpriseObject)enumeration.nextElement();
            if (!eo.entityName().equals(this.entityName())) continue;
            return true;
        }
        return false;
    }

    public void editingContextDidSaveChanges(NSNotification n) {
        EOEditingContext ec = (EOEditingContext)n.object();
        if (ec.parentObjectStore() instanceof EOObjectStoreCoordinator) {
            if (!(this.hadRelevantChanges(n.userInfo(), "inserted") || this.hadRelevantChanges(n.userInfo(), "updated") || this.hadRelevantChanges(n.userInfo(), "deleted"))) {
                return;
            }
            this.reset();
        }
    }

    public void clearCaches(NSNotification n) {
        if (n.object() == null || this.entityName().equals(n.object())) {
            this.reset();
        }
    }

    protected String entityName() {
        return this._entityName;
    }

    private synchronized Map cache() {
        long now = System.currentTimeMillis();
        if (this._timeout > 0L && now - this._timeout > this._fetchTime) {
            this.reset();
        }
        if (this._cache == null) {
            this._cache = Collections.synchronizedMap(new HashMap());
            this._fetchTime = System.currentTimeMillis();
        }
        return this._cache;
    }

    public void setObjectsForKey(NSArray<? extends EOEnterpriseObject> bugs, Object key) {
        NSArray gids = NOT_FOUND_MARKER;
        if (bugs != null) {
            gids = ERXEOControlUtilities.globalIDsForObjects(bugs);
        }
        this.setCachedArrayForKey(gids, key);
    }

    protected void setCachedArrayForKey(NSArray<EOGlobalID> gids, Object key) {
        this.cache().put(key, gids);
    }

    protected NSArray<EOGlobalID> cachedArrayForKey(Object key) {
        return (NSArray)this.cache().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray<T> objectsForKey(EOEditingContext ec, Object key) {
        ERXEnterpriseObjectArrayCache eRXEnterpriseObjectArrayCache = this;
        synchronized (eRXEnterpriseObjectArrayCache) {
            NSArray<EOGlobalID> gids = this.cachedArrayForKey(key);
            if (this.isNotFound(gids)) {
                return null;
            }
            if (gids == null) {
                this.handleUnsuccessfullQueryForKey(key);
                gids = this.cachedArrayForKey(key);
                if (this.isNotFound(gids)) {
                    return null;
                }
                if (gids == null) {
                    return null;
                }
            }
            NSArray eos = ERXEOControlUtilities.faultsForGlobalIDs(ec, gids);
            return eos;
        }
    }

    protected boolean isNotFound(NSArray<EOGlobalID> gids) {
        return gids != null ? NotFoundArray.class == gids.getClass() : false;
    }

    protected void handleUnsuccessfullQueryForKey(Object key) {
        this.setCachedArrayForKey(NOT_FOUND_MARKER, key);
    }

    public synchronized void reset() {
        this._cache = null;
    }

    protected long timeout() {
        return this._timeout;
    }

    protected long fetchTime() {
        return this._fetchTime;
    }

    public static class NotFoundArray
    extends NSArray {
    }
}

