/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import er.extensions.eof.ERXEntityOrder;
import er.extensions.foundation.ERXArrayUtilities;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXEntityFKConstraintOrder
extends ERXEntityOrder {
    private static Logger logger = Logger.getLogger(ERXEntityFKConstraintOrder.class);

    public ERXEntityFKConstraintOrder(EOModelGroup modelGroup) {
        super(modelGroup);
    }

    public ERXEntityFKConstraintOrder() {
    }

    protected NSDictionary dependenciesByEntity() {
        EOEntity entity;
        logger.debug((Object)"Building dependency list");
        NSMutableDictionary dependencyList = new NSMutableDictionary(this.allEntities().count());
        Enumeration entityEnum = this.allEntities().objectEnumerator();
        while (entityEnum.hasMoreElements()) {
            entity = (EOEntity)entityEnum.nextElement();
            logger.trace((Object)("Finding dependencies of " + entity.name()));
            Enumeration relationshipEnum = entity.relationships().objectEnumerator();
            while (relationshipEnum.hasMoreElements()) {
                EORelationship relationship = (EORelationship)relationshipEnum.nextElement();
                if (this.hasForeignKeyConstraint(relationship)) {
                    EOEntity destinationEntity = relationship.destinationEntity();
                    logger.trace((Object)("Recording dependency on " + destinationEntity.name()));
                    this.entitiesDependentOn(dependencyList, destinationEntity).addObject(entity.name());
                    continue;
                }
                logger.trace((Object)"Ignoring, is not FK relationship or vertical inheritance parent");
            }
        }
        logger.debug((Object)"Finished building dependency list");
        if (logger.isTraceEnabled()) {
            for (int i = 0; i < this.allEntities().count(); ++i) {
                entity = (EOEntity)this.allEntities().objectAtIndex(i);
                logger.trace((Object)("Entity " + entity.name() + " is referenced by " + this.entitiesDependentOn(dependencyList, entity)));
            }
        }
        return dependencyList;
    }

    protected boolean hasForeignKeyConstraint(EORelationship relationship) {
        logger.trace((Object)("Examining relationshp " + relationship.name()));
        if (relationship.entity().externalName() != null && relationship.entity().externalName().equals(relationship.destinationEntity().externalName())) {
            logger.trace((Object)"Ignoring: reflexive relationship");
            return false;
        }
        if (!ERXArrayUtilities.arraysAreIdenticalSets(relationship.destinationAttributes(), relationship.destinationEntity().primaryKeyAttributes())) {
            logger.trace((Object)"No FK constraint: found non-PK attributes in destination");
            return false;
        }
        if (ERXArrayUtilities.arraysAreIdenticalSets(relationship.sourceAttributes(), relationship.entity().primaryKeyAttributes())) {
            if (relationship.destinationEntity().equals(relationship.entity().parentEntity())) {
                logger.trace((Object)"Is vertical inheritance PK to PKconstraint");
                return true;
            }
            logger.trace((Object)"No FK constraint: Is PK to PK");
            return false;
        }
        logger.trace((Object)"Is FK constraint");
        return true;
    }

    protected String dependencyKeyFor(EOEntity entity) {
        if (entity.externalName() == null) {
            return "Abstract Dummy Entity";
        }
        return entity.externalName();
    }

    protected NSMutableSet entitiesDependentOn(NSMutableDictionary dependencies, EOEntity entity) {
        NSMutableSet referencingEntities = (NSMutableSet)dependencies.objectForKey(this.dependencyKeyFor(entity));
        if (referencingEntities == null) {
            referencingEntities = new NSMutableSet();
            dependencies.setObjectForKey(referencingEntities, this.dependencyKeyFor(entity));
        }
        return referencingEntities;
    }
}

