/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSet;
import er.extensions.eof.ERXKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXKeyFilter {
    private Base _base;
    private NSMutableDictionary<ERXKey, ERXKeyFilter> _includes;
    private NSMutableSet<ERXKey> _excludes;
    private NSMutableSet<ERXKey> _lockedRelationships;
    private NSMutableDictionary<ERXKey, ERXKey> _map;
    private Base _nextBase;
    private Delegate _delegate;

    public ERXKeyFilter(Base base) {
        this(base, Base.None);
    }

    public ERXKeyFilter(Base base, Base nextBase) {
        this._base = base;
        this._nextBase = nextBase;
        this._includes = new NSMutableDictionary();
        this._excludes = new NSMutableSet();
        this._lockedRelationships = new NSMutableSet();
        this._map = new NSMutableDictionary();
    }

    public void setDelegate(Delegate delegate) {
        this._delegate = delegate;
        for (ERXKeyFilter includedFilter : this._includes.values()) {
            includedFilter.setDelegate(delegate);
        }
    }

    public Delegate delegate() {
        return this._delegate;
    }

    public void addMap(ERXKey fromKey, ERXKey toKey) {
        this._map.setObjectForKey(toKey, fromKey);
    }

    public <T> ERXKey<T> keyMap(ERXKey<T> fromKey) {
        ERXKey<T> toKey = (ERXKey<T>)this._map.objectForKey(fromKey);
        if (toKey == null) {
            toKey = fromKey;
        }
        return toKey;
    }

    public static ERXKeyFilter filterWithNone() {
        return new ERXKeyFilter(Base.None);
    }

    public static ERXKeyFilter filterWithAttributes() {
        return new ERXKeyFilter(Base.Attributes);
    }

    public static ERXKeyFilter filterWithKeys(ERXKey<?> ... keys) {
        ERXKeyFilter keyFilter = new ERXKeyFilter(Base.None);
        for (ERXKey<?> key : keys) {
            keyFilter.include((ERXKey)key);
        }
        return keyFilter;
    }

    public static ERXKeyFilter filterWithAttributesAndToOneRelationships() {
        return new ERXKeyFilter(Base.AttributesAndToOneRelationships);
    }

    public static ERXKeyFilter filterWithAll() {
        return new ERXKeyFilter(Base.All);
    }

    public static ERXKeyFilter filterWithAllRecursive() {
        return new ERXKeyFilter(Base.All, Base.All);
    }

    public Base base() {
        return this._base;
    }

    public void includeAll() {
        this.setBase(Base.All);
    }

    public void includeAttributes() {
        this.setBase(Base.Attributes);
    }

    public void includeAttributesAndToOneRelationships() {
        this.setBase(Base.AttributesAndToOneRelationships);
    }

    public void includeNone() {
        this.setBase(Base.None);
    }

    public void setBase(Base base) {
        this._base = base;
    }

    public Base nextBase() {
        return this._nextBase;
    }

    public ERXKeyFilter setNextBase(Base nextBase) {
        this._nextBase = nextBase;
        return this;
    }

    public ERXKeyFilter _filterForKey(ERXKey key) {
        ERXKeyFilter filter = (ERXKeyFilter)this._includes.objectForKey(key);
        if (filter == null) {
            filter = new ERXKeyFilter(this._nextBase);
            filter.setDelegate(this._delegate);
            filter.setNextBase(this._nextBase);
        }
        return filter;
    }

    public NSDictionary<ERXKey, ERXKeyFilter> includes() {
        return this._includes;
    }

    public NSSet<ERXKey> excludes() {
        return this._excludes;
    }

    public NSSet<ERXKey> lockedRelationships() {
        return this._lockedRelationships;
    }

    public void include(ERXKey ... keys) {
        for (ERXKey key : keys) {
            this.include(key);
        }
    }

    public boolean includes(ERXKey key) {
        return this._includes.containsKey(key);
    }

    public ERXKeyFilter include(ERXKey key) {
        ERXKeyFilter filter;
        String keyPath = key.key();
        int dotIndex = keyPath.indexOf(46);
        if (dotIndex == -1) {
            filter = (ERXKeyFilter)this._includes.objectForKey(key);
            if (filter == null) {
                filter = new ERXKeyFilter(this._nextBase);
                filter.setDelegate(this._delegate);
                filter.setNextBase(this._nextBase);
                this._includes.setObjectForKey(filter, key);
                this._excludes.removeObject(key);
            }
        } else {
            ERXKeyFilter subFilter = this.include(new ERXKey(keyPath.substring(0, dotIndex)));
            filter = subFilter.include(new ERXKey(keyPath.substring(dotIndex + 1)));
        }
        return filter;
    }

    public boolean excludes(ERXKey key) {
        return this._excludes.contains(key);
    }

    public boolean lockedRelationship(ERXKey key) {
        return this._lockedRelationships.contains(key);
    }

    public void lockRelationship(ERXKey ... keys) {
        for (ERXKey key : keys) {
            String keyPath = key.key();
            int dotIndex = keyPath.indexOf(46);
            if (dotIndex == -1) {
                this._lockedRelationships.addObject(key);
                continue;
            }
            ERXKeyFilter subFilter = this.include(new ERXKey(keyPath.substring(0, dotIndex)));
            subFilter.lockRelationship(new ERXKey(keyPath.substring(dotIndex + 1)));
        }
    }

    public void exclude(ERXKey ... keys) {
        for (ERXKey key : keys) {
            String keyPath = key.key();
            int dotIndex = keyPath.indexOf(46);
            if (dotIndex == -1) {
                this._excludes.addObject(key);
                this._includes.removeObjectForKey(key);
                continue;
            }
            ERXKeyFilter subFilter = this.include(new ERXKey(keyPath.substring(0, dotIndex)));
            subFilter.exclude(new ERXKey(keyPath.substring(dotIndex + 1)));
        }
    }

    public void only(ERXKey ... keys) {
        this._base = Base.None;
        this._includes.clear();
        this._excludes.clear();
        for (ERXKey key : keys) {
            this.include(key);
        }
    }

    public ERXKeyFilter only(ERXKey key) {
        this._base = Base.None;
        this._includes.clear();
        this._excludes.clear();
        return this.include(key);
    }

    public boolean matches(ERXKey key, ERXKey.Type type) {
        boolean matches = false;
        if (this.includes(key) && !this.excludes(key)) {
            matches = true;
        } else if (this._base == Base.None) {
            matches = this.includes(key) && !this.excludes(key);
        } else if (this._base == Base.Attributes) {
            if (type == ERXKey.Type.Attribute) {
                matches = this.includes(key) || !this.excludes(key);
            }
        } else if (this._base == Base.AttributesAndToOneRelationships) {
            if (type == ERXKey.Type.Attribute || type == ERXKey.Type.ToOneRelationship) {
                matches = this.includes(key) || !this.excludes(key);
            }
        } else if (this._base == Base.All) {
            matches = !this.excludes(key);
        } else {
            throw new IllegalArgumentException("Unknown base '" + (Object)((Object)this._base) + "'.");
        }
        return matches;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ERXKeyFilter: base=" + (Object)((Object)this._base));
        if (!this._includes.isEmpty()) {
            sb.append("; includes=" + this._includes + "");
        }
        if (!this._excludes.isEmpty()) {
            sb.append("; excludes=" + this._excludes);
        }
        if (!this._lockedRelationships.isEmpty()) {
            sb.append("; excludesRelationships=" + this._lockedRelationships);
        }
        sb.append("]");
        return sb.toString();
    }

    public static interface Delegate {
        public void willTakeValueForKey(Object var1, Object var2, String var3) throws SecurityException;

        public void didTakeValueForKey(Object var1, Object var2, String var3) throws SecurityException;

        public void didSkipValueForKey(Object var1, Object var2, String var3) throws SecurityException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Base {
        None,
        Attributes,
        AttributesAndToOneRelationships,
        All;

    }
}

