/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ERXBooleanExpressionParser {
    private static Pattern KEYPATH_TOKEN_PATTERN = Pattern.compile("\\w+([.]\\w*)*");
    private static final String[] BOOLEAN_WORDS = new String[]{"AND", "OR", "NOT"};
    private final String expression;
    private String _qualifierFormatForBooleanExpression;
    private EOQualifier _qualifier;

    public ERXBooleanExpressionParser(String expression) {
        this.expression = expression;
    }

    public boolean evaluateWithObject(NSKeyValueCodingAdditions valueProvider) {
        return this.qualifier().evaluateWithObject((Object)valueProvider);
    }

    private String qualifierFormatForBooleanExpression() {
        if (this._qualifierFormatForBooleanExpression == null) {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = KEYPATH_TOKEN_PATTERN.matcher(this.expression);
            while (matcher.find()) {
                String token = matcher.group();
                if (this.isBooleanWordToken(token)) continue;
                String replacement = "(" + matcher.group() + " = 'true')";
                matcher.appendReplacement(sb, replacement);
            }
            matcher.appendTail(sb);
            this._qualifierFormatForBooleanExpression = sb.toString();
        }
        return this._qualifierFormatForBooleanExpression;
    }

    public EOQualifier qualifier() {
        if (this._qualifier == null) {
            this._qualifier = EOQualifier.qualifierWithQualifierFormat((String)this.qualifierFormatForBooleanExpression(), null);
        }
        return this._qualifier;
    }

    private boolean isBooleanWordToken(String token) {
        token = token.toUpperCase();
        for (int i = 0; i < BOOLEAN_WORDS.length; ++i) {
            if (!BOOLEAN_WORDS[i].equals(token)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.expression;
    }

    public String toDebugString() {
        StringBuilder b = new StringBuilder();
        b.append("Expression: ").append(this.expression);
        b.append("qualifier format: ").append(this.qualifierFormatForBooleanExpression());
        b.append("EOQualifier: ").append(this.qualifier());
        return b.toString();
    }
}

