/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.extensions.appserver.ERXApplication;
import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXRetainer;
import er.extensions.foundation.ERXUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXFileNotificationCenter {
    public static final Logger log = Logger.getLogger(ERXFileNotificationCenter.class);
    public static final String FileDidChange = "FileDidChange";
    private static ERXFileNotificationCenter _defaultCenter;
    private NSMutableDictionary _observersByFilePath = new NSMutableDictionary();
    private NSMutableDictionary _lastModifiedByFilePath = new NSMutableDictionary();
    private boolean developmentMode;
    private long lastCheckMillis = System.currentTimeMillis();
    private boolean symlinkSupport;

    public static ERXFileNotificationCenter defaultCenter() {
        if (_defaultCenter == null) {
            _defaultCenter = new ERXFileNotificationCenter();
        }
        return _defaultCenter;
    }

    private static int checkFilesPeriod() {
        return ERXProperties.intForKeyWithDefault("er.extensions.ERXFileNotificationCenter.CheckFilesPeriod", 0);
    }

    public ERXFileNotificationCenter() {
        this.developmentMode = ERXApplication.isDevelopmentModeSafe();
        if (this.developmentMode || ERXFileNotificationCenter.checkFilesPeriod() > 0) {
            ERXRetainer.retain(this);
            log.debug((Object)"Caching disabled.  Registering for notification: ApplicationWillDispatchRequestNotification");
            NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("checkIfFilesHaveChanged", ERXConstant.NotificationClassArray), "ApplicationWillDispatchRequestNotification", null);
        }
        this.symlinkSupport = Boolean.valueOf(System.getProperty("ERXFileNotificationCenter.symlinkSupport", "true"));
    }

    public void finalize() throws Throwable {
        NSNotificationCenter.defaultCenter().removeObserver((Object)this);
        super.finalize();
    }

    public void addObserver(Object observer, NSSelector selector, String filePath) {
        if (filePath == null) {
            throw new RuntimeException("Attempting to register observer for null filePath.");
        }
        this.addObserver(observer, selector, new File(filePath));
    }

    public void addObserver(Object observer, NSSelector selector, File file) {
        if (file == null) {
            throw new RuntimeException("Attempting to register a null file. " + (file != null ? " File path: " + file.getAbsolutePath() : null));
        }
        if (observer == null) {
            throw new RuntimeException("Attempting to register null observer for file: " + file);
        }
        if (selector == null) {
            throw new RuntimeException("Attempting to register null selector for file: " + file);
        }
        if (!this.developmentMode && ERXFileNotificationCenter.checkFilesPeriod() == 0) {
            log.info((Object)("Registering an observer when file checking is disabled (WOCaching must be disabled or the er.extensions.ERXFileNotificationCenter.CheckFilesPeriod property must be set).  This observer will not ever by default be called: " + file));
        }
        String filePath = this.cacheKeyForFile(file);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering Observer for file at path: " + filePath));
        }
        this.registerLastModifiedDateForFile(file);
        NSMutableSet<_ObserverSelectorHolder> observerSet = (NSMutableSet<_ObserverSelectorHolder>)this._observersByFilePath.objectForKey(filePath);
        if (observerSet == null) {
            observerSet = new NSMutableSet<_ObserverSelectorHolder>();
            this._observersByFilePath.setObjectForKey(observerSet, filePath);
        }
        observerSet.addObject(new _ObserverSelectorHolder(observer, selector));
    }

    protected String cacheKeyForFile(File file) {
        return file.getAbsolutePath();
    }

    protected Object cacheValueForFile(File file) {
        if (this.symlinkSupport) {
            try {
                File canonicalizedFile = file.getCanonicalFile();
                return canonicalizedFile.getPath() + ":" + Long.valueOf(canonicalizedFile.lastModified());
            }
            catch (IOException e) {
                log.warn((Object)("Failed to determine the lastModified time on '" + file + "': " + e.getMessage()));
                return 0L;
            }
        }
        return file.lastModified();
    }

    public void registerLastModifiedDateForFile(File file) {
        if (file != null) {
            this._lastModifiedByFilePath.setObjectForKey(this.cacheValueForFile(file), this.cacheKeyForFile(file));
        }
    }

    public boolean hasFileChanged(File file) {
        if (file == null) {
            throw new RuntimeException("Attempting to check if a null file has been changed");
        }
        Object previousCacheValue = this._lastModifiedByFilePath.objectForKey(this.cacheKeyForFile(file));
        return previousCacheValue == null || !previousCacheValue.equals(this.cacheValueForFile(file));
    }

    protected void fileHasChanged(File file) {
        NSMutableSet observers = (NSMutableSet)this._observersByFilePath.objectForKey(this.cacheKeyForFile(file));
        if (observers == null) {
            log.warn((Object)("Unable to find observers for file: " + file));
        } else {
            NSNotification notification = new NSNotification(FileDidChange, (Object)file);
            Enumeration e = observers.objectEnumerator();
            while (e.hasMoreElements()) {
                _ObserverSelectorHolder holder = (_ObserverSelectorHolder)e.nextElement();
                try {
                    holder.selector.invoke(holder.observer, (Object)notification);
                }
                catch (Exception ex) {
                    log.error((Object)("Catching exception when invoking method on observer: " + ex.toString() + " - " + ERXUtilities.stackTrace(ex)));
                }
            }
            this.registerLastModifiedDateForFile(file);
        }
    }

    public void checkIfFilesHaveChanged(NSNotification n) {
        int checkPeriod = ERXFileNotificationCenter.checkFilesPeriod();
        if (!(this.developmentMode || checkPeriod != 0 && System.currentTimeMillis() - this.lastCheckMillis >= (long)(1000 * checkPeriod))) {
            return;
        }
        this.lastCheckMillis = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Checking if files have changed");
        }
        Enumeration e = this._lastModifiedByFilePath.keyEnumerator();
        while (e.hasMoreElements()) {
            File file = new File((String)e.nextElement());
            if (!file.exists() || !this.hasFileChanged(file)) continue;
            this.fileHasChanged(file);
        }
    }

    public static class _ObserverSelectorHolder {
        public Object observer;
        public NSSelector selector;

        public _ObserverSelectorHolder(Object obs, NSSelector sel) {
            this.observer = obs;
            this.selector = sel;
        }

        public int hashCode() {
            return (this.observer == null ? 1 : this.observer.hashCode()) * (this.selector == null ? 1 : this.selector.hashCode());
        }

        public boolean equals(Object osh) {
            return osh != null && osh instanceof _ObserverSelectorHolder && ((_ObserverSelectorHolder)osh).selector.equals((Object)this.selector) && ((_ObserverSelectorHolder)osh).observer.equals(this.observer);
        }
    }
}

