/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.appserver.WOApplication;
import com.webobjects.eoaccess.EOAdaptorOperation;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EODatabaseOperation;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import er.extensions.appserver.ERXMessageEncoding;
import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXFuzzyMatchCleaner;
import er.extensions.foundation.ERXSimpleTemplateParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.MalformedInputException;
import java.text.Format;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXStringUtilities {
    private static final String DEFAULT_TARGET_DISPLAY_LANGUAGE = "English";
    public static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String _DISTANCE = "distance";
    public static final NSArray SORT_ASCENDING = new NSArray<Object>(new Object[]{new EOSortOrdering("distance", EOSortOrdering.CompareAscending)});
    public static final NSArray SORT_DESCENDING = new NSArray<Object>(new Object[]{new EOSortOrdering("distance", EOSortOrdering.CompareDescending)});
    public static final String SpecialRegexCharacters = ".*[]{}()?\\+%$!^";
    private static NSArray _defaultTargetDisplayLanguages = new NSArray<String>("English");
    protected static double adjustement = 0.5;
    private static Logger log = Logger.getLogger(ERXStringUtilities.class);
    public static final NSDictionary XML_UNESCAPES;
    public static final NSDictionary ISO_UNESCAPES;
    public static final NSDictionary SYMBOL_UNESCAPES;
    public static final NSDictionary HTML_SAFE_UNESCAPES;
    public static final NSDictionary HTML_UNESCAPES;

    public static double distance(String a, String b) {
        int i;
        int n = a.length();
        int m = b.length();
        int[][] c = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            c[i][0] = i;
        }
        for (int j = 0; j <= m; ++j) {
            c[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                int x = c[i - 1][j] + 1;
                int y = c[i][j - 1] + 1;
                int z = 0;
                z = a.charAt(i - 1) == b.charAt(j - 1) ? c[i - 1][j - 1] : c[i - 1][j - 1] + 1;
                int temp = Math.min(x, y);
                c[i][j] = Math.min(z, temp);
            }
        }
        return c[n][m];
    }

    public static void setAdjustement(double newAdjustement) {
        adjustement = newAdjustement;
    }

    public static NSArray fuzzyMatch(String name, String entityName, String propertyKey, String synonymsKey, EOEditingContext ec, ERXFuzzyMatchCleaner cleaner, NSArray sortOrderings) {
        String eoKey = "eo";
        NSMutableArray results = new NSMutableArray();
        EOFetchSpecification fs = new EOFetchSpecification(entityName, null, null);
        fs.setFetchesRawRows(true);
        NSArray pks = EOUtilities.entityNamed((EOEditingContext)ec, (String)entityName).primaryKeyAttributeNames();
        NSMutableArray<String> keyPaths = new NSMutableArray<String>(pks);
        keyPaths.addObject(propertyKey);
        if (synonymsKey != null) {
            keyPaths.addObject(synonymsKey);
        }
        fs.setRawRowKeyPaths(keyPaths);
        NSArray rawRows = ec.objectsWithFetchSpecification(fs);
        if (name == null) {
            name = "";
        }
        name = name.toUpperCase();
        String cleanedName = cleaner.cleanStringForFuzzyMatching(name);
        Enumeration e = rawRows.objectEnumerator();
        block0: while (e.hasMoreElements()) {
            Object synonymsString;
            NSMutableDictionary<String, Double> dico = ((NSDictionary)e.nextElement()).mutableClone();
            Object value = dico.valueForKey(propertyKey);
            boolean trySynonyms = true;
            if (value != null && value instanceof String) {
                String comparedString = ((String)value).toUpperCase();
                String cleanedComparedString = cleaner.cleanStringForFuzzyMatching(comparedString);
                if (ERXStringUtilities.distance(name, comparedString) <= Math.min((double)name.length(), (double)comparedString.length()) * adjustement || ERXStringUtilities.distance(cleanedName, cleanedComparedString) <= Math.min((double)cleanedName.length(), (double)cleanedComparedString.length()) * adjustement) {
                    dico.setObjectForKey(new Double(ERXStringUtilities.distance(name, comparedString)), _DISTANCE);
                    NSDictionary pkValues = new NSDictionary(dico.objectsForKeys(pks, (Double)NSKeyValueCoding.NullValue), pks);
                    dico.setObjectForKey((Double)EOUtilities.faultWithPrimaryKey((EOEditingContext)ec, (String)entityName, pkValues), eoKey);
                    results.addObject(dico);
                    trySynonyms = false;
                }
            }
            if (!trySynonyms || synonymsKey == null || (synonymsString = dico.valueForKey(synonymsKey)) == null || !(synonymsString instanceof String)) continue;
            Object plist = NSPropertyListSerialization.propertyListFromString((String)((String)synonymsString));
            Vector v = (Vector)plist;
            for (int i = 0; i < v.size(); ++i) {
                String comparedString = ((String)v.elementAt(i)).toUpperCase();
                if (!(ERXStringUtilities.distance(name, comparedString) <= Math.min((double)name.length(), (double)comparedString.length()) * adjustement) && !(ERXStringUtilities.distance(cleanedName, comparedString) <= Math.min((double)cleanedName.length(), (double)comparedString.length()) * adjustement)) continue;
                dico.setObjectForKey(new Double(ERXStringUtilities.distance(name, comparedString)), _DISTANCE);
                NSDictionary pkValues = new NSDictionary(dico.objectsForKeys(pks, (Double)NSKeyValueCoding.NullValue), pks);
                dico.setObjectForKey((Double)EOUtilities.faultWithPrimaryKey((EOEditingContext)ec, (String)entityName, pkValues), eoKey);
                results.addObject(dico);
                continue block0;
            }
        }
        if (sortOrderings != null) {
            results = (NSMutableArray)EOSortOrdering.sortedArrayUsingKeyOrderArray(results, (NSArray)sortOrderings);
        }
        return (NSArray)results.valueForKey(eoKey);
    }

    public static NSArray fuzzyMatch(String name, String entityName, String propertyKey, String synonymsKey, EOEditingContext ec, ERXFuzzyMatchCleaner cleaner, String comparisonString) {
        NSArray sortOrderings = null;
        if ("asc".equals(comparisonString)) {
            sortOrderings = SORT_ASCENDING;
        } else if ("desc".equals(comparisonString)) {
            sortOrderings = SORT_DESCENDING;
        }
        return ERXStringUtilities.fuzzyMatch(name, entityName, propertyKey, synonymsKey, ec, cleaner, sortOrderings);
    }

    public static String localizedStringForKey(String key) {
        return ERXStringUtilities.localizedStringForKey(key, null, null);
    }

    public static String localizedStringForKey(String key, String framework) {
        return ERXStringUtilities.localizedStringForKey(key, framework, null);
    }

    public static String localizedStringForKey(String key, String framework, NSArray languages) {
        languages = languages != null && languages.count() > 0 ? languages : _defaultTargetDisplayLanguages;
        String result = WOApplication.application().resourceManager().stringForKey(key, "Localizable", key, framework, languages);
        return result;
    }

    public static String localizedTemplateStringWithObjectForKey(Object o, String key, String framework, NSArray languages) {
        String template = ERXStringUtilities.localizedStringForKey(key, framework, languages);
        return ERXSimpleTemplateParser.sharedInstance().parseTemplateWithObject(template, null, o);
    }

    public static String stringWithContentsOfFile(File file) {
        try {
            if (file != null) {
                return ERXFileUtilities.stringFromFile(file);
            }
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public static String stringWithContentsOfFile(String path) {
        if (path != null) {
            return ERXStringUtilities.stringWithContentsOfFile(new File(path));
        }
        return null;
    }

    public static Integer integerWithString(String s) {
        try {
            return ERXConstant.integerForString(s);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String stringFromResource(String name, String extension, NSBundle bundle) {
        String path = null;
        if (bundle == null) {
            bundle = NSBundle.mainBundle();
        }
        if ((path = bundle.resourcePathForLocalizedResourceNamed(name + (extension == null || extension.length() == 0 ? "" : "." + extension), null)) != null) {
            try {
                InputStream stream = bundle.inputStreamForResourcePath(path);
                byte[] bytes = ERXFileUtilities.bytesFromInputStream(stream);
                return new String(bytes);
            }
            catch (IOException e) {
                log.warn((Object)("IOException when stringFromResource(" + name + "." + extension + " in bundle " + bundle.name()));
            }
        }
        return null;
    }

    public static final String firstPropertyKeyInKeyPath(String keyPath) {
        String part = null;
        if (keyPath != null) {
            int index = keyPath.indexOf(".");
            part = index != -1 ? keyPath.substring(0, index) : keyPath;
        }
        return part;
    }

    public static final String lastPropertyKeyInKeyPath(String keyPath) {
        String part = null;
        if (keyPath != null) {
            int index = keyPath.lastIndexOf(".");
            part = index != -1 ? keyPath.substring(index + 1) : keyPath;
        }
        return part;
    }

    public static final String keyPathWithoutLastProperty(String keyPath) {
        int index;
        String part = null;
        if (keyPath != null && (index = keyPath.lastIndexOf(".")) != -1) {
            part = keyPath.substring(0, index);
        }
        return part;
    }

    public static final String keyPathWithoutFirstProperty(String keyPath) {
        int index;
        String part = null;
        if (keyPath != null && (index = keyPath.indexOf(".")) != -1) {
            part = keyPath.substring(index + 1);
        }
        return part;
    }

    public static String displayNameForKey(String key) {
        StringBuffer finalString = null;
        if (!ERXStringUtilities.stringIsNullOrEmpty(key) && !key.trim().equals("")) {
            finalString = new StringBuffer();
            String lastHop = key.indexOf(".") == -1 ? key : (key.endsWith(".") ? "" : key.substring(key.lastIndexOf(".") + 1));
            StringBuffer tempString = new StringBuffer();
            char[] originalArray = lastHop.toCharArray();
            originalArray[0] = Character.toUpperCase(originalArray[0]);
            Character tempChar = null;
            Character nextChar = null;
            for (int i = 0; i < originalArray.length - 1; ++i) {
                tempChar = new Character(originalArray[i]);
                nextChar = new Character(originalArray[i + 1]);
                if (Character.isUpperCase(originalArray[i]) && Character.isLowerCase(originalArray[i + 1])) {
                    finalString.append(tempString.toString());
                    if (i > 0) {
                        finalString.append(' ');
                    }
                    tempString = new StringBuffer();
                }
                tempString.append(tempChar.toString());
            }
            finalString.append(tempString.toString());
            finalString.append(nextChar);
        }
        return finalString == null ? "" : finalString.toString();
    }

    public static int indexOfNumericInString(String str) {
        return ERXStringUtilities.indexOfNumericInString(str, 0);
    }

    public static int indexOfNumericInString(String str, int fromIndex) {
        if (str == null) {
            throw new IllegalArgumentException("String cannot be null.");
        }
        int pos = -1;
        for (int i = fromIndex; i < str.length(); ++i) {
            char c = str.charAt(i);
            if ('0' > c || c > '9') continue;
            pos = i;
            break;
        }
        return pos;
    }

    public static void appendSeparatorIfLastNot(char separator, char not, StringBuffer sb) {
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) != not) {
            sb.append(separator);
        }
    }

    public static String replaceStringByStringInString(String old, String newString, String buffer) {
        int oldLength = old.length();
        int length = buffer.length();
        StringBuffer convertedString = new StringBuffer(length + 100);
        int begin = 0;
        while (begin < length) {
            int end = buffer.indexOf(old, begin);
            if (end == -1) {
                convertedString.append(buffer.substring(begin));
                break;
            }
            if (end == 0) {
                convertedString.append(newString);
            } else {
                convertedString.append(buffer.substring(begin, end));
                convertedString.append(newString);
            }
            begin = end + oldLength;
        }
        return convertedString.toString();
    }

    public static String stringByReplacingFirstOccurrenceOfStringWithString(String sourceString, String stringToReplace, String replacementString) {
        String result;
        int indexOfMatch = sourceString.indexOf(stringToReplace);
        if (indexOfMatch >= 0) {
            int sourceStringLength = sourceString.length();
            int stringToReplaceLength = stringToReplace.length();
            int replacementStringLength = replacementString.length();
            StringBuffer buffer = new StringBuffer(sourceStringLength - stringToReplaceLength + replacementStringLength);
            buffer.append(sourceString.substring(0, indexOfMatch));
            buffer.append(replacementString);
            buffer.append(sourceString.substring(indexOfMatch + stringToReplaceLength, sourceStringLength));
            result = buffer.toString();
        } else {
            result = sourceString;
        }
        return result;
    }

    public static String escapeSpace(String aString) {
        NSArray<String> parts = NSArray.componentsSeparatedByString(aString, " ");
        return parts.componentsJoinedByString("");
    }

    public static String toLowerCase(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        int different = -1;
        for (int i = len - 1; i >= 0; --i) {
            char ch = str.charAt(i);
            if (Character.toLowerCase(ch) == ch) continue;
            different = i;
            break;
        }
        if (different == -1) {
            return str;
        }
        char[] chars = new char[len];
        str.getChars(0, len, chars, 0);
        for (int j = different; j >= 0; --j) {
            chars[j] = Character.toLowerCase(chars[j]);
        }
        return new String(chars);
    }

    public static String stringWithNtimesString(int n, String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static int numberOfOccurrencesOfCharInString(char c, String s) {
        int result = 0;
        if (s != null) {
            int i = 0;
            while (i < s.length()) {
                if (s.charAt(i++) != c) continue;
                ++result;
            }
        }
        return result;
    }

    public static boolean stringIsNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String nullForEmptyString(String s) {
        return s == null ? null : (s.length() == 0 ? null : s);
    }

    public static String emptyStringForNull(String s) {
        return s == null ? "" : s;
    }

    public static String escapeNonXMLChars(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(str.length());
        block6: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String unescapeEntities(String string, Map<String, String> map) {
        if (string != null) {
            StringBuilder result = new StringBuilder();
            int len = string.length();
            block0: for (int start = 0; start < len; ++start) {
                char c1 = string.charAt(start);
                if (c1 == '&') {
                    StringBuilder entity = new StringBuilder();
                    for (int end = start + 1; end < len; ++end) {
                        char c2 = string.charAt(end);
                        if (c2 == ';') {
                            String key = entity.toString();
                            String replacement = map.get(key);
                            if (replacement == null) {
                                replacement = map.get(key.toUpperCase());
                            }
                            if (replacement == null) {
                                replacement = "&" + key + ";";
                            }
                            result.append(replacement);
                            start = end;
                            continue block0;
                        }
                        entity.append(c2);
                    }
                    continue;
                }
                result.append(c1);
            }
            string = result.toString();
        }
        return string;
    }

    public static String escapePCData(String pcdata) {
        if (pcdata == null) {
            return null;
        }
        int start = 0;
        int end = 0;
        String close = "]]>";
        String escape = "]]]]><![CDATA[>";
        StringBuffer sb = new StringBuffer("<![CDATA[");
        do {
            sb.append(pcdata.substring(start, (end = pcdata.indexOf(close, start)) == -1 ? pcdata.length() : end));
            if (end != -1) {
                sb.append(escape);
            }
            start = end;
            start += 3;
        } while (end != -1);
        sb.append(close);
        return sb.toString();
    }

    public static String escapeNonBasicLatinChars(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        if (block != null && Character.UnicodeBlock.BASIC_LATIN.equals(block)) {
            return String.valueOf(c);
        }
        return ERXStringUtilities.toHexString(c);
    }

    public static String escapeNonBasicLatinChars(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            result.append(ERXStringUtilities.escapeNonBasicLatinChars(str.charAt(i)));
        }
        return result.toString();
    }

    public static String escapeJavascriptApostrophes(String sourceString) {
        return ERXStringUtilities.escape(new char[]{'\''}, '\\', sourceString);
    }

    public static String escape(char[] _escapeChars, char _escapeWith, String _sourceString) {
        String targetString;
        if (_sourceString == null) {
            targetString = null;
        } else {
            StringBuffer targetBuffer = null;
            int lastMatch = 0;
            int length = _sourceString.length();
            for (int sourceIndex = 0; sourceIndex < length; ++sourceIndex) {
                char ch = _sourceString.charAt(sourceIndex);
                boolean escape = false;
                for (int escapeNum = 0; !escape && escapeNum < _escapeChars.length; ++escapeNum) {
                    if (ch != _escapeChars[escapeNum]) continue;
                    escape = true;
                }
                if (!escape) continue;
                if (targetBuffer == null) {
                    targetBuffer = new StringBuffer(length + 100);
                }
                if (sourceIndex - lastMatch > 0) {
                    targetBuffer.append(_sourceString.substring(lastMatch, sourceIndex));
                }
                targetBuffer.append(_escapeWith);
                lastMatch = sourceIndex;
            }
            if (targetBuffer == null) {
                targetString = _sourceString;
            } else {
                targetBuffer.append(_sourceString.substring(lastMatch, length));
                targetString = targetBuffer.toString();
            }
        }
        return targetString;
    }

    public static String toHexString(char c) {
        StringBuffer result = new StringBuffer("\\u9999".length());
        String u = Long.toHexString(c).toUpperCase();
        switch (u.length()) {
            case 1: {
                result.append("\\u000");
                break;
            }
            case 2: {
                result.append("\\u00");
                break;
            }
            case 3: {
                result.append("\\u0");
                break;
            }
            default: {
                result.append("\\u");
            }
        }
        result.append(u);
        return result.toString();
    }

    public static String toHexString(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer result = new StringBuffer("\\u9999".length() * str.length());
        for (int i = 0; i < str.length(); ++i) {
            result.append(ERXStringUtilities.toHexString(str.charAt(i)));
        }
        return result.toString();
    }

    public static String byteArrayToHexString(byte[] block) {
        int len = block.length;
        StringBuffer buf = new StringBuffer(2 * len);
        for (int i = 0; i < len; ++i) {
            int high = (block[i] & 0xF0) >> 4;
            int low = block[i] & 0xF;
            buf.append(HEX_CHARS[high]);
            buf.append(HEX_CHARS[low]);
        }
        return buf.toString();
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int length = hexString.length();
        if (length % 2 == 1) {
            throw new IllegalArgumentException("String must have even length: " + length);
        }
        byte[] array = new byte[length / 2];
        for (int i = 0; i < array.length; ++i) {
            char c1 = hexString.charAt(i * 2);
            char c2 = hexString.charAt(i * 2 + 1);
            int b = 0;
            if (c1 >= '0' && c1 <= '9') {
                b = (byte)(b + (c1 - 48) * 16);
            } else if (c1 >= 'a' && c1 <= 'f') {
                b = (byte)(b + (c1 - 97 + 10) * 16);
            } else if (c1 >= 'A' && c1 <= 'F') {
                b = (byte)(b + (c1 - 65 + 10) * 16);
            } else {
                throw new IllegalArgumentException("Illegal Character: '" + c1 + "' in " + hexString);
            }
            if (c2 >= '0' && c2 <= '9') {
                b = (byte)(b + (c2 - 48));
            } else if (c2 >= 'a' && c2 <= 'f') {
                b = (byte)(b + (c2 - 97 + 10));
            } else if (c2 >= 'A' && c2 <= 'F') {
                b = (byte)(b + (c2 - 65 + 10));
            } else {
                throw new IllegalArgumentException("Illegal Character: '" + c2 + "' in " + hexString);
            }
            array[i] = b;
        }
        return array;
    }

    public static String removeExtraDotsFromVersionString(String version) {
        int floatingPointIndex = version.indexOf(".");
        if (floatingPointIndex >= 0 && floatingPointIndex + 1 < version.length()) {
            String minorVersion = ERXStringUtilities.replaceStringByStringInString(".", "", version.substring(floatingPointIndex + 1));
            version = version.substring(0, floatingPointIndex + 1) + minorVersion;
        }
        return version;
    }

    public static String capitalize(String value) {
        String capital = null;
        if (value != null && value.length() > 0) {
            StringBuffer buffer = new StringBuffer(value);
            buffer.setCharAt(0, Character.toUpperCase(value.charAt(0)));
            capital = buffer.toString();
        }
        return capital != null ? capital : value;
    }

    public static String uncapitalize(String value) {
        int length;
        String capital = null;
        if (value != null && (length = value.length()) > 0) {
            StringBuffer buffer = new StringBuffer(value);
            for (int i = 0; i < length; ++i) {
                char ch = value.charAt(i);
                if (i != 0 && i != length - 1 && (i >= length - 1 || !Character.isUpperCase(value.charAt(i + 1)))) break;
                buffer.setCharAt(i, Character.toLowerCase(ch));
            }
            capital = buffer.toString();
        }
        return capital != null ? capital : value;
    }

    public static String capitalizeAllWords(String value) {
        String capitalize = null;
        if (value != null && value.length() > 0) {
            StringBuffer buffer = new StringBuffer();
            boolean first = true;
            StringTokenizer tokenizer = new StringTokenizer(value);
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                if (!first) {
                    buffer.append(' ');
                } else {
                    first = false;
                }
                buffer.append(ERXStringUtilities.capitalize(token));
            }
            capitalize = buffer.toString();
        }
        return capitalize != null ? capitalize : value;
    }

    public static String underscoreToCamelCase(String underscoreString, boolean capitalize) {
        StringBuffer camelCase = new StringBuffer();
        String[] underscoreStrings = underscoreString.split("_");
        for (int i = 0; i < underscoreStrings.length; ++i) {
            String word = i > 0 || capitalize ? ERXStringUtilities.capitalize(underscoreStrings[i]) : underscoreStrings[i];
            camelCase.append(word);
        }
        return camelCase.toString();
    }

    public static String camelCaseToUnderscore(String camelString, boolean lowercase) {
        StringBuffer underscore = new StringBuffer();
        boolean lastCharacterWasWordBreak = false;
        boolean lastCharacterWasCapital = false;
        int length = camelString.length();
        for (int i = 0; i < length; ++i) {
            char ch = camelString.charAt(i);
            if (Character.isUpperCase(ch)) {
                boolean nextCharacterIsCapital;
                boolean isLastCharacter = i == length - 1;
                boolean bl = nextCharacterIsCapital = !isLastCharacter && Character.isUpperCase(camelString.charAt(i + 1));
                if (i > 0 && (!lastCharacterWasWordBreak && !lastCharacterWasCapital || !nextCharacterIsCapital && !isLastCharacter)) {
                    underscore.append("_");
                    lastCharacterWasWordBreak = true;
                } else {
                    lastCharacterWasWordBreak = false;
                }
                lastCharacterWasCapital = true;
            } else if (ch == '_') {
                lastCharacterWasWordBreak = true;
                lastCharacterWasCapital = false;
            } else {
                lastCharacterWasWordBreak = false;
                lastCharacterWasCapital = false;
            }
            if (lowercase) {
                underscore.append(Character.toLowerCase(ch));
                continue;
            }
            underscore.append(ch);
        }
        return underscore.toString();
    }

    public static boolean stringEqualsString(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 != null && s2 != null && s1.equals(s2)) {
            return true;
        }
        return s1 == null && s2 == null;
    }

    public static boolean caseInsensitiveStartsWith(String stringToSearch, String prefix) {
        return ERXStringUtilities.caseInsensitiveStartsWith(stringToSearch, prefix, 0);
    }

    public static boolean caseInsensitiveStartsWith(String stringToSearch, String prefix, int toffset) {
        boolean result = false;
        int stringToSearchLength = stringToSearch.length();
        int prefixLength = prefix.length();
        if (toffset + prefixLength <= stringToSearchLength) {
            String slice = stringToSearch.substring(toffset, toffset + prefixLength);
            result = ERXStringUtilities.toLowerCase(slice).equals(ERXStringUtilities.toLowerCase(prefix));
        }
        return result;
    }

    public static String stringByTruncatingStringToByteLengthInEncoding(String inputString, int byteLength, String encoding) {
        byte[] bytes;
        String result = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("stringByTruncatingStringToByteLengthInEncoding: encoding='" + encoding + "', byteLength=" + byteLength + ", inputString='" + inputString + "'"));
        }
        if (inputString != null && (bytes = ERXStringUtilities.toBytes(inputString, encoding)) != null) {
            if (bytes.length > byteLength) {
                if ("UTF-8".equals(encoding) || "UTF8".equals(encoding)) {
                    if (byteLength >= 1) {
                        int index;
                        for (index = byteLength - 1; index >= 0 && (bytes[index + 1] & 0xC0) == 128; --index) {
                        }
                        if (index > 0) {
                            try {
                                result = new String(bytes, 0, index + 1, encoding);
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new RuntimeException("Got " + e.getClass() + " exception.  byteLength=" + byteLength + ", encoding='" + encoding + "', inputString='" + inputString + "'.", e);
                            }
                        }
                    }
                    result = result != null ? result : "";
                } else {
                    Charset charset = Charset.forName(encoding);
                    CharsetDecoder decoder = charset.newDecoder();
                    ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
                    int currentLength = byteLength;
                    CharBuffer charBuffer = null;
                    do {
                        byteBuffer.position(0);
                        byteBuffer.limit(currentLength);
                        try {
                            charBuffer = decoder.reset().decode(byteBuffer);
                        }
                        catch (MalformedInputException e) {
                            --currentLength;
                        }
                        catch (CharacterCodingException e) {
                            log.error((Object)("Got " + e.getClass() + " exception. byteLength=" + byteLength + ", encoding='" + encoding + "', inputString='" + inputString + "'."), (Throwable)e);
                            break;
                        }
                    } while (charBuffer == null && currentLength > 0);
                    result = charBuffer != null ? charBuffer.toString() : "";
                }
            } else {
                result = inputString;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("stringByTruncatingStringToByteLengthInEncoding: result='" + result + "'"));
        }
        return result;
    }

    public static boolean isDigitsOnly(String aString) {
        int i = aString.length();
        while (i-- > 0) {
            char c = aString.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLettersOnly(String aString) {
        int i = aString.length();
        while (i-- > 0) {
            char c = aString.charAt(i);
            if (Character.isLetter(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean stringContainsSpecialRegexCharacters(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (SpecialRegexCharacters.indexOf(s.charAt(i)) <= -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringFromURL(URL url) throws IOException {
        String string;
        InputStream is = url.openStream();
        try {
            string = ERXStringUtilities.stringFromInputStream(is);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            is.close();
            throw throwable;
        }
        is.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringFromURL(URL url, String encoding) throws IOException {
        String string;
        InputStream is = url.openStream();
        try {
            string = ERXStringUtilities.stringFromInputStream(is, encoding);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            is.close();
            throw throwable;
        }
        is.close();
        return string;
    }

    public static String stringFromInputStream(InputStream in) throws IOException {
        return new String(ERXFileUtilities.bytesFromInputStream(in));
    }

    public static String stringFromInputStream(InputStream in, String encoding) throws IOException {
        return new String(ERXFileUtilities.bytesFromInputStream(in), encoding);
    }

    public static String toString(Object[] array, String separator) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            Object o = array[i];
            buf.append(o.toString());
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String dumpObject(Object object) {
        StringBuffer sb = new StringBuffer(4000);
        ERXStringUtilities.dumpObject(sb, object, 0);
        return sb.toString();
    }

    public static boolean containsAnyCharacter(String source, String characters) {
        int i = source.length();
        while (i-- > 0) {
            char c = source.charAt(i);
            if (characters.indexOf(c) <= -1) continue;
            return true;
        }
        return false;
    }

    public static String removeExceptCharacters(String source, String characters) {
        StringBuffer buf = new StringBuffer();
        int l = source.length();
        for (int i = 0; i < l; ++i) {
            char c = source.charAt(i);
            if (characters.indexOf(c) <= -1) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static String removeCharacters(String source, String characters) {
        StringBuffer buf = new StringBuffer();
        int l = source.length();
        for (int i = 0; i < l; ++i) {
            char c = source.charAt(i);
            if (characters.indexOf(c) != -1) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static boolean quicksilverContains(String _str, String _searchString) {
        boolean equals;
        if (_str == null) {
            equals = false;
        } else {
            equals = true;
            if (_searchString != null && _searchString.length() > 0) {
                int searchStringLength = _searchString.length();
                int strLength = _str.length();
                int strPos = 0;
                for (int searchStringPos = 0; equals && searchStringPos < searchStringLength; ++searchStringPos) {
                    char searchStringCh = Character.toLowerCase(_searchString.charAt(searchStringPos));
                    boolean searchStringChFound = false;
                    while (!searchStringChFound && strPos < strLength) {
                        char strCh = _str.charAt(strPos);
                        searchStringChFound = Character.toLowerCase(strCh) == searchStringCh;
                        ++strPos;
                    }
                    if (searchStringChFound) continue;
                    equals = false;
                }
            }
        }
        return equals;
    }

    public static byte[] md5(String str, String encoding) {
        byte[] bytes;
        if (str == null) {
            bytes = new byte[]{};
        } else {
            try {
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                bytes = ERXFileUtilities.md5(new ByteArrayInputStream(str.getBytes(encoding)));
            }
            catch (UnsupportedEncodingException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            catch (IOException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        }
        return bytes;
    }

    public static String md5Hex(String str, String encoding) {
        String hexStr = str == null ? null : ERXStringUtilities.byteArrayToHexString(ERXStringUtilities.md5(str, encoding));
        return hexStr;
    }

    public static String matchCase(String originalString, String newString) {
        int length;
        String matchedCase = newString;
        if (matchedCase != null && (length = originalString.length()) > 0) {
            boolean uppercase = true;
            boolean lowercase = true;
            boolean capitalize = true;
            for (int i = 0; i < length; ++i) {
                char ch = originalString.charAt(i);
                if (Character.isUpperCase(ch)) {
                    lowercase = false;
                    if (i <= 0) continue;
                    capitalize = false;
                    continue;
                }
                uppercase = false;
                if (i != 0) continue;
                capitalize = false;
            }
            if (capitalize) {
                matchedCase = ERXStringUtilities.capitalize(newString);
            } else if (uppercase) {
                matchedCase = newString.toUpperCase();
            } else if (lowercase) {
                matchedCase = newString.toLowerCase();
            }
        }
        return matchedCase;
    }

    public static void indent(PrintWriter writer, int level) {
        for (int i = 0; i < level; ++i) {
            writer.append("  ");
        }
    }

    public static void indent(StringBuffer sb, int level) {
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
    }

    private static void dumpArray(StringBuffer sb, NSArray array, int level) {
        sb.append("(\n");
        Enumeration e = array.objectEnumerator();
        while (e.hasMoreElements()) {
            Object value = e.nextElement();
            ERXStringUtilities.dumpObject(sb, value, level + 1);
            sb.append(",\n");
        }
        ERXStringUtilities.indent(sb, level);
        sb.append(")");
    }

    private static void dumpDictionary(StringBuffer sb, NSDictionary dict, int level) {
        sb.append("{\n");
        Enumeration e = dict.keyEnumerator();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = dict.objectForKey(key);
            ERXStringUtilities.indent(sb, level + 1);
            sb.append(key).append(" = ");
            ERXStringUtilities.dumpObject(sb, value, level + 1);
            sb.append(";\n");
        }
        ERXStringUtilities.indent(sb, level);
        sb.append("}");
    }

    private static NSDictionary databaseOperationAsDictionary(EODatabaseOperation op) {
        NSMutableDictionary<String, Object> dict = new NSMutableDictionary<String, Object>(8);
        int operator = op.databaseOperator();
        if (operator == 0) {
            dict.setObjectForKey("EODatabaseNothingOperator", "_databaseOperator");
        } else if (operator == 1) {
            dict.setObjectForKey("EODatabaseInsertOperator", "_databaseOperator");
        } else if (operator == 3) {
            dict.setObjectForKey("EODatabaseDeleteOperator", "_databaseOperator");
        } else if (operator == 2) {
            dict.setObjectForKey("EODatabaseUpdateOperator", "_databaseOperator");
        } else {
            dict.setObjectForKey("<unrecognized value>", "_databaseOperator");
        }
        if (op.newRow() != null) {
            dict.setObjectForKey(op.newRow(), "_newRow");
        }
        if (op.dbSnapshot() != null) {
            dict.setObjectForKey(op.dbSnapshot(), "_dbSnapshot");
        }
        if (op.globalID() != null) {
            dict.setObjectForKey(op.globalID(), "_globalID");
        }
        if (op.entity() != null) {
            dict.setObjectForKey(op.entity().name(), "_entity");
        }
        if (op.adaptorOperations() != null) {
            dict.setObjectForKey(op.adaptorOperations(), "_adaptorOps");
        }
        if (op.object() != null) {
            dict.setObjectForKey(op.object().toString(), "_object");
        }
        return dict;
    }

    private static NSDictionary adaptorOperationAsDictionary(EOAdaptorOperation op) {
        NSMutableDictionary<String, Object> dict = new NSMutableDictionary<String, Object>();
        int operator = op.adaptorOperator();
        if (operator == 0) {
            dict.setObjectForKey("EOAdaptorLockOperator", "_adaptorOperator");
        } else if (operator == 1) {
            dict.setObjectForKey("EOAdaptorInsertOperator", "_adaptorOperator");
        } else if (operator == 3) {
            dict.setObjectForKey("EOAdaptorDeleteOperator", "_adaptorOperator");
        } else if (operator == 2) {
            dict.setObjectForKey("EOAdaptorUpdateOperator", "_adaptorOperator");
        } else {
            dict.setObjectForKey("<unrecognized value>", "_adaptorOperator");
        }
        if (op.entity() != null) {
            dict.setObjectForKey(op.entity(), "_entity");
        }
        if (op.qualifier() != null) {
            dict.setObjectForKey(op.qualifier().toString(), "_qualifier");
        }
        if (op.changedValues() != null) {
            dict.setObjectForKey(op.changedValues(), "_changedValues");
        }
        if (op.exception() != null) {
            dict.setObjectForKey(op.exception(), "_exception");
        }
        return dict;
    }

    private static void dumpObject(StringBuffer sb, Object value, int level) {
        if (value instanceof NSDictionary) {
            ERXStringUtilities.dumpDictionary(sb, (NSDictionary)value, level);
        } else if (value instanceof NSArray) {
            ERXStringUtilities.dumpArray(sb, (NSArray)value, level);
        } else if (value instanceof NSData) {
            NSData data = (NSData)value;
            sb.append(ERXStringUtilities.byteArrayToHexString(data.bytes()));
        } else if (value instanceof EODatabaseOperation) {
            ERXStringUtilities.dumpDictionary(sb, ERXStringUtilities.databaseOperationAsDictionary((EODatabaseOperation)value), level);
        } else if (value instanceof EOAdaptorOperation) {
            ERXStringUtilities.dumpDictionary(sb, ERXStringUtilities.adaptorOperationAsDictionary((EOAdaptorOperation)value), level);
        } else {
            ERXStringUtilities.indent(sb, level);
            sb.append(value);
        }
    }

    private static String getSimpleBinaryName(Class clazz) {
        Class<?> declaringClass = clazz.getDeclaringClass();
        if (declaringClass == null) {
            return null;
        }
        try {
            return clazz.getName().substring(declaringClass.getName().length());
        }
        catch (IndexOutOfBoundsException e) {
            throw new InternalError("Malformed class name");
        }
    }

    private static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public static String getSimpleClassName(Class clazz) {
        int j;
        if (clazz.isArray()) {
            return ERXStringUtilities.getSimpleClassName(clazz.getComponentType()) + "[]";
        }
        String declaringClassName = ERXStringUtilities.getSimpleBinaryName(clazz);
        if (declaringClassName == null) {
            declaringClassName = clazz.getName();
            return declaringClassName.substring(declaringClassName.lastIndexOf(".") + 1);
        }
        int i = declaringClassName.length();
        if (i < 1 || declaringClassName.charAt(0) != '$') {
            throw new InternalError("Malformed class name");
        }
        for (j = 1; j < i && ERXStringUtilities.isAsciiDigit(declaringClassName.charAt(j)); ++j) {
        }
        return declaringClassName.substring(j);
    }

    public static String stringFromDictionary(NSDictionary dict) {
        NSArray orderedKeys = dict.allKeys();
        orderedKeys = ERXArrayUtilities.sortedArraySortedWithKey(orderedKeys, "toString.toLowerCase");
        StringBuffer result = new StringBuffer();
        Enumeration keys = orderedKeys.objectEnumerator();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = dict.objectForKey(key);
            String stringValue = NSPropertyListSerialization.stringFromPropertyList(value);
            String stringKey = NSPropertyListSerialization.stringFromPropertyList(key);
            if (!(value instanceof String)) {
                stringValue = stringValue.replaceAll("\n", "\n\t");
            }
            result.append("\t");
            result.append(stringKey);
            result.append(" = ");
            result.append(stringValue);
            result.append(";\n");
        }
        return "{\n" + result + "}\n";
    }

    public static boolean regionMatches(StringBuffer str, int toffset, String other, int ooffset, int len) {
        int to = toffset;
        int po = ooffset;
        int count = str.length();
        int otherCount = other.length();
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)count - (long)len || (long)ooffset > (long)otherCount - (long)len) {
            return false;
        }
        while (len-- > 0) {
            if (str.charAt(to++) == other.charAt(po++)) continue;
            return false;
        }
        return true;
    }

    public static String safeIdentifierName(String source, String prefix, char replacement) {
        StringBuffer b;
        if (source == null || source.length() == 0 || Character.isJavaIdentifierStart(source.charAt(0))) {
            b = new StringBuffer(source);
        } else {
            b = new StringBuffer(prefix);
            b.append(source);
        }
        for (int i = 0; i < b.length(); ++i) {
            char c = b.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            b.setCharAt(i, replacement);
        }
        return b.toString();
    }

    public static String safeIdentifierName(String source, String prefix) {
        return ERXStringUtilities.safeIdentifierName(source, prefix, '_');
    }

    public static String safeIdentifierName(String source) {
        return ERXStringUtilities.safeIdentifierName(source, "_", '_');
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, ERXMessageEncoding.defaultEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, ERXMessageEncoding.defaultEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public static byte[] toUTF8Bytes(String string) {
        return ERXStringUtilities.toBytes(string, "UTF-8");
    }

    public static byte[] toBytes(String string, String encoding) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public static String fromUTF8Bytes(byte[] bytes) {
        return ERXStringUtilities.fromBytes(bytes, "UTF-8");
    }

    public static String fromBytes(byte[] bytes, String encoding) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public static String rightPad(String string, char padChar, int paddedLength) {
        if (string.length() >= paddedLength) {
            return string;
        }
        StringBuffer buffer = new StringBuffer(string);
        for (int i = string.length(); i < paddedLength; ++i) {
            buffer.append(padChar);
        }
        return buffer.toString();
    }

    public static String leftPad(String string, char padChar, int paddedLength) {
        if (string.length() >= paddedLength) {
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = string.length(); i < paddedLength; ++i) {
            buffer.append(padChar);
        }
        buffer.append(string);
        return buffer.toString();
    }

    public static String insertString(String destinationString, String contentToInsert, int insertOffset) {
        String result;
        if (destinationString == null) {
            if (insertOffset > 0) {
                throw new IndexOutOfBoundsException("You attempted to insert '" + contentToInsert + "' into an empty string at the offset " + insertOffset + ".");
            }
            result = contentToInsert;
        } else {
            StringBuffer sb = new StringBuffer(destinationString.length() + contentToInsert.length());
            sb.append(destinationString.substring(0, insertOffset));
            sb.append(contentToInsert);
            sb.append(destinationString.substring(insertOffset));
            result = sb.toString();
        }
        return result;
    }

    public static String trimString(String s) {
        if (s == null) {
            return s;
        }
        return s.trim();
    }

    public static String excelSafeCsvString(String s) {
        if (s != null) {
            boolean mustQuote = false;
            s = ERXStringUtilities.unquote(s, "\"");
            s = s.replaceAll("\r", "");
            if ((s = s.replaceAll("\n", "")).contains("\"")) {
                s = s.replaceAll("\"", "\"\"");
                mustQuote = true;
            }
            if (s.contains(",")) {
                mustQuote = true;
            }
            if (mustQuote) {
                s = ERXStringUtilities.quote(s, "\"");
            }
        }
        return s;
    }

    public static String unquote(String s, String quoteSymbol) {
        if (s == null || quoteSymbol == null) {
            throw new IllegalArgumentException("Neither the string nor the quote symbol are allowed to be null");
        }
        if (s.startsWith(quoteSymbol) && s.endsWith(quoteSymbol)) {
            s = s.substring(1);
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String quote(String s, String quoteSymbol) {
        if (s == null || quoteSymbol == null) {
            throw new IllegalArgumentException("Neither the string nor the quote symbol are allowed to be null");
        }
        s = new StringBuffer().append(quoteSymbol).append(s).append(quoteSymbol).toString();
        return s;
    }

    public static String stringByAppendingCSSClass(String originalString, String cssClass) {
        String newString = cssClass == null || cssClass.length() == 0 ? originalString : (originalString == null || originalString.length() == 0 ? cssClass : originalString + " " + cssClass);
        return newString;
    }

    public static String stripHtml(String str) {
        String stripped = str;
        if (stripped != null) {
            stripped = stripped.replaceAll("<[^>]*>", " ");
            stripped = stripped.replaceAll("\\s+", " ");
            stripped = stripped.replaceAll("&#8217;", "'");
            stripped = stripped.replaceAll("&#169;", "(C)");
            stripped = stripped.replaceAll("&#215;", " x ");
            stripped = stripped.replaceAll("&#8230;", "...");
            stripped = stripped.replaceAll("&#8212;", " -- ");
            stripped = stripped.replaceAll("&#8211;", " - ");
            stripped = stripped.replaceAll("&#8220;", "\"");
            stripped = stripped.replaceAll("&#8221;", "\"");
            stripped = stripped.replaceAll("&#174;", "(C)");
            stripped = stripped.replaceAll("&#174;", "(R)");
            stripped = stripped.replaceAll("&#8482;", "(TM)");
            stripped = stripped.trim();
        }
        return stripped;
    }

    public static Object attributeValueFromString(EOAttribute attr, String strVal, String encoding, Format formatter) {
        Object val = null;
        Class<?> attrValueClass = null;
        try {
            attrValueClass = Class.forName(attr.className());
        }
        catch (ClassNotFoundException cnfe) {
            NSForwardException._runtimeExceptionForThrowable((Throwable)cnfe);
        }
        if (NSTimestamp.class.equals(attrValueClass)) {
            Date parseResult = null;
            try {
                parseResult = (Date)formatter.parseObject(strVal);
                val = new NSTimestamp(parseResult);
            }
            catch (ParseException pe) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)pe);
            }
        } else if (Number.class.isAssignableFrom(attrValueClass)) {
            val = ERXStringUtilities.attributeNumberValueFromString(attr, strVal);
        } else if (String.class.equals(attrValueClass)) {
            val = strVal;
        } else if (attr.valueFactoryMethod() != null) {
            val = ERXStringUtilities.attributeCustomValueFromString(attr, strVal, encoding);
        }
        return val;
    }

    public static Number attributeNumberValueFromString(EOAttribute attr, String strVal) {
        Number val = null;
        String typeString = attr.valueType();
        if (typeString != null) {
            char key = typeString.charAt(0);
            String numberType = null;
            switch (key) {
                case 'b': {
                    numberType = Byte.class.getName();
                    break;
                }
                case 's': {
                    numberType = Short.class.getName();
                    break;
                }
                case 'i': {
                    numberType = Integer.class.getName();
                    break;
                }
                case 'l': {
                    numberType = Long.class.getName();
                    break;
                }
                case 'f': {
                    numberType = Float.class.getName();
                    break;
                }
                case 'd': {
                    numberType = Double.class.getName();
                    break;
                }
                case 'B': {
                    numberType = BigDecimal.class.getName();
                    break;
                }
                case 'c': {
                    numberType = Boolean.class.getName();
                    break;
                }
            }
            if (numberType != null) {
                try {
                    Class<?> numberClass = Class.forName(numberType);
                    Constructor<?> numberConstructor = numberClass.getConstructor(String.class);
                    val = (Number)numberConstructor.newInstance(strVal);
                }
                catch (Exception e) {
                    NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
            }
        }
        return val;
    }

    public static Object attributeCustomValueFromString(EOAttribute attr, String strVal, String encoding) {
        Object val = null;
        Class<?> attrValueClass = null;
        try {
            attrValueClass = Class.forName(attr.className());
        }
        catch (ClassNotFoundException cnfe) {
            NSForwardException._runtimeExceptionForThrowable((Throwable)cnfe);
        }
        NSSelector sel = attr.valueFactoryMethod();
        try {
            Method m = sel.methodOnClass(attrValueClass);
            switch (attr.factoryMethodArgumentType()) {
                case 2: {
                    if (encoding == null) {
                        throw new NullPointerException();
                    }
                    byte[] b = strVal.getBytes(encoding);
                    val = m.invoke(null, new Object[]{b});
                    break;
                }
                case 0: {
                    if (encoding == null) {
                        throw new NullPointerException();
                    }
                    NSData d = new NSData(strVal, encoding);
                    val = m.invoke(null, d);
                    break;
                }
                case 1: {
                    val = m.invoke(null, strVal);
                    break;
                }
            }
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (Exception e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        return val;
    }

    public static boolean isValueInRange(int value, String rangeString) {
        boolean rangeMatches = false;
        if (rangeString != null && rangeString.length() > 0) {
            String[] ranges;
            for (String range : ranges = rangeString.split(",")) {
                int dashIndex = (range = range.trim()).indexOf(45);
                if (dashIndex == -1) {
                    int singleValue = Integer.parseInt(range);
                    if (value != singleValue) continue;
                    rangeMatches = true;
                    break;
                }
                int lowValue = Integer.parseInt(range.substring(0, dashIndex).trim());
                int highValue = Integer.parseInt(range.substring(dashIndex + 1).trim());
                if (value < lowValue || value > highValue) continue;
                rangeMatches = true;
                break;
            }
        }
        return rangeMatches;
    }

    public static String maskStringWithCharacter(String arg, char mask, int beginIndex, int endIndex) {
        int begin;
        int length = arg.length();
        int end = endIndex < 0 ? length + endIndex : endIndex;
        int sub = end - (begin = beginIndex < 0 ? length + beginIndex : beginIndex);
        if (sub < 0) {
            throw new StringIndexOutOfBoundsException(sub);
        }
        StringBuilder sb = new StringBuilder(arg.substring(0, begin));
        for (int i = 0; i < sub; ++i) {
            sb.append(mask);
        }
        sb.append(arg.substring(end, length));
        return sb.toString();
    }

    static {
        Object[] xml = new Object[]{Character.valueOf('<'), "lt", Character.valueOf('>'), "gt", Character.valueOf('&'), "amp", Character.valueOf('\"'), "quot"};
        NSMutableDictionary<String, String> dict = new NSMutableDictionary<String, String>();
        for (int i = 0; i < xml.length; i += 2) {
            Character charValue = (Character)xml[i];
            String key = (String)xml[i + 1];
            dict.setObjectForKey(charValue + "", key);
            dict.setObjectForKey(charValue + "", "#" + charValue);
        }
        XML_UNESCAPES = dict.immutableClone();
        Object[] iso = new Object[]{160, "nbsp", 161, "iexcl", 162, "cent", 163, "pound", 164, "curren", 165, "yen", 166, "brvbar", 167, "sect", 168, "uml", 169, "copy", 170, "ordf", 171, "laquo", 172, "not", 173, "shy", 174, "reg", 175, "macr", 176, "deg", 177, "plusmn", 178, "sup2", 179, "sup3", 180, "acute", 181, "micro", 182, "para", 183, "middot", 184, "cedil", 185, "sup1", 186, "ordm", 187, "raquo", 188, "frac14", 189, "frac12", 190, "frac34", 191, "iquest", 215, "times", 247, "divide", 192, "Agrave", 193, "Aacute", 194, "Acirc", 195, "Atilde", 196, "Auml", 197, "Aring", 198, "AElig", 199, "Ccedil", 200, "Egrave", 201, "Eacute", 202, "Ecirc", 203, "Euml", 204, "Igrave", 205, "Iacute", 206, "Icirc", 207, "Iuml", 208, "ETH", 209, "Ntilde", 210, "Ograve", 211, "Oacute", 212, "Ocirc", 213, "Otilde", 214, "Ouml", 216, "Oslash", 217, "Ugrave", 218, "Uacute", 219, "Ucirc", 220, "Uuml", 221, "Yacute", 222, "THORN", 223, "szlig", 224, "agrave", 225, "aacute", 226, "acirc", 227, "atilde", 228, "auml", 229, "aring", 230, "aelig", 231, "ccedil", 232, "egrave", 233, "eacute", 234, "ecirc", 235, "euml", 236, "igrave", 237, "iacute", 238, "icirc", 239, "iuml", 240, "eth", 241, "ntilde", 242, "ograve", 243, "oacute", 244, "ocirc", 245, "otilde", 246, "ouml", 248, "oslash", 249, "ugrave", 250, "uacute", 251, "ucirc", 252, "uuml", 253, "yacute", 254, "thorn", 255, "yuml"};
        dict = new NSMutableDictionary();
        for (int i = 0; i < iso.length; i += 2) {
            Integer charValue = (Integer)iso[i];
            String key = (String)iso[i + 1];
            dict.setObjectForKey(Character.toChars(charValue)[0] + "", key);
            dict.setObjectForKey(Character.toChars(charValue)[0] + "", "#" + charValue);
        }
        ISO_UNESCAPES = dict.immutableClone();
        Object[] symbols = new Object[]{8704, "forall", 8706, "part", 8707, "exists", 8709, "empty", 8711, "nabla", 8712, "isin", 8713, "notin", 8715, "ni", 8719, "prod", 8721, "sum", 8722, "minus", 8727, "lowast", 8730, "radic", 8733, "prop", 8734, "infin", 8736, "ang", 8743, "and", 8744, "or", 8745, "cap", 8746, "cup", 8747, "int", 8756, "there4", 8764, "sim", 8773, "cong", 8776, "asymp", 8800, "ne", 8801, "equiv", 8804, "le", 8805, "ge", 8834, "sub", 8835, "sup", 8836, "nsub", 8838, "sube", 8839, "supe", 8853, "oplus", 8855, "otimes", 8869, "perp", 8901, "sdot", 913, "Alpha", 914, "Beta", 915, "Gamma", 916, "Delta", 917, "Epsilon", 918, "Zeta", 919, "Eta", 920, "Theta", 921, "Iota", 922, "Kappa", 923, "Lambda", 924, "Mu", 925, "Nu", 926, "Xi", 927, "Omicron", 928, "Pi", 929, "Rho", 931, "Sigma", 932, "Tau", 933, "Upsilon", 934, "Phi", 935, "Chi", 936, "Psi", 937, "Omega", 945, "alpha", 946, "beta", 947, "gamma", 948, "delta", 949, "epsilon", 950, "zeta", 951, "eta", 952, "theta", 953, "iota", 954, "kappa", 955, "lambda", 956, "mu", 957, "nu", 958, "xi", 959, "omicron", 960, "pi", 961, "rho", 962, "sigmaf", 963, "sigma", 964, "tau", 965, "upsilon", 966, "phi", 967, "chi", 968, "psi", 969, "omega", 977, "thetasym", 978, "upsih", 982, "piv", 338, "OElig", 339, "oelig", 352, "Scaron", 353, "scaron", 376, "Yuml", 402, "fnof", 710, "circ", 732, "tilde", 8194, "ensp", 8195, "emsp", 8201, "thinsp", 8204, "zwnj", 8205, "zwj", 8206, "lrm", 8207, "rlm", 8211, "ndash", 8212, "mdash", 8216, "lsquo", 8217, "rsquo", 8218, "sbquo", 8220, "ldquo", 8221, "rdquo", 8222, "bdquo", 8224, "dagger", 8225, "Dagger", 8226, "bull", 8230, "hellip", 8240, "permil", 8242, "prime", 8243, "Prime", 8249, "lsaquo", 8250, "rsaquo", 8254, "oline", 8364, "euro", 8482, "trade", 8592, "larr", 8593, "uarr", 8594, "rarr", 8595, "darr", 8596, "harr", 8629, "crarr", 8968, "lceil", 8969, "rceil", 8970, "lfloor", 8971, "rfloor", 9674, "loz", 9824, "spades", 9827, "clubs", 9829, "hearts", 9830, "diams"};
        dict = new NSMutableDictionary();
        for (int i = 0; i < symbols.length; i += 2) {
            Integer charValue = (Integer)symbols[i];
            String key = (String)symbols[i + 1];
            dict.setObjectForKey(Character.toChars(charValue)[0] + "", key);
            dict.setObjectForKey(Character.toChars(charValue)[0] + "", "#" + charValue);
        }
        SYMBOL_UNESCAPES = dict.immutableClone();
        dict = new NSMutableDictionary();
        dict.addEntriesFromDictionary(ISO_UNESCAPES);
        dict.addEntriesFromDictionary(SYMBOL_UNESCAPES);
        HTML_SAFE_UNESCAPES = dict.immutableClone();
        dict.addEntriesFromDictionary(XML_UNESCAPES);
        HTML_UNESCAPES = dict.immutableClone();
    }
}

