/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class ERXTimestampUtility {
    public static GregorianCalendar calendarForTimestamp(NSTimestamp t) {
        GregorianCalendar calendar = (GregorianCalendar)Calendar.getInstance();
        calendar.setTime((Date)t);
        return calendar;
    }

    public static long offsetForDateInCommonEra(NSTimestamp t, int mode) {
        GregorianCalendar calendar = ERXTimestampUtility.calendarForTimestamp(t);
        switch (mode) {
            case 1: {
                return calendar.get(1);
            }
            case 2: {
                return calendar.get(1) * 12 + calendar.get(2);
            }
            case 3: {
                return calendar.get(1) * 52 + calendar.get(3);
            }
            case 5: 
            case 6: {
                return calendar.get(1) * 365 + calendar.get(6);
            }
            case 10: 
            case 11: {
                return (calendar.get(1) * 365 + calendar.get(6)) * 24 + calendar.get(11);
            }
        }
        return 0L;
    }

    public static long differenceByDay(NSTimestamp t1, NSTimestamp t2) {
        return ERXTimestampUtility.compareDatesInCommonEra(t1, t2, 6);
    }

    public static long differenceByWeek(NSTimestamp t1, NSTimestamp t2) {
        return ERXTimestampUtility.compareDatesInCommonEra(t1, t2, 3);
    }

    public static long differenceByMonth(NSTimestamp t1, NSTimestamp t2) {
        return ERXTimestampUtility.compareDatesInCommonEra(t1, t2, 2);
    }

    public static long differenceByYear(NSTimestamp t1, NSTimestamp t2) {
        return ERXTimestampUtility.compareDatesInCommonEra(t1, t2, 1);
    }

    public static NSTimestamp firstDateInSameWeek(NSTimestamp value) {
        return new NSTimestamp(ERXTimestampUtility.yearOfCommonEra(value), ERXTimestampUtility.monthOfYear(value), -ERXTimestampUtility.dayOfWeek(value) + 1, 0, 0, 0, (TimeZone)NSTimeZone.defaultTimeZone());
    }

    public static NSTimestamp firstDateInSameMonth(NSTimestamp value) {
        return new NSTimestamp(ERXTimestampUtility.yearOfCommonEra(value), ERXTimestampUtility.monthOfYear(value), -ERXTimestampUtility.dayOfMonth(value) + 1, 0, 0, 0, (TimeZone)NSTimeZone.defaultTimeZone());
    }

    public static NSTimestamp firstDateInNextMonth(NSTimestamp value) {
        return ERXTimestampUtility.firstDateInSameMonth(value).timestampByAddingGregorianUnits(0, 1, 0, 0, 0, 0);
    }

    public static long compareDatesInCommonEra(NSTimestamp t1, NSTimestamp t2, int mode) {
        return ERXTimestampUtility.offsetForDateInCommonEra(t2, mode) - ERXTimestampUtility.offsetForDateInCommonEra(t1, mode);
    }

    public static int dayOfCommonEra(NSTimestamp t) {
        return ERXTimestampUtility.yearOfCommonEra(t) * 365 + ERXTimestampUtility.dayOfYear(t);
    }

    public static int monthOfCommonEra(NSTimestamp t) {
        return ERXTimestampUtility.yearOfCommonEra(t) * 12 + ERXTimestampUtility.monthOfYear(t);
    }

    public static int weekOfCommonEra(NSTimestamp t) {
        return ERXTimestampUtility.yearOfCommonEra(t) * 12 + ERXTimestampUtility.weekOfYear(t);
    }

    public static boolean isWeekDay(NSTimestamp t) {
        int day = ERXTimestampUtility.dayOfWeek(t);
        return day != 7 && day != 1;
    }

    public static int dayOfWeek(NSTimestamp t) {
        return ERXTimestampUtility.calendarForTimestamp(t).get(7);
    }

    public static int dayOfMonth(NSTimestamp t) {
        return ERXTimestampUtility.calendarForTimestamp(t).get(5);
    }

    public static int weekOfYear(NSTimestamp t) {
        return ERXTimestampUtility.calendarForTimestamp(t).get(3);
    }

    public static int weekOfMonth(NSTimestamp t) {
        return ERXTimestampUtility.calendarForTimestamp(t).get(4);
    }

    public static int dayOfYear(NSTimestamp t) {
        return ERXTimestampUtility.calendarForTimestamp(t).get(6);
    }

    public static int hourOfDay(NSTimestamp t) {
        return ERXTimestampUtility.calendarForTimestamp(t).get(11);
    }

    public static int minuteOfHour(NSTimestamp t) {
        return ERXTimestampUtility.calendarForTimestamp(t).get(12);
    }

    public static int secondOfMinute(NSTimestamp t) {
        return ERXTimestampUtility.calendarForTimestamp(t).get(13);
    }

    public static int monthOfYear(NSTimestamp t) {
        return ERXTimestampUtility.calendarForTimestamp(t).get(2);
    }

    public static int yearOfCommonEra(NSTimestamp t) {
        return ERXTimestampUtility.calendarForTimestamp(t).get(1);
    }
}

