/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.jdbc;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAdaptorContext;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOStoredProcedure;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.jdbcadaptor.ERXJDBCColumn;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import com.webobjects.jdbcadaptor.JDBCAdaptorException;
import com.webobjects.jdbcadaptor.JDBCChannel;
import com.webobjects.jdbcadaptor.JDBCContext;
import com.webobjects.jdbcadaptor.JDBCPlugIn;
import er.extensions.eof.ERXAdaptorOperationWrapper;
import er.extensions.foundation.ERXKeyValueCodingUtilities;
import er.extensions.foundation.ERXPatcher;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXSystem;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.jdbc.ERXJDBCConnectionBroker;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ERXJDBCAdaptor
extends JDBCAdaptor {
    public static final Logger log = Logger.getLogger(ERXJDBCAdaptor.class);
    public static final String USE_CONNECTION_BROKER_KEY = "er.extensions.ERXJDBCAdaptor.useConnectionBroker";
    public static final String CLASS_NAME_KEY = "er.extensions.ERXJDBCAdaptor.className";
    private static Boolean switchReadWrite = null;
    private static Boolean useConnectionBroker = null;

    static boolean switchReadWrite() {
        if (switchReadWrite == null) {
            switchReadWrite = "false".equals(ERXSystem.getProperty("er.extensions.ERXJDBCAdaptor.switchReadWrite", "false")) ? Boolean.FALSE : Boolean.TRUE;
        }
        return switchReadWrite;
    }

    public static boolean useConnectionBroker() {
        if (useConnectionBroker == null) {
            useConnectionBroker = ERXProperties.booleanForKeyWithDefault(USE_CONNECTION_BROKER_KEY, false) ? Boolean.TRUE : Boolean.FALSE;
        }
        return useConnectionBroker;
    }

    public static void registerJDBCAdaptor() {
        String className = ERXProperties.stringForKey(CLASS_NAME_KEY);
        if (className != null) {
            Class c = ERXPatcher.classForName(className);
            if (c == null) {
                throw new IllegalStateException("Can't find class: " + className);
            }
            ERXPatcher.setClassForName(c, JDBCAdaptor.class.getName());
        }
    }

    public ERXJDBCAdaptor(String s) {
        super(s);
    }

    protected JDBCContext _cachedAdaptorContext() {
        if (this._cachedContext == null) {
            this._cachedContext = this.createJDBCContext();
        }
        return this._cachedContext;
    }

    protected NSDictionary jdbcInfo() {
        boolean closeCachedContext = this._cachedContext == null && this._jdbcInfo == null;
        NSDictionary jdbcInfo = super.jdbcInfo();
        if (closeCachedContext && this._cachedContext != null) {
            this._cachedContext.disconnect();
            this._cachedContext = null;
        }
        return jdbcInfo;
    }

    protected NSDictionary typeInfo() {
        boolean closeCachedContext = this._cachedContext == null && this._jdbcInfo == null;
        NSDictionary typeInfo = super.typeInfo();
        if (closeCachedContext && this._cachedContext != null) {
            this._cachedContext.disconnect();
            this._cachedContext = null;
        }
        return typeInfo;
    }

    public Context createJDBCContext() {
        Context context = new Context((EOAdaptor)this);
        return context;
    }

    public EOAdaptorContext createAdaptorContext() {
        JDBCContext context;
        if (this._cachedContext != null) {
            context = this._cachedContext;
            this._cachedContext = null;
        } else {
            context = this.createJDBCContext();
        }
        return context;
    }

    protected Connection checkoutConnection() {
        Connection c = this.connectionBroker().getConnection();
        return c;
    }

    private ConnectionBroker connectionBroker() {
        return ERXJDBCConnectionBroker.connectionBrokerForAdaptor((EOAdaptor)this);
    }

    protected void freeConnection(Connection connection) {
        this.connectionBroker().freeConnection(connection);
    }

    public static class Context
    extends JDBCContext {
        public Context(EOAdaptor eoadaptor) {
            super(eoadaptor);
        }

        private void freeConnection() {
            if (ERXJDBCAdaptor.useConnectionBroker() && this._jdbcConnection != null) {
                ((ERXJDBCAdaptor)this.adaptor()).freeConnection(this._jdbcConnection);
                this._jdbcConnection = null;
            }
        }

        public void rollbackTransaction() {
            if (!this.hasOpenTransaction()) {
                return;
            }
            if (((Number)ERXKeyValueCodingUtilities.privateValueForKey((Object)this, "_fetchesInProgress")).intValue() > 0) {
                throw new JDBCAdaptorException("Cannot rollbackTransaction() while a fetch is in progress", null);
            }
            if (this._delegateRespondsTo_shouldRollback && !this._delegate.booleanPerform("adaptorContextShouldRollback", (Object)this)) {
                return;
            }
            try {
                if (this._connectionSupportTransaction && !this._jdbcConnection.isClosed()) {
                    this._jdbcConnection.rollback();
                }
            }
            catch (SQLException sqlexception) {
                throw new JDBCAdaptorException(sqlexception);
            }
            this.transactionDidRollback();
            if (this._delegateRespondsTo_didRollback) {
                this._delegate.perform("adaptorContextDidRollback", (Object)this);
            }
        }

        private void checkoutConnection() {
            if (ERXJDBCAdaptor.useConnectionBroker() && this._jdbcConnection == null) {
                this._jdbcConnection = ((ERXJDBCAdaptor)this.adaptor()).checkoutConnection();
            }
        }

        public boolean connect() throws JDBCAdaptorException {
            boolean connected = false;
            if (ERXJDBCAdaptor.useConnectionBroker()) {
                this.checkoutConnection();
                connected = this._jdbcConnection != null;
            } else {
                connected = super.connect();
            }
            return connected;
        }

        protected JDBCChannel createJDBCChannel() {
            return new Channel(this);
        }

        protected JDBCChannel _cachedAdaptorChannel() {
            if (this._cachedChannel == null) {
                this._cachedChannel = this.createJDBCChannel();
            }
            return this._cachedChannel;
        }

        public EOAdaptorChannel createAdaptorChannel() {
            if (this._cachedChannel != null) {
                JDBCChannel jdbcchannel = this._cachedChannel;
                this._cachedChannel = null;
                return jdbcchannel;
            }
            return this.createJDBCChannel();
        }

        public void disconnect() throws JDBCAdaptorException {
            this.freeConnection();
            super.disconnect();
        }

        public void beginTransaction() {
            this.checkoutConnection();
            super.beginTransaction();
        }

        public void transactionDidCommit() {
            super.transactionDidCommit();
            this.freeConnection();
        }

        public void transactionDidRollback() {
            super.transactionDidRollback();
            this.freeConnection();
        }
    }

    public static class Channel
    extends JDBCChannel {
        private static NSMutableDictionary<String, NSMutableArray> pkCache = new NSMutableDictionary();
        private int defaultBatchSize = ERXProperties.intForKeyWithDefault("er.extensions.ERXPrimaryKeyBatchSize", -1);

        public Channel(JDBCContext jdbccontext) {
            super(jdbccontext);
            try {
                Field field = JDBCChannel.class.getDeclaredField("_inputColumn");
                field.setAccessible(true);
                field.set((Object)this, (Object)new ERXJDBCColumn(this));
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace();
                System.exit(1);
            }
        }

        public void setAttributesToFetch(NSArray attributes) {
            int j;
            this._attributes = attributes;
            if (this._attributes == null || (j = this._attributes.count()) == 0) {
                return;
            }
            ERXJDBCColumn[] columns = new ERXJDBCColumn[j];
            for (int i = 0; i < j; ++i) {
                columns[i] = new ERXJDBCColumn((EOAttribute)this._attributes.objectAtIndex(i), this, i + 1, this._resultSet);
            }
            this._selectedColumns = new NSArray<ERXJDBCColumn>(columns);
        }

        private boolean setReadOnly(boolean mode) {
            boolean old = false;
            if (ERXJDBCAdaptor.switchReadWrite()) {
                try {
                    Connection connection = ((JDBCContext)this.adaptorContext()).connection();
                    if (connection == null) {
                        throw new EOGeneralAdaptorException("Can't switch connection mode to " + mode + ", the connection is null");
                    }
                    old = connection.isReadOnly();
                    connection.setReadOnly(mode);
                }
                catch (SQLException e) {
                    throw new EOGeneralAdaptorException("Can't switch connection mode to " + mode, new NSDictionary<String, SQLException>(e, "originalException"));
                }
            }
            return old;
        }

        public void selectAttributes(NSArray array, EOFetchSpecification fetchspecification, boolean lock, EOEntity entity) {
            boolean mode = this.setReadOnly(!lock);
            super.selectAttributes(array, fetchspecification, lock, entity);
            this.setReadOnly(mode);
        }

        public void performAdaptorOperations(NSArray ops) {
            super.performAdaptorOperations(ops);
            ERXAdaptorOperationWrapper.adaptorOperationsDidPerform(ops);
        }

        private JDBCPlugIn _plugIn() {
            JDBCAdaptor jdbcadaptor = (JDBCAdaptor)this.adaptorContext().adaptor();
            return jdbcadaptor.plugIn();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NSArray primaryKeysForNewRowsWithEntity(int cnt, EOEntity entity) {
            if (this.defaultBatchSize > 0) {
                NSMutableDictionary<String, NSMutableArray> nSMutableDictionary = pkCache;
                synchronized (nSMutableDictionary) {
                    String key = entity.primaryKeyRootName();
                    NSMutableArray pks = (NSMutableArray)pkCache.objectForKey(key);
                    if (pks == null) {
                        pks = new NSMutableArray();
                        pkCache.setObjectForKey(pks, key);
                    }
                    if (pks.count() < cnt) {
                        String batchSize;
                        String string = batchSize = entity.userInfo() != null ? (String)entity.userInfo().objectForKey("ERXPrimaryKeyBatchSize") : null;
                        if (batchSize == null) {
                            String string2 = batchSize = entity.model().userInfo() != null ? (String)entity.model().userInfo().objectForKey("ERXPrimaryKeyBatchSize") : null;
                        }
                        if (batchSize == null) {
                            batchSize = ERXProperties.stringForKey("er.extensions.ERXPrimaryKeyBatchSize");
                        }
                        int size = this.defaultBatchSize;
                        if (batchSize != null) {
                            size = ERXValueUtilities.intValue(batchSize);
                        }
                        pks.addObjectsFromArray(this._plugIn().newPrimaryKeys(size + cnt, entity, (JDBCChannel)this));
                    }
                    NSMutableArray batch = new NSMutableArray();
                    Iterator iterator = pks.iterator();
                    while (iterator.hasNext() && --cnt >= 0) {
                        Object pk = iterator.next();
                        batch.addObject(pk);
                        iterator.remove();
                    }
                    return batch;
                }
            }
            return this._plugIn().newPrimaryKeys(cnt, entity, (JDBCChannel)this);
        }

        private void cleanup() {
            Boolean value = (Boolean)ERXKeyValueCodingUtilities.privateValueForKey((Object)this, "_beganTransaction");
            if (value.booleanValue()) {
                try {
                    this._context.rollbackTransaction();
                }
                catch (JDBCAdaptorException ex) {
                    ERXKeyValueCodingUtilities.takePrivateValueForKey((Object)this, Boolean.FALSE, "_beganTransaction");
                    throw ex;
                }
            }
        }

        public void evaluateExpression(EOSQLExpression eosqlexpression) {
            try {
                super.evaluateExpression(eosqlexpression);
            }
            catch (JDBCAdaptorException ex) {
                this.cleanup();
                throw ex;
            }
        }

        public void executeStoredProcedure(EOStoredProcedure eostoredprocedure, NSDictionary nsdictionary) {
            try {
                super.executeStoredProcedure(eostoredprocedure, nsdictionary);
            }
            catch (JDBCAdaptorException ex) {
                this.cleanup();
                throw ex;
            }
        }

        public int deleteRowsDescribedByQualifier(EOQualifier eoqualifier, EOEntity eoentity) {
            try {
                return super.deleteRowsDescribedByQualifier(eoqualifier, eoentity);
            }
            catch (JDBCAdaptorException ex) {
                this.cleanup();
                throw ex;
            }
        }

        public int updateValuesInRowsDescribedByQualifier(NSDictionary nsdictionary, EOQualifier eoqualifier, EOEntity eoentity) {
            try {
                return super.updateValuesInRowsDescribedByQualifier(nsdictionary, eoqualifier, eoentity);
            }
            catch (JDBCAdaptorException ex) {
                this.cleanup();
                throw ex;
            }
        }
    }

    public static interface ConnectionBroker {
        public void freeConnection(Connection var1);

        public Connection getConnection();
    }
}

