/*
 * Decompiled with CFR 0.152.
 */
package er.selenium;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODirectAction;
import com.webobjects.appserver.WORedirect;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSSelector;
import er.selenium.ERSelenium;
import org.apache.log4j.Logger;

public class SeleniumStartTesting
extends WODirectAction {
    private static final Logger log = Logger.getLogger(SeleniumStartTesting.class);
    public static final String RESULTS_FILE_KEY = "resultsFile";

    public SeleniumStartTesting(WORequest request) {
        super(request);
    }

    public String buildUrl(String suite, boolean auto) {
        WOContext context = this.context();
        String baseUrl = "http://" + WOApplication.application().hostAddress().getHostAddress();
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("test=" + context.directActionURLForActionNamed("SeleniumTestSuite" + (suite != null ? "/" + suite : ""), null));
        queryStr.append("&resultsUrl=" + context.directActionURLForActionNamed("SeleniumTestResults", null));
        String resultsFile = (String)this.context().request().formValueForKey(RESULTS_FILE_KEY);
        if (resultsFile != null) {
            queryStr.append("/" + resultsFile);
        }
        if (auto) {
            queryStr.append("&auto=true");
        }
        String url = context.urlWithRequestHandlerKey("_sl_", "selenium-core/TestRunner.html", queryStr.toString());
        return url;
    }

    public WOActionResults defaultAction() {
        return this.runAction();
    }

    private WOActionResults redirect(String url) {
        WORedirect redirect = new WORedirect(this.context());
        redirect.setUrl(url);
        return redirect;
    }

    private WOActionResults html(String url) {
        WOResponse response = new WOResponse();
        response.appendContentString("<html><body><a href='" + url + "'>go</a><body></html>");
        return response;
    }

    private WOActionResults result(String suite, boolean edit) {
        String url = this.buildUrl(suite, edit);
        if (this.context().request().formValueForKey("ide") != null) {
            return this.html(url);
        }
        return this.redirect(url);
    }

    public WOActionResults runAction() {
        return this.result(null, true);
    }

    public WOActionResults editAction() {
        return this.result(null, false);
    }

    public WOActionResults performActionNamed(String anActionName) {
        if (!ERSelenium.testsEnabled()) {
            return new WOResponse();
        }
        if ("default".equals(anActionName)) {
            anActionName = null;
        } else if (new NSSelector(anActionName + "Action").implementedByObject((Object)this)) {
            return super.performActionNamed(anActionName);
        }
        return this.result(anActionName, false);
    }
}

