/*
 * Decompiled with CFR 0.152.
 */
package er.selenium;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotificationCenter;
import er.extensions.foundation.ERXFileUtilities;
import er.selenium.ERSelenium;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SeleniumTestRunnerProxy
extends WORequestHandler {
    private static final Logger log = Logger.getLogger(SeleniumTestRunnerProxy.class);
    protected NSMutableDictionary _cache = new NSMutableDictionary();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOResponse handleRequest(WORequest request) {
        CachedFile cachedFile;
        if (!ERSelenium.testsEnabled()) {
            return new WOResponse();
        }
        NSArray pathElements = request.requestHandlerPathArray();
        StringBuilder builder = new StringBuilder();
        Iterator iter = pathElements.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append("/");
        }
        String filePath = builder.toString();
        log.debug((Object)("Processing file '" + filePath + "'"));
        NSMutableDictionary nSMutableDictionary = this._cache;
        synchronized (nSMutableDictionary) {
            cachedFile = (CachedFile)this._cache.objectForKey((Object)filePath);
        }
        if (cachedFile == null) {
            cachedFile = new CachedFile();
            URL fileUrl = WOApplication.application().resourceManager().pathURLForResourceNamed(filePath, "ERSelenium", null);
            if (fileUrl == null) {
                throw new RuntimeException("Can't find specified resource ('" + filePath + "')");
            }
            cachedFile.mimeType = WOApplication.application().resourceManager().contentTypeForResourceNamed(filePath);
            if (cachedFile.mimeType == null) {
                throw new RuntimeException("Can't determine resource mime type ('" + filePath + "')");
            }
            try {
                cachedFile.data = new NSData(ERXFileUtilities.bytesFromInputStream((InputStream)fileUrl.openStream()));
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading file '" + fileUrl.getPath() + "'", e);
            }
            NSMutableDictionary nSMutableDictionary2 = this._cache;
            synchronized (nSMutableDictionary2) {
                this._cache.setObjectForKey((Object)cachedFile, (Object)filePath);
            }
        }
        WOResponse response = new WOResponse();
        response.setHeader(cachedFile.mimeType, "content-type");
        response.setContent(cachedFile.data);
        NSNotificationCenter.defaultCenter().postNotification(WORequestHandler.DidHandleRequestNotification, (Object)response);
        return response;
    }

    protected class CachedFile {
        public NSData data;
        public String mimeType;

        protected CachedFile() {
        }
    }
}

