/*
 * Decompiled with CFR 0.152.
 */
package er.selenium.filters;

import com.webobjects.foundation.NSMutableArray;
import er.selenium.SeleniumTest;
import er.selenium.filters.SeleniumTestFilter;
import er.selenium.filters.SeleniumTestFilterHelper;
import java.util.Formatter;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumOverrideOpenTestFilter
extends SeleniumTestFilterHelper
implements SeleniumTestFilter {
    private static final Logger log = Logger.getLogger(SeleniumOverrideOpenTestFilter.class);
    private static final String TEMP_VAR_PREFIX = "__overrideOpenTmp";
    protected String _openPrefix;

    public SeleniumOverrideOpenTestFilter(String openPrefix) {
        this._openPrefix = openPrefix;
    }

    protected int processOpenCommand(SeleniumTest.Command command, NSMutableArray<SeleniumTest.Element> elements, int index) {
        String target = command.getTarget().trim();
        if (target.startsWith("javascript") || target.matches(".*\\$\\{.*\\}.*")) {
            String varName = TEMP_VAR_PREFIX + index;
            Formatter fmt = new Formatter();
            fmt.format("javascript{if (storedVars['%1$s'].trim().startsWith('http://') || storedVars['%1$s'].trim().startsWith('https://')) {storedVars['%1$s']} else {'%2$s' + storedVars['%1$s']}}", varName, this._openPrefix);
            SeleniumTest.Command newOpenCommand = new SeleniumTest.Command(command.getName(), fmt.toString(), command.getValue());
            command.setName("storeExpression");
            command.setValue(varName);
            elements.insertObjectAtIndex((Object)newOpenCommand, index + 1);
            return 1;
        }
        if (!target.startsWith("http://") && !target.startsWith("https://")) {
            command.setTarget(this._openPrefix + target);
        }
        return 0;
    }

    @Override
    protected void processTestElements(NSMutableArray<SeleniumTest.Element> elements) {
        for (int i = 0; i < elements.count(); ++i) {
            SeleniumTest.Command command;
            if (!(elements.get(i) instanceof SeleniumTest.Command) || !(command = (SeleniumTest.Command)elements.get(i)).getName().startsWith("open")) continue;
            i += this.processOpenCommand(command, elements, i);
        }
    }
}

