/*
 * Decompiled with CFR 0.152.
 */
package er.selenium.io;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import er.selenium.SeleniumTest;
import er.selenium.io.SeleniumTestImporter;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SeleniumXHTMLImporter
implements SeleniumTestImporter {
    private static final Logger log = Logger.getLogger(SeleniumXHTMLImporter.class);
    private static final String TEST_NAME_XPATH = "//thead/tr/td/text()";
    private static final String ROOT_ELEMENTS_XPATH = "//tbody/child::node()[self::tr or self::comment()]";
    private static final String COMMAND_XPATH = "self::node()/child::td/text()";

    protected Document parseDocument(String contents) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(contents)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String name() {
        return "xhtml";
    }

    public SeleniumTest process(String contents) {
        String name;
        NSMutableArray elements = new NSMutableArray();
        Document document = this.parseDocument(contents);
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath path = factory.newXPath();
            name = (String)path.evaluate(TEST_NAME_XPATH, document, XPathConstants.STRING);
            NodeList rootElements = (NodeList)path.evaluate(ROOT_ELEMENTS_XPATH, document, XPathConstants.NODESET);
            block6: for (int i = 0; i < rootElements.getLength(); ++i) {
                Node node = rootElements.item(i);
                switch (node.getNodeType()) {
                    case 8: {
                        String commentValue = node.getNodeValue().trim();
                        if (commentValue.startsWith("@")) {
                            SeleniumTest.MetaCommand metaCommand = SeleniumTest.MetaCommand.metaCommandFromString(commentValue.substring(1));
                            elements.add((Object)metaCommand);
                            continue block6;
                        }
                        elements.add((Object)new SeleniumTest.Comment(commentValue));
                        continue block6;
                    }
                    case 1: {
                        if (!node.getNodeName().equalsIgnoreCase("tr")) {
                            throw new RuntimeException("Can't find expected 'tr' tag ('" + node.getNodeName() + "' was found instead");
                        }
                        NodeList commandNodes = (NodeList)path.evaluate(COMMAND_XPATH, node, XPathConstants.NODESET);
                        int cmdLength = commandNodes.getLength();
                        if (cmdLength > 3 || cmdLength == 0) {
                            throw new RuntimeException("Invalid command structure - expected 1-3 'td' tags (only " + commandNodes.getLength() + " were found)");
                        }
                        elements.add((Object)new SeleniumTest.Command(commandNodes.item(0).getNodeValue(), cmdLength >= 2 ? commandNodes.item(1).getNodeValue() : "", cmdLength == 3 ? commandNodes.item(2).getNodeValue() : ""));
                        continue block6;
                    }
                    default: {
                        throw new RuntimeException("Unexpected node: " + node.getNodeName());
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing document.", e);
        }
        SeleniumTest test = new SeleniumTest(name, (NSArray<SeleniumTest.Element>)elements);
        test.dump();
        return test;
    }
}

