/*
 * Decompiled with CFR 0.152.
 */
package er.selenium.rc;

import com.thoughtworks.selenium.HttpCommandProcessor;
import com.thoughtworks.selenium.SeleniumException;
import er.selenium.SeleniumTest;
import er.selenium.rc.SeleniumTestFailureException;
import org.apache.log4j.Logger;

public class SeleniumTestRCRunner {
    private static final Logger log = Logger.getLogger(SeleniumTestRCRunner.class);
    private HttpCommandProcessor browser;

    public SeleniumTestRCRunner(String host, int port, String browserType, String browserStartUrl) {
        this.browser = new HttpCommandProcessor(host, port, browserType, browserStartUrl);
    }

    public void prepare() {
        this.browser.start();
    }

    public void run(SeleniumTest test) {
        int processedCommands = 0;
        try {
            for (SeleniumTest.Element element : test.elements()) {
                if (!(element instanceof SeleniumTest.Command)) continue;
                SeleniumTest.Command command = (SeleniumTest.Command)element;
                log.debug((Object)("original command: " + command));
                if (!command.getName().equals("pause")) {
                    this.browser.doCommand(command.getName(), new String[]{command.getTarget(), command.getValue()});
                } else {
                    try {
                        Thread.sleep(new Integer(command.getTarget()).intValue());
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("invalid argument for pause command: " + command.getTarget()));
                        throw new SeleniumException((Exception)e);
                    }
                    catch (InterruptedException e) {
                        log.warn((Object)"pause command interrupted");
                    }
                }
                ++processedCommands;
            }
        }
        catch (SeleniumException e) {
            throw new SeleniumTestFailureException(e, test, processedCommands);
        }
    }

    public void finish() {
        this.browser.stop();
    }

    public void captureScreenshot(String filename) {
        this.browser.doCommand("captureScreenshot", new String[]{filename});
    }

    public void captureEntirePageScreenshot(String filename) {
        this.browser.doCommand("captureEntirePageScreenshot", new String[]{filename});
    }
}

