/*
 * Decompiled with CFR 0.152.
 */
package er.reporting;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXValueUtilities;
import er.grouping.DRAttribute;
import er.grouping.DRCriteria;
import er.grouping.DRGroup;
import er.grouping.DRMasterCriteria;
import er.grouping.DRRecordGroup;
import er.grouping.DRReportModel;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class WRReport
extends WOComponent {
    private static final Logger log = Logger.getLogger(WRReport.class);
    protected DRReportModel _model;
    public DRGroup aGrp;
    public DRGroup hGroup;
    public DRGroup vGroup;
    public DRGroup zGroup;
    public String areportStyle;
    public int currentIndex;
    public int currentIndexV;
    public int currentLevelV;
    public int currentLevel;
    public int vheadingCount;
    public int depth;
    public String dispType;
    public DRAttribute attrib;
    protected DRCriteria _topCriteriaV;
    protected DRCriteria _topCriteria;
    protected int _vheadingIndex;
    protected NSMutableDictionary _indexDict;
    protected NSMutableDictionary _currentZCriteria = new NSMutableDictionary();
    protected NSArray _recordGroupDisplayTypes;
    protected NSArray _reportStyles;
    protected String _selectedReportStyle;
    protected String _selectedRecordGroupDisplayType;
    protected String _recordGroupTotalToShow;
    protected String _recordGroupTotalFormat;
    protected Boolean _showRecordGroupAsTable;
    protected Boolean _showRecordGroupHeadings;
    protected Boolean _showPresentationControls;
    protected Boolean _showEditing;
    protected String _componentName;
    protected Boolean _showNavigation;
    protected NSArray _colorDict = null;
    protected Boolean _showCustomReportStyle;
    protected boolean _initializedDimensionArrayFromBindings = false;
    protected Boolean _showTopCriteriaLabel;
    protected Boolean _shouldTotalCheck;

    public WRReport(WOContext c) {
        super(c);
        this._indexDict = new NSMutableDictionary();
        this._recordGroupDisplayTypes = new NSArray(new Object[]{"SINGLE_TOTAL", "TABLE", "TOTALS"});
        this._reportStyles = new NSArray(new Object[]{"VERTICAL_ROWS", "NESTED_CELLS"});
        NSSelector rebuildModelSelector = new NSSelector("rebuildModel", ERXConstant.NotificationClassArray);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, rebuildModelSelector, "DRReportModelRebuild", null);
    }

    public Object recordGroupTest() {
        throw new IllegalStateException("There is a component bound to this variable and it doesn't exist.  If you need this component to work, please look at what this is supposed to do and submit a patch.");
    }

    public void finalize() throws Throwable {
        NSNotificationCenter.defaultCenter().removeObserver((Object)this);
        super.finalize();
    }

    public Boolean booleanValueForBinding(String name) {
        boolean flag = ERXValueUtilities.booleanValue((Object)this.valueForBinding(name));
        return flag ? Boolean.TRUE : Boolean.FALSE;
    }

    public NSArray recordGroupDisplayTypes() {
        return this._recordGroupDisplayTypes;
    }

    public NSArray reportStyles() {
        return this._reportStyles;
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public void initializeDimensionArrayFromBindings() {
        if (!this._initializedDimensionArrayFromBindings) {
            if (this.model() != null) {
                this._initializedDimensionArrayFromBindings = true;
                this.initializeDimensionArrayFromBindings("H");
                this.initializeDimensionArrayFromBindings("V");
                this.initializeDimensionArrayFromBindings("Z");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("V :" + this.model().vList()));
                    log.debug((Object)("H :" + this.model().hList()));
                    log.debug((Object)("Z :" + this.model().zList()));
                }
            } else {
                log.error((Object)"Model is null!");
            }
        }
    }

    public void awake() {
        this._model = null;
        this._vheadingIndex = 0;
        this._indexDict.removeAllObjects();
        this._colorDict = null;
        this._showPresentationControls = null;
        this._showRecordGroupHeadings = null;
        this._showTopCriteriaLabel = null;
        this._shouldTotalCheck = null;
        this._recordGroupTotalToShow = null;
        this._currentZCriteria.removeAllObjects();
        this.initializeDimensionArrayFromBindings();
    }

    public void takeValuesFromRequest(WORequest r, WOContext c) {
        super.takeValuesFromRequest(r, c);
    }

    public void appendToResponse(WOResponse r, WOContext c) {
        this.initializeDimensionArrayFromBindings();
        super.appendToResponse(r, c);
    }

    public void rebuildModel(NSNotification notification) {
        if (this._model != null && this._model == notification.object()) {
            log.debug((Object)("rebuildModel: " + notification.object().hashCode() + ": " + this._model.hashCode()));
            this._currentZCriteria.removeAllObjects();
            this._initializedDimensionArrayFromBindings = false;
            this._model = null;
        }
    }

    public boolean showPresentationControls() {
        if (this._showPresentationControls == null) {
            this._showPresentationControls = this.booleanValueForBinding("showPresentationControls");
        }
        return this._showPresentationControls;
    }

    public void setShowPresentationControls(boolean v) {
        this._showPresentationControls = v ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setShouldTotalCheck(boolean shouldTotalCheck) {
        this._shouldTotalCheck = shouldTotalCheck;
    }

    public boolean shouldTotalCheck() {
        if (this._shouldTotalCheck == null) {
            this._shouldTotalCheck = this.booleanValueForBinding("shouldTotalCheck");
        }
        return this._shouldTotalCheck;
    }

    public NSDictionary currentZCriteria() {
        return this._currentZCriteria;
    }

    public String selectedRecordGroupDisplayType() {
        if (this._selectedRecordGroupDisplayType == null) {
            this._selectedRecordGroupDisplayType = (String)this.valueForBinding("selectedRecordGroupDisplayType");
            if (this._selectedRecordGroupDisplayType == null) {
                this._selectedRecordGroupDisplayType = "TOTALS";
            }
        }
        return this._selectedRecordGroupDisplayType;
    }

    public void setSelectedRecordGroupDisplayType(String v) {
        this._selectedRecordGroupDisplayType = v;
    }

    public String selectedReportStyle() {
        if (this._selectedReportStyle == null) {
            this._selectedReportStyle = (String)this.valueForBinding("selectedReportStyle");
            if (this._selectedReportStyle == null) {
                this._selectedReportStyle = "NESTED_CELLS";
            }
        }
        return this._selectedReportStyle;
    }

    public void setSelectedReportStyle(String v) {
        this._selectedReportStyle = v;
    }

    public boolean showVerticalRows() {
        return this.selectedReportStyle().equals("VERTICAL_ROWS") && !this.showRecordGroupAsTable() && this.selectedRecordGroupDisplayType().equals("TABLE");
    }

    public String recordGroupTotalToShow() {
        if (this._recordGroupTotalToShow == null) {
            this._recordGroupTotalToShow = (String)this.valueForBinding("recordGroupTotalToShow");
            if (this._recordGroupTotalToShow == null) {
                this._recordGroupTotalToShow = "description";
            }
        }
        return this._recordGroupTotalToShow;
    }

    public void setRecordGroupTotalToShow(String v) {
        this._recordGroupTotalToShow = v;
    }

    public String recordGroupTotalFormat() {
        if (this._recordGroupTotalFormat == null) {
            this._recordGroupTotalFormat = (String)this.valueForBinding("recordGroupTotalFormat");
            if (this._recordGroupTotalFormat == null) {
                this._recordGroupTotalFormat = "#,###0.00;;-#,###0.00";
            }
        }
        return this._recordGroupTotalFormat;
    }

    public void setRecordGroupTotalFormat(String v) {
        this._recordGroupTotalFormat = v;
    }

    public boolean showDefaultReportStyle() {
        return this.showCustomReportStyle();
    }

    public boolean showCustomReportStyle() {
        if (this._showCustomReportStyle == null) {
            this._showCustomReportStyle = this.booleanValueForBinding("showCustomReportStyle");
        }
        return this._showCustomReportStyle;
    }

    public void setShowCustomReportStyle(boolean v) {
        this._showCustomReportStyle = v ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean showRecordGroupHeadings() {
        if (this._showRecordGroupHeadings == null) {
            this._showRecordGroupHeadings = !this.hasBinding("showRecordGroupHeadings") ? Boolean.TRUE : this.booleanValueForBinding("showRecordGroupHeadings");
        }
        return this._showRecordGroupHeadings;
    }

    public void setShowRecordGroupHeadings(boolean v) {
        this._showRecordGroupHeadings = v ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean showRecordGroupAsTable() {
        if (this._showRecordGroupAsTable == null) {
            this._showRecordGroupAsTable = !this.hasBinding("showRecordGroupAsTable") ? Boolean.FALSE : this.booleanValueForBinding("showRecordGroupAsTable");
        }
        return this._showRecordGroupAsTable;
    }

    public void setShowRecordGroupAsTable(boolean v) {
        this._showRecordGroupAsTable = v ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean showTotalsOnlyAsCells() {
        return this.selectedRecordGroupDisplayType().equals("TOTALS") && !this.showRecordGroupAsTable();
    }

    public String componentName() {
        if (this._componentName == null) {
            this._componentName = (String)this.valueForBinding("recordGroupComponentName");
            if (this._componentName == null) {
                this._componentName = "WRRecordGroup";
            }
        }
        return this._componentName;
    }

    public boolean showAsCells() {
        return !this.showRecordGroupAsTable() && !this.selectedRecordGroupDisplayType().equals("SINGLE_TOTAL") && !this.selectedRecordGroupDisplayType().equals("TABLE");
    }

    public boolean showEditing() {
        if (this._showEditing == null) {
            this._showEditing = this.booleanValueForBinding("showEditing");
        }
        return this._showEditing;
    }

    public boolean showNavigation() {
        if (this._showNavigation == null) {
            this._showNavigation = this.booleanValueForBinding("showNavigation");
        }
        return this._showNavigation;
    }

    public void setShowNavigation(boolean v) {
        this._showNavigation = v ? Boolean.TRUE : Boolean.FALSE;
    }

    public DRReportModel model() {
        if (this._model == null) {
            this._model = (DRReportModel)this.valueForBinding("model");
        }
        return this._model;
    }

    public boolean showSingleRow() {
        return this.model().vList().count() <= 0;
    }

    public boolean showSingleCol() {
        return this.model().hList().count() <= 0;
    }

    public boolean showNoColNoRow() {
        return this.showSingleRow() && this.showSingleCol();
    }

    public NSArray zDimensions() {
        return this.model().zList();
    }

    public NSArray horzDimensions() {
        return this.model().hList();
    }

    public NSArray vertDimensions() {
        return this.model().vList();
    }

    public NSArray topHorzGroupCriteriaList() {
        NSArray hList = this.model().hList();
        if (hList.count() > 0) {
            DRGroup group = (DRGroup)hList.objectAtIndex(0);
            NSArray sortedCriteriaList = group.sortedCriteriaList();
            return sortedCriteriaList;
        }
        return NSArray.EmptyArray;
    }

    public NSArray topVertGroupCriteriaList() {
        NSArray arr = this.model().vList();
        if (arr.count() > 0) {
            DRGroup grp = (DRGroup)arr.objectAtIndex(0);
            return grp.sortedCriteriaList();
        }
        return NSArray.EmptyArray;
    }

    public int colSpanForHorzList() {
        return this.model().spanForVListIndexAsCellsShowHeadingShowTotals(false, this.currentLevel - 1, this.showAsCells(), this.showRecordGroupHeadings(), this.selectedRecordGroupDisplayType().equals("TOTALS"));
    }

    public int horzColSpan() {
        return this.colSpanForHorzList();
    }

    public boolean hasTitle() {
        return this.title() != null;
    }

    public String title() {
        return (String)this.valueForBinding("title");
    }

    public NSArray vertSubList() {
        DRMasterCriteria bottomMasterCrit;
        DRMasterCriteria masterCritForCrit = this.topCriteriaV().masterCriteria();
        DRGroup drg = (DRGroup)this.model().vList().lastObject();
        if (drg != null && masterCritForCrit.equals(bottomMasterCrit = drg.masterCriteria())) {
            return null;
        }
        DRGroup innerGroup = (DRGroup)this.model().vList().objectAtIndex(this.currentLevelV - 1);
        return innerGroup.sortedCriteriaList();
    }

    public DRCriteria topCriteria() {
        return this._topCriteria;
    }

    public void setTopCriteria(DRCriteria c) {
        String ky;
        if (c != null && (ky = c.masterCriteria().label()) != null) {
            this._currentZCriteria.setObjectForKey((Object)c, (Object)ky);
        }
        this._topCriteria = c;
    }

    public NSArray horzSubList() {
        DRMasterCriteria masterCritForCrit = this.topCriteria().masterCriteria();
        if (masterCritForCrit.equals(this.hGroup.masterCriteria())) {
            return null;
        }
        DRGroup innerGroup = (DRGroup)this.model().hList().objectAtIndex(this.currentLevel - 1);
        return innerGroup.sortedCriteriaList();
    }

    public NSArray horzSubList2() {
        DRGroup grp;
        DRMasterCriteria bottomMasterCrit;
        DRMasterCriteria masterCritForCrit = this.topCriteria().masterCriteria();
        if (masterCritForCrit.equals(bottomMasterCrit = (grp = (DRGroup)this.model().hList().lastObject()).masterCriteria())) {
            return null;
        }
        DRGroup innerGroup = (DRGroup)this.model().hList().objectAtIndex(this.currentLevel - 1);
        return innerGroup.sortedCriteriaList();
    }

    public void initializeDimensionArrayFromBindings(String dimension) {
        NSArray keypaths = ERXValueUtilities.arrayValue((Object)this.valueForBinding("keysIn" + dimension));
        if (keypaths != null && keypaths.count() > 0) {
            Enumeration en = keypaths.objectEnumerator();
            while (en.hasMoreElements()) {
                String keypath = (String)en.nextElement();
                DRMasterCriteria crit = this.model().masterCriteriaForKeyPath(keypath);
                if (crit != null) {
                    DRGroup group = this.model().groupForMasterCriteria(crit);
                    if ("Z".equals(dimension)) {
                        this.model().addToZList(group);
                        continue;
                    }
                    if ("H".equals(dimension)) {
                        this.model().addToHList(group);
                        continue;
                    }
                    if (!"V".equals(dimension)) continue;
                    this.model().addToVList(group);
                    continue;
                }
                log.warn((Object)("Criteria not found: " + keypath));
            }
        }
    }

    public NSDictionary addCoordsFrom(NSMutableDictionary currCritDict) {
        NSMutableDictionary dict = new NSMutableDictionary();
        Enumeration en = this.model().groups().objectEnumerator();
        while (en.hasMoreElements()) {
            DRGroup grp = (DRGroup)en.nextElement();
            DRMasterCriteria dmc = grp.masterCriteria();
            DRCriteria crt = (DRCriteria)currCritDict.objectForKey((Object)dmc.label());
            if (crt == null) continue;
            dict.setObjectForKey((Object)crt, (Object)dmc.keyDesc());
            if (!crt.isTotal()) continue;
            NSMutableDictionary d = (NSMutableDictionary)dict.objectForKey((Object)"isTotal");
            if (d == null) {
                d = new NSMutableDictionary();
                dict.setObjectForKey((Object)d, (Object)"isTotal");
            }
            d.setObjectForKey((Object)"true", (Object)dmc.keyDesc());
        }
        return dict;
    }

    public NSDictionary currentCoordinates() {
        NSDictionary dict = this.addCoordsFrom(this._currentZCriteria);
        return dict;
    }

    public DRRecordGroup recordGroup() {
        NSDictionary crds = this.currentCoordinates();
        DRRecordGroup drg = this.model().recordGroupForCoordinates(crds);
        return drg;
    }

    public DRCriteria topCriteriaV() {
        return this._topCriteriaV;
    }

    public void setTopCriteriaV(DRCriteria c) {
        String ky;
        if (c != null && (ky = c.masterCriteria().label()) != null) {
            this._currentZCriteria.setObjectForKey((Object)c, (Object)ky);
        }
        this._topCriteriaV = c;
    }

    public String topCriteriaVLabel() {
        return this.topCriteriaV().label();
    }

    public int vheadingCount() {
        return this.model().vList().count() - 1;
    }

    public int vheadingIndex() {
        return this._vheadingIndex;
    }

    public void setVheadingIndex(int indx) {
        this._vheadingIndex = indx;
    }

    public int vertRowSpan() {
        return this.model().spanForVListIndexAsCellsShowHeadingShowTotals(true, this.vheadingIndex(), !this.showRecordGroupAsTable(), this.showRecordGroupHeadings(), this.selectedRecordGroupDisplayType().equals("TOTALS"));
    }

    public boolean showIndentCell() {
        int oldCnt;
        Number oldCount = (Number)this._indexDict.objectForKey((Object)new Integer(this.vheadingIndex()));
        if (oldCount == null) {
            oldCnt = 0;
        } else {
            int span = this.model().spanForVListIndexAsCellsShowHeadingShowTotals(true, this.vheadingIndex(), !this.showRecordGroupAsTable(), this.showRecordGroupHeadings(), this.selectedRecordGroupDisplayType().equals("TOTALS"));
            oldCnt = oldCount.intValue();
            if (++oldCnt > span - 1) {
                oldCnt = 0;
            }
        }
        this._indexDict.setObjectForKey((Object)new Integer(oldCnt), (Object)new Integer(this.vheadingIndex()));
        return oldCnt == 0;
    }

    public String vIndentCriteriaLabel() {
        DRGroup grp = (DRGroup)this.model().vList().objectAtIndex(this.vheadingIndex());
        String ky = grp.masterCriteria().label();
        DRCriteria crt = (DRCriteria)this._currentZCriteria.objectForKey((Object)ky);
        return crt.label();
    }

    public WOComponent regenReport() {
        return null;
    }

    public int numberOfCrits() {
        int nm = 1;
        Enumeration en = this.model().hList().objectEnumerator();
        while (en.hasMoreElements()) {
            DRGroup grp = (DRGroup)en.nextElement();
            nm *= grp.sortedCriteriaList().count();
        }
        return nm;
    }

    public boolean showHeadersForAsCells() {
        return this.showRecordGroupHeadings() && this.showTotalsOnlyAsCells();
    }

    public NSDictionary attributeListDict() {
        return this.model().flatAttributeListTotalDict();
    }

    public int depthCount() {
        return this.attributeListDict().allKeys().count();
    }

    public int colspanAddition() {
        int count = this.model().vList().count();
        return count - this.currentLevelV;
    }

    public int depthCountAllAttribs() {
        return this.model().flatAttributeList().count() + this.model().vList().count() - this.vheadingIndex();
    }

    public int indentCellCount() {
        return this.currentLevelV;
    }

    public boolean showVHeadings() {
        return this.vheadingIndex() == 0;
    }

    public NSArray attributeListAtDepth() {
        Integer ky = new Integer(this.depth);
        NSArray a = (NSArray)this.attributeListDict().objectForKey((Object)ky);
        return a;
    }

    public int colSpan() {
        int cls = this.attrib.flatAttributesTotal().count();
        if (this.attrib.showTotal()) {
            ++cls;
        }
        return cls == 0 ? 1 : cls;
    }

    public int rowSpan() {
        int rs = 1;
        if (!this.attrib.isGroup()) {
            rs = this.depthCount() - this.depth;
        }
        return rs;
    }

    public String attribLabel() {
        return this.attrib.label();
    }

    public String idAttributeTd() {
        String id = this.attrib.keyPath();
        id = ERXStringUtilities.escapeNonXMLChars((String)id);
        return id;
    }

    public DRAttribute attrib() {
        return this.attrib;
    }

    public void setAttrib(DRAttribute at) {
        this.attrib = at;
    }

    public DRGroup aGrp() {
        return this.aGrp;
    }

    public void setAGrp(DRGroup gp) {
        this.aGrp = gp;
    }

    public NSDictionary totalDict() {
        NSDictionary dict = this.currentCoordinates();
        NSDictionary totalDict = (NSDictionary)dict.objectForKey((Object)"isTotal");
        return totalDict;
    }

    public int totalCount() {
        NSDictionary totalDict = this.totalDict();
        if (totalDict == null) {
            return 0;
        }
        int totalCount = totalDict.allKeys().count();
        return totalCount;
    }

    public String colorForCoords() {
        int maxColorsConfigured;
        int totalCount = this.totalCount();
        if (totalCount == (maxColorsConfigured = this.colorDict().count())) {
            return "#eeeeee";
        }
        if (totalCount > maxColorsConfigured) {
            return "#ffffff";
        }
        return (String)this.colorDict().objectAtIndex(totalCount);
    }

    public String bgcolorRowSpanTd() {
        return this.colorForCoords();
    }

    public String bgcolorColSpanTd() {
        return this.colorForCoords();
    }

    public String classAttributeTd() {
        return "WRAttribute" + this.depth + "Total" + this.totalCount();
    }

    public String classColSpanTd() {
        return "WRHTotal" + this.totalCount();
    }

    public String classRowSpanTd() {
        return "WRVTotal" + this.totalCount();
    }

    public NSArray colorDict() {
        if (this._colorDict == null) {
            if (this.hasBinding("colors")) {
                this._colorDict = (NSArray)this.valueForBinding("colors");
            }
            if (this._colorDict == null) {
                this._colorDict = new NSArray(new Object[]{"#c6c3af", "#b7af4b", "#d5ba27", "#ffec00"});
            }
        }
        return this._colorDict;
    }

    public int vheadingCount2() {
        return this.model().vList().count();
    }

    public boolean showTopCriteriaLabel() {
        if (this._showTopCriteriaLabel == null) {
            this._showTopCriteriaLabel = !this.hasBinding("showTopCriteriaLabel") ? Boolean.TRUE : this.booleanValueForBinding("showTopCriteriaLabel");
        }
        return this._showTopCriteriaLabel;
    }
}

