/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSCollectionEnumerator;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSFoundationCollection;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSDictionary<K, V>
implements Cloneable,
Serializable,
NSCoding,
NSKeyValueCoding,
NSKeyValueCodingAdditions,
_NSFoundationCollection,
Map<K, V> {
    public static final Class _CLASS = _NSUtilitiesExtra._classWithFullySpecifiedNamePrime((String)"com.webobjects.foundation.NSDictionary");
    public static final Class _MAP_ENTRY_CLASS = _NSUtilitiesExtra._classWithFullySpecifiedNamePrime((String)"com.webobjects.foundation.NSDictionary$_JavaNSDictionaryMapEntry");
    public static final NSDictionary EmptyDictionary = new NSDictionary();
    static final long serialVersionUID = 2886170486405617806L;
    private static final String SerializationKeysFieldKey = "keys";
    private static final String SerializationValuesFieldKey = "objects";
    private static final Class<?> _objectArrayClass = new Object[0].getClass();
    protected transient int _capacity;
    protected transient int _hashtableBuckets;
    protected transient int _count;
    protected Object[] _objects;
    protected transient Object[] _objectsCache;
    protected transient byte[] _flags;
    protected Object[] _keys;
    protected transient Object[] _keysCache;
    protected transient int _hashCache;
    protected transient int _deletionLimit;
    protected static int _NSDictionaryClassHashCode = _CLASS.hashCode();
    protected static int _NSDictionaryMapEntryHashCode = _MAP_ENTRY_CLASS.hashCode();
    protected Set<K> _keySetCache;
    protected Set<Map.Entry<K, V>> _entrySetCache;
    public static final boolean CheckForNull = true;
    public static final boolean IgnoreNull = true;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("keys", _objectArrayClass), new ObjectStreamField("objects", _objectArrayClass)};

    private void _copyImmutableDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
        this._capacity = otherDictionary._capacity;
        this._count = otherDictionary._count;
        this._hashtableBuckets = otherDictionary._hashtableBuckets;
        this._hashCache = otherDictionary._hashCache;
        this._objects = otherDictionary._objects;
        this._objectsCache = otherDictionary._objectsCache;
        this._entrySetCache = null;
        this._flags = otherDictionary._flags;
        this._keys = otherDictionary._keys;
        this._keysCache = otherDictionary._keysCache;
        this._deletionLimit = otherDictionary._deletionLimit;
    }

    void _copyMutableDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
        this._capacity = otherDictionary._capacity;
        this._count = otherDictionary._count;
        this._hashtableBuckets = otherDictionary._hashtableBuckets;
        this._hashCache = otherDictionary._hashCache;
        this._objects = _NSCollectionPrimitives.copyArray((Object[])otherDictionary._objects);
        this._objectsCache = null;
        this._entrySetCache = null;
        this._flags = _NSCollectionPrimitives.copyArray((byte[])otherDictionary._flags);
        this._keys = _NSCollectionPrimitives.copyArray((Object[])otherDictionary._keys);
        this._keysCache = null;
        this._deletionLimit = otherDictionary._deletionLimit;
    }

    protected void _initializeDictionary() {
        this._count = 0;
        this._capacity = 0;
        this._objectsCache = null;
        this._objects = null;
        this._entrySetCache = null;
        this._flags = null;
        this._keysCache = null;
        this._keys = null;
        this._hashtableBuckets = _NSCollectionPrimitives.hashTableBucketsForCapacity((int)this._capacity);
        this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets((int)this._hashtableBuckets);
        this._keySetCache = null;
        this._entrySetCache = null;
    }

    protected void _ensureCapacity(int capacity) {
        int newCapacity;
        int currentCapacity = this._capacity;
        if (capacity > currentCapacity && (newCapacity = _NSCollectionPrimitives.hashTableCapacityForCapacity((int)capacity)) != currentCapacity) {
            int newSize;
            int oldSize = this._hashtableBuckets;
            this._hashtableBuckets = newSize = _NSCollectionPrimitives.hashTableBucketsForCapacity((int)newCapacity);
            if (newSize == 0) {
                this._objects = null;
                this._keys = null;
                this._flags = null;
            } else {
                Object[] oldObjects = this._objects;
                Object[] oldKeys = this._keys;
                byte[] oldFlags = this._flags;
                Object[] newObjects = new Object[newSize];
                Object[] newKeys = new Object[newSize];
                byte[] newFlags = new byte[newSize];
                for (int i = 0; i < oldSize; ++i) {
                    if ((oldFlags[i] & 0xFFFFFFC0) != -128) continue;
                    _NSCollectionPrimitives.addValueInHashTable((Object)oldKeys[i], (Object)oldObjects[i], (Object[])newKeys, (Object[])newObjects, (byte[])newFlags);
                }
                this._objects = newObjects;
                this._keys = newKeys;
                this._flags = newFlags;
            }
            this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets((int)newSize);
            this._capacity = newCapacity;
        }
    }

    protected void _clearDeletionsAndCollisions() {
        int size = this._hashtableBuckets;
        if (this._count == 0) {
            this._flags = new byte[size];
        } else {
            Object[] oldObjects = this._objects;
            Object[] oldKeys = this._keys;
            byte[] oldFlags = this._flags;
            Object[] newObjects = new Object[size];
            Object[] newKeys = new Object[size];
            byte[] newFlags = new byte[size];
            for (int i = 0; i < size; ++i) {
                if ((oldFlags[i] & 0xFFFFFFC0) != -128) continue;
                _NSCollectionPrimitives.addValueInHashTable((Object)oldKeys[i], (Object)oldObjects[i], (Object[])newKeys, (Object[])newObjects, (byte[])newFlags);
            }
        }
        this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets((int)size);
    }

    public NSDictionary() {
        this._initializeDictionary();
    }

    public NSDictionary(V object, K key) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null object into an  " + this.getClass().getName() + ".");
        }
        if (key == null) {
            throw new IllegalArgumentException("Attempt to insert null key into an  " + this.getClass().getName() + ".");
        }
        this._initializeDictionary();
        this._ensureCapacity(1);
        if (_NSCollectionPrimitives.addValueInHashTable(key, object, (Object[])this._keys, (Object[])this._objects, (byte[])this._flags)) {
            ++this._count;
        }
    }

    private void initFromKeyValues(Object[] objects, Object[] keys, boolean checkForNull) {
        if (objects != null && keys != null) {
            int i;
            if (objects.length != keys.length) {
                throw new IllegalArgumentException("Attempt to create an " + this.getClass().getName() + " with a different number of objects and keys.");
            }
            if (checkForNull) {
                for (i = 0; i < objects.length; ++i) {
                    if (objects[i] == null) {
                        throw new IllegalArgumentException("Attempt to insert null object into an  " + this.getClass().getName() + ".");
                    }
                    if (keys[i] != null) continue;
                    throw new IllegalArgumentException("Attempt to insert null key into an  " + this.getClass().getName() + ".");
                }
            }
            this._initializeDictionary();
            this._ensureCapacity(objects.length);
            for (i = 0; i < objects.length; ++i) {
                if (!_NSCollectionPrimitives.addValueInHashTable((Object)keys[i], (Object)objects[i], (Object[])this._keys, (Object[])this._objects, (byte[])this._flags)) continue;
                ++this._count;
            }
        } else if (objects == null && keys == null) {
            this._initializeDictionary();
        } else {
            throw new IllegalArgumentException("Either objects and keys cannot be null");
        }
    }

    private NSDictionary(V[] objects, K[] keys, boolean checkForNull) {
        this.initFromKeyValues(objects, keys, checkForNull);
    }

    public NSDictionary(V[] objects, K[] keys) {
        this(objects, keys, true);
    }

    public NSDictionary(NSArray<? extends V> objects, NSArray<? extends K> keys) {
        this(objects == null ? null : objects.objectsNoCopy(), keys == null ? null : keys.objectsNoCopy(), false);
    }

    public NSDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
        if (otherDictionary.getClass() == _CLASS) {
            this._copyImmutableDictionary(otherDictionary);
        } else {
            this._copyMutableDictionary(otherDictionary);
        }
    }

    public NSDictionary(Map<? extends K, ? extends V> map) {
        this(map, false);
    }

    public NSDictionary(Map<? extends K, ? extends V> map, boolean ignoreNull) {
        this._initializeDictionary();
        if (map != null) {
            this._ensureCapacity(map.size());
            Set<K> keySet = map.keySet();
            for (K key : keySet) {
                V object = map.get(key);
                if (key == null) {
                    if (ignoreNull) continue;
                    throw new IllegalArgumentException("Attempt to insert null key into an  " + this.getClass().getName() + ".");
                }
                if (object == null) {
                    if (ignoreNull) continue;
                    throw new IllegalArgumentException("Attempt to insert null value into an  " + this.getClass().getName() + ".");
                }
                if (!_NSCollectionPrimitives.addValueInHashTable(key, object, (Object[])this._keys, (Object[])this._objects, (byte[])this._flags)) continue;
                ++this._count;
            }
        } else {
            throw new NullPointerException("map cannot be null");
        }
    }

    public NSDictionary(Dictionary<? extends K, ? extends V> dictionary, boolean ignoreNull) {
        this._initializeDictionary();
        if (dictionary != null) {
            this._ensureCapacity(dictionary.size());
            Enumeration<K> enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                K key = enumeration.nextElement();
                V object = dictionary.get(key);
                if (key == null) {
                    if (ignoreNull) continue;
                    throw new IllegalArgumentException("Attempt to insert null key into an  " + this.getClass().getName() + ".");
                }
                if (object == null) {
                    if (ignoreNull) continue;
                    throw new IllegalArgumentException("Attempt to insert null value into an  " + this.getClass().getName() + ".");
                }
                if (!_NSCollectionPrimitives.addValueInHashTable(key, object, (Object[])this._keys, (Object[])this._objects, (byte[])this._flags)) continue;
                ++this._count;
            }
        }
    }

    protected Object[] keysNoCopy() {
        if (this._keysCache == null) {
            this._keysCache = this._count != 0 ? _NSCollectionPrimitives.keysInHashTable((Object[])this._keys, (Object[])this._objects, (byte[])this._flags, (int)this._capacity, (int)this._hashtableBuckets) : _NSCollectionPrimitives.EmptyArray;
        }
        return this._keysCache;
    }

    protected Object[] objectsNoCopy() {
        if (this._objectsCache == null) {
            this._objectsCache = this._count != 0 ? _NSCollectionPrimitives.valuesInHashTable((Object[])this._keys, (Object[])this._objects, (byte[])this._flags, (int)this._capacity, (int)this._hashtableBuckets) : _NSCollectionPrimitives.EmptyArray;
            this._entrySetCache = null;
        }
        return this._objectsCache;
    }

    public int count() {
        return this._count;
    }

    public V objectForKey(Object key) {
        return (V)(this._count != 0 && key != null ? _NSCollectionPrimitives.findValueInHashTable((Object)key, (Object[])this._keys, (Object[])this._objects, (byte[])this._flags) : null);
    }

    public Hashtable<K, V> hashtable() {
        Object[] keys = this.keysNoCopy();
        int c = keys.length;
        Hashtable<Object, V> hashtable = new Hashtable<Object, V>(c <= 0 ? 1 : c);
        for (int i = 0; i < c; ++i) {
            hashtable.put(keys[i], this.objectForKey(keys[i]));
        }
        return hashtable;
    }

    public HashMap<K, V> hashMap() {
        Object[] keys = this.keysNoCopy();
        int c = keys.length;
        HashMap<Object, V> map = new HashMap<Object, V>(c <= 0 ? 1 : c);
        for (int i = 0; i < c; ++i) {
            map.put(keys[i], this.objectForKey(keys[i]));
        }
        return map;
    }

    public NSArray<K> allKeysForObject(Object object) {
        if (object != null) {
            Object[] keys = this.keysNoCopy();
            NSMutableArray<int> array = new NSMutableArray<int>(keys.length);
            for (int i = 0; i < keys.length; ++i) {
                V compareObject = this.objectForKey(keys[i]);
                if (object != compareObject && !object.equals(compareObject)) continue;
                array.addObject((int)keys[i]);
            }
            return array;
        }
        return NSArray.EmptyArray;
    }

    public NSArray<V> objectsForKeys(NSArray<? extends K> keys, V notFoundMarker) {
        if (keys != null) {
            Object[] keysArray = keys.objectsNoCopy();
            NSMutableArray<int> array = new NSMutableArray<int>(keysArray.length);
            for (int i = 0; i < keysArray.length; ++i) {
                V object = this.objectForKey(keysArray[i]);
                if (object != null) {
                    array.addObject((int)object);
                    continue;
                }
                if (notFoundMarker == null) continue;
                array.addObject((int)notFoundMarker);
            }
            return array;
        }
        return NSArray.EmptyArray;
    }

    private boolean _equalsDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
        int count = this.count();
        if (count != otherDictionary.count()) {
            return false;
        }
        Object[] keys = this.keysNoCopy();
        for (int i = 0; i < count; ++i) {
            V value = this.objectForKey(keys[i]);
            V otherValue = otherDictionary.objectForKey(keys[i]);
            if (otherValue != null && value.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualToDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
        if (otherDictionary == null) {
            return false;
        }
        if (otherDictionary == this) {
            return true;
        }
        return this._equalsDictionary(otherDictionary);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NSDictionary) {
            return this._equalsDictionary((NSDictionary)object);
        }
        return false;
    }

    public NSArray<K> allKeys() {
        return new NSArray<Object>(this.keysNoCopy());
    }

    public NSArray<V> allValues() {
        return new NSArray<Object>(this.objectsNoCopy());
    }

    public Enumeration<K> keyEnumerator() {
        return new _NSCollectionEnumerator(this._keys, this._flags, this._count);
    }

    public Enumeration<V> objectEnumerator() {
        return new _NSCollectionEnumerator(this._objects, this._flags, this._count);
    }

    public Object valueForKey(String key) {
        V value = this.objectForKey(key);
        if (value == null && key != null) {
            if (key.equals("allValues")) {
                return this.allValues();
            }
            if (key.equals("allKeys")) {
                return this.allKeys();
            }
            if (key.equals("count")) {
                return _NSUtilities.IntegerForInt((int)this.count());
            }
        }
        return value;
    }

    public void takeValueForKey(Object value, String key) {
        throw new IllegalStateException(this.getClass().getName() + " is immutable.");
    }

    public Object valueForKeyPath(String keyPath) {
        V flattenedKeyPresent = this.objectForKey(keyPath);
        if (flattenedKeyPresent != null) {
            return flattenedKeyPresent;
        }
        return NSKeyValueCodingAdditions.DefaultImplementation.valueForKeyPath((Object)this, (String)keyPath);
    }

    public void takeValueForKeyPath(Object value, String keyPath) {
        NSKeyValueCodingAdditions.DefaultImplementation.takeValueForKeyPath((Object)this, (Object)value, (String)keyPath);
    }

    public Class classForCoder() {
        return _CLASS;
    }

    public static final <K, V> NSDictionary<K, V> emptyDictionary() {
        return EmptyDictionary;
    }

    public static Object decodeObject(NSCoder coder) {
        int count = coder.decodeInt();
        Object[] keys = new Object[count];
        Object[] objects = new Object[count];
        for (int i = 0; i < count; ++i) {
            keys[i] = coder.decodeObject();
            objects[i] = coder.decodeObject();
        }
        return new NSDictionary<Object, Object>(objects, keys);
    }

    public void encodeWithCoder(NSCoder coder) {
        int count = this.count();
        coder.encodeInt(count);
        if (count > 0) {
            Object[] keys = this.keysNoCopy();
            for (int i = 0; i < keys.length; ++i) {
                coder.encodeObject(keys[i]);
                coder.encodeObject(this.objectForKey(keys[i]));
            }
        }
    }

    public int _shallowHashCode() {
        return _NSDictionaryClassHashCode;
    }

    @Override
    public int hashCode() {
        return _NSDictionaryClassHashCode ^ this.count();
    }

    public Object clone() {
        return this;
    }

    public NSDictionary<K, V> immutableClone() {
        return this;
    }

    public NSMutableDictionary<K, V> mutableClone() {
        return new NSMutableDictionary(this);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("{");
        Object[] keys = this.keysNoCopy();
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            V object = this.objectForKey(key);
            buffer.append(key.toString());
            buffer.append(" = ");
            if (object instanceof String) {
                buffer.append('\"');
                buffer.append((String)object);
                buffer.append('\"');
            } else if (object instanceof Boolean) {
                buffer.append((Boolean)object != false ? "true" : "false");
            } else {
                buffer.append(object);
            }
            buffer.append("; ");
        }
        buffer.append("}");
        return new String(buffer);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        Object[] keys = this.keysNoCopy();
        int c = keys.length;
        Object[] values = new Object[c];
        for (int i = 0; i < c; ++i) {
            values[i] = this.objectForKey(keys[i]);
        }
        fields.put(SerializationKeysFieldKey, keys);
        fields.put(SerializationValuesFieldKey, values);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        Object[] keys = (Object[])fields.get(SerializationKeysFieldKey, _NSUtilities._NoObjectArray);
        Object[] values = (Object[])fields.get(SerializationValuesFieldKey, _NSUtilities._NoObjectArray);
        keys = keys != null ? keys : _NSUtilities._NoObjectArray;
        values = values != null ? values : _NSUtilities._NoObjectArray;
        this.initFromKeyValues(values, keys, true);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.getClass() == _CLASS && this.count() == 0) {
            return EmptyDictionary;
        }
        return this;
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return this.count() <= 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.objectForKey(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.allValues().containsObject(value);
    }

    @Override
    public V get(Object key) {
        return this.objectForKey(key);
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException("put is not a supported operation in com.webobjects.foundation.NSDictionary");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("remove is not a supported operation in com.webobjects.foundation.NSDictionary");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException("putAll is not a supported operation in com.webobjects.foundation.NSDictionary");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("putAll is not a supported operation in com.webobjects.foundation.NSDictionary");
    }

    @Override
    public Set<K> keySet() {
        if (this._keySetCache == null) {
            Object[] currKeys = this.keysNoCopy();
            this._keySetCache = currKeys != null && currKeys.length > 0 ? new NSSet<Object>(currKeys) : NSSet.EmptySet;
        }
        return this._keySetCache;
    }

    @Override
    public Collection<V> values() {
        return this.allValues();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this._entrySetCache == null) {
            this._entrySetCache = this._initMapEntrySet();
        }
        return this._entrySetCache;
    }

    private Set<Map.Entry<K, V>> _initMapEntrySet() {
        Object[] keys = this.keysNoCopy();
        int length = keys.length;
        _JavaNSDictionaryMapEntry[] set = new _JavaNSDictionaryMapEntry[length];
        for (int i = 0; i < length; ++i) {
            _JavaNSDictionaryMapEntry<Object, V> current;
            Object key = keys[i];
            V object = this.objectForKey(key);
            set[i] = current = new _JavaNSDictionaryMapEntry<Object, V>(key, object);
        }
        return new NSSet<Map.Entry<K, V>>(set);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class _JavaNSDictionaryMapEntry<P, Q>
    implements Map.Entry<P, Q> {
        Q _entryValue;
        P _entryKey;

        @Override
        public P getKey() {
            return this._entryKey;
        }

        @Override
        public Q getValue() {
            return this._entryValue;
        }

        @Override
        public Q setValue(Q value) {
            return NSDictionary.this.put(this.getKey(), value);
        }

        @Override
        public boolean equals(Object o) {
            return this._entryKey == null && ((Map.Entry)o).getKey() == null && this.getKey().equals(((Map.Entry)o).getKey()) && this.getValue().equals(((Map.Entry)o).getValue());
        }

        @Override
        public int hashCode() {
            return this._entryKey == null ? System.identityHashCode(this) : this._entryKey.hashCode();
        }

        public _JavaNSDictionaryMapEntry(P key, Q value) {
            this._entryKey = key;
            this._entryValue = value;
        }
    }
}

