/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.appserver.ERXBrowser;
import org.apache.log4j.Logger;

public class ERXBasicBrowser
extends ERXBrowser {
    public static final Logger log = Logger.getLogger(ERXBasicBrowser.class);
    private final String _browserName;
    private final String _version;
    private final String _mozillaVersion;
    private final String _platform;
    private final String _cpu;
    private final String _geckoRevision;
    private final NSDictionary _userInfo;
    private final boolean _isRobot;
    private final boolean _isICab;
    private final boolean _isIE;
    private final boolean _isNetscape;
    private final boolean _isOmniWeb;
    private final boolean _isOpera;
    private final boolean _isSafari;
    private final boolean _isFirefox;
    private final boolean _isMozilla;
    private final boolean _isChrome;
    private final boolean _isUnknownBrowser;
    private final boolean _isMozillaVersion50;
    private final boolean _isMozillaVersion45;
    private final boolean _isMozillaVersion40;
    private final boolean _isVersion9;
    private final boolean _isVersion8;
    private final boolean _isVersion7;
    private final boolean _isVersion6;
    private final boolean _isVersion5;
    private final boolean _isVersion51;
    private final boolean _isVersion45;
    private final boolean _isVersion41;
    private final boolean _isVersion40;
    private final boolean _isVersion4;
    private final boolean _isVersion3;
    private final boolean _isVersion2;
    private final boolean _isMacOS;
    private final boolean _isWindows;
    private final boolean _isLinux;
    private final boolean _isIPhone;
    private final boolean _isUnknownPlatform;

    public ERXBasicBrowser(String browserName, String version, String mozillaVersion, String platform, NSDictionary userInfo) {
        if (userInfo instanceof NSMutableDictionary) {
            userInfo = new NSDictionary(userInfo);
        }
        this._userInfo = userInfo != null ? userInfo : null;
        this._browserName = browserName != null ? browserName : "Unknown Browser";
        this._version = version != null ? version : "Unknown Version";
        this._mozillaVersion = mozillaVersion != null ? mozillaVersion : "Unknown Version";
        this._platform = platform != null ? platform : "Unknown Platform";
        String tempCpu = userInfo != null ? (String)userInfo.objectForKey("cpu") : "Unknown CPU";
        this._cpu = tempCpu != null ? tempCpu : "Unknown CPU";
        this._geckoRevision = userInfo != null ? (String)userInfo.objectForKey("geckoRevision") : null;
        this._isRobot = this._browserName.equals("robot");
        this._isICab = this._browserName.equals("iCab");
        this._isIE = this._browserName.equals("IE");
        this._isNetscape = this._browserName.equals("Netscape");
        this._isOmniWeb = this._browserName.equals("OmniWeb");
        this._isOpera = this._browserName.equals("Opera");
        this._isSafari = this._browserName.equals("Safari");
        this._isFirefox = this._browserName.equals("Firefox");
        this._isMozilla = this._browserName.equals("Mozilla") || this._browserName.equals("Firefox");
        this._isChrome = this._browserName.equals("Chrome");
        this._isUnknownBrowser = this._browserName.equals("Unknown Browser");
        this._isMozillaVersion50 = -1 < this._mozillaVersion.indexOf("5.0");
        this._isMozillaVersion45 = -1 < this._mozillaVersion.indexOf("4.5") || -1 < this._mozillaVersion.indexOf("4.6") || -1 < this._mozillaVersion.indexOf("4.7");
        this._isMozillaVersion40 = -1 < this._mozillaVersion.indexOf("4.0");
        this._isVersion9 = -1 < this._version.indexOf("9.");
        this._isVersion8 = -1 < this._version.indexOf("8.");
        this._isVersion7 = -1 < this._version.indexOf("7.");
        this._isVersion6 = -1 < this._version.indexOf("6.");
        this._isVersion5 = -1 < this._version.indexOf("5.");
        this._isVersion51 = -1 < this._version.indexOf("5.1");
        this._isVersion45 = -1 < this._version.indexOf("4.5") || -1 < this._version.indexOf("4.6") || -1 < this._version.indexOf("4.7");
        this._isVersion41 = -1 < this._version.indexOf("4.1");
        this._isVersion40 = -1 < this._version.indexOf("4.0");
        this._isVersion4 = -1 < this._version.indexOf("4.");
        this._isVersion3 = -1 < this._version.indexOf("3.");
        this._isVersion2 = -1 < this._version.indexOf("2.");
        this._isMacOS = this._platform.equals("MacOS");
        this._isWindows = this._platform.equals("Windows");
        this._isLinux = this._platform.equals("Linux");
        this._isIPhone = this._platform.equals("iPhone");
        this._isUnknownPlatform = this._platform.equals("Unknown Platform");
    }

    public String browserName() {
        return this._browserName;
    }

    public String version() {
        return this._version;
    }

    public String mozillaVersion() {
        return this._mozillaVersion;
    }

    public String platform() {
        return this._platform;
    }

    public String cpu() {
        return this._cpu;
    }

    public NSDictionary userInfo() {
        return this._userInfo;
    }

    public boolean isUnknownBrowser() {
        return this._isUnknownBrowser;
    }

    public boolean isRobot() {
        return this._isRobot;
    }

    public boolean isICab() {
        return this._isICab;
    }

    public boolean isIE() {
        return this._isIE;
    }

    public boolean isNetscape() {
        return this._isNetscape;
    }

    public boolean isNotNetscape() {
        return !this._isNetscape;
    }

    public boolean isOmniWeb() {
        return this._isOmniWeb;
    }

    public boolean isOpera() {
        return this._isOpera;
    }

    public boolean isSafari() {
        return this._isSafari;
    }

    public boolean isFirefox() {
        return this._isFirefox;
    }

    public boolean isChrome() {
        return this._isChrome;
    }

    public boolean isMozilla() {
        return this._isMozilla;
    }

    public boolean isMozilla50Compatible() {
        return this._isMozillaVersion50;
    }

    public boolean isMozilla45Compatible() {
        return this._isMozillaVersion45;
    }

    public boolean isMozilla40Compatible() {
        return this._isMozillaVersion40 || this._isMozillaVersion45;
    }

    public boolean isVersion9() {
        return this._isVersion9;
    }

    public boolean isVersion8() {
        return this._isVersion8;
    }

    public boolean isVersion7() {
        return this._isVersion7;
    }

    public boolean isVersion6() {
        return this._isVersion6;
    }

    public boolean isVersion5() {
        return this._isVersion5;
    }

    public boolean isVersion51() {
        return this._isVersion51;
    }

    public boolean isVersion45() {
        return this._isVersion45;
    }

    public boolean isVersion41() {
        return this._isVersion41;
    }

    public boolean isVersion40() {
        return this._isVersion40;
    }

    public boolean isVersion4() {
        return this._isVersion4;
    }

    public boolean isVersion3() {
        return this._isVersion3;
    }

    public boolean isVersion2() {
        return this._isVersion2;
    }

    public boolean isUnknownPlatform() {
        return this._isUnknownPlatform;
    }

    public boolean isMacOS() {
        return this._isMacOS;
    }

    public boolean isWindows() {
        return this._isWindows;
    }

    public boolean isLinux() {
        return this._isLinux;
    }

    public boolean isIPhone() {
        return this._isIPhone;
    }

    public String geckoRevision() {
        return this._geckoRevision;
    }

    public boolean isIFrameSupported() {
        return this.isIE();
    }

    public boolean willRenderNestedTablesFast() {
        return this.isNotNetscape() || this.isMozilla50Compatible();
    }

    public boolean isJavaScriptOnImageButtonSupported() {
        return this.isNotNetscape() || this.isMozilla50Compatible();
    }
}

