/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXThreadStorage;
import org.apache.log4j.Logger;

public class ERXComponentActionRedirector {
    protected static final Logger log = Logger.getLogger(ERXComponentActionRedirector.class);
    protected WOResponse originalResponse;
    protected WOResponse redirectionResponse;
    protected String sessionID;
    protected String url;
    protected static final NSMutableDictionary responses = new NSMutableDictionary();
    private static Observer observer = new Observer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void storeRedirector(ERXComponentActionRedirector redirector) {
        NSMutableDictionary nSMutableDictionary = responses;
        synchronized (nSMutableDictionary) {
            NSMutableDictionary<String, ERXComponentActionRedirector> sessionRef = (NSMutableDictionary<String, ERXComponentActionRedirector>)responses.objectForKey(redirector.sessionID());
            if (sessionRef == null) {
                sessionRef = new NSMutableDictionary<String, ERXComponentActionRedirector>();
                responses.setObjectForKey(sessionRef, redirector.sessionID());
            }
            sessionRef.setObjectForKey(redirector, redirector.url());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stored URL: " + redirector.url()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ERXComponentActionRedirector redirectorForRequest(WORequest request) {
        ERXComponentActionRedirector redirector = null;
        NSMutableDictionary nSMutableDictionary = responses;
        synchronized (nSMutableDictionary) {
            redirector = (ERXComponentActionRedirector)responses.valueForKeyPath(request.sessionID() + "." + request.uri());
        }
        if (redirector != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieved URL: " + redirector.url()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No Redirector for request: " + request.uri()));
        }
        return redirector;
    }

    public static void createRedirector(WOActionResults results) {
        WOComponent component;
        WOContext context;
        ERXThreadStorage.removeValueForKey("redirector");
        if (results instanceof WOComponent && (context = (component = (WOComponent)results).context()).request().requestHandlerKey().equals("wo")) {
            if (component instanceof Restorable) {
                ERXComponentActionRedirector r = new ERXComponentActionRedirector((Restorable)component);
                ERXComponentActionRedirector.storeRedirector(r);
            } else {
                log.debug((Object)("Not restorable: " + context.request().uri() + ", " + component));
            }
        }
    }

    public static ERXComponentActionRedirector currentRedirector() {
        return (ERXComponentActionRedirector)ERXThreadStorage.valueForKey("redirector");
    }

    public ERXComponentActionRedirector(Restorable r) {
        WOComponent component = (WOComponent)r;
        WOContext context = component.context();
        this.sessionID = component.session().sessionID();
        this.url = r.urlForCurrentState();
        if (context.session().storesIDsInURLs()) {
            String argsChar;
            String string = argsChar = this.url.indexOf("?") >= 0 ? "&" : "?";
            if (this.url.indexOf("wosid=") < 0) {
                this.url = this.url + argsChar + "wosid=" + this.sessionID;
                argsChar = "&";
            }
            if (this.url.indexOf("wocid=") < 0) {
                this.url = this.url + argsChar + "wocid=" + context.contextID();
            }
        }
        this.redirectionResponse = WOApplication.application().createResponseInContext(context);
        this.redirectionResponse.setHeader(this.url, "location");
        this.redirectionResponse.setStatus(302);
        ERXThreadStorage.takeValueForKey(this, "redirector");
    }

    public WOResponse redirectionResponse() {
        return this.redirectionResponse;
    }

    public String url() {
        return this.url;
    }

    public String sessionID() {
        return this.sessionID;
    }

    public WOResponse originalResponse() {
        return this.originalResponse;
    }

    public void setOriginalResponse(WOResponse value) {
        this.originalResponse = value;
    }

    public static class Observer {
        protected Observer() {
            NSSelector sel = new NSSelector("sessionDidTimeout", ERXConstant.NotificationClassArray);
            NSNotificationCenter.defaultCenter().addObserver((Object)this, sel, "SessionDidTimeOutNotification", null);
        }

        public void sessionDidTimeout(NSNotification n) {
            String sessionID = (String)n.object();
            responses.removeObjectForKey(sessionID);
        }
    }

    public static interface Restorable {
        public String urlForCurrentState();
    }
}

