/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WODirectAction;
import com.webobjects.appserver.WORedirect;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.woextensions.WOEventDisplayPage;
import com.webobjects.woextensions.WOEventSetupPage;
import com.webobjects.woextensions.WOStatsPage;
import er.extensions.ERXExtensions;
import er.extensions.appserver.ERXApplication;
import er.extensions.appserver.ERXBrowser;
import er.extensions.appserver.ERXBrowserFactory;
import er.extensions.components.ERXStringHolder;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXObjectStoreCoordinator;
import er.extensions.formatters.ERXUnitAwareDecimalFormat;
import er.extensions.foundation.ERXConfigurationManager;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.localization.ERXLocalizer;
import er.extensions.logging.ERXLogger;
import er.extensions.statistics.ERXStats;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXDirectAction
extends WODirectAction {
    public static final Logger log = Logger.getLogger(ERXDirectAction.class);
    private ERXBrowser browser;

    public ERXDirectAction(WORequest r) {
        super(r);
    }

    protected boolean canPerformActionWithPasswordKey(String passwordKey) {
        if (ERXApplication.isDevelopmentModeSafe()) {
            return true;
        }
        String password = ERXProperties.decryptedStringForKey(passwordKey);
        if (password == null || password.length() == 0) {
            log.error((Object)("Attempt to use action when key is not set: " + passwordKey));
            return false;
        }
        String requestPassword = this.request().stringFormValueForKey("pw");
        if (requestPassword == null) {
            requestPassword = (String)this.context().session().objectForKey("ERXDirectAction." + passwordKey);
        } else {
            this.context().session().setObjectForKey((Object)requestPassword, "ERXDirectAction." + passwordKey);
        }
        if (requestPassword == null || requestPassword.length() == 0) {
            return false;
        }
        return password.equals(requestPassword);
    }

    public WOComponent testAction() {
        WOComponent result = null;
        if (this.canPerformActionWithPasswordKey("er.extensions.ERXJUnitPassword")) {
            result = this.pageWithName("ERXWOTestInterface");
            this.session().setObjectForKey((Object)Boolean.TRUE, "ERXWOTestInterface.enabled");
            String testCase = this.request().stringFormValueForKey("case");
            if (testCase != null) {
                result.takeValueForKey((Object)testCase, "theTest");
            }
        }
        return result;
    }

    public WOActionResults flushComponentCacheAction() {
        WOResponse response = new WOResponse();
        if (this.canPerformActionWithPasswordKey("er.extensions.ERXFlushComponentCachePassword")) {
            WOApplication.application()._removeComponentDefinitionCacheContents();
            response.setContent("OK");
        }
        return response;
    }

    public WOActionResults statsAction() {
        WOStatsPage nextPage = (WOStatsPage)this.pageWithName("ERXStatisticsPage");
        nextPage.password = this.context().request().stringFormValueForKey("pw");
        return nextPage.submit();
    }

    public WOActionResults resetStatsAction() {
        WORedirect result = null;
        if (this.canPerformActionWithPasswordKey("WOStatisticsPassword")) {
            ERXStats.reset();
            WORedirect redirect = new WORedirect(this.context());
            redirect.setUrl(this.context().directActionURLForActionNamed("ERXDirectAction/stats", null));
            result = redirect;
        }
        return result;
    }

    public WOActionResults eventsAction() {
        WOEventDisplayPage nextPage = (WOEventDisplayPage)this.pageWithName("WOEventDisplayPage");
        nextPage.password = this.context().request().stringFormValueForKey("pw");
        nextPage.valueForKey("submit");
        return nextPage;
    }

    public WOActionResults eventsSetupAction() {
        WOEventSetupPage nextPage = (WOEventSetupPage)this.pageWithName("WOEventSetupPage");
        nextPage.password = this.context().request().stringFormValueForKey("pw");
        nextPage.submit();
        nextPage.selectAll();
        return this.eventsAction();
    }

    public WOComponent eoAdaptorDebuggingAction() {
        ERXStringHolder result = (ERXStringHolder)this.pageWithName("ERXStringHolder");
        result.setEscapeHTML(false);
        if (this.canPerformActionWithPasswordKey("er.extensions.ERXEOAdaptorDebuggingPassword")) {
            String message;
            boolean currentState = ERXExtensions.adaptorLogging();
            int instance = this.request().applicationNumber();
            if (instance == -1) {
                log.info((Object)"EOAdaptorDebuggingAction requested without a specific instance.");
                message = "<p>You must invoke this action on a <em>specific</em> instance.</p><p>Your url should look like: <code>.../WebObjects/1/wa/...</code>, where '1' would be the first instance of the target application.</p>";
            } else {
                String debugParam = this.request().stringFormValueForKey("debug");
                log.debug((Object)("EOAdaptorDebuggingAction requested with 'debug' param:" + debugParam));
                if (debugParam == null || debugParam.trim().length() == 0) {
                    message = "<p>EOAdaptorDebugging is currently <strong>" + (currentState ? "ON" : "OFF") + "</strong> for instance <strong>" + instance + "</strong>.</p>";
                    message = message + "<p>To change the setting, provide the 'debug' parameter to this action, e.g.: <code>...eoAdaptorDebugging?debug=on&pw=secret</code></p>";
                } else {
                    if (debugParam.trim().equalsIgnoreCase("on")) {
                        debugParam = "true";
                    } else if (debugParam.trim().equalsIgnoreCase("off")) {
                        debugParam = "false";
                    }
                    boolean desiredState = ERXValueUtilities.booleanValueWithDefault(debugParam, false);
                    log.debug((Object)("EOAdaptorDebuggingAction requested 'debug' state change to: '" + desiredState + "' for instance: " + instance + "."));
                    if (currentState != desiredState) {
                        ERXExtensions.setAdaptorLogging(desiredState);
                        message = "<p>Turned EOAdaptorDebugging <strong>" + (desiredState ? "ON" : "OFF") + "</strong> for instance <strong>" + instance + "</strong>.</p>";
                    } else {
                        message = "<p>EOAdaptorDebugging setting <strong>not changed</strong>.</p>";
                    }
                }
            }
            message = message + "<p><em>Please be mindful of using EOAdaptorDebugging as it may have a large impact on application performance.</em></p>";
            result.setValue(message);
        }
        return result;
    }

    public WOComponent log4jAction() {
        WOComponent result = null;
        if (this.canPerformActionWithPasswordKey("er.extensions.ERXLog4JPassword")) {
            result = this.pageWithName("ERXLog4JConfiguration");
            this.session().setObjectForKey((Object)Boolean.TRUE, "ERXLog4JConfiguration.enabled");
        }
        return result;
    }

    public WOComponent remoteShellAction() {
        WOComponent result = null;
        if (this.canPerformActionWithPasswordKey("er.extensions.ERXRemoteShellPassword")) {
            result = this.pageWithName("ERXRemoteShell");
            this.session().setObjectForKey((Object)Boolean.TRUE, "ERXRemoteShell.enabled");
        }
        return result;
    }

    public WOComponent databaseConsoleAction() {
        WOComponent result = null;
        if (this.canPerformActionWithPasswordKey("er.extensions.ERXDatabaseConsolePassword")) {
            result = this.pageWithName("ERXDatabaseConsole");
            this.session().setObjectForKey((Object)Boolean.TRUE, "ERXDatabaseConsole.enabled");
        }
        return result;
    }

    public WOComponent forceGCAction() {
        ERXStringHolder result = (ERXStringHolder)this.pageWithName("ERXStringHolder");
        if (this.canPerformActionWithPasswordKey("er.extensions.ERXGCPassword")) {
            Runtime runtime = Runtime.getRuntime();
            ERXUnitAwareDecimalFormat decimalFormatter = new ERXUnitAwareDecimalFormat("byte");
            decimalFormatter.setMaximumFractionDigits(2);
            String info = "Before: ";
            info = info + decimalFormatter.format(runtime.maxMemory()) + " max, ";
            info = info + decimalFormatter.format(runtime.totalMemory()) + " total, ";
            info = info + decimalFormatter.format(runtime.totalMemory() - runtime.freeMemory()) + " used, ";
            info = info + decimalFormatter.format(runtime.freeMemory()) + " free\n";
            int count = 5;
            if (this.request().stringFormValueForKey("count") != null) {
                count = Integer.parseInt(this.request().stringFormValueForKey("count"));
            }
            ERXExtensions.forceGC(count);
            info = info + "After: ";
            info = info + decimalFormatter.format(runtime.maxMemory()) + " max, ";
            info = info + decimalFormatter.format(runtime.totalMemory()) + " total, ";
            info = info + decimalFormatter.format(runtime.totalMemory() - runtime.freeMemory()) + " used, ";
            info = info + decimalFormatter.format(runtime.freeMemory()) + " free\n";
            result.setValue(info);
            log.info((Object)("GC forced\n" + info));
        }
        return result;
    }

    public WOComponent showOpenEditingContextLockTracesAction() {
        ERXStringHolder result = (ERXStringHolder)this.pageWithName("ERXStringHolder");
        if (this.canPerformActionWithPasswordKey("er.extensions.ERXOpenEditingContextLockTracesPassword")) {
            result.setEscapeHTML(false);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("<pre>");
            pw.println(ERXEC.outstandingLockDescription());
            pw.println("</pre>");
            pw.println("<hr>");
            pw.println("<pre>");
            pw.println(ERXObjectStoreCoordinator.outstandingLockDescription());
            pw.println("</pre>");
            pw.close();
            result.setValue(sw.toString());
        }
        return result;
    }

    public WOActionResults logoutAction() {
        if (this.existingSession() != null) {
            this.existingSession().terminate();
        }
        WORedirect r = (WORedirect)this.pageWithName("WORedirect");
        r.setUrl(this.context().directActionURLForActionNamed("default", null));
        return r;
    }

    public ERXBrowser browser() {
        if (this.browser == null && this.request() != null) {
            ERXBrowserFactory browserFactory = ERXBrowserFactory.factory();
            this.browser = browserFactory.browserMatchingRequest(this.request());
            browserFactory.retainBrowser(this.browser);
        }
        return this.browser;
    }

    public WOActionResults performActionNamed(String actionName) {
        WOActionResults actionResult = super.performActionNamed(actionName);
        if (this.browser != null) {
            ERXBrowserFactory.factory().releaseBrowser(this.browser);
        }
        return actionResult;
    }

    public WOActionResults systemPropertyAction() {
        WOResponse r = null;
        if (this.canPerformActionWithPasswordKey("er.extensions.ERXDirectAction.ChangeSystemPropertyPassword")) {
            String key = this.request().stringFormValueForKey("key");
            r = new WOResponse();
            if (ERXStringUtilities.stringIsNullOrEmpty(key)) {
                String user = this.request().stringFormValueForKey("user");
                Properties props = ERXConfigurationManager.defaultManager().defaultProperties();
                if (user != null) {
                    System.setProperty("user.name", user);
                    props = ERXConfigurationManager.defaultManager().applyConfiguration(props);
                }
                r.appendContentString(ERXProperties.logString(props));
            } else {
                String value = this.request().stringFormValueForKey("value");
                value = ERXStringUtilities.stringIsNullOrEmpty(value) ? "" : value;
                Properties p = System.getProperties();
                p.put(key, value);
                System.setProperties(p);
                ERXLogger.configureLoggingWithSystemProperties();
                Enumeration<Object> e = p.keys();
                while (e.hasMoreElements()) {
                    Object k = e.nextElement();
                    if (k.equals(key)) {
                        r.appendContentString("<b>'" + k + "=" + p.get(k) + "'     <= you changed this</b><br>");
                        continue;
                    }
                    r.appendContentString("'" + k + "=" + p.get(k) + "'<br>");
                }
                r.appendContentString("</body></html>");
            }
        }
        return r;
    }

    public WOActionResults editLocalizedFilesAction() {
        WOActionResults r = null;
        if (ERXApplication.isDevelopmentModeSafe()) {
            return this.pageWithName("ERXLocalizationEditor");
        }
        return r;
    }

    public WOActionResults dumpCreatedKeysAction() {
        WOResponse r = new WOResponse();
        if (ERXApplication.isDevelopmentModeSafe()) {
            this.session();
            ERXLocalizer.currentLocalizer().dumpCreatedKeys();
        }
        return r;
    }

    public WOActionResults emptyAction() {
        WOResponse response = new WOResponse();
        return response;
    }

    public WOActionResults closeHTTPSessionAction() {
        WOResponse response = new WOResponse();
        response.setContent("");
        response.setHeader("close", "Connection");
        return response;
    }

    public <T extends WOComponent> T pageWithName(Class<T> componentClass) {
        return (T)super.pageWithName(componentClass.getName());
    }
}

