/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableData;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSRange;
import er.extensions.appserver.ERXRequest;
import er.extensions.appserver.ERXWOContext;
import er.extensions.foundation.ERXThreadStorage;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;

public class ERXResponse
extends WOResponse {
    public static final String ContentDispositionHeaderKey = "content-disposition";
    public static final String ContentTypeHeaderKey = "content-type";
    public static final String DisablePageCachingKey = "com.webobjects.appserver.Response.DisablePageCaching";
    private LinkedHashMap<String, Integer> marks;
    private Stack<Object> _contentStack;
    private WOContext _context;

    public ERXResponse() {
    }

    public ERXResponse(String content, int status) {
        this(content);
        this.setStatus(status);
    }

    public ERXResponse(String content) {
        this.setContent(content);
    }

    public ERXResponse(WOContext context) {
        this._context = context;
    }

    protected void __setContent(Object appendable) {
        try {
            WOMessage.class.getDeclaredField("_content").set((Object)this, appendable);
        }
        catch (Throwable e) {
            throw new NSForwardException(e);
        }
    }

    public void pushContent() {
        Object newContent;
        if (this._contentStack == null) {
            this._contentStack = new Stack();
        }
        this._contentStack.push(this._content);
        try {
            newContent = this._content.getClass().newInstance();
        }
        catch (Throwable e) {
            throw new NSForwardException(e);
        }
        this.__setContent(newContent);
    }

    public void popContent(boolean append) {
        if (this._contentStack == null || this._contentStack.size() == 0) {
            throw new IllegalStateException("You attempted to popContent off of an empty stack.");
        }
        StringBuffer oldAppendable = this._content;
        Object appendable = this._contentStack.pop();
        this.__setContent(appendable);
        if (append) {
            this.appendContentString(((Object)oldAppendable).toString());
        }
    }

    public void mark(String key) {
        if (this.marks == null) {
            this.marks = new LinkedHashMap();
        }
        this.marks.put(key, this._contentLength());
    }

    public void _finalizeInContext(WOContext originalContext) {
        super._finalizeInContext(originalContext);
        if (this.marks != null && this.marks.size() > 0) {
            Context context = ERXResponse.currentContext();
            NSMutableData content = new NSMutableData();
            int last = 0;
            for (Map.Entry<String, Integer> entry : this.marks.entrySet()) {
                String key = entry.getKey();
                Integer offset = entry.getValue();
                NSRange range = new NSRange(last, offset - last);
                NSData data = this.content().subdataWithRange(range);
                content.appendData(data);
                ERXResponse partial = context.partials.get(key);
                if (partial != null) {
                    NSData partialData = partial.content();
                    content.appendData(partialData);
                }
                last = offset;
            }
            NSRange range = new NSRange(last, this._contentLength() - last);
            NSData data = this.content().subdataWithRange(range);
            content.appendData(data);
            this.setContent((NSData)content);
        }
    }

    private static Context currentContext() {
        Context context = (Context)ERXThreadStorage.valueForKey("ERXResponse.Context");
        if (context == null) {
            context = new Context();
            ERXThreadStorage.takeValueForKey(context, "ERXResponse.Context");
        }
        return context;
    }

    public static ERXResponse pushPartial(String key) {
        Context context = ERXResponse.currentContext();
        WOContext wocontext = ERXWOContext.currentContext();
        context.stack.push((ERXResponse)wocontext.response());
        ERXResponse response = context.partials.get(key);
        if (response == null) {
            response = new ERXResponse(wocontext);
            context.partials.put(key, response);
        }
        wocontext._setResponse((WOResponse)response);
        return response;
    }

    public static ERXResponse popPartial() {
        Context context = ERXResponse.currentContext();
        ERXResponse response = context.stack.pop();
        WOContext wocontext = ERXWOContext.currentContext();
        wocontext._setResponse((WOResponse)response);
        return response;
    }

    public void _appendTagAttributeAndValue(String name, String value, boolean escape) {
        if (value != null) {
            super._appendTagAttributeAndValue(name, value, escape);
        }
    }

    public void disableClientCaching() {
        boolean isIEDownloadingAttachment;
        boolean bl = isIEDownloadingAttachment = this.isIE() && this.isAttachment() && !this.isHTML();
        if (!isIEDownloadingAttachment) {
            super.disableClientCaching();
        }
    }

    public boolean isPageCachingDisabled() {
        return this.userInfoForKey(DisablePageCachingKey) != null;
    }

    public void setUserInfoForKey(Object value, String key) {
        NSMutableDictionary<String, Object> newUserInfo = new NSMutableDictionary<String, Object>(value, key);
        if (this.userInfo() != null) {
            newUserInfo.addEntriesFromDictionary(this.userInfo());
        }
        this.setUserInfo(newUserInfo);
    }

    public Object userInfoForKey(String key) {
        return this.userInfo() != null ? this.userInfo().objectForKey(key) : null;
    }

    public boolean isAttachment() {
        String contentDisposition = this.contentDisposition();
        return contentDisposition != null && (contentDisposition.indexOf("inline") > -1 || contentDisposition.indexOf("attachment") > -1);
    }

    public boolean isHTML() {
        return this.contentType() != null && this.contentType().toLowerCase().indexOf("text/html") > -1;
    }

    public String contentDisposition() {
        return this.headerForKey(ContentDispositionHeaderKey);
    }

    public String contentType() {
        return this.headerForKey(ContentTypeHeaderKey);
    }

    public boolean isIE() {
        boolean isIE = false;
        if (this._context != null && this._context.request() instanceof ERXRequest) {
            isIE = ((ERXRequest)this._context.request()).browser().isIE();
        }
        return isIE;
    }

    public static void setXHTML(WOResponse response, boolean xhtml) {
        response.setHeader(String.valueOf(xhtml), "x-wo-xml-tags");
    }

    public static boolean isXHTML(WOResponse response) {
        return "true".equals(response.headerForKey((Object)"x-wo-xml-tags"));
    }

    public static class Context {
        protected LinkedHashMap<String, ERXResponse> partials = new LinkedHashMap();
        protected Stack<ERXResponse> stack = new Stack();
    }
}

