/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.batching;

import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.localization.ERXLocalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXDirectActionBatchNavigationBar
extends ERXStatelessComponent {
    private NSArray<NSDictionary<String, Object>> batchNumbers;
    public NSDictionary dictInRepetition;
    private static final String SHOW_BATCH_NAVIGATION_FOR_SINGLE_PAGE = "showBatchNavigationForSinglePage";
    private static final String ACTION_NAME_KEY = "actionName";
    private static final String ACTION_CLASS_KEY = "actionClass";
    private static final String BATCH_SIZE_KEY = "batchSize";
    private static final String NUMBER_OF_OBJECTS_KEY = "numberOfObjects";
    private static final String CURRENT_BATCH_INDEX_KEY = "currentBatchIndex";
    private static int defaultBatchSize = 20;
    private static final String ADDITIONAL_URL_PARAMETERS_KEY = "additionalUrlParameters";
    private static final String CONTAINER_CSS_CLASS_KEY = "containerCssClass";
    private static final String SHOW_PAGE_STRING_KEY = "showPageString";
    private static final String BACK_STRING = "backString";
    private static final String FORWARD_STRING = "forwardString";
    private static final String SHOW_PAGE_NUMBERS = "showPageNumbers";

    public ERXDirectActionBatchNavigationBar(WOContext context) {
        super(context);
    }

    @Override
    public void reset() {
        this.dictInRepetition = null;
        this.batchNumbers = null;
    }

    private int numberOfBatches(int productCount, int sizeOfOneBatch) {
        if (sizeOfOneBatch == 0) {
            return productCount;
        }
        if (productCount == 0) {
            return productCount;
        }
        int numberOfBatches = productCount / sizeOfOneBatch;
        if (productCount % sizeOfOneBatch != 0) {
            ++numberOfBatches;
        }
        return numberOfBatches;
    }

    public NSArray<NSDictionary<String, Object>> batchNumbers() {
        if (this.batchNumbers == null) {
            NSMutableDictionary<String, Object> entry;
            NSMutableArray tmpArray = new NSMutableArray();
            int currentBatchIndex = this.currentBatchIndex();
            int batchSize = this.batchSize();
            int numberOfObjects = this.numberOfObjects();
            int tmp = currentBatchIndex % 9;
            if (tmp == 0) {
                tmp = 9;
            }
            int batchIndex = currentBatchIndex - tmp + 1;
            int maxPages = this.numberOfBatches(numberOfObjects, batchSize);
            int batchStart = batchIndex;
            int batchEnd = 0;
            if (currentBatchIndex > 5 && maxPages > 9) {
                batchIndex = batchStart = currentBatchIndex - 4;
            }
            while (tmpArray.count() < 9 && batchIndex <= maxPages) {
                entry = new NSMutableDictionary<String, Object>();
                entry.setObjectForKey(new Integer(batchIndex), "batchNumber");
                entry.setObjectForKey(new Integer(batchIndex).toString(), "batchString");
                entry.setObjectForKey(Boolean.FALSE, "disable");
                tmpArray.addObject(entry);
                batchEnd = batchIndex++;
            }
            if (batchStart >= 2) {
                entry = new NSMutableDictionary();
                entry.setObjectForKey(new Integer(1), "batchNumber");
                entry.setObjectForKey(new Integer(1).toString(), "batchString");
                entry.setObjectForKey(Boolean.FALSE, "disabled");
                tmpArray.insertObjectAtIndex(entry, 0);
                if (batchStart > 2) {
                    entry = new NSMutableDictionary();
                    entry.setObjectForKey(new Integer(0), "batchNumber");
                    entry.setObjectForKey("...", "batchString");
                    entry.setObjectForKey(Boolean.TRUE, "disabled");
                    tmpArray.insertObjectAtIndex(entry, 1);
                } else {
                    tmpArray.removeObjectAtIndex(9);
                }
            }
            if (batchEnd < maxPages - 1) {
                entry = new NSMutableDictionary();
                entry = new NSMutableDictionary();
                entry.setObjectForKey(new Integer(0), "batchNumber");
                entry.setObjectForKey("...", "batchString");
                entry.setObjectForKey(Boolean.TRUE, "disabled");
                tmpArray.addObject(entry);
            }
            if (batchEnd < maxPages) {
                entry = new NSMutableDictionary();
                entry.setObjectForKey(this.lastBatch(), "batchNumber");
                entry.setObjectForKey(this.lastBatch().toString(), "batchString");
                entry.setObjectForKey(Boolean.FALSE, "disabled");
                tmpArray.addObject(entry);
            }
            this.batchNumbers = tmpArray.immutableClone();
        }
        return this.batchNumbers;
    }

    public boolean hasMoreThanOneBatch() {
        return this.batchNumbers() != null && this.batchNumbers().count() > 1;
    }

    public boolean showNavigationBar() {
        return this.hasMoreThanOneBatch() || this.showBatchNavigationForSinglePage() != false;
    }

    public boolean isSelected() {
        return this.dictInRepetition.valueForKey("batchNumber").equals(this.currentBatchIndex());
    }

    public Integer previousBatch() {
        return new Integer(this.currentBatchIndex() - 1);
    }

    public Integer nextBatch() {
        return new Integer(this.currentBatchIndex() + 1);
    }

    public Integer lastBatch() {
        return new Integer(this.numberOfBatches(this.numberOfObjects(), this.batchSize()));
    }

    public boolean isLastBatch() {
        return this.currentBatchIndex().intValue() == this.numberOfBatches(this.numberOfObjects(), this.batchSize());
    }

    public boolean isFirstBatch() {
        return this.currentBatchIndex() == 1;
    }

    @Override
    public ERXLocalizer localizer() {
        if (this.context().hasSession()) {
            return ERXLocalizer.currentLocalizer();
        }
        return ERXLocalizer.localizerForLanguages(this.context().request().browserLanguages());
    }

    public String actionName() {
        return this.stringValueForBinding(ACTION_NAME_KEY);
    }

    public void setActionName(String name) {
        this.setValueForBinding(name, ACTION_NAME_KEY);
    }

    public String actionClass() {
        if (this.stringValueForBinding(ACTION_CLASS_KEY) != null) {
            return this.stringValueForBinding(ACTION_CLASS_KEY);
        }
        return "DirectAction";
    }

    public void setActionClass(String className) {
        this.setValueForBinding(className, ACTION_CLASS_KEY);
    }

    public Integer batchSize() {
        return new Integer(this.intValueForBinding(BATCH_SIZE_KEY, defaultBatchSize));
    }

    public void setBatchSize(Integer size) {
        this.setValueForBinding(size, BATCH_SIZE_KEY);
    }

    public Integer numberOfObjects() {
        return new Integer(this.intValueForBinding(NUMBER_OF_OBJECTS_KEY, 0));
    }

    public void setNumberOfObjects(Integer n) {
        this.takeValueForKey(n, NUMBER_OF_OBJECTS_KEY);
    }

    public Integer currentBatchIndex() {
        return new Integer(this.intValueForBinding(CURRENT_BATCH_INDEX_KEY, 0));
    }

    public void setCurrentBatchIndex(Integer index) {
        this.setValueForBinding(index, CURRENT_BATCH_INDEX_KEY);
    }

    public NSDictionary<String, Object> additionalUrlParameters() {
        return (NSDictionary)this.valueForBinding(ADDITIONAL_URL_PARAMETERS_KEY);
    }

    public void setAdditionalUrlParameters(NSDictionary<String, Object> dict) {
        this.setValueForBinding(dict, ADDITIONAL_URL_PARAMETERS_KEY);
    }

    public String containerCssClass() {
        return this.stringValueForBinding(CONTAINER_CSS_CLASS_KEY, "ERXDABatchNav");
    }

    public void setContainerCssClass(String cssClass) {
        this.takeValueForKey(cssClass, CONTAINER_CSS_CLASS_KEY);
    }

    public Boolean showPageString() {
        return new Boolean(this.booleanValueForBinding(SHOW_PAGE_STRING_KEY, false));
    }

    public void setShowPageString(Boolean flag) {
        this.setValueForBinding(flag, SHOW_PAGE_STRING_KEY);
    }

    public String forwardString() {
        return this.stringValueForBinding(FORWARD_STRING, "forward&nbsp;&raquo;");
    }

    public void setForwardString(String s) {
        this.setValueForBinding(s, FORWARD_STRING);
    }

    public String backString() {
        return this.stringValueForBinding(BACK_STRING, "&laquo;&nbsp;back");
    }

    public void setBackString(String s) {
        this.setValueForBinding(s, BACK_STRING);
    }

    public Boolean showPageNumbers() {
        return new Boolean(this.booleanValueForBinding(SHOW_PAGE_NUMBERS, true));
    }

    public void setShowPageNumbers(Boolean flag) {
        this.setValueForBinding(flag, SHOW_PAGE_NUMBERS);
    }

    public Boolean showBatchNavigationForSinglePage() {
        return this.booleanValueForBinding(SHOW_BATCH_NAVIGATION_FOR_SINGLE_PAGE, true) ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setShowBatchNavigationForSinglePage(Boolean flag) {
        this.setValueForBinding(flag, SHOW_BATCH_NAVIGATION_FOR_SINGLE_PAGE);
    }
}

