/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOResourceManager;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOConstantValueAssociation;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.appserver.ERXApplication;
import er.extensions.appserver.ERXWOContext;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXValueUtilities;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXComponentUtilities {
    public static WOAssociation TRUE = new WOConstantValueAssociation((Object)Boolean.TRUE);
    public static WOAssociation FALSE = new WOConstantValueAssociation((Object)Boolean.FALSE);
    public static WOAssociation EMPTY = new WOConstantValueAssociation((Object)"");
    public static WOAssociation ZERO = new WOConstantValueAssociation((Object)0);

    public static NSMutableDictionary queryParametersInComponent(NSDictionary associations, WOComponent component) {
        NSMutableDictionary queryParameterAssociations = ERXComponentUtilities.queryParameterAssociations(associations);
        return ERXComponentUtilities._queryParametersInComponent(queryParameterAssociations, component);
    }

    public static NSMutableDictionary queryParametersInComponent(NSMutableDictionary associations, WOComponent component, boolean removeQueryParametersAssociations) {
        NSMutableDictionary queryParameterAssociations = ERXComponentUtilities.queryParameterAssociations(associations, removeQueryParametersAssociations);
        return ERXComponentUtilities._queryParametersInComponent(queryParameterAssociations, component);
    }

    public static NSMutableDictionary _queryParametersInComponent(NSMutableDictionary associations, WOComponent component) {
        NSMutableDictionary<String, Object> queryParameters = new NSMutableDictionary<String, Object>();
        Enumeration keyEnum = associations.keyEnumerator();
        while (keyEnum.hasMoreElements()) {
            String key = (String)keyEnum.nextElement();
            WOAssociation association = (WOAssociation)associations.valueForKey(key);
            Object associationValue = association.valueInComponent(component);
            if (associationValue == null) continue;
            queryParameters.setObjectForKey(associationValue, key.substring(1));
        }
        return queryParameters;
    }

    public static NSMutableDictionary queryParameterAssociations(NSDictionary associations) {
        return ERXComponentUtilities._queryParameterAssociations(associations, false);
    }

    public static NSMutableDictionary queryParameterAssociations(NSMutableDictionary associations, boolean removeQueryParameterAssociations) {
        return ERXComponentUtilities._queryParameterAssociations(associations, removeQueryParameterAssociations);
    }

    public static NSMutableDictionary _queryParameterAssociations(NSDictionary associations, boolean removeQueryParameterAssociations) {
        NSMutableDictionary mutableAssociations = null;
        if (removeQueryParameterAssociations) {
            mutableAssociations = (NSMutableDictionary)associations;
        }
        NSMutableDictionary<String, WOAssociation> queryParameterAssociations = new NSMutableDictionary<String, WOAssociation>();
        Enumeration keyEnum = associations.keyEnumerator();
        while (keyEnum.hasMoreElements()) {
            String key = (String)keyEnum.nextElement();
            if (!key.startsWith("?")) continue;
            WOAssociation association = (WOAssociation)associations.valueForKey(key);
            if (mutableAssociations != null) {
                mutableAssociations.removeObjectForKey(key);
            }
            queryParameterAssociations.setObjectForKey(association, key);
        }
        return queryParameterAssociations;
    }

    public static boolean booleanValueForBinding(WOComponent component, String bindingName) {
        return ERXComponentUtilities.booleanValueForBinding(component, bindingName, false);
    }

    public static boolean booleanValueForBinding(WOComponent component, String bindingName, boolean defaultValue) {
        if (component == null) {
            return defaultValue;
        }
        return ERXValueUtilities.booleanValueWithDefault(component.valueForBinding(bindingName), defaultValue);
    }

    public static URL htmlTemplateUrl(String componentName, NSArray languages) {
        return ERXComponentUtilities.templateUrl(componentName, "html", languages);
    }

    public static URL templateUrl(String componentName, String extension, NSArray languages) {
        NSArray frameworkBundles;
        String htmlPathName = componentName + ".wo/" + componentName + "." + extension;
        WOResourceManager resourcemanager = WOApplication.application().resourceManager();
        URL templateUrl = resourcemanager.pathURLForResourceNamed(htmlPathName, null, languages);
        if (templateUrl == null && (frameworkBundles = NSBundle.frameworkBundles()) != null) {
            Enumeration frameworksEnum = frameworkBundles.objectEnumerator();
            while (templateUrl == null && frameworksEnum.hasMoreElements()) {
                NSBundle frameworkBundle = (NSBundle)frameworksEnum.nextElement();
                templateUrl = resourcemanager.pathURLForResourceNamed(htmlPathName, frameworkBundle.name(), languages);
            }
        }
        return templateUrl;
    }

    public static String htmlTemplate(String componentName, NSArray languages) throws IOException {
        return ERXComponentUtilities.template(componentName, "html", languages);
    }

    public static String template(String componentName, String extension, NSArray languages) throws IOException {
        URL templateUrl = ERXComponentUtilities.templateUrl(componentName, extension, languages);
        String template = templateUrl == null ? null : ERXStringUtilities.stringFromURL(templateUrl);
        return template;
    }

    public static WOElement inheritTemplateFrom(String componentName, NSArray<String> languages) {
        try {
            String htmlString = ERXComponentUtilities.template(componentName, "html", languages);
            String wodString = ERXComponentUtilities.template(componentName, "wod", languages);
            return WOComponent.templateWithHTMLString((String)htmlString, (String)wodString, languages);
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public static NSArray componentTree() {
        WOContext context = ERXWOContext.currentContext();
        NSMutableArray<String> result = new NSMutableArray<String>();
        if (context != null) {
            for (WOComponent c = context.component(); c != null; c = c.parent()) {
                result.addObject(c.name());
            }
        }
        return result;
    }

    public static void appendHtmlAttributes(NSDictionary<String, WOAssociation> associations, WOResponse response, WOContext context) {
        WOComponent component = context.component();
        ERXComponentUtilities.appendHtmlAttributes(associations, response, component);
    }

    public static void appendHtmlAttributes(NSDictionary<String, WOAssociation> associations, WOResponse response, WOComponent component) {
        for (String key : associations.allKeys()) {
            WOAssociation association = associations.objectForKey(key);
            ERXComponentUtilities.appendHtmlAttribute(key, association, response, component);
        }
    }

    public static void appendHtmlAttribute(String key, WOAssociation association, WOResponse response, WOComponent component) {
        Object value = association.valueInComponent(component);
        if (value != null) {
            response.appendContentString(" ");
            response.appendContentString(key);
            response.appendContentString("=\"");
            response.appendContentHTMLAttributeValue(value.toString());
            response.appendContentString("\"");
        }
    }

    public static <T extends WOComponent> T pageWithName(Class<T> componentClass, WOContext context) {
        return ERXApplication.erxApplication().pageWithName(componentClass, context);
    }

    public static <T extends WOComponent> T pageWithName(Class<T> componentClass) {
        return ERXApplication.erxApplication().pageWithName(componentClass);
    }
}

