/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.eocontrol.EODataSource;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestamp;
import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXTimestampUtility;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class ERXDateGrouper
extends WODisplayGroup {
    private static Logger log = Logger.getLogger(ERXDateGrouper.class);
    public static final int DAY = 6;
    public static final int MONTH = 2;
    public static final int WEEK = 3;
    public static final int YEAR = 1;
    static NSMutableDictionary cachedDays = new NSMutableDictionary();
    static int currentYear = ERXTimestampUtility.yearOfCommonEra(new NSTimestamp());
    protected NSArray _objects;
    protected String _dateKeyPath;
    protected NSTimestamp _selectedDate = new NSTimestamp();
    protected NSTimestamp _currentDate;
    protected NSTimestamp _firstDateInSameMonth;
    protected NSTimestamp _firstDateInNextMonth;
    protected NSTimestamp _today = new NSTimestamp();
    protected int _currentMonth;
    protected int _groupingMode = 6;
    protected int _currentWeek;
    protected int _currentDayOfMonth;
    protected int _currentDayOfWeek;
    protected NSArray _datesForCurrentWeek;
    protected NSMutableDictionary _groupedObjects;
    protected NSMutableArray _datesForWeeksForCurrentMonth;
    protected boolean _weekStartsMonday = false;

    public boolean weekStartsMonday() {
        return this._weekStartsMonday;
    }

    public void setWeekStartsMonday(boolean value) {
        this._reset();
        this._weekStartsMonday = value;
    }

    public boolean hasNoObjectsForCurrentDate() {
        return this.displayedObjects().count() == 0;
    }

    public boolean isToday() {
        return ERXTimestampUtility.differenceByDay(this.today(), this.currentDate()) == 0L;
    }

    public boolean isSelectedDate() {
        return ERXTimestampUtility.differenceByDay(this.selectedDate(), this.currentDate()) == 0L;
    }

    public boolean isInMonth() {
        return ERXTimestampUtility.differenceByDay(this.firstDateInSameMonth(), this.currentDate()) >= 0L && ERXTimestampUtility.differenceByDay(this.firstDateInNextMonth(), this.currentDate()) < 0L;
    }

    public String dateKeyPath() {
        return this._dateKeyPath;
    }

    public void setDateKeyPath(String value) {
        this._groupedObjects = null;
        this._dateKeyPath = value;
    }

    public int groupingMode() {
        return this._groupingMode;
    }

    public void setGroupingMode(int value) {
        this._groupingMode = value;
        this._reset();
    }

    public NSArray allObjects() {
        return super.allObjects();
    }

    public void setObjectArray(NSArray value) {
        this._groupedObjects = null;
        this._reset();
        super.setObjectArray(value);
    }

    public void setDataSource(EODataSource value) {
        this._groupedObjects = null;
        this._reset();
        super.setDataSource(value);
    }

    public NSTimestamp today() {
        return this._today;
    }

    protected void _reset() {
        this._firstDateInSameMonth = null;
        this._firstDateInNextMonth = null;
        this._datesForWeeksForCurrentMonth = null;
    }

    public NSTimestamp selectedDate() {
        return this._selectedDate == null ? this.today() : this._selectedDate;
    }

    public void setSelectedDate(Date date) {
        NSTimestamp value = date instanceof NSTimestamp ? (NSTimestamp)date : new NSTimestamp(date);
        this._reset();
        this._selectedDate = value;
    }

    public NSTimestamp currentDate() {
        return this._currentDate == null ? this.selectedDate() : this._currentDate;
    }

    public void setCurrentDate(NSTimestamp value) {
        this._currentDate = value;
    }

    protected Object _groupingKeyForDate(NSTimestamp date) {
        int value = 0;
        switch (this.groupingMode()) {
            case 6: {
                value = ERXTimestampUtility.dayOfCommonEra(date) - currentYear * 365;
                break;
            }
            case 2: {
                value = ERXTimestampUtility.yearOfCommonEra(date) * 12 + ERXTimestampUtility.monthOfYear(date) - currentYear * 12;
                break;
            }
            case 3: {
                value = ERXTimestampUtility.yearOfCommonEra(date) * 53 + ERXTimestampUtility.monthOfYear(date) - currentYear * 53;
                break;
            }
            case 1: {
                value = ERXTimestampUtility.yearOfCommonEra(date) - currentYear;
            }
        }
        return ERXConstant.integerForInt(value);
    }

    protected NSDictionary _groupedObjects() {
        if (this._groupedObjects == null) {
            this._groupedObjects = new NSMutableDictionary();
            Enumeration e = this.allObjects().objectEnumerator();
            while (e.hasMoreElements()) {
                Object eo = e.nextElement();
                Object date = NSKeyValueCodingAdditions.Utility.valueForKeyPath(eo, (String)this.dateKeyPath());
                boolean isNullKey = date == null || date instanceof NSKeyValueCoding.Null;
                if (isNullKey) continue;
                Object key = this._groupingKeyForDate((NSTimestamp)date);
                NSMutableArray existingGroup = (NSMutableArray)this._groupedObjects.objectForKey(key);
                if (existingGroup == null) {
                    existingGroup = new NSMutableArray();
                    this._groupedObjects.setObjectForKey(existingGroup, key);
                }
                existingGroup.addObject(eo);
            }
        }
        return this._groupedObjects;
    }

    public NSArray displayedObjects() {
        NSArray _displayedObjects = (NSArray)this._groupedObjects().objectForKey(this._groupingKeyForDate(this.currentDate()));
        return _displayedObjects == null ? NSArray.EmptyArray : _displayedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NSTimestamp _dateForDayInYear(int year, int day) {
        NSMutableDictionary nSMutableDictionary = cachedDays;
        synchronized (nSMutableDictionary) {
            String key = year + "-" + day;
            NSTimestamp date = (NSTimestamp)cachedDays.valueForKey(key);
            if (date == null) {
                date = new NSTimestamp(year, 1, day, 0, 0, 0, (TimeZone)NSTimeZone.defaultTimeZone());
                cachedDays.setObjectForKey(date, key);
            }
            return date;
        }
    }

    protected NSArray _datesForYearStartDays(int year, int startOffset, int count) {
        NSMutableArray<NSTimestamp> dates = new NSMutableArray<NSTimestamp>();
        for (int i = 0; i < count; ++i) {
            dates.addObject(this._dateForDayInYear(year, startOffset + i));
        }
        return dates;
    }

    protected NSTimestamp _firstDateInSameWeek(NSTimestamp value) {
        int startOfWeek;
        int dayOfWeek = ERXTimestampUtility.dayOfWeek(value);
        int dayOfYear = ERXTimestampUtility.dayOfYear(value);
        if (log.isDebugEnabled()) {
            log.debug((Object)("dayOfYear: " + dayOfYear));
            log.debug((Object)("dayOfWeek: " + dayOfWeek));
            log.debug((Object)"SUNDAY: 1");
        }
        int n = startOfWeek = this.weekStartsMonday() ? 2 : 1;
        if (dayOfWeek == startOfWeek) {
            return this._dateForDayInYear(ERXTimestampUtility.yearOfCommonEra(value), ERXTimestampUtility.dayOfYear(value));
        }
        int offset = !this.weekStartsMonday() ? 1 : (dayOfWeek == 1 ? -5 : 2);
        return this._dateForDayInYear(ERXTimestampUtility.yearOfCommonEra(value), ERXTimestampUtility.dayOfYear(value) - dayOfWeek + offset);
    }

    protected NSTimestamp _firstDateInSameMonth(NSTimestamp value) {
        int dayOfMonth = ERXTimestampUtility.dayOfMonth(value);
        int dayOfYear = ERXTimestampUtility.dayOfYear(value);
        if (log.isDebugEnabled()) {
            log.debug((Object)("dayOfYear: " + dayOfYear));
            log.debug((Object)("dayOfMonth: " + dayOfMonth));
        }
        return this._dateForDayInYear(ERXTimestampUtility.yearOfCommonEra(value), ERXTimestampUtility.dayOfYear(value) - dayOfMonth + 1);
    }

    public NSTimestamp firstDateInSameMonth() {
        if (this._firstDateInSameMonth == null) {
            this._firstDateInSameMonth = this._firstDateInSameMonth(this.selectedDate());
        }
        return this._firstDateInSameMonth;
    }

    public NSTimestamp firstDateInNextMonth() {
        if (this._firstDateInNextMonth == null) {
            this._firstDateInNextMonth = this.firstDateInSameMonth().timestampByAddingGregorianUnits(0, 1, 0, 0, 0, 0);
        }
        return this._firstDateInNextMonth;
    }

    protected NSArray _weekDatesForDate(NSTimestamp week) {
        NSTimestamp startDate = this._firstDateInSameWeek(week);
        int startOffset = ERXTimestampUtility.dayOfYear(startDate);
        int year = ERXTimestampUtility.yearOfCommonEra(startDate);
        return this._datesForYearStartDays(year, startOffset, 7);
    }

    public NSTimestamp lastDateForMonth() {
        return (NSTimestamp)((NSArray)this.datesForWeeksForCurrentMonth().lastObject()).lastObject();
    }

    public NSTimestamp firstDateForMonth() {
        return (NSTimestamp)((NSArray)this.datesForWeeksForCurrentMonth().objectAtIndex(0)).objectAtIndex(0);
    }

    public NSArray datesForWeeksForCurrentMonth() {
        if (this._datesForWeeksForCurrentMonth == null) {
            this._datesForWeeksForCurrentMonth = new NSMutableArray();
            NSTimestamp startDate = this.firstDateInSameMonth();
            NSTimestamp endDate = this.firstDateInNextMonth();
            startDate = this._firstDateInSameWeek(startDate);
            int year = ERXTimestampUtility.yearOfCommonEra(startDate);
            int startOffset = ERXTimestampUtility.dayOfYear(startDate);
            for (int i = 0; i < 6; ++i) {
                NSMutableArray<NSTimestamp> weekDates = new NSMutableArray<NSTimestamp>();
                for (int j = 0; j < 7; ++j) {
                    NSTimestamp day = this._dateForDayInYear(year, startOffset + i * 7 + j);
                    if (j == 0 && ERXTimestampUtility.differenceByDay(endDate, day) >= 0L) {
                        return this._datesForWeeksForCurrentMonth;
                    }
                    weekDates.addObject(day);
                }
                this._datesForWeeksForCurrentMonth.addObject(weekDates);
            }
        }
        return this._datesForWeeksForCurrentMonth;
    }

    public void setDatesForCurrentWeek(NSArray value) {
        this._datesForCurrentWeek = value;
    }

    public NSArray datesForCurrentWeek() {
        NSArray result = this._datesForCurrentWeek;
        if (result == null) {
            int weekOfMonth = ERXTimestampUtility.weekOfMonth(this.selectedDate()) - 1;
            if (weekOfMonth == -1) {
                log.debug((Object)"weekOfMonth is -1, setting to 0");
                weekOfMonth = 0;
            }
            result = (NSArray)this.datesForWeeksForCurrentMonth().objectAtIndex(weekOfMonth);
        }
        return result;
    }

    public NSArray datesForCurrentMonth() {
        NSTimestamp startDate = this.currentDate().timestampByAddingGregorianUnits(0, 0, -ERXTimestampUtility.dayOfMonth(this.currentDate()) + 1, 0, 0, 0);
        int year = ERXTimestampUtility.yearOfCommonEra(startDate);
        int startOffset = ERXTimestampUtility.dayOfYear(startDate);
        int daysInMonth = 31;
        if (ERXTimestampUtility.monthOfYear(startDate) != 12) {
            daysInMonth = ERXTimestampUtility.dayOfYear(startDate.timestampByAddingGregorianUnits(0, 1, -1, 0, 0, 0)) - startOffset + 1;
        }
        return this._datesForYearStartDays(year, startOffset, daysInMonth);
    }

    public void nextMonth() {
        this.setSelectedDate((Date)this.selectedDate().timestampByAddingGregorianUnits(0, 1, 0, 0, 0, 0));
    }

    public void previousMonth() {
        this.setSelectedDate((Date)this.selectedDate().timestampByAddingGregorianUnits(0, -1, 0, 0, 0, 0));
    }

    public void nextDay() {
        this.setSelectedDate((Date)this.selectedDate().timestampByAddingGregorianUnits(0, 0, 1, 0, 0, 0));
    }

    public void previousDay() {
        this.setSelectedDate((Date)this.selectedDate().timestampByAddingGregorianUnits(0, 0, -1, 0, 0, 0));
    }

    public void nextWeek() {
        this.setSelectedDate((Date)this.selectedDate().timestampByAddingGregorianUnits(0, 0, 7, 0, 0, 0));
    }

    public void previousWeek() {
        this.setSelectedDate((Date)this.selectedDate().timestampByAddingGregorianUnits(0, 0, -7, 0, 0, 0));
    }

    public void nextYear() {
        this.setSelectedDate((Date)this.selectedDate().timestampByAddingGregorianUnits(1, 0, 0, 0, 0, 0));
    }

    public void previousYear() {
        this.setSelectedDate((Date)this.selectedDate().timestampByAddingGregorianUnits(-1, 0, 0, 0, 0, 0));
    }
}

