/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.ERXExtensions;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.localization.ERXLocalizer;
import java.util.Enumeration;

public class ERXErrorDictionaryPanel
extends ERXStatelessComponent {
    protected NSMutableDictionary errorMessages;
    protected NSMutableArray errorKeyOrder;
    protected String extraErrorMessage;
    public String errorKey;
    private static final String eliminable = "Could not save your changes: null";
    private static final String couldNotSave = "Could not save your changes: ";
    public Object value;

    public ERXErrorDictionaryPanel(WOContext aContext) {
        super(aContext);
    }

    public NSMutableDictionary errorMessages() {
        if (this.errorMessages == null) {
            this.errorMessages = (NSMutableDictionary)this.valueForBinding("errorMessages");
            if (this.errorMessages == null) {
                this.errorMessages = new NSMutableDictionary();
            }
        }
        return this.errorMessages;
    }

    public NSMutableArray errorKeyOrder() {
        if (this.errorKeyOrder == null) {
            this.errorKeyOrder = (NSMutableArray)this.valueForBinding("errorKeyOrder");
        }
        return this.errorKeyOrder;
    }

    public String extraErrorMessage() {
        if (this.extraErrorMessage == null) {
            this.extraErrorMessage = (String)this.valueForBinding("extraErrorMessage");
        }
        return this.extraErrorMessage;
    }

    public boolean hasErrors() {
        boolean hasErrors = false;
        hasErrors = this.errorMessages().count() > 0 || this.extraErrorMessage() != null && this.extraErrorMessage().length() > 0;
        return hasErrors;
    }

    public NSArray errorKeys() {
        return this.errorKeyOrder() != null ? this.errorKeyOrder() : this.errorMessages().allKeys();
    }

    public String errorMessageItem() {
        return (String)this.errorMessages().objectForKey(this.errorKey);
    }

    public static String massageErrorMessage(String initialMessage, String displayErrorKey) {
        String result = ERXExtensions.substituteStringByStringInString("EOValidationException:", "", initialMessage);
        if (displayErrorKey != null) {
            result = ERXExtensions.substituteStringByStringInString("** KEY_MARKER **", displayErrorKey, result);
        }
        if (result != null) {
            String replace;
            if (result.endsWith("is not allowed to be null.") || result.startsWith(" The ") && result.indexOf(" property ") != -1 && result.indexOf(" must have a ") != -1 && result.endsWith(" assigned")) {
                char c;
                if (displayErrorKey == null) {
                    result = result.substring(result.indexOf("'") + 1, result.indexOf("is not allowed to be null.") - 2);
                    c = result.charAt(0);
                } else {
                    result = displayErrorKey;
                    c = result.toLowerCase().charAt(0);
                }
                String article = c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' ? "an" : "a";
                result = "Please provide " + article + " <b>" + result + "</b>.";
            } else if (result.indexOf(": Invalid number") != -1) {
                int colon = result.indexOf(58);
                result = "<b>" + (displayErrorKey == null ? result.substring(0, colon - 1) : displayErrorKey);
                result = result + "</b>: I could not understand the number you typed.";
            } else if (result.indexOf(eliminable) > 0) {
                result = result.substring(eliminable.length() + 1, result.length());
            }
            if (result.indexOf(couldNotSave) > 0 && (replace = (String)ERXLocalizer.currentLocalizer().valueForKey(couldNotSave)) != null) {
                result = replace + result.substring(couldNotSave.length() + 1, result.length());
            }
        }
        return result;
    }

    public void reset() {
        super.reset();
        this.errorMessages = null;
        this.errorKeyOrder = null;
        this.extraErrorMessage = null;
    }

    public void appendToResponse(WOResponse r, WOContext c) {
        Enumeration e = this.errorMessages().keyEnumerator();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String errorMessageValue = (String)this.errorMessages().objectForKey(key);
            this.errorMessages().setObjectForKey(ERXErrorDictionaryPanel.massageErrorMessage(errorMessageValue, key), key);
        }
        this.extraErrorMessage = ERXErrorDictionaryPanel.massageErrorMessage(this.extraErrorMessage(), null);
        super.appendToResponse(r, c);
    }
}

