/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOResourceManager;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOGenericContainer;
import com.webobjects.appserver._private.WOURLValuedElementData;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import java.util.Enumeration;

public class ERXStyledContainer
extends WOGenericContainer {
    NSMutableDictionary _styles;
    WOAssociation _style;
    WOAssociation _mimeType;
    WOAssociation _unit;

    public ERXStyledContainer(String name, NSDictionary associations, WOElement template) {
        super(name, associations, template);
        this._style = (WOAssociation)this._associations.removeObjectForKey("style");
        this._styles = new NSMutableDictionary();
        Enumeration enumerator = this._associations.keyEnumerator();
        while (enumerator.hasMoreElements()) {
            String key = (String)enumerator.nextElement();
            if (!key.startsWith("style.")) continue;
            String styleKey = key.substring(6);
            WOAssociation association = (WOAssociation)this._associations.removeObjectForKey(key);
            if ("background-image.type".equals(styleKey)) {
                this._mimeType = association;
                continue;
            }
            if ("unit".equals(styleKey)) {
                this._unit = association;
                continue;
            }
            this._styles.setObjectForKey(association, styleKey);
        }
    }

    public void appendAttributesToResponse(WOResponse woresponse, WOContext wocontext) {
        String s;
        super.appendAttributesToResponse(woresponse, wocontext);
        WOComponent component = wocontext.component();
        StringBuffer style = new StringBuffer();
        if (this._style != null && (s = (String)this._style.valueInComponent(component)) != null) {
            style.append(s);
            style.append("; ");
        }
        if (this._styles.count() > 0) {
            Enumeration enumerator = this._styles.keyEnumerator();
            while (enumerator.hasMoreElements()) {
                String stringValue;
                String key = (String)enumerator.nextElement();
                WOAssociation association = (WOAssociation)this._styles.objectForKey(key);
                Object value = association.valueInComponent(component);
                if (value == null) continue;
                if ("background-image".equals(key)) {
                    if (value instanceof NSData) {
                        NSData data = (NSData)value;
                        WOResourceManager rm = WOApplication.application().resourceManager();
                        String mimeType = this._mimeType != null ? this._mimeType.valueInComponent(component) : "image/jpeg";
                        WOURLValuedElementData uve = new WOURLValuedElementData(data, mimeType, null);
                        rm._cacheData(uve);
                        stringValue = uve.dataURL(wocontext);
                    } else {
                        stringValue = value.toString();
                    }
                    if (stringValue.indexOf("url(") < 0) {
                        stringValue = "url(" + stringValue + ")";
                    }
                } else {
                    stringValue = value.toString();
                }
                if (value instanceof Number) {
                    stringValue = stringValue + (this._unit != null ? this._unit.valueInComponent(component) : "px");
                }
                style.append(key).append(": ").append(stringValue).append("; ");
            }
        }
        if (style.length() > 0) {
            woresponse._appendTagAttributeAndValue("style", style.toString(), false);
        }
    }
}

